python3.7/site-packages/pip/_vendor/cachecontrol/heuristics.py                                      0000644                 00000007746 15107360303 0020475 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       import calendar
import time

from email.utils import formatdate, parsedate, parsedate_tz

from datetime import datetime, timedelta

TIME_FMT = "%a, %d %b %Y %H:%M:%S GMT"


def expire_after(delta, date=None):
    date = date or datetime.utcnow()
    return date + delta


def datetime_to_header(dt):
    return formatdate(calendar.timegm(dt.timetuple()))


class BaseHeuristic(object):

    def warning(self, response):
        """
        Return a valid 1xx warning header value describing the cache
        adjustments.

        The response is provided too allow warnings like 113
        http://tools.ietf.org/html/rfc7234#section-5.5.4 where we need
        to explicitly say response is over 24 hours old.
        """
        return '110 - "Response is Stale"'

    def update_headers(self, response):
        """Update the response headers with any new headers.

        NOTE: This SHOULD always include some Warning header to
              signify that the response was cached by the client, not
              by way of the provided headers.
        """
        return {}

    def apply(self, response):
        updated_headers = self.update_headers(response)

        if updated_headers:
            response.headers.update(updated_headers)
            warning_header_value = self.warning(response)
            if warning_header_value is not None:
                response.headers.update({"Warning": warning_header_value})

        return response


class OneDayCache(BaseHeuristic):
    """
    Cache the response by providing an expires 1 day in the
    future.
    """

    def update_headers(self, response):
        headers = {}

        if "expires" not in response.headers:
            date = parsedate(response.headers["date"])
            expires = expire_after(timedelta(days=1), date=datetime(*date[:6]))
            headers["expires"] = datetime_to_header(expires)
            headers["cache-control"] = "public"
        return headers


class ExpiresAfter(BaseHeuristic):
    """
    Cache **all** requests for a defined time period.
    """

    def __init__(self, **kw):
        self.delta = timedelta(**kw)

    def update_headers(self, response):
        expires = expire_after(self.delta)
        return {"expires": datetime_to_header(expires), "cache-control": "public"}

    def warning(self, response):
        tmpl = "110 - Automatically cached for %s. Response might be stale"
        return tmpl % self.delta


class LastModified(BaseHeuristic):
    """
    If there is no Expires header already, fall back on Last-Modified
    using the heuristic from
    http://tools.ietf.org/html/rfc7234#section-4.2.2
    to calculate a reasonable value.

    Firefox also does something like this per
    https://developer.mozilla.org/en-US/docs/Web/HTTP/Caching_FAQ
    http://lxr.mozilla.org/mozilla-release/source/netwerk/protocol/http/nsHttpResponseHead.cpp#397
    Unlike mozilla we limit this to 24-hr.
    """
    cacheable_by_default_statuses = {
        200, 203, 204, 206, 300, 301, 404, 405, 410, 414, 501
    }

    def update_headers(self, resp):
        headers = resp.headers

        if "expires" in headers:
            return {}

        if "cache-control" in headers and headers["cache-control"] != "public":
            return {}

        if resp.status not in self.cacheable_by_default_statuses:
            return {}

        if "date" not in headers or "last-modified" not in headers:
            return {}

        date = calendar.timegm(parsedate_tz(headers["date"]))
        last_modified = parsedate(headers["last-modified"])
        if date is None or last_modified is None:
            return {}

        now = time.time()
        current_age = max(0, now - date)
        delta = date - calendar.timegm(last_modified)
        freshness_lifetime = max(0, min(delta / 10, 24 * 3600))
        if freshness_lifetime <= current_age:
            return {}

        expires = date + freshness_lifetime
        return {"expires": time.strftime(TIME_FMT, time.gmtime(expires))}

    def warning(self, resp):
        return None
                          python3.7/site-packages/pip/_vendor/cachecontrol/caches/__pycache__/file_cache.cpython-37.pyc       0000644                 00000006246 15107360303 0026062 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re9                 @   s~   d dl Z d dlZd dlmZ ddlmZ ddlmZ ye W n e	k
rX   e
efZY nX dd ZG dd	 d	eZ
d
d ZdS )    N)dedent   )	BaseCache)CacheControllerc          	   C   s   t j}|t jt jB O }tt dr*|t jO }tt dr>|t jO }yt |  W n tt	fk
rd   Y nX t 
| ||}yt |dS    t |  Y nX d S )N
O_NOFOLLOWO_BINARYwb)
osO_WRONLYO_CREATO_EXCLhasattrr   r   removeIOErrorOSErroropenfdopenclose)filenamefmodeflagsfd r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/cachecontrol/caches/file_cache.py_secure_open_write   s     




r   c               @   sB   e Zd ZdddZedd Zd	d
 Zdd Zd
d Zdd Z	dS )	FileCacheF    Nc       
      C   s   |d k	r|d k	rt dyddlm} ddlm} W n$ tk
rX   td}	t|	Y nX |rd|}n|d krp|}|| _|| _|| _	|| _
|| _d S )Nz/Cannot use use_dir_lock and lock_class togetherr   )LockFile)
MkdirLockFilez
            NOTE: In order to use the FileCache you must have
            lockfile installed. You can install it via pip:
              pip install lockfile
            )
ValueErrorlockfiler   lockfile.mkdirlockfiler   ImportErrorr   	directoryforeverfilemodedirmode
lock_class)
selfr$   r%   r&   r'   use_dir_lockr(   r   r   noticer   r   r   __init__:   s$    
zFileCache.__init__c             C   s   t |   S )N)hashlibsha224encode	hexdigest)xr   r   r   r/   a   s    zFileCache.encodec             C   s4   |  |}t|d d |g }tjj| jf| S )N   )r/   listr	   pathjoinr$   )r)   namehashedpartsr   r   r   _fne   s    
z
FileCache._fnc          	   C   sB   |  |}yt|d
}| S Q R X W n tk
r<   d S X d S )Nrb)r9   r   readFileNotFoundError)r)   keyr6   fhr   r   r   getl   s    
z
FileCache.getc          
   C   s|   |  |}yttj|| j W n ttfk
r<   Y nX | |*}t	|j| j
}|| W d Q R X W d Q R X d S )N)r9   r	   makedirsr4   dirnamer'   r   r   r(   r   r&   write)r)   r=   valuer6   lockr>   r   r   r   setu   s    
z
FileCache.setc             C   s8   |  |}| js4yt| W n tk
r2   Y nX d S )N)r9   r%   r	   r   r<   )r)   r=   r6   r   r   r   delete   s    
zFileCache.delete)Fr   r   NN)
__name__
__module____qualname__r,   staticmethodr/   r9   r?   rE   rF   r   r   r   r   r   8   s       
 	r   c             C   s   t | }||S )z\Return the file cache path based on the URL.

    This does not ensure the file exists!
    )r   	cache_urlr9   )url	filecacher=   r   r   r   url_to_file_path   s    
rN   )r-   r	   textwrapr   cacher   
controllerr   r<   	NameErrorr   r   r   r   rN   r   r   r   r   <module>   s   )T                                                                                                                                                                                                                                                                                                                                                          python3.7/site-packages/pip/_vendor/cachecon