python3.7/site-packages/certifi/core.py                                                             0000644                 00000001504 15107360250 0013763 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # -*- coding: utf-8 -*-

"""
certifi.py
~~~~~~~~~~

This module returns the installation location of cacert.pem.
"""
import os
import warnings


class DeprecatedBundleWarning(DeprecationWarning):
    """
    The weak security bundle is being deprecated. Please bother your service
    provider to get them to stop using cross-signed roots.
    """


def where():
    f = os.path.dirname(__file__)

    return "/etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem"


def old_where():
    warnings.warn(
        "The weak security bundle has been removed. certifi.old_where() is now an alias "
        "of certifi.where(). Please update your code to use certifi.where() instead. "
        "certifi.old_where() will be removed in 2018.",
        DeprecatedBundleWarning
    )
    return where()

if __name__ == '__main__':
    print(where())
                                                                                                                                                                                            python3.7/site-packages/certifi/__pycache__/__init__.cpython-37.pyc                                 0000644                 00000000355 15107360250 0021062 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    aSe?                  @   s   d dl mZmZ dZdS )   )where	old_wherez
2018.04.16N)corer   r   __version__ r   r   A/opt/alt/python37/lib/python3.7/site-packages/certifi/__init__.py<module>   s                                                                                                                                                                                                                                                                                      python3.7/site-packages/certifi/__pycache__/core.cpython-37.pyc                                     0000644                 00000002253 15107360250 0020252 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    aSeD                 @   sJ   d Z ddlZddlZG dd deZdd Zdd Zed	krFee  dS )
zU
certifi.py
~~~~~~~~~~

This module returns the installation location of cacert.pem.
    Nc               @   s   e Zd ZdZdS )DeprecatedBundleWarningz
    The weak security bundle is being deprecated. Please bother your service
    provider to get them to stop using cross-signed roots.
    N)__name__
__module____qualname____doc__ r   r   =/opt/alt/python37/lib/python3.7/site-packages/certifi/core.pyr   
   s   r   c              C   s   t jt} dS )Nz1/etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem)ospathdirname__file__)fr   r   r   where   s    r   c               C   s   t dt t S )NzThe weak security bundle has been removed. certifi.old_where() is now an alias of certifi.where(). Please update your code to use certifi.where() instead. certifi.old_where() will be removed in 2018.)warningswarnr   r   r   r   r   r   	old_where   s    r   __main__)	r   r	   r   DeprecationWarningr   r   r   r   printr   r   r   r   <module>   s   	                                                                                                                                                                                                                                                                                                                                                     python3.7/site-packages/certifi/__pycache__/core.cpython-37.opt-1.pyc                               0000644                 00000002253 15107360250 0021211 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    aSeD                 @   sJ   d Z ddlZddlZG dd deZdd Zdd Zed	krFee  dS )
zU
certifi.py
~~~~~~~~~~

This module returns the installation location of cacert.pem.
    Nc               @   s   e Zd ZdZdS )DeprecatedBundleWarningz
    The weak security bundle is being deprecated. Please bother your service
    provider to get them to stop using cross-signed roots.
    N)__name__
__module____qualname____doc__ r   r   =/opt/alt/python37/lib/python3.7/site-packages/certifi/core.pyr   
   s   r   c              C   s   t jt} dS )Nz1/etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem)ospathdirname__file__)fr   r   r   where   s    r   c               C   s   t dt t S )NzThe weak security bundle has been removed. certifi.old_where() is now an alias of certifi.where(). Please update your code to use certifi.where() instead. certifi.old_where() will be removed in 2018.)warningswarnr   r   r   r   r   r   	old_where   s    r   __main__)	r