ote ``uri``.

        If called directly, does not check the store first, but after
        retrieving the document at the specified URI it will be saved in
        the store if :attr:`cache_remote` is True.

        .. note::

            If the requests_ library is present, ``jsonschema`` will use it to
            request the remote ``uri``, so that the correct encoding is
            detected and used.

            If it isn't, or if the scheme of the ``uri`` is not ``http`` or
            ``https``, UTF-8 is assumed.

        Arguments:

            uri (str):

                The URI to resolve

        Returns:

            The retrieved document

        .. _requests: https://pypi.org/project/requests/
        r   N)httphttpszutf-8)
requestsImportErrorr   schemer   rB   jsonr   loadsreaddecoder   r   )r   r   r   r   resultr   r   r   r   r   3  s    




zRefResolver.resolve_remote)r   Tr   NN)r   r   r   r   rK   re   rD   rH   rP   rT   r?   r   r   
contextlibcontextmanagerr   r   r   r   r   r   r   r   r   r   rG   P  s$   *    
$rG   c             O   sJ   |dkrt |}|| ||f||}t|| }|dk	rF|dS )a   
    Validate an instance under the given schema.

        >>> validate([2, 3, 4], {"maxItems": 2})
        Traceback (most recent call last):
            ...
        ValidationError: [2, 3, 4] is too long

    :func:`validate` will first verify that the provided schema is
    itself valid, since not doing so can lead to less obvious error
    messages and fail in less obvious or consistent ways.

    If you know you have a valid schema already, especially if you
    intend to validate multiple instances with the same schema, you
    likely would prefer using the `IValidator.validate` method directly
    on a specific validator (e.g. ``Draft7Validator.validate``).


    Arguments:

        instance:

            The instance to validate

        schema:

            The schema to validate with

        cls (IValidator):

            The class that will be used to validate the instance.

    If the ``cls`` argument is not provided, two things will happen
    in accordance with the specification. First, if the schema has a
    :validator:`$schema` property containing a known meta-schema [#]_
    then the proper validator will be used. The specification recommends
    that all schemas contain :validator:`$schema` properties for this
    reason. If no :validator:`$schema` property is found, the default
    validator class is the latest released draft.

    Any other provided positional and keyword arguments will be passed
    on when instantiating the ``cls``