_scope)r   r    _schemascoperefr1   kvrO   errorsrM   )rE   r   r   rL   (  sH    


z%create.<locals>.Validator.iter_errorsc             s   sH   xB|  ||D ]2}|d k	r&|j| |d k	r:|j| |V  qW d S )N)rL   pathrS   rR   )r   r    rC   r[   rR   rM   r   r   r   descendW  s    z!create.<locals>.Validator.descendc             _   s   x| j ||D ]}|qW d S )N)rL   )r   argskwargsrM   r   r   r   validate_  s    z"create.<locals>.Validator.validatec             S   s:   y| j ||S  tjk
r4   t||| jY nX d S )N)rF   is_typer	   ZUndefinedTypeCheckZUnknownTyperC   )r   r    typer   r   r   r`   c  s    z!create.<locals>.Validator.is_typec             S   s   t | ||d }|d kS )N)nextrL   )r   r    rU   rM   r   r   r   is_validi  s    z"create.<locals>.Validator.is_valid)r   NN)N)NN)N)r   r   r   r%   rQ   r3   rF   staticmethodr2   r?   r=   r@   r;   rK   classmethodrN   rL   r\   r_   r`   rc   r   )_created_with_default_types
default_typesrE   meta_schematype_checkerr1   r   r   	Validator   s      /
rj    rA   )	TypeErrorr   r<   r   TypeCheckerr)   _DEPRECATED_DEFAULT_TYPES*_TYPE_CHECKER_FOR_DEPRECATED_DEFAULT_TYPESr   r>   r.   r8   titlereplacer   )rh   r1   r6   rg   ri   rE   rj   r   )rf   rg   rE   rh   ri   r1   r   create   s0    @rrr   c             C   sH   t | j}|| |dkr$| j}n| jr2tdt| j|||| jdS )a  
    Create a new validator class by extending an existing one.

    Arguments:

        validator (jsonschema.IValidator):

            an existing validator class

        validators (collections.Mapping):

            a mapping of new validator callables to extend with, whose
            structure is as in `create`.

            .. note::

                Any validator callables with the same name as an
                existing one will (silently) replace the old validator
                callable entirely, effectively overriding any validation
                done in the "parent" validator class.

                If you wish to instead extend the behavior of a parent's
                validator callable, delegate and call it directly in
                the new validator function by retrieving it using
                ``OldValidator.VALIDATORS["validator_name"]``.

        version (str):

            a version for the new validator class

        type_checker (jsonschema.TypeChecker):

            a type checker, used when applying the :validator:`type` validator.

            If unprovided, the type checker of the extended
            `jsonschema.IValidator` will be carried along.`

    Returns:

        a new `jsonschema.IValidator` class extending the one provided

    .. note:: Meta Schemas

        The new validator class will have its parent's meta schema.

        If you wish to change or extend the meta schema in the new
        validator class, modify ``META_SCHEMA`` directly on the returned
        class. Note that no implicit copying is done, so a copy should
        likely be made before modifying it, in order to not affect the
        old validator.
    NzCannot extend a validator created with default_types with a type_checker. Update the validator to use a type_checker when created.)rh   r1   r6   ri   rE   )	r%   rQ   updaterF   r;   rl   rr   r3   r2   )rO   r1   r6   ri   Zall_validatorsr   r   r   extendt  s    5

rt   Zdraft3)z$refadditionalItemsadditionalPropertiesdependenciesZdisallowZdivisibleByenumZextendsformatitemsmaxItems	maxLengthmaximumminItems	minLengthminimumpatternpatternProperties
propertiesra   uniqueItemsc             C   s   |  ddS )NidrA   )rB   )rC   r   r   r   <lambda>      r   )rh   r1   ri   r6   rE   Zdraft4)z$refru   rv   allOfanyOfrw   rx   ry   rz   r{   r|   
maxPropertiesr}   r~   r   
minPropertiesr   
multipleOfnotoneOfr   r   r   requiredra   r   c             C   s   |  ddS )Nr   rA   )rB   )rC   r   r   r   r     r   Zdraft6)z$refru   rv   r   r   constcontainsrw   rx   exclusiveMaximumexclusiveMinimumry   rz   r{   r|   r   r}   r~   r   r   r   r   r   r   r   r   r   
propertyNamesr   ra   r   )rh   r1   ri   r6   Zdraft7) z$refru   rv   r   r   r   r   rw   rx   r   r   ry   ifrz   r{   r|   r   r}   r~   r   r   r   r   r   r   r   r   r   r   r   ra   r   c               @   s   e Zd ZdZdddZeefddZd	d
 Zdd Z	e
d
d Ze
dd Ze
jdd Ze
jdd Zdd Zdd Zdd Zdd ZdS )rG   a  
    Resolve JSON References.

    Arguments:

        base_uri (str):

            The URI of the referring document

        referrer:

            The actual referring document

        store (dict):

            A mapping from URIs to documents to cache

        cache_remote (bool):

            Whether remote refs should be cached after first resolution

        handlers (dict):

            A mapping from URI schemes to functions that should be used
            to retrieve them

        urljoin_cache (:func:`functools.lru_cache`):

            A cache that will be used for caching the results of joining
            the resolution scope to subscopes.

        remote_cache (:func:`functools.lru_cache`):

            A cache that will be used for caching the results of
            resolved remote URLs.

    Attributes:

        cache_remote (bool):

            Whether remote refs should be cached after first resolution
    r   TNc             C   s   |d krt dt}|d kr*t d| j}|| _|| _t|| _|g| _t	dd t
tD | _| j
| || j|< || _|| _d S )Ni   c             s   s   | ]\}}||j fV  qd S )N)r3   ).0r   rO   r   r   r   	<genexpr>  s   z'RefResolver.__init__.<locals>.<genexpr>)r
   r   resolve_from_urlreferrercache_remoter%   handlers
_scopes_stackr   URIDictr   r4   storers   _urljoin_cache
_remote_cache)r   base_urir   r   r   r   Z
urljoin_cacheZremote_cacher   r   r   rK   |  s    


zRefResolver.__init__c             O   s   | ||||d|S )z
        Construct a resolver from a JSON schema object.

        Arguments:

            schema:

                the referring schema

        Returns:

            `RefResolver`
        )r   r   r   )r5   rC   rE   