ng-help-

Getting Help
============

Please use the ``python-attrs`` tag on `StackOverflow <https://stackoverflow.com/questions/tagged/python-attrs>`_ to get help.

Answering questions of your fellow developers is also a great way to help the project!


.. -project-information-

Project Information
===================

``attrs`` is released under the `MIT <https://choosealicense.com/licenses/mit/>`_ license,
its documentation lives at `Read the Docs <https://www.attrs.org/>`_,
the code on `GitHub <https://github.com/python-attrs/attrs>`_,
and the latest release on `PyPI <https://pypi.org/project/attrs/>`_.
It’s rigorously tested on Python 2.7, 3.5+, and PyPy.

We collect information on **third-party extensions** in our `wiki <https://github.com/python-attrs/attrs/wiki/Extensions-to-attrs>`_.
Feel free to browse and add your own!

If you'd like to contribute to ``attrs`` you're most welcome and we've written `a little guide <https://www.attrs.org/en/latest/contributing.html>`_ to get you started!


``attrs`` for Enterprise
------------------------

Available as part of the Tidelift Subscription.

The maintainers of ``attrs`` and thousands of other packages are working with Tidelift to deliver commercial support and maintenance for the open source packages you use to build your applications.
Save time, reduce risk, and improve code health, while paying the maintainers of the exact packages you use.
`Learn more. <https://tidelift.com/subscription/pkg/pypi-attrs?utm_source=pypi-attrs&utm_medium=referral&utm_campaign=enterprise&utm_term=repo>`_


Release Information
===================

21.2.0 (2021-05-07)
-------------------

Backward-incompatible Changes
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

- We had to revert the recursive feature for ``attr.evolve()`` because it broke some use-cases -- sorry!
  `#806 <https://github.com/python-attrs/attrs/issues/806>`_
- Python 3.4 is now blocked using packaging metadata because ``attrs`` can't be imported on it anymore.
  To ensure that 3.4 users can keep installing  ``attrs`` easily, we will `yank <https://pypi.org/help/#yanked>`_ 21.1.0 from PyPI.
  This has **no** consequences if you pin ``attrs`` to 21.1.0.
  `#807 <https://github.com/python-attrs/attrs/issues/807>`_

`Full changelog <https://www.attrs.org/en/stable/changelog.html>`_.

Credits
=======

``attrs`` is written and maintained by `Hynek Schlawack <https://hynek.me/>`_.

The development is kindly supported by `Variomedia AG <https://www.variomedia.de/>`_.

A full list of contributors can be found in `GitHub's overview <https://github.com/python-attrs/attrs/graphs/contributors>`_.

It’s the spiritual successor of `characteristic <https://characteristic.readthedocs.io/>`_ and aspires to fix some of it clunkiness and unfortunate decisions.
Both were inspired by Twisted’s `FancyEqMixin <https://twistedmatrix.com/documents/current/api/twisted.python.util.FancyEqMixin.html>`_ but both are implemented using class decorators because `subclassing is bad for you <https://www.youtube.com/watch?v=3MNVP9-hglc>`_, m’kay?


         python3.7/site-packages/Jinja2-3.0.3-py3.7.egg-info/SOURCES.txt                                     0000644                 00000004563 15107360251 0017055 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       CHANGES.rst
LICENSE.rst
MANIFEST.in
README.rst
setup.cfg
setup.py
tox.ini
artwork/jinjalogo.svg
docs/Makefile
docs/api.rst
docs/changes.rst
docs/conf.py
docs/extensions.rst
docs/faq.rst
docs/index.rst
docs/integration.rst
docs/intro.rst
docs/license.rst
docs/make.bat
docs/nativetypes.rst
docs/sandbox.rst
docs/switching.rst
docs/templates.rst
docs/tricks.rst
docs/_static/jinja-logo-sidebar.png
docs/_static/jinja-logo.png
docs/examples/cache_extension.py
docs/examples/inline_gettext_extension.py
examples/basic/cycle.py
examples/basic/debugger.py
examples/basic/inheritance.py
examples/basic/test.py
examples/basic/test_filter_and_linestatements.py
examples/basic/test_loop_filter.py
examples/basic/translate.py
examples/basic/templates/broken.html
examples/basic/templates/subbroken.html
requirements/dev.txt
requirements/docs.txt
requirements/tests.txt
requirements/typing.txt
src/Jinja2.egg-info/PKG-INFO
src/Jinja2.egg-info/SOURCES.txt
src/Jinja2.egg-info/dependency_links.txt
src/Jinja2.egg-info/entry_points.txt
src/Jinja2.egg-info/requires.txt
src/Jinja2.egg-info/top_le