utOSError_to_str
splitlines_parse_lsb_release_content)r*   r   cmdstdoutcontentr   r   r   rg     s    z#LinuxDistribution._lsb_release_infoc             C   s\   i }xR| D ]J}| ddd}t|dkr.q
|\}}||dd |  i q
W |S )aM  
        Parse the output of the lsb_release command.

        Parameters:

        * lines: Iterable through the lines of the lsb_release output.
                 Each line must be a unicode string or a UTF-8 encoded byte
                 string.

        Returns:
            A dictionary containing all information items.
        
:ra   rb   rC   rD   )r   r|   lenupdaterF   rE   )r   r   linekvr   rW   r   r   r   r     s    
"z,LinuxDistribution._parse_lsb_release_contentc          	   C   s\   t tjd2}yd}tj||d}W n tk
r8   i S X W d Q R X | | }| |S )Nr   )unamez-rs)r   )	rk   r9   r   r   r   r   r   r   _parse_uname_content)r*   r   r   r   r   r   r   r   ri     s    zLinuxDistribution._uname_infoc             C   sT   i }t d| d  }|rP| \}}|dkr4i S | |d< ||d< ||d< |S )Nz^([^\s]+)\s+([\d\.]+)r   Linuxr   r   rR   )rX   r}   r   r[   rE   )r   r   rZ   r   r   r   r   r   r     s    z&LinuxDistribution._parse_uname_contentc             C   sT   t  }|dkrdn|}t jd dkr<t| trP| |S nt| trP| |S | S )Nasciizutf-8r      )ru   getfilesystemencodingrv   rw   ry   rz   unicodeencode)textencodingr   r   r   r   0  s    


zLinuxDistribution._to_strc             C   s0  | j rb| | j }tj| j }t|}d|krLd|d  krLd|d< n|r^|d|d< |S yt	t
}|  W n6 tk
r   ddddd	d
ddd
ddddddg}Y nX xv|D ]n}|t
krqt|}|rtjt
|}| |}d|kr|| _ |d|d< d|d  kr d|d< |S qW i S dS )z
        Get the information items from the specified distro release file.

        Returns:
            A dictionary containing all information items.
        r   
cloudlinuxr   ra   zSuSE-releasezarch-releasezbase-releasezcentos-releasezfedora-releasezgentoo-releasezmageia-releasezmandrake-releasezmandriva-releasezmandrivalinux-releasezmanjaro-releasezoracle-releasezredhat-releasez
sl-releasezslackware-versionN)r?   _parse_distro_release_filer9   r:   basename _DISTRO_RELEASE_BASENAME_PATTERNrZ   rE   r~   listdirr<   sortr    _DISTRO_RELEASE_IGNORE_BASENAMESr;   )r*   distro_infor   rZ   	basenamesfilepathr   r   r   rh   >  sX    





z&LinuxDistribution._distro_release_infoc          	   C   s@   y"t |}| | S Q R X W n ttfk
r:   i S X dS )z
        Parse a distro release file.

        Parameters:

        * filepath: Path name of the distro release file.

        Returns:
            A dictionary containing all information items.
        N)rk   rT   readliner   IOError)r*   r   fpr   r   r   r     s
    
z,LinuxDistribution._parse_distro_release_filec             C   s   t |  ddd }i }|r~|dddd |d< |drZ|dddd |d< |dr|dddd |d< n| r|  |d< |S )	a  
        Parse a line from a distro release file.

        Parameters:
        * line: Line from the distro release file. Must be a unicode string
                or a UTF-8 encoded byte string.

        Returns:
            A dictionary containing all information items.
        Nr   r   rb   rQ   ra   r   )(_DISTRO_RELEASE_CONTENT_REVERSED_PATTERNrZ   r   r~   )r   r^   r   r   r   r   rT     s    

z/LinuxDistribution._parse_distro_release_contentN)Tr8   r8   T)T)F)FF)F)F)F)F)FF)%r'   r4   r5   r6   r,   rB   r
   r   r   r   r   r   r   r   r   r   r   r   r   r   r    r!   r#   r$   r%   r&   rd   staticmethodrl   rg   r   ri   r   r   rh   r   rT   r   r   r   r   r7   0  sF      
J


"




	

					
ADr7   c              C   s   t t} | t j | t tj t	j
dd}|jddddd | }|j
rn| t
jt dd	d
 n:| dtd	d td	d}| d
| t }| d| d S )NzOS distro info tool)rP   z--jsonz-jz!Output in machine readable format
store_true)helpaction   T)indent	sort_keyszName: %s)r   zVersion: %szCodename: %s)logging	getLoggerr'   setLevelDEBUG
addHandler
StreamHandlerru   r   argparseArgumentParseradd_argument
parse_argsjsonr   dumpsr   r   r   )loggerparserargsdistribution_versiondistribution_codenamer   r   r   main  s"    

r   __main__)T)F)FF)F)F)F)F)FF)-r6   r9   rX   ru   r   rs   r   r   r   environrG   r<   r=   rL   rM   rN   rY   r   r   r   r
   r   r   r   r   r   r   r   r   r   r   r   r   r   r    r!   r#   r$   r%   objectr&   r7   r   r   r'   r   r   r   r   <module>   sr   

O
'
,





,

     
                                                                                                                                                                                                     python3.7/site-packages/pip/_vendor/cachecontrol/serialize.py                                       0000644                 00000015663 15107360303 0020277 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       import base64
import io
import json
import zlib

from pip._vendor import msgpack
from pip._vendor.requests.structures import CaseInsensitiveDict

from .compat import HTTPResponse, pickle, text_type


def _b64_decode_bytes(b):
    return base64.b64decode(b.encode("ascii"))


def _b64_decode_str(s):
    return _b64_decode_bytes(s).decode("utf8")


class Serializer(object):

    def dumps(self, request, response, body=None):
        response_headers = CaseInsensitiveDict(response.headers)

        if body is None:
            body = response.read(decode_content=False)

            # NOTE: 99% sure this is dead code. I'm only leaving it
            #       here b/c I don't have a test yet to prove
            #       it. Basically, before using
            #       `cachecontrol.filewrapper.CallbackFileWrapper`,
            #       this made an effort to reset the file handle. The
            #       `CallbackFileWrapper` short circuits this code by
            #       setting the body as the content is consumed, the
            #       result being a `body` argument is *always* passed
            #       into cache_response, and in turn,
            #       `Serializer.dump`.
            response._fp = io.BytesIO(body)

        # NOTE: This is all a bit weird, but it's really important that on
        #       Python 2.x these objects are unicode and not str, even when
        #       they contain only ascii. The problem here is that msgpack
        #       understands the difference between unicode and bytes and we
        #       have it set to differentiate between them, however Python 2
        #       doesn't know the difference. Forcing these to unicode will be
        #       enough to have msgpack know the difference.
        data = {
            u"response": {
                u"body": body,
                u"headers": dict(
                    (text_type(k), text_type(v)) for k, v in response.headers.items()
                ),
                u"status": response.status,
                u"version": response.version,
                u"reason": text_type(response.reason),
                u"strict": response.strict,
                u"decode_content": response.decode_content,
            }
        }

        # Construct our vary headers
        data[u"vary"] = {}
        if u"vary" in response_headers:
            varied_headers = response_headers[u"vary"].split(",")
            for header in varied_headers:
                header = text_type(header).strip()
                header_value = request.headers.get(header, None)
                if header_value is not None:
                    header_value = text_type(header_value)
                data[u"vary"][header] = header_value

        return b",".join([b"cc=4", msgpack.dumps(data, use_bin_type=True)])

    def loads(self, request, data):
        # Short circuit if we've been given an empty set of data
        if not data:
            return

        # Determine what version of the serializer the data was serialized
        # with
        try:
            ver, data = data.split(b",", 1)
        except ValueError:
            ver = b"cc=0"

        # Make sure that our "ver" is act