istribution`, supporting a subset
        of its parameters.

        For details, see :func:`distro.linux_distribution`.
        )r   r   r   r   )r*   r   r   r   r   r
     s    	z$LinuxDistribution.linux_distributionc             C   sl   dd }|  d}|r ||tS | d}|r8||tS | d}|rP||tS | d}|rh||tS dS )zoReturn the distro ID of the OS distribution, as a string.

        For details, see :func:`distro.id`.
        c             S   s   |   dd} || | S )N _)lowerreplaceget)	distro_idtabler   r   r   	normalize  s    z'LinuxDistribution.id.<locals>.normalizer   distributor_idr8   )r!   NORMALIZED_OS_IDr#   NORMALIZED_LSB_IDr$   NORMALIZED_DISTRO_IDr%   )r*   rJ   rH   r   r   r   r     s    







zLinuxDistribution.idFc             C   s|   |  dp&| dp&| dp&| d}|rt|  dp>| d}|st| dpV| d}| jdd}|rt|d | }|pzdS )	zu
        Return the name of the OS distribution, as a string.

        For details, see :func:`distro.name`.
        r   rK   pretty_namedescriptionT)r   rC   r8   )r!   r#   r$   r%   r   )r*   r   r   r   r   r   r   r     s    







zLinuxDistribution.namec          	   C   s   |  d| d| d| |  ddd| | ddd| dg}d}|rxJ|D ]$}|d|dks~|dkr^|}q^W nx|D ]}|dkr|}P qW |r|r|  rd||  }|S )z{
        Return the version of the OS distribution, as a string.

        For details, see :func:`distro.version`.
        
version_idreleaserO   r8   rP   .z	{0} ({1}))	r!   r#   r$   _parse_distro_release_contentrG   r%   countr   r.   )r*   r   r   versionsr   vr   r   r   r     s(    


zLinuxDistribution.versionc             C   sL   | j |d}|rHtd}||}|rH| \}}}||p>d|pDdfS dS )z
        Return the version of the OS distribution, as a tuple of version
        numbers.

        For details, see :func:`distro.version_parts`.
        )r   z(\d+)\.?(\d+)?\.?(\d+)?r8   )r8   r8   r8   )r   recompilematchgroups)r*   r   version_str
version_regexmatchesmajorminorr   r   r   r   r     s    

zLinuxDistribution.version_partsc             C   s   |  |d S )z
        Return the major version number of the current distribution.

        For details, see :func:`distro.major_version`.
        r   )r   )r*   r   r   r   r   r     s    zLinuxDistribution.major_versionc             C   s   |  |d S )z
        Return the minor version number of the current distribution.

        For details, see :func:`distro.minor_version`.
           )r   )r*   r   r   r   r   r     s    zLinuxDistribution.minor_versionc             C   s   |  |d S )z}
        Return the build number of the current distribution.

        For details, see :func:`distro.build_number`.
           )r   )r*   r   r   r   r   r     s    zLinuxDistribution.build_numberc             C   s   |  dpdS )z
        Return the IDs of distributions that are like the OS distribution.

        For details, see :func:`distro.like`.
        id_liker8   )r!   )r*   r   r   r   r   '  s    zLinuxDistribution.likec             C   s8   y
| j d S  tk
r2   | dp0| dp0dS X dS )zp
        Return the codename of the OS distribution.

        For details, see :func:`distro.codename`.
        r   r8   N)_os_release_infoKeyErrorr#   r$   )r*   r   r   r   r   /  s    


zLinuxDistribution.codenamec          	   C   sB   t |  | ||t | || || |d|  |  dS )z
        Return certain machine-readable information about the OS
        distribution.

        For details, see :func:`distro.info`.
        )r_   r`   r   )r   r   r   r   r   )dictr   r   r   r   r   r   r   )r*   r   r   r   r   r   r   >  s    
zLinuxDistribution.infoc             C   s   | j S )z
        Return a dictionary containing key-value pairs for the information
        items from the os-release file data source of the OS distribution.

        For details, see :func:`distro.os_release_info`.
        )rd   )r*   r   r   r   r   Q  s    z!LinuxDistribution.os_release_infoc             C   s   | j S )z
        Return a dictionary containing key-value pairs for the information
        items from the lsb_release command data source of the OS
        distribution.

        For details, see :func:`distro.lsb_release_info`.
        )_lsb_release_info)r*   r   r   r   r   Z  s    z"LinuxDistribution.lsb_release_infoc             C   s   | j S )z
        Return a dictionary containing key-value pairs for the information
        items from the distro release file data source of the OS
        distribution.

        For details, see :func:`distro.distro_release_info`.
        )_distro_release_info)r*   r   r   r   r   d  s    z%LinuxDistribution.distro_release_infoc             C   s   | j S )z
        Return a dictionary containing key-value pairs for the information
        items from the uname command data source of the OS distribution.

        For details, see :func:`distro.uname_info`.
        )_uname_info)r*   r   r   r   r    n  s    zLinuxDistribution.uname_infoc             C   s   | j |dS )z
        Return a single named information item from the os-release file data
        source of the OS distribution.

        For details, see :func:`distro.os_release_attr`.
        r8   )rd   rG   )r*   r"   r   r   r   r!   w  s    z!LinuxDistribution.os_release_attrc             C   s   | j |dS )z
        Return a single named information item from the lsb_release command
        output data source of the OS distribution.

        For details, see :func:`distro.lsb_release_attr`.
        r8   )rg   rG   )r*   r"   r   r   r   r#     s    z"LinuxDistribution.lsb_release_attrc             C   s   | j |dS )z
        Return a single named information item from the distro release file
        data source of the OS distribution.

        For details, see :func:`distro.distro_release_attr`.
        r8   )rh   rG   )r*   r"   r   r   r   r$     s    z%LinuxDistribution.distro_release_attrc             C   s   | j |dS )z
        Return a single named information item from the uname command
        output data source of the OS distribution.

        For details, see :func:`distro.uname_release_attr`.
        r8   )ri   rG   )r*   r"   r   r   r   r%     s    zLinuxDistribution.uname_attrc          	   C   s.   t j| jr*t| j}| |S Q R X i S )z
        Get the information items from the specified os-release file.

        Returns:
            A dictionary containing all information items.
        N)r9   r:   isfiler>   open_parse_os_release_content)r*   release_filer   r   r   rd     s    z"LinuxDistribution._os_release_infoc             C   s   i }t j | dd}d|_tjd dkr@t|jtr@|jd|_t|}x2|D ]*}d|krN|	dd\}}|||
 < qNqNW d|kr|d |d	< n^d
|kr|d
 |d	< nHd|krtd|d }|r|
 }|d
}|d}| }||d	< |S )aD  
        Parse the lines of an os-release file.

        Parameters:

        * lines: Iterable through the lines in the os-release file.
                 Each line must be a unicode string or a UTF-8 encoded byte
                 string.

        Returns:
            A dictionary containing all information items.
        T)posixr   rb   z
iso-8859-1=ra   version_codenamer   ubuntu_codenamer   z(\(\D+\))|,(\s+)?\D+z(),)shlexwhitespace_splitsysversion_info
isinstance	wordcharsbytesdecodelistsplitrE   rX   searchgroupstrip)