  :param parent_req_name: The name of the requirement that needed this
            added. The name is used because when multiple unnamed requirements
            resolve to the same name, we could otherwise end up with dependency
            links that point outside the Requirements set. parent_req must
            already be added. Note that None implies that this is a user
            supplied requirement, vs an inferred one.
        :param extras_requested: an iterable of extras used to evaluate the
            environment markers.
        :return: Additional requirements to scan. That is either [] if
            the requirement is not applicable, or [install_req] if the
            requirement is applicable and has just been added.
        z6Ignoring %s: markers '%s' don't match your environmentNz-{} is not a supported wheel on this platform.z+a user supplied req shouldn't have a parentz7Double requirement given: {} (already in {}, name={!r})zhCould not satisfy constraints for '{}': installation from path or url cannot be constrained to a versionFTzSetting %s extras to: %s)
match_markersloggerinfor   markerslinkis_wheelr   filenamer   
get_supportedr   	supportedr   r(   
user_suppliedr.   r1   get_requirementKeyError
constraintextrasr   	specifierr3   pathtupler!   setdebug)	r   r0   parent_req_nameextras_requestedwheeltagsexisting_reqhas_conflicting_requirementdoes_not_satisfy_constraintr   r   r   add_requirementC   sh    








zRequirementSet.add_requirementc             C   s    t |}|| jko| j| j S )N)r   r   r@   )r   r   r2   r   r   r   has_requirement   s    
zRequirementSet.has_requirementc             C   s2   t |}|| jkr| j| S tdjf t d S )Nz!No project with the name {name!r})r   r   r?   r(   locals)r   r   r2   r   r   r   r>      s    

zRequirementSet.get_requirementc             C   s   | j t| j  S )N)r   listr   r"   )r   r   r   r   all_requirements   s    zRequirementSet.all_requirements)T)NN)
r*   
__module____qualname__r   r$   r-   r1   r3   rN   rO   r>   propertyrR   r   r   r   r   r      s   


 
o		r   )
__future__r   loggingcollectionsr   Zpip._vendor.packaging.utilsr   pip._internal.exceptionsr   pip._internal.models.wheelr   Zpip._internal.utilsr   pip._internal.utils.typingr   typingr	   r
   r   r   r
   Zpip._internal.req.req_installr   	getLoggerr*   r5   objectr   r   r   r   r   <module>   s   
                                                                                                                                                                                                                                                                                                                                                     python3.7/site-packages/pip/_internal/req/__pycache__/req_install.cpython-37.pyc                    0000644                 00000051535 15107360303 0023552 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   sD  d dl mZ d dlZd dlZd dlZd dlZd dlZd dlZd dlm	Z	m
Z
 d dlmZ d dl
mZ d dlmZ d dlmZ d dlmZ d d	lmZ d d
lmZ d dlmZ d dlmZ d d
lmZ d d
lmZ  d dl!m"Z# d dl$m%Z% d dl$m&Z' d dl(m)Z) d dl*m+Z+m,Z, d dl-m.Z. d dl/m0Z0 d dl1m2Z2 d dl3m4Z4 d dl5m6Z6 d dl7m8Z8m9Z9m:Z:m;Z;m<Z<m=Z=m>Z>m?Z?m@Z@mAZA d dlBmCZC d dlDmEZEmFZF d dlGmHZH d dlImJZJ d dlKmLZL eHrd dlMmNZNmOZOmPZPmQZQmRZRmSZSmTZT d dlmUZU d d lVmWZW d d!lXmYZY d d"lZm[Z[ e\e]Z^d#d$ Z_G d%d& d&e`Zad'd( ZbdS ))    )absolute_importN)
pkg_resourcessix)Requirement)canonicalize_name)Version)parse)Pep517HookCaller)NoOpBuildEnvironment)InstallationError)
get_scheme)Link)generate_metadata)install_editable)LegacyInstallFailure)install)
install_wheel)load_pyproject_tomlmake_pyproject_path)UninstallPathSet)
deprecated)direct_url_from_link)Hashes)
indent_log)
ask_path_exists
backup_dirdisplay_pathdist_in_install_pathdist_in_site_packagesdist_in_usersiteget_distributionget_installed_versionhide_urlredact_auth_from_url)get_metadata)
TempDirectory
tempdir_kinds)MYPY_CHECK_RUNNING)running_under_virtualenv)vcs)AnyDictIterableListOptionalSequenceUnion)BuildEnvironment)Distribution)SpecifierSet)Markerc             C   s   |  tj}tj|\}}t||}|drJtj}tj	|d }n.|dsXt
tj}tj	|d dd }||||dS )zQReturn a pkg_resources.Distribution for the provided
    metadata directory.
    z	.egg-infor   z
.dist-info-)project_namemetadata)rstriposseppathsplitr   PathMetadataendswithr2   splitextAssertionErrorDistInfoDistribution)metadata_directorydist_dirbase_dir
dist_dir_namer7   dist_cls	dist_name rH   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/req/req_install.py	_get_distE   s    
rJ   c               @   sF  e Zd ZdZdFddZdd Zd	d
 Zdd Zed
d Z	edd Z
edd Zedd ZdGddZ
edd ZdHddZdd Zdd Zd d! Zd"d# Zd$d% Zed&d' Zed(d) Zed*d+ Zed,d- Zd.d/ Zd0d1 Zd2d3 Zed4d5 Zd6d7 Zd8d9 ZdId:d;ZdJd<d=Z dKd>d?Z!d@dA Z"dBdC Z#dLdDdEZ$dS )MInstallRequirementz
    Represents something that may be installed later on, may have information
    about where to fetch the relevant requirement and also contains logic for
    installing the said requirement.
    FNrH   c             C   s  |d kst |tst||| _|| _|| _|| _d | _d | _| jrj|sLt|j	rjt
jt
j
|j| _|d kr|r|jrt|j}| | _| _d| _d | _| jr| jj	r| jj| _|r|| _n |rdd |jD | _nt | _|d kr|r|j}|| _d | _d| _d | _d | _|r|ng | _|	r,|	ng | _|
r<|
ni | _d| _ |
| _!d| _"|| _#t$ | _%d | _&d | _'g | _(d | _)|| _*d S )NFc             S   s   h | ]}t |qS rH   )r   
safe_extra).0extrarH   rH   rI   	<setcomp>   s   z.InstallRequirement.__init__.<locals>.<setcomp>)+
isinstancer   r@   req
comes_from
constrainteditablelegacy_install_reason
source_diris_filer9   r;   normpathabspath	file_pathurlr
   link
original_linkoriginal_link_is_in_wheel_cachelocal_file_pathextrassetmarkermarkerssatisfied_byshould_reinstall_temp_build_dirinstall_succeededinstall_optionsglobal_optionshash_optionsprepared
user_suppliedsuccessfully_downloadedisolatedr
   	build_envrB   pyproject_requiresrequirements_to_checkpep517_backend
use_pep517)selfrQ   rR   rT   r\   rc   rs   rn   rh   ri   rj   rS   r`   rl   rH   rH   rI   __init__g   sZ    

	zInstallRequirement.__init__c             C   s   | j r.t| j }| jrF|dt| jj7 }n| jrBt| jj}nd}| jd k	rf|dt| jj7 }| j	rt
| j	tjr| j	}n
| j	
 }|r|d|7 }|S )Nz from {}z<InstallRequirement>z in {}z
 (from {}))rQ   strr\   formatr#   r[   rd   r   locationrR   rP   r   string_types	from_path)rt   srR   rH   rH   rI   __str__   s     


zInstallRequirement.__str__c             C   s   d | jjt| | jS )Nz<{} object: {} editable={!r}>)rw   	__class____name__rv   rT   )rt   rH   rH   rI   __repr__   s    zInstallRequirement.__repr__c                s>   t |  t } fddt|D }dj| jjd|dS )z>An un-tested helper for getting state, for debugging.
        c             3   s   | ]}d  | | V  qdS )z{}={!r}N)rw   )rM   attr)
attributesrH   rI   	<genexpr>   s    z2InstallRequirement.format_debug.<locals>.<genexpr>z<{name} object: {{{state}}}>z, )namestate)varssortedrw   r}   r~   join)rt   namesr   rH   )r   rI   format_debug   s    zInstallRequirement.format_debugc             C   s"   | j d krd S tt| j jS )N)rQ   r   
ensure_strr   	safe_namer   )rt   rH   rH   rI   r     s    
zInstallRequirement.namec             C   s   | j jS )N)rQ   	specifier)rt   rH   rH   rI   r     s    zInstallRequirement.specifierc             C   s$   | j }t|dko"tt|jdkS )zReturn whether I am pinned to an exact version.

        For example, some-package==1.2 is pinned; some-package>1.2 is not.
           >   =====)r   lennextiteroperator)rt   
specifiersrH   rH   rI   	is_pinned  s    zInstallRequirement.is_pinnedc             C   s
   t | jS )N)r!   r   )rt   rH   rH   rI   installed_version  s    z$InstallRequirement.installed_versionc                s0   |sd} j d k	r(t fdd|D S dS d S )N) c             3   s   | ]} j d |iV  qdS )rN   N)rc   evaluate)rM   rN   )rt   rH   rI   r   (  s   z3InstallRequirement.match_markers.<locals>.<genexpr>T)rc   any)rt   extras_requestedrH   )rt   rI   
match_markers   s    


z InstallRequirement.match_markersc             C   s
   t | jS )zReturn whether any known-good hashes are specified as options.

        These activate --require-hashes mode; hashes specified as part of a
        URL do not.

        )boolrj   )rt   rH   rH   rI   has_hash_options-  s    	z#InstallRequirement.has_hash_optionsTc             C   sB   | j  }|r| jn| j}|r:|jr:||jg |j t|S )a  Return a hash-comparer that considers my option- and URL-based
        hashes to be known-good.

        Hashes in URLs--ones embedded in the requirements file, not ones
        downloaded from an index server--are almost peers with ones from
        flags. They satisfy --require-hashes (whether it was implicitly or
        explicitly activated) but do not activate it. md5 and sha224 are not
        allowed in flags, which should nudge people toward good algos. We
        always OR all hashes together, even ones from URLs.

        :param trust_internet: Whether to trust URL-based (#md5=...) hashes
            downloaded from the internet, as by populate_link()

        )	rj   copyr\   r]   hash
setdefault	hash_nameappendr   )rt   trust_internetgood_hashesr\   rH   rH   rI   hashes8  s
    

zInstallRequirement.hashesc             C   sR   | j dkrdS t| j }| jrNt| jtjr4| j}n
| j }|rN|d| 7 }|S )z@Format a nice indicator to show where this "comes from"
        Nz->)rQ   rv   rR   rP   r   ry   rz   )rt   r{   rR   rH   rH   rI   rz   N  s    


zInstallRequirement.from_pathc             C   s   |d k	st | jd k	r*| jjs"t | jjS | jd krLttjdd| _| jjS t| j}|rld	|t
 j}t
j|std| t
| t
j||}|rd nd}t||tjddjS )NT)kindglobally_managedz{}_{}zCreating directory %sF)r;   deleter   r   )r@   rf   r;   rQ   r%   r&   	REQ_BUILDr   r   rw   uuiduuid4hexr9   existsloggerdebugmakedirsr   )rt   	build_dir
autodeleteparallel_buildsdir_nameactual_build_dir
delete_argrH   rH   rI   ensure_build_location^  s*    



z(InstallRequirement.ensure_build_locationc             C   sn   | j dkst| jdk	st| jdk	s*ttt| jd trDd}nd}td| jd || jd g| _ dS )z3Set requirement after generating metadata.
        Nr   z==z===r   Name)	rQ   r@   r7   rV   rP   
parse_versionr   r   r   )rt   oprH   rH   rI   _set_requirement  s    z#InstallRequirement._set_requirementc             C   sD   t | jd }t | jj|kr"d S td| j|| j t|| _d S )Nr   zeGenerating metadata for package %s produced metadata for project name %s. Fix your #egg=%s fragments.)r   r7   rQ   r   r   warningr   )rt   
metadata_namerH   rH   rI   warn_on_mismatching_name  s    z+InstallRequirement.warn_on_mismatching_namec             C   s   | j dkrdS t| j j}|s"dS |j}| j jj|ddsd| _|rxt|rTd| _qt	 rt
|rtd|j
|jqt|rd| _n| jrd| _d| _n|| _dS )zFind an installed distribution that satisfies or conflicts
        with this requirement, and set self.satisfied_by or
        self.should_reinstall appropriately.
        NT)prereleaseszVWill not install to the user site because it will lack sys.path precedence to {} in {})rQ   r    r   parsed_versionr   containsrd   r   re   r(   r   r   rw   r6   rx   r   rT   )rt   
use_user_site
existing_distexisting_versionrH   rH   rI   check_if_exists  s,    
z"InstallRequirement.check_if_existsc             C   s   | j s
dS | j jS )NF)r\   is_wheel)rt   rH   rH   rI   r     s    zInstallRequirement.is_wheelc             C   s   t j| j| jr| jjpdS )Nr   )r9   r;   r   rV   r\   subdirectory_fragment)rt   rH   rH   rI   unpacked_source_directory  s    z,InstallRequirement.unpacked_source_directoryc             C   sH   | j std| tj| jd}tjrDt	|tj
rD|t
 }|S )NzNo source dir for {}zsetup.py)rV   r@   rw   r9   r;   r   r   r   PY2rP   	text_typeencodesysgetfilesystemencoding)rt   setup_pyrH   rH   rI   
setup_py_path  s
    z InstallRequirement.setup_py_pathc             C   s   | j std| t| jS )NzNo source dir for {})rV   r@   rw   r   r   )rt   rH   rH   rI   pyproject_toml_path  s    z&InstallRequirement.pyproject_toml_pathc             C   s^   t | j| j| jt| }|dkr*d| _dS d| _|\}}}}|| _|| _t| j||d| _	dS )aA  Load the pyproject.toml file.

        After calling this routine, all of the attributes related to PEP 517
        processing for this requirement have been set. In particular, the
        use_pep517 attribute can be used to determine whether we should
        follow the PEP 517 or legacy (setup.py) code path.
        NFT)backend_path)
r   rs   r   r   rv   rq   rp   r	   r   rr   )rt   pyproject_toml_datarequiresbackendcheckr   rH   rH   rI   r     s    	
z&InstallRequirement.load_pyproject_tomlc             C   sV   | j s8| jstt| j| j| j| j| jp2d| j	dS | j
dk	sFtt| j| j
dS )zKInvokes metadata generator functions, with the required arguments.
        zfrom {})ro   r   rV   rn   detailsN)ro   r   )rs   r   r@   generate_metadata_legacyro   r   rn   r   rw   r\   rr   r   )rt   rH   rH   rI   _generate_metadata  s    
z%InstallRequirement._generate_metadatac          	   C   sJ   | j s
tt  |  | _W dQ R X | js6|   n|   |   dS )zEnsure that project metadata is available.

        Under PEP 517, call the backend hook to prepare the metadata.
        Under legacy processing, call setup.py egg-info.
        N)	rV   r@   r   r   rB   r   r   r   assert_source_matches_version)rt   rH   rH   rI   prepare_metadata"  s    

z#InstallRequirement.prepare_metadatac             C   s   t | dst|  | _| jS )N	_metadata)hasattrr$   get_distr   )rt   rH   rH   rI   r7   6  s    
zInstallRequirement.metadatac             C   s
   t | jS )N)rJ   rB   )rt   rH   rH   rI   r   >  s    zInstallRequirement.get_distc             C   sR   | j s
t| jd }| jjr8|| jjkr8td| | ntdt| j ||  d S )Nversionz'Requested %s, but installing version %sz;Source in %s has version %s, which satisfies requirement %s)	rV   r@   r7   rQ   r   r   r   r   r   )rt   r   rH   rH   rI   r   B  s    

z0InstallRequirement.assert_source_matches_versionc             C   s    | j dkr| j|||d| _ dS )aA  Ensure that a source_dir is set.

        This will create a temporary build dir if the name of the requirement
        isn't known yet.

        :param parent_dir: The ideal pip parent_dir for the source_dir.
            Generally src_dir for editables and build_dir for sdists.
        :return: self.source_dir
        N)r   r   )rV   r   )rt   
parent_dirr   r   rH   rH   rI   ensure_has_source_dirU  s
    
z(InstallRequirement.ensure_has_source_dirc             C   s  | j std| j d S | js"t| js,t| j jdkr<d S d| j jksZtdjf t	 | j j
dd\}}t|}|r| j j
sd| j j}d }| j jdrd}t||d	d
d t| j j}|r|j| j|d n|j| j|d nd
std| j |d S )Nz>Cannot update repository at %s; repository location is unknownfile+zbad url: {self.link.url!r}r   z5This form of VCS requirement is being deprecated: {}.zgit+git@zmgit+https://git@example.com/..., git+ssh://git@example.com/..., or the insecure git+git://git@example.com/...z21.0i  )gone_inissue)r[   r   z+Unexpected version control type (in {}): {})r\   r   r   rV   rT   r@   schemer[   rw   localsr<   r)   get_backendis_vcs
startswithr   r"   obtainexport)rt   r   vc_typer[   vcs_backendreasonreplacement
hidden_urlrH   rH   rI   update_editablem  s8    



z"InstallRequirement.update_editablec             C   sR   | j s
tt| j j}|s,td| j dS td| t|}|	|| |S )a  
        Uninstall the distribution currently satisfying this requirement.

        Prompts before removing or modifying files unless
        ``auto_confirm`` is True.

        Refuses to delete or modify files outside of ``sys.prefix`` -
        thus uninstallation within a virtual environment can only
        modify that virtual environment, even if the virtualenv is
        linked to global site-packages.

        z#Skipping %s as it is not installed.NzFound existing installation: %s)
rQ   r@   r    r   r   r   infor   	from_distremove)rt   auto_confirmverbosedistuninstalled_pathsetrH   rH   rI   	uninstall  s    

zInstallRequirement.uninstallc             C   s.   dd }t j||}|||}| jd | S )Nc             S   sL   |  |tjj s$tdjf t | t|d d  } | tjjd} | S )Nz2name {name!r} doesn't start with prefix {prefix!r}r   /)	r   r9   r;   r:   r@   rw   r   r   replace)r   prefixrH   rH   rI   _clean_zip_name  s    
z=InstallRequirement._get_archive_name.<locals>._clean_zip_namer   )r9   r;   r   r   )rt   r;   	parentdirrootdirr   r   rH   rH   rI   _get_archive_name  s    

z$InstallRequirement._get_archive_namec          	   C   s  | j s
td}d| j| jd }tj||}tj|rt	dt
|d}|dkr^d}nj|dkrtd	t
| t
| nF|d
krt|}tdt
|t
| t|| n|dkrtd
 |sdS tj|dtjdd}| tjtj| j}xt|D ]\}	}
}x>|
D ]6}| j||	|d}
t|
d }d|_||d qW x8|D ]0}| j||	|d}tj|	|}||| q\W qW W dQ R X tdt
| dS )z}Saves archive to provided build_dir.

        Used for saving downloaded VCS requirements as part of `pip download`.
        Tz	{}-{}.zipr   z8The file {} exists. (i)gnore, (w)ipe, (b)ackup, (a)bort )iwbar  Fr  zDeleting %sr  zBacking up %s to %sr  N)
allowZip64)r   r   r   i  r   zSaved %s) rV   r@   rw   r   r7   r9   r;   r   r   r   r   r   r   r   r   shutilmover   exitzipfileZipFileZIP_DEFLATEDnormcaserY   r   walkr   ZipInfo
external_attrwritestrwriter   )rt   r   create_archivearchive_namearchive_pathresponse	dest_file
zip_outputdirdirpathdirnames	filenamesdirnamedir_arcnamezipdirfilenamefile_arcnamerH   rH   rI   archive  sV    




"zInstallRequirement.archivec	       
      C   s  t | j|||| j|d}	|d k	r$|ng }| jr^t|||||| j| j| j| j| jd
 d| _d S | j	r| j
sntd }
| jrt
| j| j| j}
t| j| j
|	t| j|||
| jd d| _d S t|| j }t|| j }y8t||||||||	| j| j| j| j| jt| jd}W nR tk
rB } zd| _tj|j  W d d }~X Y n tk
r^   d| _ Y nX || _|r| jdkrtd| jd	d
dd d S )N)userhomerootrn   r   )r   r$  r   r   r   rn   ro   r   T)r   req_description	pycompilewarn_script_location
direct_url	requested)rh   ri   r%  r$  r   r   r'  r   r   rn   req_namero   r   r&  Fi   zg{} was installed using the legacy 'setup.py install' method, because a wheel could not be built for it.z+to fix the wheel build issue reported abovez21.0)r   r   r   r   ) r   r   rn   rT   install_editable_legacyr   ro   r   rg   r   r_   r@   r]   r   rV   r^   r   rv   rQ   rl   listri   rh   install_legacyr   r   reraiseparent	ExceptionrU   r   rw   )
rt   rh   ri   r%  r$  r   r(  r   r'  r   r)  successexcrH   rH   rI   r      s    