3.x).)r  r:  )r   r   r   r   keys  s    zParseResults.keysc             C   s   t |  S )zXReturns all named result values (as a list in Python 2.x, as an iterator in Python 3.x).)r  
itervalues)r   r   r   r   values  s    zParseResults.valuesc             C   s   t |  S )zfReturns all named result key-values (as a list of tuples in Python 2.x, as an iterator in Python 3.x).)r  	iteritems)r   r   r   r   r,    s    zParseResults.itemsc             C   s
   t | jS )zSince keys() returns an iterator, this method is helpful in bypassing
           code that looks for the existence of any defined results names.)r   r  )r   r   r   r   haskeys  s    zParseResults.haskeysc             O   s   |s
dg}x6|  D ]*\}}|dkr2|d |f}qtd| qW t|d tsht|dksh|d | kr|d }| | }| |= |S |d }|S dS )a  
        Removes and returns item at specified index (default= ``last``).
        Supports both ``list`` and ``dict`` semantics for ``pop()``. If
        passed no argument or an integer argument, it will use ``list``
        semantics and pop tokens from the list of parsed tokens. If passed
        a non-integer argument (most likely a string), it will use ``dict``
        semantics and pop the corresponding value from any defined results
        names. A second default return value argument is supported, just as in
        ``dict.pop()``.

        Example::

            def remove_first(tokens):
                tokens.pop(0)
            print(OneOrMore(Word(nums)).parseString("0 123 321")) # -> ['0', '123', '321']
            print(OneOrMore(Word(nums)).addParseAction(remove_first).parseString("0 123 321")) # -> ['123', '321']

            label = Word(alphas)
            patt = label("LABEL") + OneOrMore(Word(nums))
            print(patt.parseString("AAB 123 321").dump())

            # Use pop() in a parse action to remove named result (note that corresponding value is not
            # removed from list form of results)
            def remove_LABEL(tokens):
                tokens.pop("LABEL")
                return tokens
            patt.addParseAction(remove_LABEL)
            print(patt.parseString("AAB 123 321").dump())

        prints::

            ['AAB', '123', '321']
            - LABEL: AAB

            ['AAB', '123', '321']
        r   defaultr   z-pop() got an unexpected keyword argument '%s'r   N)r,  r!  r   r   r   )r   r   kwargsr&  r#  indexr   defaultvaluer   r   r   pop  s    %zParseResults.popc             C   s   || kr| | S |S dS )a[  
        Returns named result matching the given key, or if there is no
        such name, then returns the given ``defaultValue`` or ``None`` if no
        ``defaultValue`` is specified.

        Similar to ``dict.get()``.

        Example::

            integer = Word(nums)
            date_str = integer("year") + '/' + integer("month") + '/' + integer("day")

            result = date_str.parseString("1999/12/31")
            print(result.get("year")) # -> '1999'
            print(result.get("hour", "not specified")) # -> 'not specified'
            print(result.get("hour")) # -> None
        Nr   )r   keydefaultValuer   r   r   r     s    zParseResults.getc             C   sZ   | j || xF| j D ]8\}}x.t|D ]"\}\}}t||||k ||< q,W qW dS )a  
        Inserts new element at location index in the list of parsed tokens.

        Similar to ``list.insert()``.

        Example::

            print(OneOrMore(Word(nums)).parseString("0 123 321")) # -> ['0', '123', '321']

            # use a parse action to insert the parse location in the front of the parsed results
            def insert_locn(locn, tokens):
                tokens.insert(0, locn)
            print(OneOrMore(Word(nums)).addParseAction(insert_locn).parseString("0 123 321")) # -> [0, '0', '123', '321']
        N)r  insertr  r,  r   r  )r   rF  insStrr  r/  r&  r1  r2  r   r   r   rK    s    zParseResults.insertc             C   s   | j | dS )a  
        Add single element to