 f |	S n4t j|  d7  < t|	t
r|	|	d |	d  fS W d Q R X d S )N)r   r   r   r   )rA   packrat_cache_lock
packrat_cacher   r  packrat_cache_statsr   r:   r   r  r   rR  r   r  )r   r  r   r  r  HITMISSlookupr   r1  r   r   r   r   _parseCache+  s$    


zParserElement._parseCachec               C   s(   t j  dgtt j t jd d < d S )Nr   )rA   r  rQ  r   r  r   r   r   r   
resetCacheD  s    
zParserElement.resetCache   c             C   s8   t js4dt _| dkr t  t _nt | t _t jt _dS )a  Enables "packrat" parsing, which adds memoizing to the parsing logic.
           Repeated parse attempts at the same string location (which happens
           often in many complex grammars) can immediately return a cached value,
           instead of re-executing parsing/validating code.  Memoizing is done of
           both valid results and parsing exceptions.

           Parameters:

           - cache_size_limit - (default= ``128``) - if an integer value is provided
             will limit the size of the packrat cache; if None is passed, then
             the cache size will be unbounded; if 0 is passed, the cache will
             be effectively disabled.

           This speedup may break existing programs that use parse actions that
           have side-effects.  For this reason, packrat parsing is disabled when
           you first import pyparsing.  To activate the packrat feature, your
           program must call the class method :class:`ParserElement.enablePackrat`.
           For best results, call ``enablePackrat()`` immediately after
           importing pyparsing.

           Example::

               from pip._vendor import pyparsing
               pyparsing.ParserElement.enablePackrat()
        TN)rA   _packratEnabledr  r  r	  r  r  )cache_size_limitr   r   r   
enablePackratJ  s    zParserElement.enablePackratc          
   C   s   t   | js|   x| jD ]}|  qW | js<| }y<| |d\}}|rv| ||}t	 t
  }||| W nN tk
r } z0t jr n"t
|dddk	r| |j|_|W dd}~X Y nX |S dS )a  
        Execute the parse expression with the given string.
        This is the main interface to the client code, once the complete
        expression has been built.

        Returns the parsed data as a :class:`ParseResults` object, which may be
        accessed as a list, or as a dict or object with attributes if the given parser
        includes results names.

        If you want the grammar to require that the entire input string be
        successfully parsed, then set ``parseAll`` to True (equivalent to ending
        the grammar with ``StringEnd()``).

        Note: ``parseString`` implicitly calls ``expandtabs()`` on the input string,
        in order to report proper column numbers in parse actions.
        If the input string contains tabs and
        the grammar uses parse actions that use the ``loc`` argument to index into the
        string being parsed, you can ensure you have a consistent view of the input
        string by:

        - calling ``parseWithTabs`` on your grammar before calling ``parseString``
          (see :class:`parseWithTabs`)
        - define your parse action using the full ``(s, loc, toks)`` signature, and
          reference the input string using the parse action's ``s`` argument
        - explictly expand the tabs in your input string before calling
          ``parseString``

        Example::

            Word('a').parseString('aaaaabaaa')  # -> ['aaaaa']
            Word('a').parseString('aaaaabaaa', parseAll=True)  # -> Exception: Expected end of text
        r   r   N)rA   r  r  
streamliner  r  
expandtabsr  r  r)   rF   r:   verbose_stacktracer  r  r   )r   r  parseAllr  r   r  ser   r   r   r   parseStringm  s(    !zParserElement.parseStringc          
   c   sb  | j s|   x| jD ]}|  qW | js8t| }t|}d}| j}| j}t	
  d}	yx||kr|	|k ry |||}
|||
dd\}}W n tk
r   |
d }Y q`X ||kr|	d7 }	||
|fV  |r|||}
|
|kr|}q|d7 }n|}q`|
d }q`W W nT tk
r\ } z4t	j
r( n$t|dddk	rH| |j|_|W dd}~X Y nX dS )aq  
        Scan the input string for expression matches.  Each match will return the
        matching tokens, start location, and end location.  May be called with optional
        ``maxMatches`` argument, to clip scanning after 'n' matches are found.  If
        ``overlap`` is specified, then overlapping matches will be reported.

        Note that the start and end locations are reported relative to the string
        being parsed.  See :class:`parseString` for more information on parsing
        strings with embedded tabs.

        Example::

            source = "sldjf123lsdjjkf345sldkjf879lkjsfd987"
            print(source)
            for tokens, start, end in Word(alphas).scanString(source):
                print(' '*start + '^'*(end-start))
                print(' '*start + tokens[0])

        prints::

            sldjf123lsdjjkf345sldkjf879lkjsfd987
            ^^^^^
            sldjf
                    ^^^^^^^
                    lsdjjkf
                              ^^^^^^
                              sldkjf
                                       ^^^^^^
                                       lkjsfd
        r   F)r  r   r   N)r  r  r  r  r   r  r   r  r  rA   r  r<   r:   r  r  r  r   )r   r  
maxMatchesoverlapr  r  r   
preparseFnparseFnmatchesr  nextLocr  nextlocr   r   r   r   
scanString  sF    


zParserElement.scanStringc          
   C   s   g }d}d| _ yxh| |D ]Z\}}}||||  |rrt|trT|| 7 }nt|trh||7 }n
|| |}qW |||d  dd |D }dtt	t
|S  tk
r } z0tj
rȂ n"t|dddk	r| |j|_|W dd}~X Y nX dS )a[  
        Extension to :class:`scanString`, to modify matching text with modified tokens that may
        be returned from a parse action.  To use ``transformString``, define a grammar and
        attach a parse action to it that modifies the returned token list.
        Invoking ``transformString()`` on a target string will then scan for matches,
        and replace the matched text patterns according to the logic in the parse
        action.  ``transformString()`` returns the resulting transformed string.

        Example::

            wd = Word(alphas)
            wd.setParseAction(lambda toks: toks[0].title())

            print(wd.transformString("now is the winter of our discontent made glorious summer by this sun of york."))

        prints::

            Now Is The Winter Of Our Discontent Made Glorious Summer By This Sun Of York.
        r   TNc             S   s   g | ]}|r|qS r   r   )r   or   r   r   r     s    z1ParserElement.transformString.<locals>.<listcomp>r   r   )r  r'  r   r   r?   r  r  r   r  r   _flattenr:   rA   r  r  r  r   )r   r  ra  lastEr   r   r  r   r   r   r   r     s,    



zParserElement.transformStringc          
   C   sn   yt dd | ||D S  tk
rh } z0tjr6 n"t|dddk	rT| |j|_|W dd}~X Y nX dS )a  
        Another extension to :class:`scanString`, simplifying the access to the tokens found
        to match the given parse expression.  May be called with optional
        ``maxMatches`` argument, to clip searching after 'n' matches are found.

        Example::

            # a capitalized word starts with an uppercase letter, followed by zero or more lowercase letters
            cap_word = Word(alphas.upper(), alphas.lower())

            print(cap_word.searchString("More than Iron, more than Lead, more than Gold I need Electricity"))

            # the sum() builtin can be used to merge results into a single ParseResults object
            print(sum(cap_word.searchString("More than Iron, more than Lead, more than Gold I need Electricity")))

        prints::

            [['More'], ['Iron'], ['Lead'], ['Gold'], ['I'], ['Electricity']]
            ['More', 'Iron', 'Lead', 'Gold', 'I', 'Electricity']
        c             S   s   g | ]\}}}|qS r   r   )r   r   r   r  r   r   r   r   7  s    z.ParserElement.searchString.<locals>.<listcomp>r   N)r?   r'  r:   rA   r  r  r  r   )r   r  r   r   r   r   r   searchString!  s    zParserElement.searchStringc       	      c   sX   d}d}x<| j ||dD ]*\}}}||| V  |r>|d V  |}qW ||d V  dS )aR  
        Generator method to split a string using the given expression as a separator.
        May be called with optional ``maxsplit`` argument, to limit the number of splits;
        and the optional ``includeSeparators`` argu