  - message = define a custom message to be used in the raised exception
        - fatal   = if True, will raise ParseFatalException to stop parsing immediately; otherwise will raise ParseException

        Example::

            integer = Word(nums).setParseAction(lambda toks: int(toks[0]))
            year_int = integer.copy()
            year_int.addCondition(lambda toks: toks[0] >= 2000, message="Only support years 2000 and later")
            date_str = year_int + '/' + integer + '/' + integer

            result = date_str.parseString("1999/12/31")  # -> Exception: Only support years 2000 and later (at char 0), (line:1, col:1)
        r   r   F)r   r   r  )r  r   r   r   r  )r   r  rE  r   r   r   r   addCondition)  s
    
zParserElement.addConditionc             C   s
   || _ | S )a  Define action to perform if parsing fails at this expression.
           Fail acton fn is a callable function that takes the arguments
           ``fn(s, loc, expr, err)`` where:
           - s = string being parsed
           - loc = location where expression match was attempted and failed
           - expr = the parse expression that failed
           - err = the exception thrown
           The function returns no value.  It may throw :class:`ParseFatalException`
           if it is desired to stop parsing immediately.)r  )r   r   r   r   r   
setFailActionB  s    
zParserElement.setFailActionc          	   C   sZ   d}xP|rTd}xB| j D ]8}yx|||\}}d}qW W q tk
rL   Y qX qW qW |S )NTF)r  r  r<   )r   r  r   
exprsFoundedummyr   r   r   _skipIgnorablesO  s    zParserElement._skipIgnorablesc             C   sL   | j r| ||}| jrH| j}t|}x ||k rF|| |krF|d7 }q(W |S )Nr   )r  r  r  r  r   )r   r  r   wtinstrlenr   r   r   preParse\  s    zParserElement.preParsec             C   s   |g fS )Nr   )r   r  r   r  r   r   r   r   h  s    zParserElement.parseImplc             C   s   |S )Nr   )r   r  r   	tokenlistr   r   r   	postParsek  s    zParserElement.postParsec             C   s  d\}}}| j }|s| jr"| j| r8| j| |||  y|rR| jrR| ||}	n|}	|	}
| jsl|	t|kry| ||	|\}}W q tk
r   t	|t|| j
| Y qX n| ||	|\}}W n\ tk
r } z<| j| r| j| ||
| | | jr| ||
| |  W d d }~X Y nX n|r>| jr>| ||}	n|}	|	}
| js\|	t|kry| ||	|\}}W n* tk
r   t	|t|| j
| Y nX n| ||	|\}}| |||}t
|| j| j| jd}
| jrh|s| jrh|ryx| jD ]}y|||
|
}W n6 tk
rF } zt	d}||_|W d d }~X Y nX |d k	r||
k	rt
|| j| joxt|t
tf| jd}
qW W nF tk
r } z&| j| r| j| ||
| |  W d d }~X Y nX nx| jD ]}y|||
|
}W n6 tk
r& } zt	d}||_|W d d }~X Y nX |d k	r||
k	rt
|| j| joXt|t
tf| jd}
qW |r| j| r| j| ||
|| |
 ||
fS )N)r   r   r   )r  r  z exception raised in parse action)r  r  r  r  r  r  r   r   r"  r<   r  r  r  r?   r  r  r  r  r  	__cause__r   r  )r   r  r   r  r  TRYMATCHFAIL	debuggingpreloctokensStarttokenserr	retTokensr   parse_action_excr   r   r   r   r   o  s    



zParserElement._parseNoCachec             C   s>   y| j ||ddd S  tk
r8   t||| j| Y nX d S )NF)r  r   )r  r>   r<   r  )r   r  r   r   r   r   tryParse  s    zParserElement.tryParsec          	   C   s2   y|  || W n ttfk
r(   dS X dS d S )NFT)r  r<   r"  )r   r  r   r   r   r   canParseNext  s
    zParserElement.canParseNextc               @   s   e Zd Zdd ZdS )zParserElement._UnboundedCachec                s~   i  t   | _ fdd} fdd} fdd