ns elements that
        match ``<TAB>`` characters.
        T)r  )r   r   r   r   
parseWithTabs	  s    zParserElement.parseWithTabsc             C   sL   t |trt|}t |tr4|| jkrH| j| n| jt|  | S )a  
        Define expression to be ignored (e.g., comments) while doing pattern
        matching; may be called repeatedly, to define multiple comment or other
        ignorable patterns.

        Example::

            patt = OneOrMore(Word(alphas))
            patt.parseString('ablaj /* comment */ lskjd') # -> ['ablaj']

            patt.ignore(cStyleComment)
            patt.parseString('ablaj /* comment */ lskjd') # -> ['ablaj', 'lskjd']
        )r   r  rH   r  r   rR  )r   rS  r   r   r   ignore	  s    


zParserElement.ignorec             C   s"   |pt |pt|ptf| _d| _| S )zT
        Enable display of debugging messages while doing pattern matching.
        T)r  r  r  r  r  )r   startAction
successActionexceptionActionr   r   r   setDebugActions	  s
    zParserElement.setDebugActionsc             C   s   |r|  ttt nd| _| S )a  
        Enable display of debugging messages while doing pattern matching.
        Set ``flag`` to True to enable, False to disable.

        Example::

            wd = Word(alphas).setName("alphaword")
            integer = Word(nums).setName("numword")
            term = wd | integer

            # turn on debugging for wd
            wd.setDebug()

            OneOrMore(term).parseString("abc 123 xyz 890")

        prints::

            Match alphaword at loc 0(1,1)
            Matched alphaword -> ['abc']
            Match alphaword at loc 3(1,4)
            Exception raised:Expected alphaword (at char 4), (line:1, col:5)
            Match alphaword at loc 7(1,8)
            Matched alphaword -> ['xyz']
            Match alphaword at loc 11(1,12)
            Exception raised:Expected alphaword (at char 12), (line:1, col:13)
            Match alphaword at loc 15(1,16)
            Exception raised:Expected alphaword (at char 15), (line:1, col:16)

        The output shown is that produced by the default debug actions - custom debug actions can be
        specified using :class:`setDebugActions`. Prior to attempting
        to match the ``wd`` expression, the debugging message ``"Match <exprname> at loc <n>(<line>,<col>)"``
        is shown. Then if the parse succeeds, a ``"Matched"`` message is shown, or an ``"Exception raised"``
        message is shown. Also note the use of :class:`setName` to assign a human-readable name to the expression,
        which makes debugging and exception messages easier to understand - for instance, the default
        name created for the :class:`Word` expression without calling ``setName`` is ``"W:(ABCD...)"``.
        F)rR  r  r  r  r  )r   flagr   r   r   r  	  s    %zParserElement.setDebugc             C   s   | j S )N)r  )r   r   r   r   r   	  s    zParserElement.__str__c             C   s   t | S )N)r   )r   r   r   r   r   	  s    zParserElement.__repr__c             C   s   d| _ d | _| S )NT)r  r  )r   r   r   r   r  	  s    zParserElement.streamlinec             C   s   d S )Nr   )r   r  r   r   r   checkRecursion	  s    zParserElement.checkRecursionc             C   s   |  g  dS )zj
        Check defined expressions for valid structure, check for infinite recursive definitions.
        N)rT  )r   
validateTracer   r   r   validate	  s    zParserElement.validatec             C   s   y|  }W n2 tk
r>   t|d}|  }W dQ R X Y nX y| ||S  tk
r } z0tjrh n"t|dddk	r| |j	|_	|W dd}~X Y nX dS )z
        Execute the parse expression on the given file or filename.
        If a filename is specified (instead of a file object),
        the entire file is opened, read, and closed before parsing.
        rNr   )
readr   openr  r:   rA   r  r  r  r   )r   file_or_filenamer  
file_contentsfr   r   r   r   	parseFile
  s    zParserElement.parseFilec             C   s>   | |krdS t |tr | |S t |tr:t| t|kS dS )NTF)r   r  r$  rA   vars)r   rS  r   r   r   __eq__
  s    


zParserElement.__eq__c             C   s
   | |k S )Nr   )r   rS  r   r   r   __ne__$
  s    zParserElement.__ne__c             C   s   t | S )N)id)r   r   r   r   __hash__'
  s    zParserElement.__hash__c             C   s   | |kS )Nr   )r   rS  r   r   r   __req__*
  s    zParserElement.__req__c             C   s
   | |k S )Nr   )r   rS  r   r   r   __rne__-
  s    zParserElement.__rne__c             C   s0   y| j t||d dS  tk
r*   dS X dS )a  
        Method for quick testing of a parser against a test string. Good for simple
        inline microtests of sub expressions while building up larger parser.

        Parameters:
         - testString - to test against this expression for a match
         - parseAll - (default= ``True``) - flag to pass to :class:`parseString` when running tests

        Example::

            expr = Word(nums)
            assert expr.matches("100")
        )r  TFN)r  r   r:   )r   
testStringr  r   r   r   r$  0
  s
    zParserElement.matches#c	             C   s  t |tr"tttj|  }t |tr4t|}|dkrBt	j
}|j}	g }
g }d}tdt
dt}
d}xt|D ]j}|dk	r||ds|r|s|| qx|sqx|rdd| nd|g}g }y"|
||}| j||d}W n tk
r } zt |trd	nd}d|krT|t|j| |d
t|j|d  d |  n|d
|j d |  |d
t|  |o|}|}W dd}~X Y n tk
r } z$|dt|  |o|}|}W dd}~X Y nX |o| }|dk	ryR|||}|dk	r:t |tr*||  n|t| n||  W nR tk
r } z2||j|d |d|jt |j| W dd}~X Y nX n||j|d |r|r|d |	d| |
||f qxW ||
fS )as
  
        Execute the parse expression on a series of test strings, showing each
        test, the parsed results or where the parse failed. Quick and easy way to
        run a parse expression against a list of sample strings.

        Parameters:
         - tests - a list of separate test strings, or a multiline string of test strings
         - parseAll - (default= ``True``) - flag to pass to :class:`parseString` when running tests
         - comment - (default= ``'#'``) - expression for indicating embedded comments in the test
              string; pass None to disable comment filtering
         - fullDump - (default= ``True``) - dump results as list followed by results names in nested outline;
              if False, only dump nested list
         - printResults - (default= ``True``) prints test output to stdout
         - failureTests - (default= ``False``) indicates if these tests are expected to fail parsing
         - postParse - (default= ``None``) optional callback for successful parse results; called as
              `fn(test_string, parse_results)` and returns a string to be added to the test output
         - file - (default=``None``) optional file-like object to which test output will be written;
              if None, will default to ``sys.stdout``

        Returns: a (success, results) tuple, where success indicates that all tests succeeded
        (or failed if ``failureTests`` is True), and the results contain a list of lines of each
        test's output

        Example::

            number_expr = pyparsing_common.number.copy()

            result = number_expr.runTests('''
                # unsigned integer
                100
                # negative integer
                -100
                # float with scientific notation
                6.02e23
                # integer with scientific notation
                1e-12
                ''')
            print("Success" if result[0] else "Failed!")

            result = number_expr.runTests('''
                # stray character
                100Z
                # missing leading digit before '.'
                -.100
                # too many '.'
                3.14.159
                ''', failureTests=True)
            print("Success" if result[0] else "Failed!")

        prints::

            # unsigned integer
            100
            [100]

            # negative integer
            -100
            [-100]

            # float with scientific notation
            6.02e23
            [6.02e+23]

            # integer with scientific notation
            1e-12
            [1e-12]

      