Borrows syntax from regexp '[]' string range
    definitions::

        srange("[0-9]")   -> "0123456789"
        srange("[a-z]")   -> "abcdefghijklmnopqrstuvwxyz"
        srange("[a-z$_]") -> "abcdefghijklmnopqrstuvwxyz$_"

    The input string must be enclosed in []'s, and the returned string
    is the expanded character set joined into a single string. The
    values enclosed in the []'s may be:

     - a single character
     - an escaped character with a leading backslash (such as ``\-``
       or ``\]``)
     - an escaped hex character with a leading ``'\x'``
       (``\x21``, which is a ``'!'`` character) (``\0x##``
       is also supported for backwards compatibility)
     - an escaped octal character with a leading ``'\0'``
       (``\041``, which is a ``'!'`` character)
     - a range of any of the above, separated by a dash (``'a-z'``,
       etc.)
     - any combination of the above (``'aeiouy'``,
       ``'a-zA-Z0-9_$'``, etc.)
    c             S   s<   t | ts| S ddd tt| d t| d d D S )Nr   c             s   s   | ]}t |V  qd S )N)r_  )r   r   r   r   r   r   I  s    z+srange.<locals>.<lambda>.<locals>.<genexpr>r   r   )r   r?   r   r)  ord)pr   r   r   r   I  r   zsrange.<locals>.<lambda>r   c             3   s   | ]} |V  qd S )Nr   )r   part)	_expandedr   r   r   K  s    zsrange.<locals>.<genexpr>N)r   _reBracketExprr  rb  r  )r   r   )rf  r   r}   /  s
     c                s    fdd}|S )zoHelper method for defining parse actions that require matching at
    a specific column in the input text.
    c                s"   t ||  krt| |d  d S )Nzmatched token not at column %d)rW   r<   )r  locnr  )r9  r   r   	verifyColS  s    z!matchOnlyAtCol.<locals>.verifyColr   )r9  ri  r   )r9  r   rk   O  s    c                s    fddS )a  Helper method for common parse actions that simply return
    a literal value.  Especially useful when used with
    :class:`transformString<ParserElement.transformString>` ().

    Example::

        num = Word(nums).setParseAction(lambda toks: int(toks[0]))
        na = oneOf("N/A NA").setParseAction(replaceWith(math.nan))
        term = na | num

        OneOrMore(term).parseString("324 234 N/A 234") # -> [324, 234, nan, 234]
    c                s    gS )Nr   )r   r   r   )replStrr   r   r   e  r   zreplaceWith.<locals>.<lambda>r   )rj  r   )rj  r   rz   X  s    
c             C   s   |d dd S )a  Helper parse action for removing quotation marks from parsed
    quoted strings.

    Example::

        # by default, quotation marks are included in parsed results
        quotedString.parseString("'Now is the Winter of our Discontent'") # -> ["'Now is the Winter of our Discontent'"]

        # use removeQuotes to strip quotation marks from parsed results
        quotedString.setParseAction(removeQuotes)
        quotedString.parseString("'Now is the Winter of our Discontent'") # -> ["Now is the Winter of our Discontent"]
    r   r   r   r   )r   r   r   r   r   r   rx   g  s    
c                sN    fdd}yt dt dj}W n tk
rB   t}Y nX ||_|S )aL  Helper to define a parse action by mapping a function to all
    elements of a ParseResults list. If any additional args are passed,
    they are forwarded to the given function as additional arguments
    after the token, as in
    ``hex_integer = Word(hexnums).setParseAction(tokenMap(int, 16))``,
    which will convert the parsed data to an integer using base 16.

    Example (compare the last to example in :class:`ParserElemen