   d  } |_ |_t| |_||fS )zRInternal helper to construct opening and closing tag expressions, given a tag name)r  z_-:tag=/F)rD  ra   c             S   s   |d dkS )Nr   ro  r   )r   r   r   r   r   r   r     r   z_makeTags.<locals>.<lambda>ri  )r  c             S   s   |d dkS )Nr   ro  r   )r   r   r   r   r   r   r     r   z</)r+  z<%s>c          	      s*   |  dd dd   |  S )Nr  r   :r   )r(  r   r   titler   rR  )r   )resnamer   r   r     r   r  r   rp  r   z</%s>)r   r  r.   r  rL   rR   rQ   r\   rR  r   rx   r'   rO   r-   rH   r8   rw   rt   r`   r&   _Lr  r  r   r   rq  r   rm  rE   tag_body)tagStrxmlsuppress_LTsuppress_GTtagAttrNametagAttrValueopenTagcloseTagr   )rr  r   	_makeTags  s$    
JR,r}  c             C   s
   t | dS )aK  Helper to construct opening and closing tag expressions for HTML,
    given a tag name. Matches tags in either upper or lower case,
    attributes with namespaces and with quoted or unquoted values.

    Example::

        text = '<td>More info at the <a href="https://github.com/pyparsing/pyparsing/wiki">pyparsing</a> wiki page</td>'
        # makeHTMLTags returns pyparsing expressions for the opening and
        # closing tags as a 2-tuple
        a, a_end = makeHTMLTags("A")
        link_expr = a + SkipTo(a_end)("link_text") + a_end

        for link in link_expr.searchString(text):
            # attributes in the <A> tag (like "href" shown here) are
            # also accessible as named results
            print(link.link_text, '->', link.href)

    prints::

        pyparsing -> https://github.com/pyparsing/pyparsing/wiki
    F)r}  )ru  r   r   r   ri     s    c             C   s
   t | dS )zHelper to construct opening and closing tag expressions for XML,
    given a tag name. Matches tags only in the given upper/lower case.

    Example: similar to :class:`makeHTMLTags`
    T)r}  )ru  r   r   r   rj     s    c                 s8   | r| dd  n|   dd  D   fdd}|S )a7  Helper to create a validating parse action to be used with start
    tags created with :class:`makeXMLTags` or
    :class:`makeHTMLTags`. Use ``withAttribute`` to qualify
    a starting tag with a required attribute value, to avoid false
    matches on common tags such as ``<TD>`` or ``<DIV>``.

    Call ``withAttribute`` with a series of attribute names and
    values. Specify the list of filter attributes names and values as:

     - keyword arguments, as in ``(align="right")``, or
     - as an explicit dict with ``**`` operator, when an attribute
       name is also a Python reserved word, as in ``**{"class":"Customer", "align":"right"}``
     - a list of name-value tuples, as in ``(("ns1:class", "Customer"), ("ns2:align", "right"))``

    For attribute names with a namespace prefix, you must use the second
    form.  Attribute names are matched insensitive to upper/lower case.

    If just testing for ``class`` (with or without a namespace), use
    :class:`withClass`.

    To verify that the attribute exists, but without specifying a value,
    pass ``withAttribute.ANY_VALUE`` as the value.

    Example::

        html = '''
            <div>
            Some text
            <div type="grid">1 4 0 1 0</div>
            <div type="graph">1,3 2,3 1,1</div>
            <div>this has no type</div>
            </div>

        '''
        div,div_end = makeHTMLTags("div")

        # only match div tag having a type attribute with value "grid"
        div_grid = div().setParseAction(withAttribute(type="grid"))
        grid_expr = div_grid + SkipTo(div | div_end)("body")
        for grid_header in grid_expr.searchString(html):
            print(grid_header.body)

        # construct a match with any div tag having a type attribute, regardless of the value
        div_any_type = div().setParseAction(withAttribute(type=withAttribute.ANY_VALUE))
        div_expr = div_any_type + SkipTo(div | div_end)("body")
        for div_header in div_expr.searchString(html):
            print(div_header.body)

    prints::

        1 4 0 1 0

        1 4 0 1 0
        1,3 2,3 1,1
    Nc             S   s   g | ]\}}||fqS r   r   )r   r&  r#  r   r   r   r   /  s    z!withAttribute.<locals>.<listcomp>c                s^   xX D ]P\}}||kr&t | |d| |tjkr|| |krt | |d||| |f qW d S )Nzno matching attribute z+attribute '%s' has value '%s', must be '%s')r<   r   	ANY_VALUE)r   r   r  attrName	attrValue)attrsr   r   r   0  s    zwithAttribute.<locals>.pa)r,  )r   attrDictr   r   )r  r   r     s    8c             C   s   |rd| nd}t f || iS )a  Simplified version of :class:`withAttribute` when
    matching on a div class - made difficult because ``class`` is
    a reserved word in Python.

    Example::

        html = '''
            <div>
            Some text
            <div class="grid">1 4 0 1 0</div>
            <div class="graph">1,3 2,3 1,1</div>
            <div>this &lt;div&gt; has no class</div>
            </div>

        '''
        div,div_end = makeHTMLTags("div")
        div_grid = div().setParseAction(withClass("grid"))

        grid_expr = div_grid + SkipTo(div | div_end)("body")
        for grid_header in grid_expr.searchString(html):
            print(grid_header.body)

        div_any_type = div().setParseAction(withClass(withAttribute.ANY_VALUE))
        div_expr = div_any_type + SkipTo(div | div_end)("body")
        for div_header in div_expr.searchString(html):
            print(div_header.body)

    prints::

        1 4 0 1 0

        1 4 0 1 0
        1,3 2,3 1,1
    z%s:classclass)r   )	classname	namespace	classattrr   r   r   r   :  s    #(r  c             C   s  G dd dt }t }| || | B }xt|D ]r\}}|d dd \}	}
}}|
dk rdd|	 nd|	 }
|
dkr|	dkst|	d	krtd
|	\}}t |
}|tjkrx|
dkr|||	 t|t	|	  }n|
d	kr.|	dk	r|||	 | t|t	|	|   }n||| t|t	|  }nH|
dkrn||| | | | t|t	|| | |   }ntdn|tj
kr\|
dkrt|	tst|	}	||	j
| t|	|  }n|
d	kr|	dk	r|||	 | t|t	|	|   }n||| t|t	|  }nD|
dkrR||| | | | t|| | | |  }ntdntd
|rt|ttfr|j|  n
|| |||
|B K }|}q2W ||K }|S )al
  Helper method for constructing grammars of expressions made up of
    operators working in a precedence hierarchy.  Operators may be unary
    or binary, left- or right-associative.  Parse actions can also be
    attached to operator expressions. The generated parser will also
    recognize the use of parentheses to override operator precedences
    (see example below).

    Note: if you define a deep operator list, you may see performance
    issues when using infixNotation. See
    :class:`ParserElement.enablePackrat` for a mechanism to potentially
    improve your parser performance.

    Parameters:
     - baseExpr - expression representing the most basic element for the
       nested
     - opList - list of tuples, one for each operator precedence level
       in the expression grammar; each tuple is of the form ``(opExpr,
       numTerms, rightLeftAssoc, parseAction)``, where:

       - opExpr is the pyparsing expression for the operator; may also
         be a string, which will be converted to a Literal; if numTerms
         is 3, opExpr is a tuple of two expressions, for the two
         operators separating the 3 terms
       - numTerms is the number of terms for this operator (must be 1,
         2, or 3)
       - rightLeftAssoc is the indicator whether the operator is right
         or left associative, using the pyparsing-defined constants
         ``opAssoc.RIGHT`` and ``opAssoc.LEFT``.
       - parseAction is the parse action to be associated with
         expressions matching this operator expression (the parse action
         tuple member may be omitted); if the parse action is passed
         a tuple or list of functions, this is equivalent to calling
         ``setParseAction(*fn)``
         (:class:`ParserElement.setParseAction`)
     - lpar - expression for matching left-parentheses
       (default= ``Suppress('(')``)
     - rpar - expression for matching right-parentheses
       (default= ``Suppress(')')``)

    Example::

        # simple example of four-function arithmetic with ints and
        # variable names
        integer = pyparsing_common.signed_integer
        varname = pyparsing_common.identifier

        arith_expr = infixNotation(integer | varname,
            [
            ('-', 1, opAssoc.RIGHT),
            (oneOf('* /'), 2, opAssoc.LEFT),
            (oneOf('+ -'), 2, opAssoc.LEFT),
            ])

        arith_expr.runTests('''
            5+3*6
            (5+3)*6
            -2--11
            ''', fullDump=False)

    prints::

        5+3*6
        [[5, '+', [3, '*', 6]]]

        (5+3)*6
        [[[5, '+', 3], '*', 6]]

        -2--11
        [[['-', 2], '-', ['-', 11]]]
    c               @   s   e Zd ZdddZdS )zinfixNotation.<locals>._FBTc             S   s   | j || |g fS )N)r  r  )r   r  r   r  r   r   r   r     s    z$infixNotation.<locals>._FB.parseImplN)T)r   r   r   r   r   r   r   r   _FB  s   r  )NNr  r   z%s termz	%s%s termr   z@if numterms=3, opExpr must be a tuple or list of two expressionsr   z6operator must be unary (1), binary (2), or ternary (3)z2operator must indicate right or left associativity)r*   r+   r   r   r<  r  rr   LEFTr-   r6   RIGHTr   r8   r  r;  r  r   )baseExpropListlparrparr  r   lastExprr   operDefopExprarityrightLeftAssocr   termNameopExpr1opExpr2thisExprr[  r   r   r   r   d  sZ    H

&
 



&


z4"(?:[^"\n\r\\]|(?:"")|(?:\\(?:[^x]|x[0-9a-fA-F]+)))*"z string enclosed in double quotesz4'(?:[^'\n\r\\]|(?:'')|(?:\\(?:[^x]|x[0-9a-fA-F]+)))*'z string enclosed in single quotesz*quotedString using single or double quotesuzunicode string literalc             C   s  | |krt d|dkr*t| tr"t|tr"t| dkrt|dkr|dk	rtt| t| | tj dd 	dd }n$t
 t| | tj 	dd  }nx|dk	rtt| t|   t|  ttjdd 	dd }n4ttt|  t|  ttjdd 	d	d }nt d
t
 }|dk	rd|tt| t||B |B  t| K }n$|tt| t||B  t| K }|d| |f  |S )a	  Helper method for defining nested lists enclosed in opening and
    closing delimiters ("(" and ")" are the default).

    Parameters:
     - opener - opening character for a nested list
       (default= ``"("``); can also be a pyparsing expression
     - closer - closing character for a nested list
       (default= ``")"``); can also be a pyparsing expression
     - content - expression for items within the nested lists
       (default= ``None``)
     - ignoreExpr - expression for ignoring opening and closing
       delimiters (default= :class:`quotedString`)

    If an expression is not provided for the content argument, th