 )r\  r   r   z  s    ztraceParseAction.<locals>.z)r   r   r   )r\  r8  r   )r\  r   r     s    
,c             C   s`   t | d t | d t |  d }|rBt| t||   |S | tt||   |S dS )a  Helper to define a delimited list of expressions - the delimiter
    defaults to ','. By default, the list elements and delimiters can
    have intervening whitespace, and comments, but this can be
    overridden by passing ``combine=True`` in the constructor. If
    ``combine`` is set to ``True``, the matching tokens are
    returned as a single token string, with the delimiters included;
    otherwise, the matching tokens are returned as a list of tokens,
    with the delimiters suppressed.

    Example::

        delimitedList(Word(alphas)).parseString("aa,bb,cc") # -> ['aa', 'bb', 'cc']
        delimitedList(Word(hexnums), delim=':', combine=True).parseString("AA:BB:CC:DD:EE") # -> ['AA:BB:CC:DD:EE']
    z [r   z]...N)r   r&   rO   r  rH   )r  delimcombinedlNamer   r   r   r^     s    $c                sj   t    fdd}|dkr0ttdd }n| }|d |j|dd |  d	t d
 S )a>  Helper to define a counted list of expressions.

    This helper defines a pattern of the form::

        integer expr expr expr...

    where the leading integer tells how many expr expressions follow.
    The matched tokens returns the array of expr tokens as a list - the
    leading count token is suppressed.

    If ``intExpr`` is specified, it should be a pyparsing expression
    that produces an integer value.

    Example::

        countedArray(Word(alphas)).parseString('2 ab cd ef')  # -> ['ab', 'cd']

        # in this parser, the leading integer value is given in binary,
        # '10' indicating that 2 values are in the array
        binaryConstant = Word('01').setParseAction(lambda t: int(t[0], 2))
        countedArray(Word(alphas), intExpr=binaryConstant).parseString('10 ab cd ef')  # -> ['ab', 'cd']
    c                s.   |d } |r t tg| p&t t>  g S )Nr   )r-   r"   ra   )r   r   r   r9  )	arrayExprr  r   r   countFieldParseAction  s    "z+countedArray.<locals>.countFieldParseActionNc             S   s   t | d S )Nr   )r   )r   r   r   r   r     r   zcountedArray.<locals>.<lambda>arrayLenT)r  z(len) z...)r+   rL   rp   r   rR  r  r  r   )r  intExprr>  r   )r=  r  r   rZ     s    
c             C   s:   g }x0| D ](}t |tr(|t| q
|| q
W |S )N)r   r  rO  r)  r   )Lr   r   r   r   r   r)  
  s    

r)  c                s6   t    fdd}| j|dd  dt|    S )a4  Helper to define an expression that is indirectly defined from
    the tokens matched in a previous expression, that is, it looks for
    a 'repeat' of a previous expression.  For example::

        first = Word(nums)
        second = matchPreviousLiteral(first)
        matchExpr = first + ":" + second

    will match ``"1:1"``, but not ``"1:2"``.  Because this
    matches a previous literal, will also match the leading
    ``"1:1"`` in ``"1:10"``. If this is not desired, use
    :class:`matchPreviousExpr`. Do *not* use with packrat parsing
    enabled.
    c                sP   |rBt |dkr |d >  qLt| } tdd |D >  n
 t >  d S )Nr   r   c             s   s   | ]}t |V  qd S )N)r1   )r   ttr   r   r   r   *  s    zDmatchPreviousLiteral.<locals>.copyTokenToRepeater.<locals>.<genexpr>)r   r)  r  r"   r)   )r   r   r   tflat)repr   r   copyTokenToRepeater#  s    z1matchPreviousLiteral.<locals>.copyTokenToRepeaterT)r  z(prev) )r+   r  r  r   )r  rE  r   )rD  r   rm     s
    
c                sF   t   |  } |K   fdd}| j|dd  dt|    S )aT  Helper to define an expression that is indirectly defined from
    the tokens matched in a previous expression, that is, it looks for
    a 'repeat' of a previous expression.  For example::

        first = Word(nums)
        second = matchPreviousExpr(first)
        matchExpr = first + ":" + second

    will match ``"1:1"``, but not ``"1:2"``.  Because this
    matches by expressions, will *not* match the leading ``"1:1"``
    in ``"1:10"``; the expressions are evaluated first, and then
    compared, so ``"1"`` is compared with ``"10"``. Do *not* use
    with packrat parsing enabled.
    c                s*   t |   fdd}j|dd d S )Nc                s$   t | }| kr tdddd S )Nr   r   )r)  r  r<   )r   r   r   theseTokens)matchTokensr   r   mustMatchTheseTokensE  s    zLmatchPreviousExpr.<locals>.copyTokenToRepeater.<locals>.mustMatchTheseTokensT)r  )r)  r  r   )r   r   r   rH  )rD  )rG  r   rE  C  s    z.matchPreviousExpr.<locals>.copyTokenToRepeaterT)r  z(prev) )r+   rR  r  r  r   )r  e2rE  r   )rD  r   rl   1  s    c             C   s>   xdD ]}|  |t| } qW |  dd} |  dd} t| S )Nz\^-[]r   z\nr  z\t)r   _bslashr   )r   r   r   r   r   r  N  s
    
r  c                s  t |trtjddd |r:dd }dd }|r4tnt ndd }dd }|rRtnt g }t | trn|  }n$t | t	rt
| }ntjd	tdd |st S |s2d
}x|t
|d k r0|| }xjt||d d D ]J\}	}
||
|r|||	 d = P q|||
r|||	 d = |||
 P qW |d7 }qW |s|s|ryht
|t
d
|krtdd
dd |D  d|S tddd |D d|S W n& tk
r   tjdtdd Y nX t fdd|D d|S )a  Helper to quickly define a set of alternative Literals, and makes
    sure to do longest-first testing when there is a conflict,
    regardless of the input order, but returns
    a :class:`MatchFirst` for best performance.

    Parameters:

     - strs - a string of space-delimited literals, or a collection of
       string literals
     - caseless - (default= ``False``) - treat all literals as
       caseless
     - useRegex - (default= ``True``) - as an optimization, will
       generate a Regex object; otherwise, will generate
       a :class:`MatchFirst` object (if ``caseless=True`` or ``asKeyword=True``, or if
       creating a :class:`Regex` raises an exception)
     - asKeyword - (default=``False``) - enforce Keyword-style matching on the
       generated expressions

    Example::

        comp_oper = oneOf("< = > <= >= !=")
        var = Word(alphas)
        number = Word(nums)
        term = var | number
        comparison_expr = term + comp_oper + term
        print(comparison_expr.searchString("B = 12  AA=23 B<=AA AA>12"))

    prints::

        [['B', '=', '12'], ['AA', '=', '23'], ['B', '<=', 'AA'], ['AA', '>', '12']]
    z_More than one string argument passed to oneOf, pass choices as a list or space-delimited stringr   )r0  c             S   s   |   |  kS )N)r  )rU  br   r   r   r   {  r   zoneOf.<locals>.<lambda>c             S   s   |  |   S )N)r  r   )rU  rK  r   r   r   r   |  r   c             S   s   | |kS )Nr   )rU  rK  r   r   r   r     r   c             S   s
   | | S )N)r   )rU  rK  r   r   r   r     r   z6Invalid argument to oneOf, expected string or iterabler   r   Nr   z[%s]c             s   s   | ]}t |V  qd S )N)r  )r   symr   r   r   r     s    zoneOf.<locals>.<genexpr>z | |c             s   s   | ]}t |V  qd S )N)r   r  )r   rL  r   r   r   r     s    z7Exception creating Regex for oneOf, building MatchFirstc             3   s   | ]} |V  qd S )Nr   )r   rL  )parseElementClassr   r   r     s    )r   r  r3  r4  r#   r$   r.   r1   r   r
   r  r5  r4   r   r   rK  r   rD   r  r  r3   )strsr  useRegexr  isequalmaskssymbolsr   curr0  rS  r   )rN  r   rq   V  sR     







((c             C   s   t tt| | S )a  Helper to easily and clearly define a dictionary by specifying
    the respective patterns for the key and value.  Takes care of
    defining the :class:`Dict`, :class:`ZeroOrMore`, and
    :class:`Group` tokens in the proper order.  The key pattern
    can include delimiting markers or punctuation, as long as they are
    suppressed, thereby leaving the significant key text.  The value
    pattern can include named results, so that the :class:`Dict` results
    can include named token fiel