d  | jkrHt||| j| |g fS )Nr   r   )r   r  r<   r  )r   r  r   r  r  r   r   r   r     s    zWordEnd.parseImpl)T)r   r   r   r   rt   r   r   r  r   r   )r  r   rM     s   c                   sz   e Zd ZdZd fdd	Zdd Zdd Z fd	d
Z fddZ fd
dZ	dddZ
 fddZd fdd	Z  Z
S )r=   z]Abstract subclass of ParserElement, for combining and
    post-processing parsed tokens.
    Fc                s   t t | t|tr"t|}t|tr< |g _nt|t	rP|g _nnt|t
rt|}tdd |D r fdd|D }t| _n,yt| _W n tk
r   |g _Y nX d _
d S )Nc             s   s   | ]}t |tV  qd S )N)r   r  )r   r  r   r   r   r   *  s    z+ParseExpression.__init__.<locals>.<genexpr>c             3   s&   | ]}t |tr |n|V  qd S )N)r   r  r  )r   r  )r   r   r   r   +  s    F)r{  r=   r   r   r  r  r  r  exprsrA   r
   r  r!  r  )r   r  r  )r  )r   r   r     s"    




zParseExpression.__init__c             C   s   | j | d | _| S )N)r  r   r  )r   rS  r   r   r   r   4  s    zParseExpression.appendc             C   s4   d| _ dd | jD | _x| jD ]}|  q W | S )zExtends ``leaveWhitespace`` defined in base class, and also invokes ``leaveWhitespace`` on
           all contained expressions.Fc             S   s   g | ]}|  qS r   )rR  )r   r  r   r   r   r   =  s    z3ParseExpression.leaveWhitespace.<locals>.<listcomp>)r  r  rK  )r   r  r   r   r   rK  9  s
    zParseExpression.leaveWhitespacec                sz   t |trF|| jkrvtt| | xP| jD ]}|| jd  q,W n0tt| | x| jD ]}|| jd  q^W | S )Nr   )r   rH   r  r{  r=   rN  r  )r   rS  r  )r  r   r   rN  B  s    

zParseExpression.ignorec                sL   yt t|  S  tk
r"   Y nX | jd krFd| jjt| jf | _| jS )Nz%s:(%s))	r{  r=   r   r  r  r  r   r   r  )r   )r  r   r   r   N  s    
zParseExpression.__str__c                s.  t t|   x| jD ]}|  qW t| jdkr| jd }t|| jr|js|jd kr|j	s|jd d  | jd g | _d | _
|  j|jO  _|  j|jO  _| jd }t|| jr|js|jd kr|j	s| jd d |jd d   | _d | _
|  j|jO  _|  j|jO  _dt
|  | _| S )Nr   r   r   r   z	Expected )r{  r=   r  r  r   r   r  r  r  r  r  r  r  r   r  )r   r  rS  )r  r   r   r  X  s0    


zParseExpression.streamlineNc             C   sF   |d k	r|ng d d  | g }x| j D ]}|| q&W | g  d S )N)r  rV  rT  )r   rU  tmpr  r   r   r   rV  z  s    zParseExpression.validatec                s$   t t|  }dd | jD |_|S )Nc             S   s   g | ]}|  qS r   )rR  )r   r  r   r   r   r     s    z(ParseExpression.copy.<locals>.<listcomp>)r{  r=   rR  r  )r   r   )r  r   r   rR    s    zParseExpression.copyc                sZ   t jrHx@| jD ]6}t|tr|jrtjdd|t	| j
|jdd qW tt| 
||S )Nz]{0}: setting results name {1!r} on {2} expression collides with {3!r} on contained expressionr   r   )r0  )r   r   r  r   rA   r  r3  r4  r   r   r   r{  r=   r  )r   r  r  r  )r  r   r   r    s    zParseExpression._setResultsName)F)N)F)r   r   r   r   r   r   rK  rN  r   r  rV  rR  r  r  r   r   )r  r   r=     s   	
"
c                   s`   e Zd ZdZG dd deZd fdd	Z fddZdd	d
Zdd Z	d
d Z
dd Z  ZS )r"   a  
    Requires all given :class:`ParseExpression` s to be found in the given order.
    Expressions may be separated by whitespace.
    May be constructed using the ``'+'`` operator.
    May also be constructed using the ``'-'`` operator, which will
    suppress backtracking.

    Example::

        integer = Word(nums)
        name_expr = OneOrMore(Word(alphas))

        expr = And([integer("id"), name_expr("name"), integer("age")])
        # more easily written as:
        expr = integer("id") + name_expr("name") + integer("age")
    c                   s   e Zd Z fddZ  ZS )zAnd._ErrorStopc                s&   t tj| j|| d| _|   d S )N-)r{  r"   r6  r   r  rK  )r   r   rE  )r  r   r   r     s    zAnd._ErrorStop.__init__)r   r   r   r   r  r   r   )r  r   r6    s   r6  Tc                s   t |}|rt|krg }xlt|D ]`\}}|tkrx|t|d k rnt ||d   jd }|t|d qtdq"|| q"W ||d d < t	t
| || tdd | jD | _
| | jd j | jd j| _d| _d S )	Nr   r   z	_skipped*z0cannot construct And with sequence ending in ...c             s   s   | ]}|j V  qd S )N)r  )r   r  r   r   r   r     s    zAnd.__init__.<locals>.<genexpr>r   T)r  r1  r   r   r)   r  r   rE   r  r{  r"   r   r  r  rL  r  r  r  )r   r  r  r  r   r  
skipto_arg)r  r   r   r     s     
zAnd.__init__c                s   | j rtdd | j d d D rxtt| j d d D ]^\}}|d krHq6t|tr6|j r6t|j d tr6|j d | j |d   |j d< d | j |d < q6W dd | j D | _ tt|   t	dd | j D | _
| S )Nc             s   s.   | ]&}t |to$|jo$t |jd  tV  qdS )r   N)r   r=   r  r2  )r   r  r   r   r   r     s   z!And.streamline.<locals>.<genexpr>r   r   c             S   s   g | ]}|d k	r|qS )Nr   )r   r  r   r   r   r     s    z"And.streamline.<locals>.<listcomp>c             s   s   | ]}|j V  qd S )N)r  )r   r  r   r   r   r     s    )r  r  r   r   r=   r2  r{  r"   r  r  r  )r   r   r  )r  r   r   r    s    
zAnd.streamlinec       	      C   s  | j d j|||dd\}}d}x| j dd  D ]}t|tjrFd}q0|ry||||\}}W q tk
rv    Y q tk
r } zd |_t|W d d }~X Y q t	k
r   t|t
|| j| Y qX n||||\}}|s| r0||7 }q0W ||fS )Nr   F)r  r   T)
r  r  r   r"   r6  r@   r:   r   r   r"  r   r  rC  )	r   r  r   r  
resultlist	errorStopr  
exprtokensr   r   r   r   r     s(    z
And.parseImplc             C   s   t |tr| |}| |S )N)r   r  r  r   )r   rS  r   r   r   rN    s    

zAnd.__iadd__c             C   s8   |d d  | g }x | j D ]}|| |jsP qW d S )N)r  rT  r  )r   r  subRecCheckListr  r   r   r   rT    s
    
zAnd.checkRecursionc             C   s@   t | dr| jS | jd kr:dddd | jD  d | _| jS )Nr  {r   c             s   s   | ]}t |V  qd S )N)r   )r   r  r   r   r   r     s    zAnd.__str__.<locals>.<genexpr>})r;  r  r  r   r  )r   r   r   r   r     s
    

 zAnd.__str__)T)T)
r   r   r   r   r)   r6  r   r  r   rN  rT  r   r  r   r   )r  r   r"     s   
c                   s^   e Zd ZdZd fdd	Z fddZddd	Zd
d Zdd
 Zdd Z	d fdd	Z
  ZS )r9   a  Requires that at least one :class:`ParseExpression` is found. If
    two expressions match, the expression that matches the longest
    string will be used. May be constructed using the ``'^'``
    operator.

    Example::

        # construct Or using '^' operator

        number = Word(nums) ^ Combine(Word(nums) + '.' + Word(nums))
        print(number.searchString("123 3.1416 789"))

    prints::

        [['123'], ['3.1416'], ['789']]
    Fc                s:   t t| || | jr0tdd | jD | _nd| _d S )Nc             s   s   | ]}|j V  qd S )N)r  )r   r  r   r   r   r     s    zOr.__init__.<locals>.<genexpr>T)r{  r9   r   r  r  r  )r   r  r  )r  r   r   r     s    zOr.__init__c                s.   t t|   tjr*tdd | jD | _| S )Nc             s   s   | ]}|j V  qd S )N)r  )r   r  r   r   r   r     s    z Or.streamline.<locals>.<genexpr>)r{  r9   r  r!   collect_all_And_tokensr  r  r  )r   )r  r   r   r    s    z
Or.streamlineTc             C   s  d}d }g }x| j D ]}y|||}W nv tk
rd }	 zd |	_|	j|krT|	}|	j}W d d }	~	X Y q tk
r   t||krt|t||j| }t|}Y qX |||f qW |r|j	t
ddd |s|d d }
|
|||S d}x|D ]\}}
||d kr|S y|
|||\}}W n@ tk
rb }	 z d |	_|	j|krR|	}|	j}W d d }	~	X Y qX ||krv||fS ||d kr||f}qW |dkr|S |d k	r| j|_|nt||d| d S )Nr   r   T)rI  r+  r   )r   Nz no defined alternatives to match)
r  r  r<   r   r   r"  r   r  r   sortr   r  r   )r   r  r   r  	maxExcLocmaxExceptionr$  r  loc2r  	best_exprlongestloc1expr1r  r   r   r   r     sT    



zOr.parseImplc             C   s   t |tr| |}| |S )N)r   r  r  r   )r   rS  r   r   r   __ixor__[  s    

zOr.__ixor__c             C   s@   t | dr| jS | jd kr:dddd | jD  d | _| jS )Nr  r  z ^ c             s   s   | ]}t |V  qd S )N)r   )r   r  r   r   r   r   e  s    zOr.__str__.<locals>.<genexpr>r  )r;  r  r  r   r  )r   r   r   r   r   `  s
    

 z
Or.__str__c             C   s0   |d d  | g }x| j D ]}|| qW d S )N)r  rT  )r   r  r  r  r   r   r   rT  i  s    zOr.checkRecursionc                sP   t js>tjr>tdd | jD r>tjdd|t	| j
dd tt| 
||S )Nc             s   s   | ]}t |tV  qd S )N)r   r"   )r   r  r   r   r   r   q  s    z%Or._setResultsName.<locals>.<genexpr>z{0}: setting results name {1!r} on {2} expression may only return a single token for an And alternative, in future will return the full list of tokensr   r   )r0  )r!   r  r   r   r  r  r3  r4  r   r   r   r{  r9   r  )r   r  r  )r  r   r   r  n  s    zOr._setResultsName)F)T)F)r   r   r   r   r   r  r   r  r   rT  r  r  r   r   )r  r   r9      s   
=	c                   s^   e Zd ZdZd fdd	Z fddZddd	Zd
d Zdd
 Zdd Z	d fdd	Z
  ZS )r3   a  Requires that at least one :class:`ParseExpression` is found. If
    two expressions match, the first one listed is the one that will
    match. May be constructed using the ``'|'`` operator.

    Example::

        # construct MatchFirst using '|' operator

        # watch the order of expressions to match
        number = Word(nums) | Combine(Word(nums) + '.' + Word(nums))
        print(number.searchString("123 3.1416 789")) #  Fail! -> [['123'], ['3'], ['1416'], ['789']]

        # put more selective expression first
        number = Combine(Word(nums) + '.' + Word(nums)) | Word(nums)
        print(number.searchString("123 3.1416 789")) #  Better -> [['123'], ['3.1416'], ['789']]
    Fc                s:   t t| || | jr0tdd | jD | _nd| _d S )Nc             s   s   | ]}|j V  qd S )N)r  )r   r  r   r   r   r     s    z&MatchFirst.__init__.<locals>.<genexpr>T)r{  r3   r   r  r  r  )r   r  r  )r  r   r   r     s    zMatchFirst.__init__c                s.   t t|   tjr*tdd | jD | _| S )Nc             s   s   | ]}|j V  qd S )N)r  )r   r  r   r   r   r     s    z(MatchFirst.streamline.<locals>.<genexpr>)r{  r3   r  r!   r  r  r  r  )r   )r  r   r   r    s    zMatchFirst.streamlineTc       	      C   s   d}d }x| j D ]}y||||}|S  tk
r\ } z|j|krL|}|j}W d d }~X Y q tk
r   t||krt|t||j| }t|}Y qX qW |d k	r| j|_|nt||d| d S )Nr   z no defined alternatives to match)r  r  r<   r   r"  r   r  r   )	r   r  r   r  r  r  r  r   r  r   r   r   r     s$    
zMatchFirst.parseImplc             C   s   t |tr| |}| |S )N)r   r  r  r   )r   rS  r   r   r   __ior__  s    

zMatchFirst.__ior__c             C   s@   t | dr| jS | jd kr:dddd | jD  d | _| jS )Nr  r  z | c             s   s   | ]}t |V  qd S )N)r   )r   r  r   r   r   r     s    z%MatchFirst.__str__.<locals>.<genexpr>r  )r;  r  r  r   r  )r   r   r   r   r     s
    

 zMatchFirst.__str__c             C   s0   |d d  | g }x| j D ]}|| qW d S )N)r  rT  )r   r  r  r  r   r   r   rT    s    zMatchFirst.checkRecursionc                sP   t js>tjr>tdd | jD r>tjdd|t	| j
dd tt| 
||S )Nc             s   s   | ]}t |tV  qd S )N)r   r"   )r   r  r   r   r   r     s    z-MatchFirst._setResultsName.<locals>.<genexpr>z{0}: setting results name {1!r} on {2} expression may only return a single token for an And alternative, in future will return the full list of tokensr   r   )r0  )r!   r  r   r   r  r  r3  r4  r   r   r   r{  r3   r  )r   r  r  )r  r   r   r    s    zMatchFirst._setResultsName)F)T)F)r   r   r   r   r   r  r   r  r   rT  r  r  r   r   )r  r   r3   {  s   
	c                   sH   e Zd ZdZd
 fdd	Z fddZdddZd	d
 Zdd Z  Z	S )r(   as  Requires all given :class:`ParseExpression` s to be found, but in
    any order. Expressions may be separated by whitespace.

    May be constructed using the ``'&'`` operator.

    Example::

        color = oneOf("RED ORANGE YELLOW GREEN BLUE PURPLE BLACK WHITE BROWN")
        shape_type = oneOf("SQUARE CIRCLE TRIANGLE STAR HEXAGON OCTAGON")
        integer = Word(nums)
        shape_attr = "shape:" + shape_type("shape")
        posn_attr = "posn:" + Group(integer("x") + ',' + inte