         of your app to be able to run independently. If used, this
            would typically be "<major>.<minor>".
            Only applied when appname is present.
        "multipath" is an optional parameter only applicable to *nix
            which indicates that the entire list of config dirs should be
            returned. By default, the first item from XDG_CONFIG_DIRS is
            returned, or '/etc/xdg/<AppName>', if XDG_CONFIG_DIRS is not set

    Typical site config directories are:
        Mac OS X:   same as site_data_dir
        Unix:       /etc/xdg/<AppName> or $XDG_CONFIG_DIRS[i]/<AppName> for each value in
                    $XDG_CONFIG_DIRS
        Win *:      same as site_data_dir
        Vista:      (Fail! "C:\ProgramData" is a hidden *system* directory on Vista.)

    For Unix, this is using the $XDG_CONFIG_DIRS[0] default, if multipath=False

    WARNING: Do not use this on Windows. See the Vista-Fail note above for why.
    )r   r
   XDG_CONFIG_DIRSz/etc/xdgc             S   s$   g | ]}|rt j|t jqS r   )r   r   r   r#   r$   )r   r%   r   r   r   r&      s    z#site_config_dir.<locals>.<listcomp>c                s   g | ]}t j| qS r   )r   r   r   )r   r%   )r   r   r   r&      s    r   )r   r+   r   r   r   r   r(   r'   )r   r   r   r)   r   r*   r   )r   r   site_config_dir   s    
r/   Tc             C   s   t dkrz|dkr| }tjtd}ts:t|tr:t|}| r|dk	rXtj	||| }ntj	|| }|rtj	|d}nNt dkrtj
d}| rtj	|| }n&tdtj
d	}| rtj	|| }| r|rtj	||}|S )
a  Return full path to the user-specific cache dir for this application.

        "appname" is the name of application.
            If None, just the system directory is returned.
        "appauthor" (only used on Windows) is the name of the
            appauthor or distributing body for this application. Typically
            it is the owning company name. This falls back to appname. You may
            pass False to disable it.
        "version" is an optional version path element to append to the
            path. You might want to use this if you want multiple versions
            of your app to be able to run independently. If used, this
            would typically be "<major>.<minor>".
            Only applied when appname is present.
        "opinion" (boolean) can be False to disable the appending of
            "Cache" to the base app data dir for Windows. See
            discussion below.

    Typical user cache directories are:
        Mac OS X:   ~/Library/Caches/<AppName>
        Unix:       ~/.cache/<AppName> (XDG default)
        Win XP:     C:\Documents and Settings\<username>\Local Settings\Application Data\<AppAuthor>\<AppName>\Cache
        Vista:      C:\Users\<username>\AppData\Local\<AppAuthor>\<AppName>\Cache

    On Windows the only suggestion in the MSDN docs is that local settings go in
    the `CSIDL_LOCAL_APPDATA` directory. This is identical to the non-roaming
    app data dir (the default returned by `user_data_dir` above). Apps typically
    put cache data somewhere *under* the given dir here. Some examples:
        ...\Mozilla\Firefox\Profiles\<ProfileName>\Cache
        ...\Acme\SuperApp\Cache\1.0
    OPINION: This function appends "Cache" to the `CSIDL_LOCAL_APPDATA` value.
    This can be disabled with the `opinion=False` option.
    r   Nr   FCacher
   z~/Library/CachesXDG_CACHE_HOMEz~/.cache)r   r   r   r   r   PY3
isinstanceunicode_win_path_to_bytesr   r   r   )r   r   r   opinionr   r   r   r   user_cache_dir  s,    !r7   c             C   sX   t dkrt| |d|}n&tdtjd}| r>tj|| }| rT|rTtj||}|S )a  Return full path to the user-specific state dir for this application.

        "appname" is the name of application.
            If None, just the system directory is returned.
        "appauthor" (only used on Windows) is the name of the
            appauthor or distributing body for this application. Typically
            it is the owning company name. This falls back to appname. You may
            pass False to disable it.
        "version" is an optional version path element to append to the
            path. You might want to use this if you want multiple versions
            of your app to be able to run independently. If used, this
            would typically be "<major>.<minor>".
            Only applied when appname is present.
        "roaming" (boolean, default False) can be set True to use the Windows
            roaming appdata directory. That means that for users on a Windows
            network setup for roaming profiles, this user data will be
            sync'd on login. See
            <http://technet.microsoft.com/en-us/library/cc766489(WS.10).aspx>
            for a discussion of issues.

    Typical user state directories are:
        Mac OS X:  same as user_data_dir
        Unix:      ~/.local/state/<AppName>   # or in $XDG_STATE_HOME, if defined
        Win *:     same as user_data_dir

    For Unix, we follow this Debian proposal <https://wiki.debian.org/XDGBaseDirectorySpecification#state>
    to extend the XDG spec and support $XDG_STATE_HOME.

    That means, by default "~/.local/state/<AppName>".
    )r   r
   NXDG_STATE_HOMEz~/.local/state)r   r    r   r   r   r   r   )r   r   r   r   r   r   r   r   user_state_dirE  s    r9   c             C   s   t dkr tjtjd| }nNt dkrLt| ||}d}|rntj|d}n"t| ||}d}|rntj|d}| r|rtj||}|S )a  Return full path to the user-specific log dir for this application.

        "appname" is the name of application.
            If None, just the system directory is returned.
        "appauthor" (only used on Windows) is the name of the
            appauthor or distributing body for this application. Typically
            it is the owning company name. This falls back to appname. You may
            pass False to disable it.
        "version" is an optional version path element to append to the
            path. You might want to use this if you want multiple versions
            of your app to be able to run independently. If used, this
            would typically be "<major>.<minor>".
            Only applied when appname is present.
        "opinion" (boolean) can be False to disable the appending of
            "Logs" to the base app data dir for Windows, and "log" to the
            base cache dir for Unix. See discussion below.

    Typical user log directories are:
        Mac OS X:   ~/Library/Logs/<AppName>
        Unix:       ~/.cache/<AppName>/log  # or under $XDG_CACHE_HOME if defined
        Win XP:     C:\Documents and Settings\<username>\Local Settings\Application Data\<AppAuthor>\<AppName>\Logs
        Vista:      C:\Users\<username>\AppData\Local\<AppAuthor>\<AppName>\Logs

    On Windows the only suggestion in the MSDN docs is that local settings
    go in the `CSIDL_LOCAL_APPDATA` directory. (Note: I'm interested in
    examples of what some windows apps use for a logs dir.)

    OPINION: This function appends "Logs" to the `CSIDL_LOCAL_APPDATA`
    value for Windows and appends "log" to the user cache dir for Unix.
    This can be disabled with the `opinion=False` option.
    r
   z~/Library/Logsr   FLogslog)r   r   r   r   r   r    r7   )r   r   r   r6   r   r   r   r   user_log_diro  s      
r<   c               @   sn   e Zd ZdZdddZedd Zedd	 Zed
d Zedd
 Z	edd Z
edd Zedd ZdS )AppDirsz1Convenience wrapper for getting application dirs.NFc             C   s"   || _ || _|| _|| _|| _d S )N)r   r   r   r   r)   )selfr   r   r   r   r)   r   r   r   __init__  s
    zAppDirs.__init__c             C   s   t | j| j| j| jdS )N)r   r   )r    r   r   r   r   )r>   r   r   r   r      s    
zAppDirs.user_data_dirc             C   s   t | j| j| j| jdS )N)r   r)   )r+   r   r   r   r)   )r>   r   r   r   r+     s    
zAppDirs.site_data_dirc             C   s   t | j| j| j| jdS )N)r   r   )r-   r   r   r   r   )r>   r   r   r   r-     s    
zAppDirs.user_config_dirc             C   s   t | j| j| j| jdS )N)r   r)   )r/   r   r   r   r)   )r>   r   r   r   r/     s    
zAppDirs.site_config_dirc             C   s   t | j| j| jdS )N)r   )r7   r   r   r   )r>   r   r   r   r7     s    
zAppDirs.user_cache_dirc             C   s   t | j| j| jdS )N)r   )r9   r   r   r   )r>   r   r   r   r9     s    
zAppDirs.user_state_dirc             C   s   t | j| j| jdS )N)r   )r<   r   r   r   )r>   r   r   r   r<     s    
zAppDirs.user_log_dir)NNNFF)
__name__
__module____qualname____doc__r?   propertyr    r+   r-   r/   r7   r9   r<   r   r   r   r   r=     s    
r=   c             C   sH   t rddl}nddl}dddd|  }||jd}|||\}}|S )zThis is a fallback technique at best. I'm not sure if using the
    registry for this guarantees us the correct answer for all CSIDL_*
    names.
    r   NAppDatazCommon AppDataz
Local AppData)r   r!   r   z@Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders)r2   winreg_winregOpenKeyHKEY_CURRENT_USERQueryValueEx)
csidl_namerG   shell_folder_namekeydirtyper   r   r   _get_win_folder_from_registry  s    
rP   c             C   s   ddl m}m} |dt|| dd}y`t|}d}x|D ]}t|dkr:d}P q:W |rydd l}||}W n t	k
r   Y nX W n t
k
r   Y nX |S )Nr   )shellconshellF   T)win32com.shellrQ   rR   SHGetFolderPathgetattrr4   ordwin32apiGetShortPathNameImportErrorUnicodeError)rK   rQ   rR   rN   
has_high_charcrX   r   r   r   _get_win_folder_with_pywin32  s$    

r^   c             C   s   dd l }dddd|  }|d}|jjd |d d| d}x|D ]}t|dkrBd	}P qBW |r|d}|jj|j|dr|}|jS )
Nr      #      )r   r!   r   i   FrS   T)	ctypescreate_unicode_bufferwindllshell32SHGetFolderPathWrW   kernel32GetShortPathNameWvalue)rK   rb   csidl_constbufr\   r]   buf2r   r   r   _get_win_folder_with_ctypes  s"    


rm   c             C   s   dd l }ddlm} ddlm} |jjd }|d|}|jj	}|
d t|j| d |jj
| |j| d}d}x|D ]}	t|	dkr~d	}P q~W |r|d|}|jj	}
|
|||r|j| d}|S )
Nr   )jna)r      r]    FrS   T)arraycom.sunrn   com.sun.jna.platformr   WinDefMAX_PATHzerosShell32INSTANCErU   rV   ShlObjSHGFP_TYPE_CURRENTNativetoStringtostringr#   rW   Kernel32rY   )rK   rq   rn   r   buf_sizerk   rR   rN   r\   r]   kernelr   r   r   _get_win_folder_with_jna  s&    
r   )rd   c          
   C   s6   x0dD ](}y
|  |S  ttfk
r,   Y qX qW | S )a  Encode Windows paths to bytes. Only used on Python 2.

    Motivation is to be consistent with other operating systems where paths
    are also returned as bytes. This avoids problems mixing bytes and Unicode
    elsewhere in the codebase. For more details and discussion see
    <https://github.com/pypa/pip/issues/3463>.

    If encoding using ASCII and MBCS fails, return the original Unicode path.
    )ASCIIMBCS)encodeUnicodeEncodeErrorLookupError)r   encodingr   r   r   r5   E  s    



r5   __main__ZMyAppZ	MyCompany)r    r-   r7   r9   r<   r+   r/   z-- app dirs %s --z%-- app dirs (with optional 'version')z1.0)r   z%s: %sz)
-- app dirs (without optional 'version')z+
-- app dirs (without optional 'appauthor')z(
-- app dirs (with disabled 'appauthor'))r   )NNNF)NNNF)NNNF)NNNF)NNNT)NNNF)NNNT)-rC   __version__tupler(   __version_info__sysr   version_infor2   strr4   platform
startswithjava_veros_namer   namer    r+   r-   r/   r7   r9   r<   objectr=   rP   r^   rm   r   rb   rd   r   rZ   Zcom.sun.jnacomr5   r@   r   r   propsprintdirsproprV   r   r   r   r   <module>	   s|   


7
B
*
4
=
*
30






                                                                                                                                                                                                                                                                                                                                                                                                                                                                          python3.7/site-packages/pip/_vendor/__pycache__/ipaddress.cpython-37.pyc                            0000644                 00000201672 15107360303 0022104 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re8                @   sl  d Z ddlmZ ddlZddlZdZefZyeefZW n e	k
rJ   Y nX ye
ZW n$ e	k
rx   eZe
eksttY nX ddkrdd Zndd Zy
ejZW n ek
r   dd	 ZY nX d
d Zeedrd
d Zndd ZdNddZG dd deZdZdZG dd deZG dd deZdd ZdOddZd d! Z d"d# Z!d$d% Z"d&d' Z#d(d) Z$d*d+ Z%d,d- Z&d.d/ Z'd0d1 Z(d2d3 Z)G d4d5 d5eZ*G d6d7 d7e*Z+G d8d9 d9e*Z,G d:d; d;eZ-G d<d= d=e-e+Z.G d>d? d?e.Z/G d@dA dAe-e,Z0G dBdC dCeZ1e1e._2G dDdE dEeZ3G dFdG dGe3e+Z4G dHdI dIe4Z5G dJdK dKe3e,Z6G dLdM dMeZ7e7e4_2dS )PzA fast, lightweight IPv4/IPv6 manipulation library in Python.

This library is used to create/poke/manipulate IPv4 and IPv6 addresses
and networks.

    )unicode_literalsNz1.0.23c             C   s   | S )N )bytr   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/ipaddress.py_compat_bytes_to_byte_vals   s    r   c             C   s   dd | D S )Nc             S   s   g | ]}t d |d qS )s   !Br   )structunpack).0br   r   r   
<listcomp>#   s    z._compat_bytes_to_byte_vals.<locals>.<listcomp>r   )r   r   r   r   r   "   s    c             C   s<   |dkst d}x&| D ]}t|ts(t |d> | }qW |S )Nbigr      )AssertionError
isinstance_compat_int_types)Zbytvals	endianessresZbvr   r   r   _compat_int_from_byte_vals'   s    
r   c             C   s   t | tst|dkst|dkrH| dk s2| dkr<tdtd| S |dkr| dk sd| dd	 krntd
td| d? | d
@ S t d S )Nr      r   l        z(integer out of range for 'I' format codes   !I         z)integer out of range for 'QQ' format codes   !QQ@   l    )r   r   r   r   errorpackNotImplementedError)Zintvallengthr   r   r   r   _compat_to_bytes0   s    

r   
bit_lengthc             C   s   |   S )N)r   )ir   r   r   _compat_bit_lengthA   s    r    c             C   s&   x t  D ]}| |? dkr
|S q
W d S )Nr   )	itertoolscount)r   r   r   r   r   r    D   s       c             c   s0   |dkst | }x||k r*|V  ||7 }qW d S )Nr   )r   )startendstepr   r   r   r   
_compat_rangeJ   s
    
r'   c               @   s@   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dS )_TotalOrderingMixinr   c             C   s   t d S )N)r   )selfotherr   r   r   __eq__Y   s    z_TotalOrderingMixin.__eq__c             C   s   |  |}|tkrtS | S )N)r+   NotImplemented)r)   r*   equalr   r   r   __ne__\   s    
z_TotalOrderingMixin.__ne__c             C   s   t d S )N)r   )r)   r*   r   r   r   __lt__b   s    z_TotalOrderingMixin.__lt__c             C   s$   |  |}|tks|s | |S |S )N)r/   r,   r+   )r)   r*   lessr   r   r   __le__e   s    

z_TotalOrderingMixin.__le__c             C   s6   |  |}|tkrtS | |}|tkr,tS |p2| S )N)r/   r,   r+   )r)   r*   r0   r-   r   r   r   __gt__k   s    

z_TotalOrderingMixin.__gt__c             C   s   |  |}|tkrtS | S )N)r/   r,   )r)   r*   r0   r   r   r   __ge__t   s    
z_TotalOrderingMixin.__ge__N)
__name__
__module____qualname__	__slots__r+   r.   r/   r1   r2   r3   r   r   r   r   r(   R   s   	r(       r   c               @   s   e Zd ZdZdS )AddressValueErrorz%A Value Error related to the address.N)r4   r5   r6   __doc__r   r   r   r   r9      s   r9   c               @   s   e Zd ZdZdS )NetmaskValueErrorz%A Value Error related to the netmask.N)r4   r5   r6   r:   r   r   r   r   r;      s   r;   c          	   C   sj   yt | S  ttfk
r    Y nX yt| S  ttfk
rB   Y nX t| trZtd|  td|  dS )a  Take an IP string/int and return an object of the correct type.

    Args:
        address: A string or integer, the IP address.  Either IPv4 or
          IPv6 addresses may be supplied; integers less than 2**32 will
          be considered to be IPv4 by default.

    Returns:
        An IPv4Address or IPv6Address object.

    Raises:
        ValueError: if the *address* passed isn't either a v4 or a v6
          address

    zx%r does not appear to be an IPv4 or IPv6 address. Did you pass in a bytes (str in Python 2) instead of a unicode object?z0%r does not appear to be an IPv4 or IPv6 addressN)IPv4Addressr9   r;   IPv6Addressr   bytes
ValueError)addressr   r   r   
ip_address   s    
rA   Tc          	   C   sn   y
t | |S  ttfk
r"   Y nX y
t| |S  ttfk
rF   Y nX t| tr^td|  td|  dS )a  Take an IP string/int and return an object of the correct type.

    Args:
        address: A string or integer, the IP network.  Either IPv4 or
          IPv6 networks may be supplied; integers less than 2**32 will
          be considered to be IPv4 by default.

    Returns:
        An IPv4Network or IPv6Network object.

    Raises:
        ValueError: if the string passed isn't either a v4 or a v6
          address. Or if the network has host bits set.

    zx%r does not appear to be an IPv4 or IPv6 network. Did you pass in a bytes (str in Python 2) instead of a unicode object?z0%r does not appear to be an IPv4 or IPv6 networkN)IPv4Networkr9   r;   IPv6Networkr   r>   r?   )r@   strictr   r   r   
ip_network   s    


rE   c          	   C   sT   yt | S  ttfk
r    Y nX yt| S  ttfk
rB   Y nX td|  dS )ag  Take an IP string/int and return an object of the correct type.

    Args:
        address: A string or integer, the IP address.  Either IPv4 or
          IPv6 addresses may be supplied; integers less than 2**32 will
          be considered to be IPv4 by default.

    Returns:
        An IPv4Interface or IPv6Interface object.

    Raises:
        ValueError: if the string passed isn't either a v4 or a v6
          address.

    Notes:
        The IPv?Interface classes describe an Address on a particular
        Network, so they're basically a combination of both the Address
        and Network classes.

    z2%r does not appear to be an IPv4 or IPv6 interfaceN)
IPv4Interfacer9   r;   
IPv6Interfacer?   )r@   r   r   r   ip_interface   s    rH   c          	   C   s4   yt | ddS  tjtfk
r.   tdY nX dS )a`  Represent an address as 4 packed bytes in network (big-endian) order.

    Args:
        address: An integer representation of an IPv4 IP address.

    Returns:
        The integer address packed as 4 bytes in network (big-endian) order.

    Raises:
        ValueError: If the integer is negative or too large to be an
          IPv4 IP address.

    r   r   z&Address negative or too large for IPv4N)r   r   r   
OverflowErrorr?   )r@   r   r   r   v4_int_to_packed   s    rJ   c          	   C   s4   yt | ddS  tjtfk
r.   tdY nX dS )zRepresent an address as 16 packed bytes in network (big-endian) order.

    Args:
        address: An integer representation of an IPv6 IP address.

    Returns:
        The integer address packed as 16 bytes in network (big-endian) order.

    r   r   z&Address negative or too large for IPv6N)r   r   r   rI   r?   )r@   r   r   r   v6_int_to_packed  s    
rK   c             C   s*   t | d}t|dkr&td|  |S )zAHelper to split the netmask and raise AddressValueError if needed/r   zOnly one '/' permitted in %r)_compat_strsplitlenr9   )r@   addrr   r   r   _split_optional_netmask  s    rQ   c             c   sR   t | }t| }}x.|D ]&}|j|jd kr<||fV  |}|}qW ||fV  dS )zFind a sequence of sorted deduplicated IPv#Address.

    Args:
        addresses: a list of IPv#Address objects.

    Yields:
        A tuple containing the first and last IP addresses in the sequence.

    r#   N)iternext_ip)	addressesitfirstlastipr   r   r   _find_address_range  s    


rZ   c             C   s$   | dkr|S t |t|  | d @ S )zCount the number of zero bits on the right hand side.

    Args:
        number: an integer.
        bits: maximum number of bits to count.

    Returns:
        The number of zero bits on the right hand side of the number.

    r   r#   )minr    )numberbitsr   r   r   _count_righthand_zero_bits2  s    r^   c             c   s   t | trt |tstd| j|jkr8td| |f | |krHtd| jdkrXt}n| jdkrht}ntd| j}| j}|j}x^||krt	t
||t|| d d }|||| f}|V  |d|> 7 }|d |jkrP qW dS )	a  Summarize a network range given the first and last IP addresses.

    Example:
        >>> list(summarize_address_range(IPv4Address('192.0.2.0'),
        ...                              IPv4Address('192.0.2.130')))
        ...                                #doctest: +NORMALIZE_WHITESPACE
        [IPv4Network('192.0.2.0/25'), IPv4Network('192.0.2.128/31'),
         IPv4Network('192.0.2.130/32')]

    Args:
        first: the first IPv4Address or IPv6Address in the range.
        last: the last IPv4Address or IPv6Address in the range.

    Returns:
        An iterator of the summarized IPv(4|6) network objects.

    Raise:
        TypeError:
            If the first and last objects are not IP addresses.
            If the first and last objects are not the same version.
        ValueError:
            If the last object is not greater than the first.
            If the version of the first address is not 4 or 6.

    z1first and last must be IP addresses, not networksz%%s and %s are not of the same versionz*last IP address must be greater than firstr      zunknown IP versionr#   N)
r   _BaseAddress	TypeErrorversionr?   rB   rC   _max_prefixlenrT   r[   r^   r    	_ALL_ONES)rW   rX   rY   ip_bits	first_intlast_intnbitsnetr   r   r   summarize_address_rangeB  s0    





rj   c             c   s   t | }i }xL|rX| }| }||}|dkr>|||< q||kr||= || qW d}x4t| D ]$}|dk	r|j|jkrql|V  |}qlW dS )au  Loops through the addresses, collapsing concurrent netblocks.

    Example:

        ip1 = IPv4Network('192.0.2.0/26')
        ip2 = IPv4Network('192.0.2.64/26')
        ip3 = IPv4Network('192.0.2.128/26')
        ip4 = IPv4Network('192.0.2.192/26')

        _collapse_addresses_internal([ip1, ip2, ip3, ip4]) ->
          [IPv4Network('192.0.2.0/24')]

        This shouldn't be called directly; it is called via
          collapse_addresses([]).

    Args:
        addresses: A list of IPv4Network's or IPv6Network's

    Returns:
        A list of IPv4Network's or IPv6Network's depending on what we were
        passed.

    N)listpopsupernetgetappendsortedvaluesbroadcast_address)rU   to_mergesubnetsri   rm   existingrX   r   r   r   _collapse_addresses_internaly  s$    

rv   c          	   C   s8  g }g }g }x| D ]}t |trT|rH|d j|jkrHtd||d f || q|j|jkr|r|d j|jkrtd||d f y||j W q tk
r   ||j	 Y qX q|r|d j|jkrtd||d f || qW t
t|}|r,x&t|D ]\}}|
t|| qW t|| S )a  Collapse a list of IP objects.

    Example:
        collapse_addresses([IPv4Network('192.0.2.0/25'),
                            IPv4Network('192.0.2.128/25')]) ->
                           [IPv4Network('192.0.2.0/24')]

    Args:
        addresses: An iterator of IPv4Network or IPv6Network objects.

    Returns:
        An iterator of the collapsed IPv(4|6)Network objects.

    Raises:
        TypeError: If passed a list of mixed version objects.

    z%%s and %s are not of the same version)r   r`   _versionra   ro   
_prefixlenrc   rY   AttributeErrornetwork_addressrp   setrZ   extendrj   rv   )rU   addrsipsnetsrY   rW   rX   r   r   r   collapse_addresses  s4    

r   c             C   s(   t | tr|  S t | tr$|  S tS )a2  Return a key suitable for sorting between networks and addresses.

    Address and Network objects are not sortable by default; they're
    fundamentally different so the expression

        IPv4Address('192.0.2.0') <= IPv4Network('192.0.2.0/24')

    doesn't make any sense.  There are some times however, where you may wish
    to 