  ZS )r1   a  Token to exactly match a specified string.

    Example::

        Literal('blah').parseString('blah')  # -> ['blah']
        Literal('blah').parseString('blahfooblah')  # -> ['blah']
        Literal('blah').parseString('bla')  # -> Exception: Expected "blah"

    For case-insensitive matching, use :class:`CaselessLiteral`.

    For keyword matching (force word break before and after the matched string),
    use :class:`Keyword` or :class:`CaselessKeyword`.
    c                s   t t|   || _t|| _y|d | _W n* tk
rV   tj	dt
dd t| _Y nX dt
| j | _d| j | _d| _d| _| jdkrt| tkrt| _d S )	Nr   z2null string passed to Literal; use Empty() insteadr   )r0  z"%s"z	Expected Fr   )r{  r1   r   matchr   matchLenfirstMatchCharr"  r3  r4  r5  r)   r  r   r  r  r  r  r   _SingleCharLiteral)r   matchString)r  r   r   r   6  s    

zLiteral.__init__Tc             C   s@   || | j kr,|| j|r,|| j | jfS t||| j| d S )N)r  r   r  r  r<   r  )r   r  r   r  r   r   r   r   J  s    zLiteral.parseImpl)T)r   r   r   r   r   r   r  r   r   )r  r   r1   (  s   
c               @   s   e Zd ZdddZdS )r  Tc             C   s0   || | j kr|d | jfS t||| j| d S )Nr   )r  r  r<   r  )r   r  r   r  r   r   r   r   P  s    z_SingleCharLiteral.parseImplN)T)r   r   r   r   r   r   r   r   r  O  s   r  c                   sL   e Zd ZdZed Zd fdd	Zddd	Z fd
dZe	dd
 Z
  ZS )r.   a  Token to exactly match a specified string as a keyword, that is,
    it must be immediately followed by a non-keyword character.  Compare
    with :class:`Literal`:

     - ``Literal("if")`` will match the leading ``'if'`` in
       ``'ifAndOnlyIf'``.
     - ``Keyword("if")`` will not; it will only match the leading
       ``'if'`` in ``'if x=1'``, or ``'if(y==2)'``

    Accepts two optional constructor arguments in addition to the
    keyword string:

     - ``identChars`` is a string of characters that would be valid
       identifier characters, defaulting to all alphanumerics + "_" and
       "$"
     - ``caseless`` allows case-insensitive matching, default is ``False``.

    Example::

        Keyword("start").parseString("start")  # -> ['start']
        Keyword("start").parseString("starting")  # -> Exception

    For case-insensitive matching, use :class:`CaselessKeyword`.
    z_$NFc                s   t t|   |d krtj}|| _t|| _y|d | _W n$ tk
r^   t	j
dtdd Y nX d| j | _d| j | _
d| _d| _|| _|r| | _| }t|| _d S )Nr   z2null string passed to Keyword; use Empty() insteadr   )r0  z"%s"z	Expected F)r{  r.   r   DEFAULT_KEYWORD_CHARSr  r   r  r  r"  r3  r4  r5  r  r  r  r  caselessupper
caselessmatchr   
identChars)r   r  r  r  )r  r   r   r   s  s&    

zKeyword.__init__Tc             C   s  | j r||||| j   | jkr|t|| j ksL||| j   | jkr|dksj||d   | jkr|| j | jfS nv|| | jkr| jdks|| j|r|t|| j ks||| j  | jkr|dks||d  | jkr|| j | jfS t	||| j
| d S )Nr   r   )r  r  r  r  r   r  r  r  r   r<   r  )r   r  r   r  r   r   r   r     s    zKeyword.parseImplc                s   t t|  }tj|_|S )N)r{  r.   rR  r  r  )r   r   )r  r   r   rR    s    zKeyword.copyc             C   s
   | t _dS )z,Overrides the default Keyword chars
        N)r.   r  )r  r   r   r   setDefaultKeywordChars  s    zKeyword.setDefaultKeywordChars)NF)T)r   r   r   r   rQ   r  r   r   rR  r  r  r  r   r   )r  r   r.   X  s   
c                   s*   e Zd ZdZ fddZdddZ  ZS )r$   af  Token to match a specified string, ignoring case of letters.
    Note: the matched results will always be in the case of the given
    match string, NOT the case of the input text.

    Example::

        OneOrMore(CaselessLiteral("CMD")).parseString("cmd CMD Cmd10") # -> ['CMD', 'CMD', 'CMD']

    (Contrast with example for :class:`CaselessKeyword`.)
    c                s6   t t| |  || _d| j | _d| j | _d S )Nz'%s'z	Expected )r{  r$   r   r  returnStringr  r  )r   r  )r  r   r   r     s    zCaselessLiteral.__init__Tc             C   s@   |||| j    | jkr,|| j  | jfS t||| j| d S )N)r  r  r  r  r<   r  )r   r  r   r  r   r   r   r     s    zCaselessLiteral.parseImpl)T)r   r   r   r   r   r   r  r   r   )r  r   r$     s   
c                   s"   e Zd ZdZd fdd	Z  ZS )r#   z
    Caseless version of :class:`Keyword`.

    Example::

        OneOrMore(CaselessKeyword("CMD")).parseString("cmd CMD Cmd10") # -> ['CMD', 'CMD']

    (Contrast with example for :class:`CaselessLiteral`.)
    Nc                s   t t| j||dd d S )NT)r  )r{  r#   r   )r   r  r  )r  r   r   r     s    zCaselessKeyword.__init__)N)r   r   r   r   r   r  r   r   )r  r   r#     s   	c                   s,   e Zd ZdZd fdd	Zd	ddZ  ZS )
r   a  A variation on :class:`Literal` which matches "close" matches,
    that is, strings with at most 'n' mismatching characters.
    :class:`CloseMatch` takes parameters:

     - ``match_string`` - string to be matched
     - ``maxMismatches`` - (``default=1``) maximum number of
       mismatches allowed to count as a match

    The results from a successful parse will contain the matched text
    from the input string and the following named results:

     - ``mismatches`` - a list of the positions within the
       match_string where mismatches were found
     - ``original`` - the original match_string used to compare
       against the input string

    If ``mismatches`` is an empty list, then the match was an exact
    match.

    Example::

        patt = CloseMatch("ATCATCGAATGGA")
        patt.parseString("ATCATCGAAXGGA") # -> (['ATCATCGAAXGGA'], {'mismatches': [[9]], 'original': ['ATCATCGAATGGA']}