              clone = formattingElement.cloneNode()

                # Step 12
                furthestBlock.reparentChildren(clone)

                # Step 13
                furthestBlock.appendChild(clone)

                # Step 14
                self.tree.activeFormattingElements.remove(formattingElement)
                self.tree.activeFormattingElements.insert(bookmark, clone)

                # Step 15
                self.tree.openElements.remove(formattingElement)
                self.tree.openElements.insert(
                    self.tree.openElements.index(furthestBlock) + 1, clone)

        def endTagAppletMarqueeObject(self, token):
            if self.tree.elementInScope(token["name"]):
                self.tree.generateImpliedEndTags()
            if self.tree.openElements[-1].name != token["name"]:
                self.parser.parseError("end-tag-too-early", {"name": token["name"]})

            if self.tree.elementInScope(token["name"]):
                element = self.tree.openElements.pop()
                while element.name != token["name"]:
                    element = self.tree.openElements.pop()
                self.tree.clearActiveFormattingElements()

        def endTagBr(self, token):
            self.parser.parseError("unexpected-end-tag-treated-as",
                                   {"originalName": "br", "newName": "br element"})
            self.tree.reconstructActiveFormattingElements()
            self.tree.insertElement(impliedTagToken("br", "StartTag"))
            self.tree.openElements.pop()

        def endTagOther(self, token):
            for node in self.tree.openElements[::-1]:
                if node.name == token["name"]:
                    self.tree.generateImpliedEndTags(exclude=token["name"])
                    if self.tree.openElements[-1].name != token["name"]:
                        self.parser.parseError("unexpected-end-tag", {"name": token["name"]})
                    while self.tree.openElements.pop() != node:
                        pass
                    break
                else:
                    if node.nameTuple in specialElements:
                        self.parser.parseError("unexpected-end-tag", {"name": token["name"]})
                        break

        startTagHandler = _utils.MethodDispatcher([
            ("html", Phase.startTagHtml),
            (("base", "basefont", "bgsound", "command", "link", "meta",
              "script", "style", "title"),
             startTagProcessInHead),
            ("body", startTagBody),
            ("frameset", startTagFrameset),
            (("address", "article", "aside", "blockquote", "center", "details",
              "dir", "div", "dl", "fieldset", "figcaption", "figure",
              "footer", "header", "hgroup", "main", "menu", "nav", "ol", "p",
              "section", "summary", "ul"),
             startTagCloseP),
            (headingElements, startTagHeading),
            (("pre", "listing"), startTagPreListing),
            ("form", startTagForm),
            (("li", "dd", "dt"), startTagListItem),
            ("plaintext", startTagPlaintext),
            ("a", startTagA),
            (("b", "big", "code", "em", "font", "i", "s", "small", "strike",
              "strong", "tt", "u"), startTagFormatting),
            ("nobr", startTagNobr),
            ("button", startTagButton),
            (("applet", "marquee", "object"), startTagAppletMarqueeObject),
            ("xmp", startTagXmp),
            ("table", startTagTable),
            (("area", "br", "embed", "img", "keygen", "wbr"),
             startTagVoidFormatting),
            (("param", "source", "track"), startTagParamSource),
            ("input", startTagInput),
            ("hr", startTagHr),
            ("image", startTagImage),
            ("isindex", startTagIsIndex),
            ("textarea", startTagTextarea),
            ("iframe", startTagIFrame),
            ("noscript", startTagNoscript),
            (("noembed", "noframes"), startTagRawtext),
            ("select", startTagSelect),
            (("rp", "rt"), startTagRpRt),
            (("option", "optgroup"), startTagOpt),
            (("math"), startTagMath),
            (("svg"), startTagSvg),
            (("caption", "col", "colgroup", "frame", "head",
              "tbody", "td", "tfoot", "th", "thead",
              "tr"), startTagMisplaced)
        ])
        startTagHandler.default = startTagOther

        endTagHandler = _utils.MethodDispatcher([
            ("body", endTagBody),
            ("html", endTagHtml),
            (("address", "article", "aside", "blockquote", "button", "center",
              "details", "dialog", "dir", "div", "dl", "fieldset", "figcaption", "figure",
              "footer", "header", "hgroup", "listing", "main", "menu", "nav", "ol", "pre",
              "section", "summary", "ul"), endTagBlock),
            ("form", endTagForm),
            ("p", endTagP),
            (("dd", "dt", "li"), endTagListItem),
            (headingElements, endTagHeading),
            (("a", "b", "big", "code", "em", "font", "i", "nobr", "s", "small",
              "strike", "strong", "tt", "u"), endTagFormatting),
            (("applet", "marquee", "object"), endTagAppletMarqueeObject),
            ("br", endTagBr),
        ])
        endTagHandler.default = endTagOther

    class TextPhase(Phase):
        __slots__ = tuple()

        def processCharacters(self, token):
            self.tree.insertText(token["data"])

        def processEOF(self):
            self.parser.parseError("expected-named-closing-tag-but-got-eof",
                                   {"name": self.tree.openElements[-1].name})
            self.tree.openElements.pop()
            self.parser.phase = self.parser.originalPhase
            return True

        def startTagOther(self, token):
            assert False, "Tried to process start tag %s in RCDATA/RAWTEXT mode" % token['name']

        def endTagScript(self, token):
            node = self.tree.openElements.pop()
            assert node.name == "script"
            self.parser.phase = self.parser.originalPhase
            # The rest of this method is all stuff that only happens if
            # document.write works

        def endTagOther(self, token):
            self.tree.openElements.pop()
            self.parser.phase = self.parser.originalPhase

        startTagHandler = _utils.MethodDispatcher([])
        startTagHandler.default = startTagOther
        endTagHandler = _utils.MethodDispatcher([
            ("script", endTagScript)])
        endTagHandler.default = endTagOther

    class InTablePhase(Phase):
        # http://www.whatwg.org/specs/web-apps/current-work/#in-table
        __slots__ = tuple()

        # helper methods
        def clearStackToTableContext(self):
            # "clear the stack back to a table context"
            while self.tree.openElements[-1].name not in ("table", "html"):
                # self.parser.parseError("unexpected-implied-end-tag-in-table",
                #  {"name":  self.tree.openElements[-1].name})
                self.tree.openElements.pop()
            # When the current node is <html> it's an innerHTML case

        # processing methods
        def processEOF(self):
            if self.tree.openElements[-1].name != "html":
                self.parser.parseError("eof-in-table")
            else:
                assert self.parser.innerHTML
            # Stop parsing

        def processSpaceCharacters(self, token):
            originalPhase = self.parser.phase
            self.parser.phase = self.parser.phases["inTableText"]
            self.parser.phase.originalPhase = originalPhase
            self.parser.phase.processSpaceCharacters(token)

        def processCharacters(self, token):
            originalPhase = self.parser.phase
            self.parser.phase = self.parser.phases["inTableText"]
            self.parser.phase.originalPhase = originalPhase
            self.parser.phase.processCharacters(token)

        def insertText(self, token):
            # If we get here there must be at least one non-whitespace character
            # Do the table magic!
            self.tree.insertFromTable = True
            self.parser.phases["inBody"].processCharacters(token)
            self.tree.insertFromTable = False

        def startTagCaption(self, token):
            self.clearStackToTableContext()
            self.tree.activeFormattingElements.append(Marker)
            self.tree.insertElement(token)
            self.parser.phase = self.parser.phases["inCaption"]

        def startTagColgroup(self, token):
            self.clearStackToTableContext()
            self.tree.insertElement(token)
            self.parser.phase = self.parser.phases["inColumnGroup"]

        def startTagCol(self, token):
            self.startTagColgroup(impliedTagToken("colgroup", "StartTag"))
            return token

        def startTagRowGroup(self, token):
            self.clearStackToTableContext()
            self.tree.insertElement(token)
            self.parser.phase = self.parser.phases["inTableBody"]

        def startTagImplyTbody(self, token):
            self.startTagRowGroup(impliedTagToken("tbody", "StartTag"))
            return token

        def startTagTable(self, token):
            self.parser.parseError("unexpected-start-tag-implies-end-tag",
                                   {"startName": "table", "endName": "table"})
            self.parser.phase.processEndTag(impliedTagToken("table"))
            if not self.parser.innerHTML:
                return token

        def startTagStyleScript(self, token):
            return self.parser.phases["inHead"].processStartTag(token)

        def startTagInput(self, token):
            if ("type" in token["data"] and
                    token["data"]["type"].translate(asciiUpper2Lower) == "hidden"):
                self.parser.parseError("unexpected-hidden-input-in-table")
                self.tree.insertElement(token)
                # XXX associate with form
                self.tree.openElements.pop()
            else:
                self.startTagOther(token)

        def startTagForm(self, token):
            self.parser.parseError("unexpected-form-in-table")
            if self.tree.formPointer is None:
                self.tree.insertElement(token)
                self.tree.formPointer = self.tree.openElements[-1]
                self.tree.openElements.pop()

        def startTagOther(self, token):
            self.parser.parseError("unexpected-start-tag-implies-table-voodoo", {"name": token["name"]})
            # Do the table magic!
            self.tree.insertFromTable = True
            self.parser.phases["inBody"].processStartTag(token)
            self.tree.insertFromTable = False

        def endTagTable(self, token):
            if self.tree.elementInScope("table", variant="table"):
                self.tree.generateImpliedEndTags()
                if self.tree.openElements[-1].name != "table":
                    self.parser.parseError("end-tag-too-early-named",
                                           {"gotName": "table",
                                            "expectedName": self.tree.openElements[-1].name})
                while self.tree.openElements[-1].name != "table":
                    self.tree.openElements.pop()
                self.tree.openElements.pop()
                self.parser.resetInsertionMode()
            else:
                # innerHTML case
                assert self.parser.innerHTML
                self.parser.parseError()

        def endTagIgnore(self, token):
            self.parser.parseError("unexpected-end-tag", {"name": token["name"]})

        def endTagOther(self, token):
            self.parser.parseError("unexpected-end-tag-implies-table-voodoo", {"name": token["name"]})
            # Do the table magic!
            self.tree.insertFromTable = True
            self.parser.phases["inBody"].processEndTag(token)
            self.tree.insertFromTable = False

        startTagHandler = _utils.MethodDispatcher([
            ("html", Phase.startTagHtml),
            ("caption", startTagCaption),
            ("colgroup", startTagColgroup),
            ("col", startTagCol),
            (("tbody", "tfoot", "thead"), startTagRowGroup),
            (("td", "th", "tr"), startTagImplyTbody),
            ("table", startTagTable),
            (("style", "script"), startTagStyleScript),
            ("input", startTagInput),
            ("form", startTagForm)
        ])
        startTagHandler.default = startTagOther

        endTagHandler = _utils.MethodDispatch