
        self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                "expected-dashes-or-doctype"})

        while charStack:
            self.stream.unget(charStack.pop())
        self.state = self.bogusCommentState
        return True

    def commentStartState(self):
        data = self.stream.char()
        if data == "-":
            self.state = self.commentStartDashState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["data"] += "\uFFFD"
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "incorrect-comment"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-comment"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["data"] += data
            self.state = self.commentState
        return True

    def commentStartDashState(self):
        data = self.stream.char()
        if data == "-":
            self.state = self.commentEndState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["data"] += "-\uFFFD"
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "incorrect-comment"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-comment"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["data"] += "-" + data
            self.state = self.commentState
        return True

    def commentState(self):
        data = self.stream.char()
        if data == "-":
            self.state = self.commentEndDashState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["data"] += "\uFFFD"
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "eof-in-comment"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["data"] += data + \
                self.stream.charsUntil(("-", "\u0000"))
        return True

    def commentEndDashState(self):
        data = self.stream.char()
        if data == "-":
            self.state = self.commentEndState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["data"] += "-\uFFFD"
            self.state = self.commentState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-comment-end-dash"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["data"] += "-" + data
            self.state = self.commentState
        return True

    def commentEndState(self):
        data = self.stream.char()
        if data == ">":
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["data"] += "--\uFFFD"
            self.state = self.commentState
        elif data == "!":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-bang-after-double-dash-in-comment"})
            self.state = self.commentEndBangState
        elif data == "-":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-dash-after-double-dash-in-comment"})
            self.currentToken["data"] += data
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-comment-double-dash"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            # XXX
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-comment"})
            self.currentToken["data"] += "--" + data
            self.state = self.commentState
        return True

    def commentEndBangState(self):
        data = self.stream.char()
        if data == ">":
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data == "-":
            self.currentToken["data"] += "--!"
            self.state = self.commentEndDashState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["data"] += "--!\uFFFD"
            self.state = self.commentState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-comment-end-bang-state"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["data"] += "--!" + data
            self.state = self.commentState
        return True

    def doctypeState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            self.state = self.beforeDoctypeNameState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "expected-doctype-name-but-got-eof"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "need-space-after-doctype"})
            self.stream.unget(data)
            self.state = self.beforeDoctypeNameState
        return True

    def beforeDoctypeNameState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            pass
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "expected-doctype-name-but-got-right-bracket"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["name"] = "\uFFFD"
            self.state = self.doctypeNameState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "expected-doctype-name-but-got-eof"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["name"] = data
            self.state = self.doctypeNameState
        return True

    def doctypeNameState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            self.currentToken["name"] = self.currentToken["name"].translate(asciiUpper2Lower)
            self.state = self.afterDoctypeNameState
        elif data == ">":
            self.currentToken["name"] = self.currentToken["name"].translate(asciiUpper2Lower)
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["name"] += "\uFFFD"
            self.state = self.doctypeNameState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype-name"})
            self.currentToken["correct"] = False
            self.currentToken["name"] = self.currentToken["name"].translate(asciiUpper2Lower)
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["name"] += data
        return True

    def afterDoctypeNameState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            pass
        elif data == ">":
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.currentToken["correct"] = False
            self.stream.unget(data)
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            if data in ("p", "P"):
                matched = True
                for expected in (("u", "U"), ("b", "B"), ("l", "L"),
                                 ("i", "I"), ("c", "C")):
                    data = self.stream.char()
                    if data not in expected:
                        matched = False
                        break
                if matched:
                    self.state = self.afterDoctypePublicKeywordState
                    return True
            elif data in ("s", "S"):
                matched = True
                for expected in (("y", "Y"), ("s", "S"), ("t", "T"),
                                 ("e", "E"), ("m", "M")):
                    data = self.stream.char()
                    if data not in expected:
                        matched = False
                        break
                if matched:
                    self.state = self.afterDoctypeSystemKeywordState
                    return True

            # All the characters read before the current 'data' will be
            # [a-zA-Z], so they're garbage in the bogus doctype and can be
            # discarded; only the latest character might be '>' or EOF
            # and needs to be ungetted
            self.stream.unget(data)
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "expected-space-or-right-bracket-in-doctype", "datavars":
                                    {"data": data}})
            self.currentToken["correct"] = False
            self.state = self.bogusDoctypeState

        return True

    def afterDoctypePublicKeywordState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            self.state = self.beforeDoctypePublicIdentifierState
        elif data in ("'", '"'):
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.stream.unget(data)
            self.state = self.beforeDoctypePublicIdentifierState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.stream.unget(data)
            self.state = self.beforeDoctypePublicIdentifierState
        return True

    def beforeDoctypePublicIdentifierState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            pass
        elif data == "\"":
            self.currentToken["publicId"] = ""
            self.state = self.doctypePublicIdentifierDoubleQuotedState
        elif data == "'":
            self.currentToken["publicId"] = ""
            self.state = self.doctypePublicIdentifierSingleQuotedState
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-end-of-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.currentToken["correct"] = False
            self.state = self.bogusDoctypeState
        return True

    def doctypePublicIdentifierDoubleQuotedState(self):
        data = self.stream.char()
        if data == "\"":
            self.state = self.afterDoctypePublicIdentifierState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["publicId"] += "\uFFFD"
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-end-of-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["publicId"] += data
        return True

    def doctypePublicIdentifierSingleQuotedState(self):
        data = self.stream.char()
        if data == "'":
            self.state = self.afterDoctypePublicIdentifierState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["publicId"] += "\uFFFD"
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-end-of-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["publicId"] += data
        return True

    def afterDoctypePublicIdentifierState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            self.state = self.betweenDoctypePublicAndSystemIdentifiersState
        elif data == ">":
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data == '"':
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.currentToken["systemId"] = ""
            self.state = self.doctypeSystemIdentifierDoubleQuotedState
        elif data == "'":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.currentToken["systemId"] = ""
            self.state = self.doctypeSystemIdentifierSingleQuotedState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.currentToken["correct"] = False
            self.state = self.bogusDoctypeState
        return True

    def betweenDoctypePublicAndSystemIdentifiersState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            pass
        elif data == ">":
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data == '"':
            self.currentToken["systemId"] = ""
            self.state = self.doctypeSystemIdentifierDoubleQuotedState
        elif data == "'":
            self.currentToken["systemId"] = ""
            self.state = self.doctypeSystemIdentifierSingleQuotedState
        elif data == EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.currentToken["correct"] = False
            self.state = self.bogusDoctypeState
        return True

    def afterDoctypeSystemKeywordState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            self.state = self.beforeDoctypeSystemIdentifierState
        elif data in ("'", '"'):
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.stream.unget(data)
            self.state = self.beforeDoctypeSystemIdentifierState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.stream.unget(data)
            self.state = self.beforeDoctypeSystemIdentifierState
        return True

    def beforeDoctypeSystemIdentifierState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            pass
        elif data == "\"":
            self.currentToken["systemId"] = ""
            self.state = self.doctypeSystemIdentifierDoubleQuotedState
        elif data == "'":
            self.currentToken["systemId"] = ""
            self.state = self.doctypeSystemIdentifierSingleQuotedState
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.currentToken["correct"] = False
            self.state = self.bogusDoctypeState
        return True

    def doctypeSystemIdentifierDoubleQuotedState(self):
        data = self.stream.char()
        if data == "\"":
            self.state = self.afterDoctypeSystemIdentifierState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["systemId"] += "\uFFFD"
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-end-of-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["systemId"] += data
        return True

    def doctypeSystemIdentifierSingleQuotedState(self):
        data = self.stream.char()
        if data == "'":
            self.state = self.afterDoctypeSystemIdentifierState
        elif data == "\u0000":
            self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                    "data": "invalid-codepoint"})
            self.currentToken["systemId"] += "\uFFFD"
        elif data == ">":
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-end-of-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.currentToken["systemId"] += data
        return True

    def afterDoctypeSystemIdentifierState(self):
        data = self.stream.char()
        if data in spaceCharacters:
            pass
        elif data == ">":
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "eof-in-doctype"})
            self.currentToken["correct"] = False
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            self.tokenQueue.append({"type": tokenTypes["ParseError"], "data":
                                    "unexpected-char-in-doctype"})
            self.state = self.bogusDoctypeState
        return True

    def bogusDoctypeState(self):
        data = self.stream.char()
        if data == ">":
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        elif data is EOF:
            # XXX EMIT
            self.stream.unget(data)
            self.tokenQueue.append(self.currentToken)
            self.state = self.dataState
        else:
            pass
        return True

    def cdataSectionState(self):
        data = []
        while True:
            data.append(self.stream.charsUntil("]"))
            data.append(self.stream.charsUntil(">"))
            char = self.stream.char()
            if char == EOF:
                break
            else:
                assert char == ">"
                if data[-1][-2:] == "]]":
                    data[-1] = data[-1][:-2]
                    break
                else:
                    data.append(char)

        data = "".join(data)  # pylint:disable=redefined-variable-type
        # Deal with null here rather than in the parser
        nullCount = data.count("\u0000")
        if nullCount > 0:
            for _ in range(nullCount):
                self.tokenQueue.append({"type": tokenTypes["ParseError"],
                                        "data": "invalid-codepoint"})
            data = data.replace("\u0000", "\uFFFD")
        if data:
            self.tokenQueue.append({"type": tokenTypes["Characters"],
                                    "data": data})
        self.state = self.dataState
        return True
                                                                                                                                                                                                                                                                                python3.7/site-packages/pip/_vendor/__pycache__/__init__.cpython-37.pyc                             0000644                 00000005674 15107360303 0021671 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   s  d Z ddlmZ ddlZddlZddlZdZej	ej
eZdd Z
ereejedej ejdd< e
d e
d	 e
d
 e
d e
d e
d
 e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d e
d  e
d! e
d" e
d# e
d$ e
d% e
d& e
d' e
d( e
d) e
d* e
d+ e
d, e
d- e
d. e
d/ e
d0 e
d1 e
d2 e
d3 e
d4 e
d5 e
d6 e
d7 e
d8 e
d9 e
d: e
d; e
d< dS )=z
pip._vendor is for vendoring dependencies of pip to prevent needing pip to
depend on something external.

Files inside of pip._vendor should be considered immutable and should only be
updated to versions from upstream.
    )absolute_importNFc             C   sx   d t| }yt| t t dd W n tk
r:    Y n:X tj|  tj|< |dd\}}t	tj| |tj|   d S )Nz{0}.{1}r   )level.   )
format__name__
__import__globalslocalsImportErrorsysmodulesrsplitsetattr)
modulename
vendored_namebasehead r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/__init__.pyvendored   s    r   z*.whlappdirscachecontrolcertificoloramacontextlib2distlibdistrohtml5libsixz	six.moveszsix.moves.urllibzsix.moves.urllib.parse	packagingzpackaging.versionzpackaging.specifierspep517
pkg_resourcesprogressretryingrequestszrequests.exceptionszrequests.packageszrequests.packages.urllib3z&requests.packages.urllib3._collectionsz$requests.packages.urllib3.connectionz(requests.packages.urllib3.connectionpoolz!requests.packages.urllib3.contribz*requests.packages.urllib3.contrib.ntlmpoolz+requests.packages.urllib3.contrib.pyopensslz$requests.packages.urllib3.exceptionsz requests.packages.urllib3.fieldsz"requests.packages.urllib3.filepostz"requests.packages.urllib3.packagesz/requests.packages.urllib3.packages.ordered_dictz&requests.packages.urllib3.packages.sixz5requests.packages.urllib3.packages.ssl_match_hostnamezErequests.packages.urllib3.packages.ssl_match_hostname._implementationz%requests.packages.urllib3.poolmanagerz!requests.packages.urllib3.requestz"requests.packages.urllib3.responsezrequests.packages.urllib3.utilz)requests.packages.urllib3.util.connectionz&requests.packages.urllib3.util.requestz'requests.packages.urllib3.util.responsez$requests.packages.urllib3.util.retryz#requests.packages.urllib3.util.ssl_z&requests.packages.urllib3.util.timeoutz"requests.packages.urllib3.util.url
resolvelibtomlztoml.encoderztoml.decoderurllib3)__doc__
__future__r   globos.pathosr   	DEBUNDLEDpathabspathdirname__file__	WHEEL_DIRr   joinr   r   r   r   <module>   s|   $                                                                    python3.7/site-packages/pip/_vendor/__pycache__/contextlib2.cpython-37.pyc                          0000644                 00000036051 15107360303 0022360 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    ReB              	   @   s  d Z ddlZddlZddlZddlmZ ddlmZ ddddd	d
ddd
g	Zedg7 Zej	dd dkrnej
Znede
fddiZdd Zdd ZG dd deZG dd	 d	e
ZG dd deZdd ZG dd de
ZG dd de
ZG d d deZG d!d deZG d"d
 d
e
Zej	d d#kZer@d$d% Zd&d' Znd(d% Zd)d' Zydd*lmZ W n ek
rz   eZ Y n
X d+d, Z G d-d
 d
e
Z!G d.d de!Z"G d/d deZ#dS )0zAcontextlib2 - backports and enhancements to the contextlib module    N)deque)wrapscontextmanagerclosingnullcontextAbstractContextManagerContextDecorator	ExitStackredirect_stdoutredirect_stderrsuppressContextStack   )      ABC	__slots__ c             C   s4   | |krd S | |  x| jD ]}t|| qW |S )N)append	__bases___classic_mro)CresultBr   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/contextlib2.pyr      s    
r   c             G   sp   y
| j }W n" tk
r,   tt| g }Y nX x<|D ]4}x.|D ]"}||jkr>|j| d kr^tS P q>W tS q4W dS )NT)__mro__AttributeErrortupler   __dict__NotImplemented)r   methodsmromethodr   r   r   r   _check_methods$   s    



r#   c               @   s2   e Zd ZdZdd Zejdd Zedd Z	dS )	r   z,An abstract base class for context managers.c             C   s   | S )z0Return `self` upon entering the runtime context.r   )selfr   r   r   	__enter__8   s    z AbstractContextManager.__enter__c             C   s   dS )z9Raise any exception triggered within the runtime context.Nr   )r$   exc_type	exc_value	tracebackr   r   r   __exit__<   s    zAbstractContextManager.__exit__c             C   s   | t krt|ddS tS )z<Check whether subclass is considered a subclass of this ABC.r%   r)   )r   r#   r   )clsr   r   r   r   __subclasshook__A   s    z'AbstractContextManager.__subclasshook__N)
__name__
__module____qualname____doc__r%   abcabstractmethodr)   classmethodr+   r   r   r   r   r   5   s   c               @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r   zJA base class or mixin that enables context managers to work as decorators.c             C   s   t dt |  S )a  Returns the context manager used to actually wrap the call to the
        decorated function.

        The default implementation just returns *self*.

        Overriding this method allows otherwise one-shot context managers
        like _GeneratorContextManager to support use as decorators via
        implicit recreation.

        DEPRECATED: refresh_cm was never added to the standard library's
                    ContextDecorator API
        z2refresh_cm was never added to the standard library)warningswarnDeprecationWarning_recreate_cm)r$   r   r   r   
refresh_cmL   s    
zContextDecorator.refresh_cmc             C   s   | S )a6  Return a recreated instance of self.

        Allows an otherwise one-shot context manager like
        _GeneratorContextManager to support use as
        a decorator via implicit recreation.

        This is a private interface just for _GeneratorContextManager.
        See issue #11647 for details.
        r   )r$   r   r   r   r6   ]   s    
zContextDecorator._recreate_cmc                s   t   fdd}|S )Nc           	      s       | |S Q R X d S )N)r6   )argskwds)funcr$   r   r   innerj   s    
z(ContextDecorator.__call__.<locals>.inner)r   )r$   r:   r;   r   )r:   r$   r   __call__i   s    zContextDecorator.__call__N)r,   r-   r.   r/   r7   r6   r<   r   r   r   r   r   I   s   c               @   s0   e Zd ZdZdd Zdd Zdd Zdd	 Zd
S )_GeneratorContextManagerz%Helper for @contextmanager decorator.c             C   sJ   |||| _ |||  | _| _| _t|dd }|d kr@t| j}|| _d S )Nr/   )genr:   r8   r9   getattrtyper/   )r$   r:   r8   r9   docr   r   r   __init__t   s    
z!_GeneratorContextManager.__init__c             C   s   |  | j| j| jS )N)	__class__r:   r8   r9   )r$   r   r   r   r6      s    z%_GeneratorContextManager._recreate_cmc             C   s,   y
t | jS  tk
r&   tdY nX d S )Nzgenerator didn't yield)nextr>   
StopIterationRuntimeError)r$   r   r   r   r%      s    
z"_GeneratorContextManager.__enter__c          
   C   s   |d kr6yt | j W n tk
r*   d S X tdn|d krD| }y| j||| tdW n tk
r } z||k	S d }~X Y n^ tk
r } z$||krdS tr|j|krdS  W d d }~X Y n   t d |k	rނ Y nX d S )Nzgenerator didn't stopz#generator didn't stop after throw()F   )	rD   r>   rE   rF   throw_HAVE_EXCEPTION_CHAINING	__cause__sysexc_info)r$   r@   valuer(   excr   r   r   r)      s,    
z!_GeneratorContextManager.__exit__N)r,   r-   r.   r/   rB   r6   r%   r)   r   r   r   r   r=   q   s
   r=   c                s   t   fdd}|S )a  @contextmanager decorator.

    Typical usage:

        @contextmanager
        def some_generator(<arguments>):
            <setup>
            try:
                yield <value>
            finally:
                <cleanup>

    This makes this:

        with some_generator(<arguments>) as <variable>:
            <body>

    equivalent to this:

        <setup>
        try:
            <variable> = <value>
            <body>
        finally:
            <cleanup>

    c                 s   t  | |S )N)r=   )r8   r9   )r:   r   r   helper   s    zcontextmanager.<locals>.helper)r   )r:   rO   r   )r:   r   r      s    c               @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r   a2  Context to automatically close something at the end of a block.

    Code like this:

        with closing(<module>.open(<arguments>)) as f:
            <block>

    is equivalent to this:

        f = <module>.open(<arguments>)
        try:
            <block>
        finally:
            f.close()

    c             C   s
   || _ d S )N)thing)r$   rP   r   r   r   rB      s    zclosing.__init__c             C   s   | j S )N)rP   )r$   r   r   r   r%      s    zclosing.__enter__c             G   s   | j   d S )N)rP   close)r$   rL   r   r   r   r)      s    zclosing.__exit__N)r,   r-   r.   r/   rB   r%   r)   r   r   r   r   r      s   c               @   s(   e Zd ZdZdd Zdd Zdd ZdS )_RedirectStreamNc             C   s   || _ g | _d S )N)_new_target_old_targets)r$   
new_targetr   r   r   rB      s    z_RedirectStream.__init__c             C   s*   | j tt| j tt| j| j | jS )N)rT   r   r?   rK   _streamsetattrrS   )r$   r   r   r   r%      s    z_RedirectStream.__enter__c             C   s   t t| j| j  d S )N)rW   rK   rV   rT   pop)r$   exctypeexcinstexctbr   r   r   r)     s    z_RedirectStream.__exit__)r,   r-   r.   rV   rB   r%   r)   r   r   r   r   rR      s   rR   c               @   s   e Zd ZdZdZdS )r
   aA  Context manager for temporarily redirecting stdout to another file.

        # How to send help() to stderr
        with redirect_stdout(sys.stderr):
            help(dir)

        # How to write help() to a file
        with open('help.txt', 'w') as f:
            with redirect_stdout(f):
                help(pow)
    stdoutN)r,   r-   r.   r/   rV   r   r   r   r   r
     s   c               @   s   e Zd ZdZdZdS )r   zCContext manager for temporarily redirecting stderr to another file.stderrN)r,   r-   r.   r/   rV   r   r   r   r   r     s   c               @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r   a?  Context manager to suppress specified exceptions

    After the exception is suppressed, execution proceeds with the next
    statement following the with statement.

         with suppress(FileNotFoundError):
             os.remove(somefile)
         # Execution still resumes here if the file was already removed
    c             G   s
   || _ d S )N)_exceptions)r$   
exceptionsr   r   r   rB   )  s    zsuppress.__init__c             C   s   d S )Nr   )r$   r   r   r   r%   ,  s    zsuppress.__enter__c             C   s   |d k	ot || jS )N)
issubclassr^   )r$   rY   rZ   r[   r   r   r   r)   /  s    
zsuppress.__exit__N)r,   r-   r.   r/   rB   r%   r)   r   r   r   r   r     s   	r   c                s    fdd}|S )Nc                s8   x,| j }||krd S |d ks$| kr&P |} qW || _ d S )N)__context__)new_excold_excexc_context)	frame_excr   r   _fix_exception_context@  s    z3_make_context_fixer.<locals>._fix_exception_contextr   )re   rf   r   )re   r   _make_context_fixer?  s    
rg   c             C   s<   y| d j }| d W n  tk
r6   || d _  Y nX d S )NrG   )ra   
BaseException)exc_details	fixed_ctxr   r   r   _reraise_with_existing_contextO  s    

rk   c             C   s   dd S )Nc             S   s   d S )Nr   )rb   rc   r   r   r   <lambda>[      z%_make_context_fixer.<locals>.<lambda>r   )re   r   r   r   rg   Z  s    c             C   s   | \}}}t d d S )Nz!raise exc_type, exc_value, exc_tb)exec)ri   r&   r'   exc_tbr   r   r   rk   _  s    
)InstanceTypec             C   s   t | }|tkr| jS |S )N)r@   rp   rC   )objZobj_typer   r   r   	_get_typek  s    rr   c               @   sX   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd Zdd ZdS )r	   a  Context manager for dynamic management of a stack of exit callbacks

    For example:

        with ExitStack() as stack:
            files = [stack.enter_context(open(fname)) for fname in filenames]
            # All opened files will automatically be closed at the end of
            # the with statement, even if attempts to open files later
            # in the list raise an exception

    c             C   s   t  | _d S )N)r   _exit_callbacks)r$   r   r   r   rB     s    zExitStack.__init__c             C   s   t |  }| j|_t | _|S )z?Preserve the context stack by transferring it to a new instance)r@   rs   r   )r$   	new_stackr   r   r   pop_all  s    
zExitStack.pop_allc                s"    fdd} |_ | | dS )z:Helper to correctly register callbacks to __exit__ methodsc                 s    f|  S )Nr   )ri   )cmcm_exitr   r   
_exit_wrapper  s    z.ExitStack._push_cm_exit.<locals>._exit_wrapperN)__self__push)r$   rv   rw   rx   r   )rv   rw   r   
_push_cm_exit  s    zExitStack._push_cm_exitc             C   sD   t |}y
|j}W n  tk
r2   | j| Y nX | || |S )a  Registers a callback with the standard __exit__ method signature

        Can suppress exceptions the same way __exit__ methods can.

        Also accepts any object with an __exit__ method (registering a call
        to the method instead of the object itself)
        )rr   r)   r   rs   r   r{   )r$   exit_cb_typeexit_methodr   r   r   rz     s    

zExitStack.pushc                s$    fdd}|_ | | S )z\Registers an arbitrary callback and arguments.

        Cannot suppress exceptions.
        c                s     d S )Nr   )r&   rN   tb)r8   callbackr9   r   r   rx     s    z)ExitStack.callback.<locals>._exit_wrapper)__wrapped__rz   )r$   r   r8   r9   rx   r   )r8   r   r9   r   r     s    
zExitStack.callbackc             C   s(   t |}|j}||}| || |S )zEnters the supplied context manager

        If successful, also pushes its __exit__ method as a callback and
        returns the result of the __enter__ method.
        )rr   r)   r%   r{   )r$   rv   _cm_type_exitr   r   r   r   
enter_context  s
    
zExitStack.enter_contextc             C   s   |  ddd dS )z$Immediately unwind the context stackN)r)   )r$   r   r   r   rQ     s    zExitStack.closec             C   s   | S )Nr   )r$   r   r   r   r%     s    zExitStack.__enter__c       	      G   s   |d d k	}t  d }t|}d}d}x\| jr| j }y|| rPd}d}d}W q*   t  }||d |d  d}|}Y q*X q*W |rt| |o|S )Nr   rG   FT)NNN)rK   rL   rg   rs   rX   rk   )	r$   ri   received_excre   rf   suppressed_exc
pending_raisecbnew_exc_detailsr   r   r   r)     s(    
zExitStack.__exit__N)
r,   r-   r.   r/   rB   ru   r{   rz   r   r   rQ   r%   r)   r   r   r   r   r	   s  s   

c                   s8   e Zd ZdZ fddZdd Zdd Zdd	 Z  ZS )
r
   z+Backwards compatibility alias for ExitStackc                s   t dt tt|   d S )Nz*ContextStack has been renamed to ExitStack)r3   r4   r5   superr
   rB   )r$   )rC   r   r   rB     s    zContextStack.__init__c             C   s
   |  |S )N)rz   )r$   r   r   r   r   
register_exit  s    zContextStack.register_exitc             O   s   | j |f||S )N)r   )r$   r   r8   r9   r   r   r   register  s    zContextStack.registerc             C   s   |   S )N)ru   )r$   r   r   r   preserve  s    zContextStack.preserve)	r,   r-   r.   r/   rB   r   r   r   
__classcell__r   r   )rC   r   r
     s
   c               @   s*   e Zd ZdZd	ddZdd Zdd ZdS )
r   aM  Context manager that does no additional processing.
    Used as a stand-in for a normal context manager, when a particular
    block of code is only sometimes used with a normal context manager:
    cm = optional_cm if condition else nullcontext()
    with cm:
        # Perform operation, using optional_cm if condition is True
    Nc             C   s
   || _ d S )N)enter_result)r$   r   r   r   r   rB     s    znullcontext.__init__c             C   s   | j S )N)r   )r$   r   r   r   r%     s    znullcontext.__enter__c             G   s   d S )Nr   )r$   excinfor   r   r   r)     s    znullcontext.__exit__)N)r,   r-   r.   r/   rB   r%   r)   r   r   r   r   r     s   
)$r/   r0   rK   r3   collectionsr   	functoolsr   __all__version_infor   _abc_ABCABCMetaobjectr   r#   r   r   r=   r   r   rR   r
   r   r   rI   rg   rk   typesrp   ImportErrorr@   rr   r	   r
   r   r   r   r   r   <module>   sL   


(H"

q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       python3.7/site-packages/pip/_vendor/__pycache__/six.cpython-37.pyc                                  0000644                 00000064501 15107360303 0020727 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Reo              E   @   sV  d Z ddlmZ ddlZddlZddlZddlZddlZdZdZ	ej
d dkZej
d dkZej
dd dkZ
erefZefZefZeZeZejZn~efZeefZeejfZeZeZejd	red
ZnHG dd deZ ye!e   W n e"k
r   ed
ZY n
X ed
Z[ dd Z#dd Z$G dd deZ%G dd de%Z&G dd dej'Z(G dd de%Z)G dd deZ*e*e+Z,G dd de(Z-e)dddd e)d!d"d#d$d!e)d%d"d"d&d%e)d'd(d#d)d'e)d*d(d+e)d,d"d#d-d,e)d.d/d/d0d.e)d1d/d/d.d1e)d2d3d4e)d5d(d#d6d5e)d7d(e
rd8nd9d:e)d;d(d<e)d=d>d?d@e)d d de)dAdAdBe)dCdCdBe)dDdDdBe)d6d(d#d6d5e)dEd"d#dFdEe)dGd"d"dHdGe&d#d(e&dIdJe&dKdBej
dLkrdMndBe&dNdOe&dPdQdRe&dSdTdUe&dVdWej
dXk rdVndYe&dZd[d\e&d]d^d_e&d`dadbe&dcdddee&dfdgdhe&didjdke&dldmdne&dodpdqe&drdsdte&dudvdwe&dxdxdye&dzdzdye&d{d{dye&d|d|d}e&d~de&dde&dde&dYddYe&dde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&ddde&de+d de&de+d de&de+d e+d e&ddde&ddde&dddgBZ.ejdkre.e&ddg7 Z.x:e.D ]2Z/e0e-e