asa  Constraints are only allowed to take the form of a package name and a version specifier. Other forms were originally permitted as an accident of the implementation, but were undocumented. The new implementation of the resolver no longer supports these forms.z,replacing the constraint with a requirement.i   )r   r   r   r   )r   r\   r`   r   )rQ   problemrH   rH   rI   check_invalid_constraint_typem  s    r9  )c
__future__r   loggingr9   r  r   r   r
  pip._vendorr   r   Z"pip._vendor.packaging.requirementsr   Zpip._vendor.packaging.utilsr   pip._vendor.packaging.versionr   r   r   pip._vendor.pep517.wrappersr	   pip._internal.build_envr
   pip._internal.exceptionsr   pip._internal.locationsr   pip._internal.models.linkr
   'pip._internal.operations.build.metadatar   .pip._internal.operations.build.metadata_legacyr   0pip._internal.operations.install.editable_legacyr   r,  'pip._internal.operations.install.legacyr   r   r.  &pip._internal.operations.install.wheelr   pip._internal.pyprojectr   r   pip._internal.req.req_uninstallr   pip._internal.utils.deprecationr   &pip._internal.utils.direct_url_helpersr   pip._internal.utils.hashesr   pip._internal.utils.loggingr   pip._internal.utils.miscr   r   r   r   r   r   r    r!   r"   r#   pip._internal.utils.packagingr$   pip._internal.utils.temp_dirr%   r&   pip._internal.utils.typingr'   pip._internal.utils.virtualenvr(   pip._internal.vcsr)   typingr*   r+   r,   r-   r.   r/   r0   r1   Zpip._vendor.pkg_resourcesr2   Z pip._vendor.packaging.specifiersr3   Zpip._vendor.packaging.markersr4   	getLoggerr~   r   rJ   objectrK   r9  rH   rH   rH   rI   <module>   sd   0$
                                                                                                                                                                         python3.7/site-packages/pip/_internal/req/__pycache__/req_uninstall.cpython-37.pyc                  0000644                 00000041776 15107360303 0024123 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re\                 @   s|  d dl mZ d dlZd dlZd dlZd dlZd dlZd dlZd dlm	Z	 d dl
mZ d dlm
Z
mZ d dlmZmZmZ d dlmZ d dlmZmZmZmZmZmZmZmZmZ d d	lm Z m!Z! d d
l"m#Z# e#r
d dl$m%Z%m&Z&m'Z'm(Z(m)Z)m*Z*m+Z+m,Z,m-Z- d dl.m/Z/ e0e1Z2d
d Z3dd Z4e4dd Z5dd Z6dd Z7dd Z8G dd de9Z:G dd de9Z;G dd de9Z<dS )    )absolute_importN)
pkg_resources)UninstallationError)bin_pybin_user)WINDOWScache_from_sourceuses_pycache)
indent_log)	FakeFileaskdist_in_usersite
dist_is_local
egg_link_pathis_localnormalize_pathrenamesrmtree)AdjacentTempDirectory
TempDirectory)MYPY_CHECK_RUNNING)	AnyCallableDictIterableIteratorListOptionalSetTuple)Distributionc             C   sl   t | rt}nt}tj||}|g}trh||d  ||d  |rZ||d  n||d  |S )zCreate the fully qualified name of the files created by
    {console,gui}_scripts for the given ``dist``.
    Returns the list of file names
    z.exez
.exe.manifestz-script.pywz
-script.py)r
   r   r   ospathjoinr   append)distscript_nameis_guibin_direxe_namepaths_to_remove r+   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/req/req_uninstall.py
_script_names'   s    r-   c                s   t   fdd}|S )Nc              ?   s6   t  }x* | |D ]}||kr|| |V  qW d S )N)setadd)argskwseenitem)fnr+   r,   unique?   s
    
z_unique.<locals>.unique)	functoolswraps)r4   r5   r+   )r4   r,   _unique=   s    r8   c             c   s   t t| d}x||D ]t}tj| j|d }|V  |drtj	|\}}|dd }tj||d }|V  tj||d }|V  qW dS )a  
    Yield all the uninstallation paths for dist based on RECORD-without-.py[co]

    Yield paths to all the files in RECORD. For each .py file in RECORD, add
    the .pyc and .pyo in the same directory.

    UninstallPathSet.add() takes care of the __pycache__ .py[co].
    RECORDr   z.pyNz.pycz.pyo)
csvreaderr   get_metadata_linesr!   r"   r#   locationendswithsplit)r%   rrowr"   dnr4   baser+   r+   r,   uninstallation_pathsJ   s    

rE   c                sN   t jjt }x:t| tdD ]* t fdd|D }|s|  qW |S )zCompact a path set to contain the minimal number of paths
    necessary to contain all paths in the set. If /a/path/ and
    /a/path/to/a/file.txt are both in the set, leave only the
    shorter path.)keyc             3   s:   | ]2}  |d o0 t|d  kV  qdS )*N)
startswithrstriplen).0	shortpath)r"   sepr+   r,   	<genexpr>m   s   zcompact.<locals>.<genexpr>)r!   r"   rM   r.   sortedrJ   anyr/   )pathsshort_pathsshould_skipr+   )r"   rM   r,   compactb   s    
rT   c       	         s   t dd | D }t|}ttdd | D td}t }dd x|D ]tfdd|D rhqLt }t }xPtD ]B\ }}| fdd|D  | fd	d|D  qW || sL|	| |
tj  qLW tt|j
||B S )
zReturns a set containing the paths that need to be renamed.

    This set may include directories when the original sequence of paths
    included every file on disk.
    c             s   s   | ]}t j||fV  qd S )N)r!   r"   normcase)rK   pr+   r+   r,   rN   }   s    z&compress_for_rename.<locals>.<genexpr>c             s   s   | ]}t j|d  V  qdS )r   N)r!   r"   r@   )rK   rV   r+   r+   r,   rN      s   )rF   c              W   s   t jt jj|  S )N)r!   r"   rU   r#   )ar+   r+   r,   	norm_join   s    z&compress_for_rename.<locals>.norm_joinc             3   s    | ]}t j |V  qd S )N)r!   r"   rU   rH   )rK   w)rootr+   r,   rN      s   c             3   s   | ]} |V  qd S )Nr+   )rK   d)dirnamerX   rZ   r+   r,   rN      s   c             3   s   | ]} |V  qd S )Nr+   )rK   f)r\   rX   rZ   r+   r,   rN      s   )dictr.   rO   valuesrJ   rP   r!   walkupdatedifference_updater/   rM   map__getitem__)	rQ   case_map	remaining	unchecked	wildcards	all_filesall_subdirssubdirsfilesr+   )r\   rX   rZ   r,   compress_for_renamev   s*    




rm   c       
      C   s  t | }t  }t  }t  }xF|D ]>}|dr0q |dsBd|krT|tj| || q W t ttjj|}t|}xt|D ]l}xft	|D ]X\}}	}
xL|
D ]D}|drqtj
||}tj|rtj||kr|| qW qW qW |dd |D B }||fS )as  Returns a tuple of 2 sets of which paths to display to user

    The first set contains paths that would be deleted. Files of a package
    are not added and the top-level directory of the package has a '*' added
    at the end - to signify that all it's contents are removed.

    The second set contains files that would have been skipped in the above
    folders.
    z.pycz__init__.pyz
.dist-infoc             S   s   h | ]}t j|d qS )rG   )r!   r"   r#   )rK   folderr+   r+   r,   	<setcomp>   s   z.compress_for_output_listing.<locals>.<setcomp>)r.   r?   r/   r!   r"   r\   rc   rU   rT   r`   r#   isfile)
rQ   will_remove	will_skipfoldersrl   r"   _normcased_filesrn   dirpath_dirfilesfnamefile_r+   r+   r,   compress_for_output_listing   s0    





rz   c               @   sL   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	e
dd ZdS )StashedUninstallPathSetzWA set of file rename operations to stash files while
    tentatively uninstalling them.c             C   s   i | _ g | _d S )N)
_save_dirs_moves)selfr+   r+   r,   __init__   s    z StashedUninstallPathSet.__init__c             C   sD   yt |}W n tk
r*   tdd}Y nX || jtj|< |jS )zStashes a directory.

        Directories are stashed adjacent to their original location if
        possible, or else moved/copied into the user's temp dir.	uninstall)kind)r   OSErrorr   r|   r!   r"   rU   )r~   r"   save_dirr+   r+   r,   _get_directory_stash   s    z,StashedUninstallPathSet._get_directory_stashc             C   s   t j|}t j|d }}d}xd||krfy| j| }P W n tk
rP   Y nX t j|| }}q$W t j|}tdd}|| j|< t j||}|r|t jjkrt j	|j|S |jS )zStashes a file.

        If no root has been provided, one will be created for the directory
        in the user's temp directory.Nr   )r   )
r!   r"   rU   r\   r|   KeyErrorr   relpathcurdirr#   )r~   r"   headold_headr   r   r+   r+   r,   _get_file_stash   s"    



z'StashedUninstallPathSet._get_file_stashc             C   sl   t j|ot j| }|r*| |}n
| |}| j||f |r^t j|r^t | t	|| |S )zStashes the directory or file and returns its new location.
        Handle symlinks as files to avoid modifying the symlink targets.
        )
r!   r"   isdirislinkr   r   r}   r$   rmdirr   )r~   r"   path_is_dirnew_pathr+   r+   r,   stash  s    


zStashedUninstallPathSet.stashc             C   s0   x| j  D ]\}}|  qW g | _i | _ dS )z0Commits the uninstall by removing stashed files.N)r|   itemscleanupr}   )r~   rv   r   r+   r+   r,   commit  s    zStashedUninstallPathSet.commitc             C   s   x| j D ]}tjd|  qW x| j D ]\}}yTtd|| tj|sVtj|rbt| ntj	|rvt
| t|| W q& tk
r } zt
d| td| W dd}~X Y q&X q&W |   dS )z2Undoes the uninstall by moving stashed files back.Moving to %s
 from %szReplacing %s from %szFailed to restore %sz
Exception: %sN)r   )r}   loggerinfodebugr!   r"   rp   r   unlinkr   r   r   r   errorr   )r~   rV   r   r"   exr+   r+   r,   rollback&  s    "z StashedUninstallPathSet.rollbackc             C   s
   t | jS )N)boolr}   )r~   r+   r+   r,   can_rollback:  s    z$StashedUninstallPathSet.can_rollbackN)__name__
__module____qualname____doc__r   r   r   r   r   r   propertyr   r+   r+   r+   r,   r{      s   	r{   c               @   s^   e Zd ZdZdd Zdd Zdd Zdd	 ZdddZd
d Z	dd Z
dd Zedd Z
dS )UninstallPathSetzMA set of file paths to be removed in the uninstallation of a
    requirement.c             C   s(   t  | _t  | _i | _|| _t | _d S )N)r.   rQ   _refusepthr%   r{   _moved_paths)r~   r%   r+   r+   r,   r   C  s
    zUninstallPathSet.__init__c             C   s   t |S )zs
        Return True if the given path is one we are permitted to
        remove/modify, False otherwise.

        )r   )r~   r"   r+   r+   r,   
_permittedK  s    zUninstallPathSet._permittedc             C   s   t j|\}}t jt|t j|}t j|s:d S | |rR| j	| n| j
	| t j|d dkrtr| 	t
| d S )N   z.py)r!   r"   r@   r#   r   rU   existsr   rQ   r/   r   splitextr	   r   )r~   r"   r   tailr+   r+   r,   r/   T  s    
zUninstallPathSet.addc             C   sL   t |}| |r<|| jkr*t|| j|< | j| | n| j| d S )N)r   r   r   UninstallPthEntriesr/   r   )r~   pth_fileentryr+   r+   r,   add_pthh  s    

zUninstallPathSet.add_pthFc          	   C   s   | j std| jj dS | jjd | jj }td| t x |sP| |r| j}t	| j }x*t
t|D ]}|| t
d| qnW x| j D ]}|  qW td| W dQ R X dS )z[Remove paths in ``self.paths`` with confirmation (unless
        ``auto_confirm`` is True).z7Can't uninstall '%s'. No files were found to uninstall.N-zUninstalling %s:zRemoving file or directory %szSuccessfully uninstalled %s)rQ   r   r   r%   project_nameversionr
   _allowed_to_proceedr   rm   rO   rT   r   r   r   r_   remove)r~   auto_confirmverbosedist_name_versionmoved
for_renamer"   r   r+   r+   r,   r   r  s"    


zUninstallPathSet.removec             C   sn   dd }|st | j\}}nt| j}t }|d| |d| |d| j |r`|dt| j tddd	kS )
zIDisplay which files would be deleted and prompt for confirmation
        c          	   S   sH   |sd S t |  t & xtt|D ]}t | q(W W d Q R X d S )N)r   r   r
   rO   rT   )msgrQ   r"   r+   r+   r,   _display  s    
z6UninstallPathSet._allowed_to_proceed.<locals>._displayz
Would remove:z+Would not remove (might be manually added):z%Would not remove (outside of prefix):zWill actually move:zProceed (y/n)? )ynr   )rz   rQ   r.   r   rm   r   )r~   r   r   rq   rr   r+   r+   r,   r     s    



z$UninstallPathSet._allowed_to_proceedc             C   sV   | j jstd| jj dS td| jj | j   x| j	 D ]}|  qBW dS )z1Rollback the changes previously made by remove().z'Can't roll back %s; was not uninstalledNzRolling back uninstall of %s)
r   r   r   r   r%   r   r   r   r   r_   )r~   r   r+   r+   r,   r     s    

zUninstallPathSet.rollbackc             C   s   | j   dS )z?Remove temporary save dir: rollback will no longer be possible.N)r   r   )r~   r+   r+   r,   r     s    zUninstallPathSet.commitc          	      s  t |j}t|s.td|j|tj | |S |dd t	dt	dhD krhtd|j| | |S | |}t
|}dt
|j}|jotj|j}t|jdd }|r|jd	r|j|s||j |d
r"x|d
 D ]&}tjtj|j|}	||	 qW n|dr|drF|d ng  xj fd
d|d D D ]J}
tj|j|
}	||	 ||	d  ||	d  ||	d  qhW n6|rtd|jn|jdr*||j tj|jd }tjtj|jd}||d|  n|r^|jdr^xt |D ]}	||	 qHW n|rt!|d}
tj"|
# $ }W d Q R X ||jkst%d||j|j|| tjtj|d}|||j nt&d||j |drd|'drdxZ|(dD ]L}t)|r(t*}nt+}|tj|| t,r|tj||d  qW g }|j-dd}x$|. D ]}|/t0||d q~W |j-d d}x$|. D ]}|/t0||d! qW x|D ]}|| qW |S )"Nz1Not uninstalling %s at %s, outside environment %sc             S   s   h | ]}|r|qS r+   r+   )rK   rV   r+   r+   r,   ro     s    z-UninstallPathSet.from_dist.<locals>.<setcomp>stdlib
platstdlibz<Not uninstalling %s at %s, as it is in the standard library.z{}.egg-infor"   z	.egg-infozinstalled-files.txtz
top_level.txtznamespace_packages.txtc                s   g | ]}|r| kr|qS r+   r+   )rK   rV   )
namespacesr+   r,   
<listcomp>  s    z.UninstallPathSet.from_dist.<locals>.<listcomp>z.pyz.pycz.pyozCannot uninstall {!r}. It is a distutils installed project and thus we cannot accurately determine which files belong to it which would lead to only a partial uninstall.z.eggr   zeasy-install.pthz./z
.dist-inforA   z;Egg-link {} does not match installed location of {} (at {})z)Not sure how to uninstall: %s - Check: %sscriptsz.batconsole_scripts)groupFgui_scriptsT)1r   r>   r   r   r   rF   sysprefix	sysconfigget_pathr   formatr   to_filenamer   egg_infor!   r"   r   getattr	_providerr?   r/   has_metadataget_metadata
splitlinesnormpathr#   r   r@   r\   r   rE   openrU   readlinestripAssertionErrorr   metadata_isdirmetadata_listdirr
   r   r   r   
get_entry_mapkeysextendr-   )clsr%   	dist_pathr*   develop_egg_linkdevelop_egg_link_egg_infoegg_info_existsdistutils_egg_infoinstalled_filer"   
top_level_pkgeasy_install_eggeasy_install_pthfhlink_pointerscriptr(   _scripts_to_remover   namer   sr+   )r   r,   	from_dist  s    






zUninstallPathSet.from_distN)FF)r   r   r   r   r   r   r/   r   r   r   r   r   classmethodr   r+   r+   r+   r,   r   @  s   	

 r   c               @   s,   e Zd Zdd Zdd Zdd Zdd Zd	S )
r   c             C   s   || _ t | _d | _d S )N)filer.   entries_saved_lines)r~   r   r+   r+   r,   r   J  s    zUninstallPthEntries.__init__c             C   s<   t j|}tr,t j|d s,|dd}| j| d S )Nr   \/)r!   r"   rU   r   
splitdrivereplacer   r/   )r~   r   r+   r+   r,   r/   P  s    
zUninstallPthEntries.addc          	   C   s  t d| j tj| js.t d| j d S t| jd}| }|| _	W d Q R X t
dd |D rld}nd}|r|d |d	s|d |d	 |d< xH| j
D ]>}y$t d
| ||| d	 W q tk
r   Y qX qW t| jd}|| W d Q R X d S )NzRemoving pth entries from %s:z.Cannot remove entries from nonexistent file %srbc             s   s   | ]}d |kV  qdS )s   
Nr+   )rK   liner+   r+   r,   rN   n  s    z-UninstallPthEntries.remove.<locals>.<genexpr>z

zutf-8zRemoving entry: %swb)r   r   r   r!   r"   rp   warningr   	readlinesr   rP   r?   encoder   r   
ValueError
writelines)r~   r   linesendliner   r+   r+   r,   r   `  s*    

zUninstallPthEntries.removec          	   C   sR   | j d krtd| j dS td| j t| jd}|| j  W d Q R X dS )Nz.Cannot roll back changes to %s, none were madeFz!Rolling %s back to previous stater   T)r   r   r   r   r   r   r   )r~   r   r+   r+   r,   r   ~  s    

zUninstallPthEntries.rollbackN)r   r   r   r   r/   r   r   r+   r+   r+   r,   r   I  s   r   )=
__future__r   r;   r6   loggingr!   r   r   pip._vendorr   pip._internal.exceptionsr   pip._internal.locationsr   r   pip._internal.utils.compatr   r   r	   pip._internal.utils.loggingr
   pip._internal.utils.miscr   r   r
   r   r   r   r   r   r   pip._internal.utils.temp_dirr   r   pip._internal.utils.typingr   typingr   r   r   r   r   r   r   r   r   Zpip._vendor.pkg_resourcesr    	getLoggerr   r   r-   r8   rE   rT   rm   rz   objectr{   r   r   r+   r+   r+   r,   <module>   s:   ,,

(3o    python3.7/site-packages/pip/_internal/req/__pycache__/req_file.cpython-37.pyc                       0000644                 00000031600 15107360303 0023012 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    ReK                 @   sV  d Z ddlmZ ddlZddlZddlZddlZddlZddlm	Z
 ddlmZ ddl
mZmZ ddlmZ ddlmZ dd	lmZ dd
lmZ ddlmZ erddlmZ dd
lmZmZmZmZm Z m!Z!m"Z"m#Z#m$Z$ ddl%m&Z& ddl'm(Z( ee$e)e#f  Z*ee#ge$e+ef f Z,dgZ-e.dej/Z0e.dZ1e.dZ2ej3ej4ej5ej6ej7ej8ej9ej:ej;ej<ej=ej>ej?ej@gZAejBejCejDgZEdd eED ZFG dd deGZHG dd deGZId7ddZJdd ZKd8ddZLd9d d!ZMd:d"d#ZNG d$d% d%eGZOd&d' ZPd(d) ZQG d*d+ d+eRZSd,d- ZTd.d/ ZUd0d1 ZVd2d3 ZWd;d4d5ZXe.d6ej/ZYdS )<z
Requirements file parsing
    )absolute_importN)parse)
cmdoptions)InstallationErrorRequirementsFileParseError)SearchScope)raise_for_status)auto_decode)MYPY_CHECK_RUNNING)get_url_scheme)Values)	AnyCallableDictIteratorListNoReturnOptionalTextTuple)
PackageFinder)
PipSessionparse_requirementsz^(http|https|file):z(^|\s+)#.*$z#(?P<var>\$\{(?P<name>[A-Z0-9_]+)\})c             C   s   g | ]}t | jqS  )strdest).0or   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/req/req_file.py
<listcomp>L   s    r   c               @   s   e Zd ZdddZdS )ParsedRequirementNc             C   s(   || _ || _|| _|| _|| _|| _d S )N)requirementis_editable
comes_fromoptions
constraintline_source)selfr!   r"   r#   r%   r$   r&   r   r   r   __init__P   s    
zParsedRequirement.__init__)NN)__name__
__module____qualname__r(   r   r   r   r   r    O   s    r    c               @   s   e Zd Zdd ZdS )
ParsedLinec             C   s`   || _ || _|| _|| _|| _|r6d| _d| _|| _n&|jrVd| _d| _|jd | _nd| _d S )NTFr   )	filenamelinenor#   optsr%   is_requirementr"   r!   	editables)r'   r-   r.   r#   argsr/   r%   r   r   r   r(   c   s    
zParsedLine.__init__N)r)   r*   r+   r(   r   r   r   r   r,   b   s   r,   Fc       
      c   sL   t |}t|||}x2|| |D ]"}t||||d}	|	dk	r"|	V  q"W dS )a  Parse a requirements file and yield ParsedRequirement instances.

    :param filename:    Path or url of requirements file.
    :param session:     PipSession instance.
    :param finder:      Instance of pip.index.PackageFinder.
    :param comes_from:  Origin description of requirements.
    :param options:     cli options.
    :param constraint:  If true, parsing a constraint file rather than
        requirements file.
    )r$   findersessionN)get_line_parserRequirementsFileParserr   handle_line)
r-   r4   r3   r#   r$   r%   line_parserparserparsed_line
parsed_reqr   r   r   r      s    c             C   s,   t |  dd}t|}t|}t|}|S )zxSplit, filter, and join lines, and return a line iterator

    :param content: the content of the requirements file
       )start)	enumerate
splitlines
join_linesignore_commentsexpand_env_variables)content
lines_enumr   r   r   
preprocess   s
    rE   c             C   s   d | jrdnd| j| j}| js&t| jrBt| j| j|| jdS |rTt	
|| j i }x4tD ],}|| jj
kr^| jj
| r^| jj
| ||< q^W d | j| j}t| j| j|| j||dS d S )Nz{} {} (line {})z-cz-r)r!   r"   r#   r%   z
line {} of {})r!   r"   r#   r%   r$   r&   )formatr%   r-   r.   r0   AssertionErrorr"   r    r!   r   check_install_build_globalr/   SUPPORTED_OPTIONS_REQ_DEST__dict__)liner$   line_comes_fromreq_optionsr   r&   r   r   r   handle_requirement_line   s.    


rN   c                s(   r4| j r| j  _ | jr4 j fdd| jD  |r$|j}|j}| jrT| jg}| jdkrbg }| jrt|| j | jr| jd }tj	
tj	|}	tj	|	|}
tj	
|
r|
}|| t||d}||_| jr|  | jr|  |r$x.| jpg D ] }d||}
|j||
d q W d S )Nc             3   s   | ]}| j kr|V  qd S )N)features_enabled)r   f)r$   r   r   	<genexpr>   s    z%handle_option_line.<locals>.<genexpr>Tr   )
find_links
index_urlsz
line {} of {})source)require_hashesrO   extendrR   rS   	index_urlno_indexextra_index_urlsospathdirnameabspathjoinexistsappendr   search_scopepreset_allow_all_prereleases
prefer_binaryset_prefer_binary
trusted_hostsrF   add_trusted_host)r/   r-   r.   r3   r$   r4   rR   rS   valuereq_dirrelative_to_reqs_filera   hostrT   r   )r$   r   handle_option_line   sD    



rl   c             C   s4   | j rt| |}|S t| j| j| j||| dS dS )a  Handle a single parsed requirements line; This can result in
    creating/yielding requirements, or updating the finder.

    :param line:        The parsed line to be processed.
    :param options:     CLI options.
    :param finder:      The finder - updated by non-requirement lines.
    :param session:     The session - updated by non-requirement lines.

    Returns a ParsedRequirement object if the line is a requirement line,
    otherwise returns None.

    For lines that contain requirements, the only options that have an effect
    are from SUPPORTED_OPTIONS_REQ, and they are scoped to the
    requirement. Other options from SUPPORTED_OPTIONS may be present, but are
    ignored.

    For lines that do not contain requirements, the only options that have an
    effect are from SUPPORTED_OPTIONS. Options from SUPPORTED_OPTIONS_REQ may
    be present, but are ignored. These lines may contain multiple options
    (although our docs imply only one is su