| d}t |d
}t |d}	|rtt	|| t |t|  t	| t d |	 }
n.tt	|t |t|  t	| t d |	 }
|

fdd | tt   |
dS )a  Helper method for defining space-delimited indentation blocks,
    such as those used to define block statements in Python source code.

    Parameters:

     - blockStatementExpr - expression defining syntax of statement that
       is repeated within the indented block
     - indentStack - list created by caller to manage indentation stack
       (multiple statementWithIndentedBlock expressions within a single
       grammar should share a common indentStack)
     - indent - boolean indicating whether block must be indented beyond
       the current level; set to False for block of left-most
       statements (default= ``True``)

    A valid block must contain at least one ``blockStatement``.

    Example::

        data = '''
        def A(z):
          A1
          B = 100
          G = A2
          A2
          A3
        B
        def BB(a,b,c):
          BB1
          def BBA():
            bba1
            bba2
            bba3
        C
        D
        def spam(x,y):
             def eggs(z):
                 pass
        '''


        indentStack = [1]
        stmt = Forward()

        identifier = Word(alphas, alphanums)
        funcDecl = ("def" + identifier + Group("(" + Optional(delimitedList(identifier)) + ")") + ":")
        func_body = indentedBlock(stmt, indentStack)
        funcDef = Group(funcDecl + func_body)

        rvalue = Forward()
        funcCall = Group(identifier + "(" + Optional(delimitedList(rvalue)) + ")")
        rvalue << (funcCall | identifier | Word(nums))
        assignment = Group(identifier + "=" + rvalue)
        stmt << (funcDef | assignment | identifier)

        module_body = OneOrMore(stmt)

        parseTree = module_body.parseString(data)
        parseTree.pprint()

    prints::

        [['def',
          'A',
          ['(', 'z', ')'],
          ':',
          [['A1'], [['B', '=', '100']], [['G', '=', 'A2']], ['A2'], ['A3']]],
         'B',
         ['def',
          'BB',
          ['(', 'a', 'b', 'c', ')'],
          ':',
          [['BB1'], [['def', 'BBA', ['(', ')'], ':', [['bba1'], ['bba2'], ['bba3']]]]]],
         'C',
         'D',
         ['def',
          'spam',
          ['(', 'x', 'y', ')'],
          ':',
          [[['def', 'eggs', ['(', 'z', ')'], ':', [['pass']]]]]]]
    Nc                  s    d d < d S )Nr   r   )backup_stackindentStackr   r   reset_stack  s    z"indentedBlock.<locals>.reset_stackc                sN   |t | krd S t|| }| d krJ| d kr>t| |dt| |dd S )Nr   zillegal nestingznot a peer entry)r   rW   r<   )r   r   r   curCol)r  r   r   checkPeerIndent  s     
z&indentedBlock.<locals>.checkPeerIndentc                s2   t || }| d kr" | nt| |dd S )Nr   znot a subentry)rW   r   r<   )r   r   r   r  )r  r   r   checkSubIndent  s    
z%indentedBlock.<locals>.checkSubIndentc                sJ   |t | krd S t|| } r&| ks2t| |d| d k rF   d S )Nznot an unindentr   )r   rW   r<   rH  )r   r   r   r  )r  r   r   
checkUnindent  s     
z$indentedBlock.<locals>.checkUnindentz	 )r  INDENTr   UNINDENTc                s     S )Nr   )rU  rK  r   r  )r  r   r   r     r   zindentedBlock.<locals>.<lambda>zindented block)
r6   r/   rL  rJ  rF   r)   r   r  r-   r8   r  rN  rJ  )blockStatementExprr  rm  r  r  r  r  r  PEERUNDENTsmExprr   )r  r  r  r   r   W  s"    Q2,z#[\0xc0-\0xd6\0xd8-\0xf6\0xf8-\0xff]z[\0xa1-\0xbf\0xd7\0xf7]z_:zany tagzgt lt amp nbsp quot aposz><& "'z&(?P<entity>rM  z);zcommon HTML entityc             C   s   t | jS )zRHelper parser action to replace common HTML entities with their special characters)_htmlEntityMapr   entity)r   r   r   r   ry     s    z/\*(?:[^*]|\*(?!/))*z*/zC style commentz<!--[\s\S]*?-->zHTML commentz.*zrest of linez//(?:\\\n|[^\n])*z
// commentzC++ style commentz#.*zPython style comment)r  z 		commaItem)rD  c               @   s  e Zd ZdZeeZeeZe	e
deZ
e	edeedZeddeZe ed e e dZed	d
  eeeed e  B dZee ed
deZeddeZeeB eB  ZeddeZe	ed ed dZeddZ eddZ!e!de! d  dZ"ee!de! d  d ee!de! d   dZ#e#$dd
  d e  d!Z%e&e"e%B e#B d"d"Z'ed#d$Z(e)d=d&d'Z*e)d>d)d*Z+ed+d,Z,ed-d.Z-ed/d0Z.e/ e0 B Z1e)d1d2 Z2e&e3e4d3 e5   e	e6d3d4 ee7d5  d6Z8e9ee:; e8B d7d8d9Z<e)ed:d
 Z=e)ed;d
 Z>d<S )?r   a  Here are some common low-level expressions that may be useful in
    jump-starting parser development:

     - numeric forms (:class:`integers<integer>`, :class:`reals<real>`,
       :class:`scientific notation<sci_real>`)
     - common :class:`programming identifiers<identifier>`
     - network addresses (:class:`MAC<mac_address>`,
       :class:`IPv4<ipv4_address>`, :class:`IPv6<ipv6_address>`)
     - ISO8601 :class:`dates<iso8601_date>` and
       :class:`datetime<iso8601_datetime>`
     - :class:`UUID<uuid>`
     - :class:`comma-separated list<comma_separated_list>`

    Parse actions:

     - :class:`convertToInteger`
     - :class:`convertToFloat`
     - :class:`convertToDate`
     - :class:`convertToDatetime`
     - :class:`stripHTMLTags`
     - :class:`upcaseTokens`
     - :class:`downcaseTokens`

    Example::

        pyparsing_common.number.runTests('''
            # any int or real number, returned as the appropriate type
            100
            -100
            +100
            3.14159
            6.02e23
            1