js|jjs(|jjr|jjrB|jjd }d}n|jjd }d}t|rjt||}n t|st	j
t	j
||}x"| 
||D ]
}|V  qW q|V  qW d S )Nr   FT)_parse_filer0   r/   requirementsconstraints	SCHEME_REsearchurllib_parseurljoinrZ   r[   r^   r\   rp   )r'   r-   r%   rK   req_pathnested_constraint
inner_liner   r   r   rp   U  s"    

z)RequirementsFileParser._parse_and_recursec             c   s   t || j| jd\}}t|}xr|D ]j\}}y| |\}}	W n8 tk
rv }
 zd||
j}t|W d d }
~
X Y nX t	||| j||	|V  q$W d S )N)r#   zInvalid requirement: {}
{})
get_file_contentrm   ro   rE   rn   OptionParsingErrorrF   msgr   r,   )r'   r-   r%   _rC   rD   line_numberrK   args_strr/   er}   r   r   r   rq   v  s     z"RequirementsFileParser._parse_fileN)r)   r*   r+   r(   r   rp   rq   r   r   r   r   r6   B  s   !r6   c                s    fdd}|S )Nc                s^   t  }| }d |_ r  j|_t| \}}tjdk r@|d}|t	
||\}}||fS )N)         utf8)build_parserget_default_valuesrW   format_controlbreak_args_optionssysversion_infoencode
parse_argsshlexsplit)rK   r9   defaultsr   options_strr/   r~   )r3   r   r   
parse_line  s    

z#get_line_parser.<locals>.parse_liner   )r3   r   r   )r3   r   r5     s    r5   c             C   sh   |  d}g }|dd }x8|D ]0}|ds8|dr<P q || |d q W d|d|fS )zBreak up the line into an args and options string.  We only want to shlex
    (and then optparse) the options, not the args.  args can contain markers
    which are corrupted by shlex.
     N-z--r   )r   
startswithr`   popr^   )rK   tokensr2   r$   tokenr   r   r   r     s    


r   c               @   s   e Zd Zdd ZdS )r|   c             C   s
   || _ d S )N)r}   )r'   r}   r   r   r   r(     s    zOptionParsingError.__init__N)r)   r*   r+   r(   r   r   r   r   r|     s   r|   c              C   sD   t jdd} tt }x|D ]}| }| | qW dd }|| _| S )z7
    Return a parser for parsing requirement lines
    F)add_help_optionc             S   s   t |d S )N)r|   )r'   r}   r   r   r   parser_exit  s    z!build_parser.<locals>.parser_exit)optparseOptionParserSUPPORTED_OPTIONSSUPPORTED_OPTIONS_REQ
add_optionexit)r9   option_factoriesoption_factoryoptionr   r   r   r   r     s    
r   c             c   s   d}g }x| D ]\}}| dr*t|rxt|r<d| }|rl|| |dk	sVt|d|fV  g }q||fV  q|s|}||d qW |r|dk	st|d|fV  dS )zJoins a line ending in '' with the previous line (except when following
    comments).  The joined line takes on the index of the first line.
    N\r    )endswith
COMMENT_REmatchr`   rG   r^   strip)rD   primary_line_numbernew_liner   rK   r   r   r   r@     s$    

r@   c             c   s8   x2| D ]*\}}t d|}| }|r||fV  qW dS )z1
    Strips comments and filter empty lines.
    r   N)r   subr   )rD   r   rK   r   r   r   rA     s
    rA   c             c   sT   xN| D ]F\}}x2t |D ]$\}}t|}|s2q|||}qW ||fV  qW dS )a  Replace all environment variables that can be retrieved via `os.getenv`.

    The only allowed format for environment variables defined in the
    requirement file is `${MY_VARIABLE_1}` to ensure two things:

    1. Strings that contain a `$` aren't accidentally (partially) expanded.
    2. Ensure consistency across platforms for requirement files.

    These points are the result of a discussion on the `github pull
    request #3514 <https://github.com/pypa/pip/pull/3514>`_.

    Valid characters in variable names follow the `POSIX standard
    <http://pubs.opengroup.org/onlinepubs/9699919799/>`_ and are limited
    to uppercase letter, digits and the `_` (underscore).
    N)
ENV_VAR_REfindallrZ   getenvreplace)rD   r   rK   env_varvar_namerh   r   r   r   rB     s    
rB   c       
   
   C   s$  t | }|dkr.|| }t| |j|jfS |dkr|rT|drTtd|| | ddd }|	dd}t
|}|r|dd |d	dd  }t
|}|drd|d }|} y&t| d
}t| }W dQ R X W n2 tk
r }	 ztd|	W dd}	~	X Y nX | |fS )
aZ  Gets the content of a file; it may be a filename, file: URL, or
    http: URL.  Returns (location, content).  Content is unicode.
    Respects # -*- coding: declarations on the retrieved files.

    :param url:         File path or url.
    :param session:     PipSession instance.
    :param comes_from:  Origin description of requirements.
    )httphttpsfiler   z6Requirements file {} references URL {}, which is local:r<   r   /|rbNz$Could not open requirements file: {})r   getr   urltextr   r   rF   r   r   _url_slash_drive_rer   grouprv   unquotelstripopenr	   readIOError)
r   r4   r#   schemerespr[   r   rP   rC   excr   r   r   r{   #  s4    





r{   z/*([a-z])\|)NNNF)N)NNN)NNN)N)Z__doc__
__future__r   r   rZ   rer   r   Zpip._vendor.six.moves.urllibr   rv   Zpip._internal.clir   pip._internal.exceptionsr   r   !pip._internal.models.search_scoper   pip._internal.network.utilsr   pip._internal.utils.encodingr	   pip._internal.utils.typingr
   pip._internal.utils.urlsr   r   typingr
   r   r   r   r   r   r   r   r   "pip._internal.index.package_finderr   pip._internal.network.sessionr   intZReqFileLinesr   Z
LineParser__all__compileIrt   r   r   rW   extra_index_urlrX   rs   rr   editablerR   	no_binaryonly_binaryrd   rU   rb   trusted_hostuse_new_featurer   install_optionsglobal_optionshashr   rI   objectr    r,   r   rE   rN   rl   r7   r6   r5   r   	Exceptionr|   r   r@   rA   rB   r{   r   r   r   r   r   <module>   s   ,

!   

.  
7  
)N 
-                                                                                                                                python3.7/site-packages/pip/_internal/req/req_file.py                                               0000644                 00000045770 15107360303 0016542 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
Requirements file parsing
"""

from __future__ import absolute_import

import optparse
import os
import re
import shlex
import sys

from pip._vendor.six.moves.urllib import parse as urllib_parse

from pip._internal.cli import cmdoptions
from pip._internal.exceptions import (
    InstallationError,
    RequirementsFileParseError,
)
from pip._internal.models.search_scope import SearchScope
from pip._internal.network.utils import raise_for_status
from pip._internal.utils.encoding import auto_decode
from pip._internal.utils.typing import MYPY_CHECK_RUNNING
from pip._internal.utils.urls import get_url_scheme

if MYPY_CHECK_RUNNING:
    from optparse import Values
    from typing import (
        Any, Callable, Dict, Iterator, List, NoReturn, Optional, Text, Tuple,
    )

    from pip._internal.index.package_finder import PackageFinder
    from pip._internal.network.session import PipSession

    ReqFileLines = Iterator[Tuple[int, Text]]

    LineParser = Callable[[Text], Tuple[str, Values]]


__all__ = ['parse_requirements']

SCHEME_RE = re.compile(r'^(http|https|file):', re.I)
COMMENT_RE = re.compile(r'(^|\s+)#.*$')

# Matches environment variable-style values in '${MY_VARIABLE_1}' with the
# variable name consisting of only uppercase letters, digits or the '_'
# (underscore). This follows the POSIX standard defined in IEEE Std 1003.1,
# 2013 Edition.
ENV_VAR_RE = re.compile(r'(?P<var>\$\{(?P<name>[A-Z0-9_]+)\})')

SUPPORTED_OPTIONS = [
    cmdoptions.index_url,
    cmdoptions.extra_index_url,
    cmdoptions.no_index,
    cmdoptions.constraints,
    cmdoptions.requirements,
    cmdoptions.editable,
    cmdoptions.find_links,
    cmdoptions.no_binary,
    cmdoptions.only_binary,
    cmdoptions.prefer_binary,
    cmdoptions.require_hashes,
    cmdoptions.pre,
    cmdoptions.trusted_host,
    cmdoptions.use_new_feature,
]  # type: List[Callable[..., optparse.Option]]

# options to be passed to requirements
SUPPORTED_OPTIONS_REQ = [
    cmdoptions.install_options,
    cmdoptions.global_options,
    cmdoptions.hash,
]  # type: List[Callable[..., optparse.Option]]

# the 'dest' string values
SUPPORTED_OPTIONS_REQ_DEST = [str(o().dest) for o in SUPPORTED_OPTIONS_REQ]


class ParsedRequirement(object):
    def __init__(
        self,
        requirement,  # type:str
        is_editable,  # type: bool
        comes_from,  # type: str
        constraint,  # type: bool
        options=None,  # type: Optional[Dict[str, Any]]
        line_source=None,  # type: Optional[str]
    ):
        # type: (...) -> None
        self.requirement = requirement
        self.is_editable = is_editable
        self.comes_from = comes_from
        self.options = options
        self.constraint = constraint
        self.line_source = line_source


class ParsedLine(object):
    def __init__(
        self,
        filename,  # type: str
        lineno,  # type: int
        comes_from,  # type: Optional[str]
        args,  # type: str
        opts,  # type: Values
        constraint,  # type: bool
    ):
        # type: (...) -> None
        self.filename = filename
        self.lineno = lineno
        self.comes_from = comes_from
        self.opts = opts
        self.constraint = constraint

        if args:
            self.is_requirement = True
            self.is_editable = False
            self.requirement = args
        elif opts.editables:
            self.is_requirement = True
            self.is_editable = True
            # We don't support multiple -e on one line
            self.requirement = opts.editables[0]
        else:
            self.is_requirement = False


def parse_requirements(
    filename,  # type: str
    session,  # type: PipSession
    finder=None,  # type: Optional[PackageFinder]
    comes_from=None,  # type: Optional[str]
    options=None,  # type: Optional[optparse.Values]
    constraint=False,  # type: bool
):
    # type: (...) -> Iterator[ParsedRequirement]
    """Parse a requirements file and yield ParsedRequirement instances.

    :param filename:    Path or url of requirements file.
    :param session:     PipSession instance.
    :param finder:      Instance of pip.index.PackageFinder.
    :param comes_from:  Origin description of requirements.
    :param options:     cli options.
    :param constraint:  If true, parsing a constraint file rather than
        requirements file.
    """
    line_parser = get_line_parser(finder)
    parser = RequirementsFileParser(session, line_parser, comes_from)

    for parsed_line in parser.parse(filename, constraint):
        parsed_req = handle_line(
            parsed_line,
            options=options,
            finder=finder,
            session=session
        )
        if parsed_req is not None:
            yield parsed_req


def preprocess(content):
    # type: (Text) -> ReqFileLines
    """Split, filter, and join lines, and return a line iterator

    :param content: the content of the requirements file
    """
    lines_enum = enumerate(content.splitlines(), start=1)  # type: ReqFileLines
    lines_enum = join_lines(lines_enum)
    lines_enum = ignore_comments(lines_enum)
    lines_enum = expand_env_variables(lines_enum)
    return lines_enum


def handle_requirement_line(
    line,  # type: ParsedLine
    options=None,  # type: Optional[optparse.Values]
):
    # type: (...) -> ParsedRequirement

    # preserve for the nested code path
    line_comes_from = '{} {} (line {})'.format(
        '-c' if line.constraint else '-r', line.filename, line.lineno,
    )

    assert line.is_requirement

    if line.is_editable:
        # For editable requirements, we don't support per-requirement
        # options, so just return the parsed requirement.
        return ParsedRequirement(
            requirement=line.requirement,
            is_editable=line.is_editable,
            comes_from=line_comes_from,
            constraint=line.constraint,
        )
    else:
        if options:
            # Disable wheels if the user has specified build options
            cmdoptions.check_install_build_global(options, line.opts)

        # get the options that apply to requirements
        req_options = {}
        for dest in SUPPORTED_OPTIONS_REQ_DEST:
            if dest in line.opts.__dict__ and line.opts.__dict__[dest]:
                req_options[dest] = line.opts.__dict__[dest]

        line_source = 'line {} of {}'.format(line.lineno, line.filename)
        return ParsedRequirement(
            requirement=line.requirement,
            is_editable=line.is_editable,
            comes_from=line_comes_from,
            constraint=line.constraint,
            options=req_options,
            line_source=line_source,
        )


def handle_option_line(
    opts,  # type: Values
    filename,  # type: str
    lineno,  # type: int
    finder=None,  # type: Optional[PackageFinder]
    options=None,  # type: Optional[optparse.Values]
    session=None,  # type: Optional[PipSession]
):
    # type:  (...) -> None

    if options:
        # percolate options upward
        if opts.require_hashes:
            options.require_hashes = opts.require_hashes
        if opts.features_enabled:
            options.features_enabled.extend(
                f for f in opts.features_enabled
                if f not in options.features_enabled
            )

    # set finder options
    if finder:
        find_links = finder.find_links
        index_urls = finder.index_urls
        if opt