     s    
z!CommandContextMixIn.enter_context)__name__
__module____qualname__r   r   r   r   
__classcell__r   r   )r   r   r
   
   s   r
   N)
contextlibr   pip._vendor.contextlib2r   pip._internal.utils.typingr   typingr   r   r   r   objectr
   r   r   r   r   <module>   s                                                                                                                                                                           python3.7/site-packages/pip/_internal/cli/autocompletion.py                                         0000644                 00000014623 15107360274 0017776 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Logic that powers autocompletion installed by ``pip completion``.
"""

import optparse
import os
import sys
from itertools import chain

from pip._internal.cli.main_parser import create_main_parser
from pip._internal.commands import commands_dict, create_command
from pip._internal.utils.misc import get_installed_distributions
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from typing import Any, Iterable, List, Optional


def autocomplete():
    # type: () -> None
    """Entry Point for completion of main and subcommand options.
    """
    # Don't complete if user hasn't sourced bash_completion file.
    if 'PIP_AUTO_COMPLETE' not in os.environ:
        return
    cwords = os.environ['COMP_WORDS'].split()[1:]
    cword = int(os.environ['COMP_CWORD'])
    try:
        current = cwords[cword - 1]
    except IndexError:
        current = ''

    parser = create_main_parser()
    subcommands = list(commands_dict)
    options = []

    # subcommand
    subcommand_name = None  # type: Optional[str]
    for word in cwords:
        if word in subcommands:
            subcommand_name = word
            break
    # subcommand options
    if subcommand_name is not None:
        # special case: 'help' subcommand has no options
        if subcommand_name == 'help':
            sys.exit(1)
        # special case: list locally installed dists for show and uninstall
        should_list_installed = (
            subcommand_name in ['show', 'uninstall'] and
            not current.startswith('-')
        )
        if should_list_installed:
            installed = []
            lc = current.lower()
            for dist in get_installed_distributions(local_only=True):
                if dist.key.startswith(lc) and dist.key not in cwords[1:]:
                    installed.append(dist.key)
            # if there are no dists installed, fall back to option completion
            if installed:
                for dist in installed:
                    print(dist)
                sys.exit(1)

        subcommand = create_command(subcommand_name)

        for opt in subcommand.parser.option_list_all:
            if opt.help != optparse.SUPPRESS_HELP:
                for opt_str in opt._long_opts + opt._short_opts:
                    options.append((opt_str, opt.nargs))

        # filter out previously specified options from available options
        prev_opts = [x.split('=')[0] for x in cwords[1:cword - 1]]
        options = [(x, v) for (x, v) in options if x not in prev_opts]
        # filter options by current input
        options = [(k, v) for k, v in options if k.startswith(current)]
        # get completion type given cwords and available subcommand options
        completion_type = get_path_completion_type(
            cwords, cword, subcommand.parser.option_list_all,
        )
        # get completion files and directories if ``completion_type`` is
        # ``<file>``, ``<dir>`` or ``<path>``
        if completion_type:
            paths = auto_complete_paths(current, completion_type)
            options = [(path, 0) for path in paths]
        for option in options:
            opt_label = option[0]
            # append '=' to options which require args
            if option[1] and option[0][:2] == "--":
                opt_label += '='
            print(opt_label)
    else:
        # show main parser options only when necessary

        opts = [i.option_list for i in parser.option_groups]
        opts.append(parser.option_list)
        flattened_opts = chain.from_iterable(opts)
        if current.startswith('-'):
            for opt in flattened_opts:
                if opt.help != optparse.SUPPRESS_HELP:
                    subcommands += opt._long_opts + opt._short_opts
        else:
            # get completion type given cwords and all available options
            completion_type = get_path_completion_type(cwords, cword,
                                                       flattened_opts)
            if completion_type:
                subcommands = list(auto_complete_paths(current,
                                                       completion_type))

        print(' '.join([x for x in subcommands if x.startswith(current)]))
    sys.exit(1)


def get_path_completion_type(cwords, cword, opts):
    # type: (List[str], int, Iterable[Any]) -> Optional[str]
    """Get the type of path completion (``file``, ``dir``, ``path`` or None)

    :param cwords: same as the environmental variable ``COMP_WORDS``
    :param cword: same as the environmental variable ``COMP_CWORD``
    :param opts: The available options to check
    :return: path completion type (``file``, ``dir``, ``path`` or None)
    """
    if cword < 2 or not cwords[cword - 2].startswith('-'):
        return None
    for opt in opts:
        if opt.help == optparse.SUPPRESS_HELP:
            continue
        for o in str(opt).split('/'):
            if cwords[cword - 2].split('=')[0] == o:
                if not opt.metavar or any(
                        x in ('path', 'file', 'dir')
                        for x in opt.metavar.split('/')):
                    return opt.metavar
    return None


def auto_complete_paths(current, completion_type):
    # type: (str, str) -> Iterable[str]
    """If ``completion_type`` is ``file`` or ``path``, list all regular files
    and directories starting with ``current``; otherwise only list directories
    starting with ``current``.

    :param current: The word to be completed
    :param completion_type: path completion type(`file`, `path` or `dir`)i
    :return: A generator of regular files and/or directories
    """
    directory, filename = os.path.split(current)
    current_path = os.path.abspath(directory)
    # Don't complete paths if they can't be accessed
    if not os.access(current_path, os.R_OK):
        return
    filename = os.path.normcase(filename)
    # list all files that start with ``filename``
    file_list = (x for x in os.listdir(current_path)
                 if os.path.normcase(x).startswith(filename))
    for f in file_list:
        opt = os.path.join(current_path, f)
        comp_file = os.path.normcase(os.path.join(directory, f))
        # complete regular files when there is not ``<dir>`` after option
        # complete directories when there is ``<file>``, ``<path>`` or
        # ``<dir>``after option
        if completion_type != 'dir' and os.path.isfile(opt):
            yield comp_file
        elif os.path.isdir(opt):
            yield os.path.join(comp_file, '')
                                                                                                             python3.7/site-packages/pip/_internal/cli/progress_bars.py                                          0000644                 00000021641 15107360274 0017605 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import division

import itertools
import sys
from signal import SIGINT, default_int_handler, signal

from pip._vendor import six
from pip._vendor.progress.bar import Bar, FillingCirclesBar, IncrementalBar
from pip._vendor.progress.spinner import Spinner

from pip._internal.utils.compat import WINDOWS
from pip._internal.utils.logging import get_indentation
from pip._internal.utils.misc import format_size
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from typing import Any, Dict, List

try:
    from pip._vendor import colorama
# Lots of different errors can come from this, including SystemError and
# ImportError.
except Exception:
    colorama = None


def _select_progress_class(preferred, fallback):
    # type: (Bar, Bar) -> Bar
    encoding = getattr(preferred.file, "encoding", None)

    # If we don't know what encoding this file is in, then we'll just assume
    # that it doesn't support unicode and use the ASCII bar.
    if not encoding:
        return fallback

    # Collect all of the possible characters we want to use with the preferred
    # bar.
    characters = [
        getattr(preferred, "empty_fill", six.text_type()),
        getattr(preferred, "fill", six.text_type()),
    ]
    characters += list(getattr(preferred, "phases", []))

    # Try to decode the characters we're using for the bar using the encoding
    # of the given file, if this works then we'll assume that we can use the
    # fancier bar and if not we'll fall back to the plaintext bar.
    try:
        six.text_type().join(characters).encode(encoding)
    except UnicodeEncodeError:
        return fallback
    else:
        return preferred


_BaseBar = _select_progress_class(IncrementalBar, Bar)  # type: Any


class InterruptibleMixin(object):
    """
    Helper to ensure that self.finish() gets called on keyboard interrupt.

    This allows downloads to be interrupted without leaving temporary state
    (like hidden cursors) behind.

    This class is similar to the progress library's existing SigIntMixin
    helper, but as of version 1.2, that helper has the following problems:

    1. It calls sys.exit().
    2. It discards the existing SIGINT handler completely.
    3. It leaves its own handler in place even after an uninterrupted finish,
       which will have unexpected delayed effects if the user triggers an
       unrelated keyboard interrupt some time after a progress-displaying
       download has already completed, for example.
    """

    def __init__(self, *args, **kwargs):
        # type: (List[Any], Dict[Any, Any]) -> None
        """
        Save the original SIGINT handler for later.
        """
        # https://github.com/python/mypy/issues/5887
        super(InterruptibleMixin, self).__init__(  # type: ignore
            *args,
            **kwargs
        )

        self.original_handler = signal(SIGINT, self.handle_sigint)

        # If signal() returns None, the previous handler was not installed from
        # Python, and we cannot restore it. This probably should not happen,
        # but if it does, we must restore something sensible instead, at least.
        # The least bad option should be Python's default SIGINT handler, which
        # just raises KeyboardInterrupt.
        if self.original_handler is None:
            self.original_handler = default_int_handler

    def finish(self):
        # type: () -> None
        """
        Restore the original SIGINT handler after finishing.

        This should happen regardless of whether the progress display finishes
        normally, or gets interrupted.
        """
        super(InterruptibleMixin, self).finish()  # type: ignore
        signal(SIGINT, self.original_handler)

    def handle_sigint(self, signum, frame):  # type: ignore
        """
        Call self.finish() before delegating to the original SIGINT handler.

        This handler should only be in place while the progress display is
        active.
        """
        self.finish()
        self.original_handler(signum, frame)


class SilentBar(Bar):

    def update(self):
        # type: () -> None
        pass


class BlueEmojiBar(IncrementalBar):

    suffix = "%(percent)d%%"
    bar_prefix = " "
    bar_suffix = " "
    phases = (u"\U0001F539", u"\U0001F537", u"\U0001F535")  # type: Any


class DownloadProgressMixin(object):

    def __init__(self, *args, **kwargs):
        # type: (List[Any], Dict[Any, Any]) -> None
        # https://github.com/python/mypy/issues/5887
        super(DownloadProgressMixin, self).__init__(  # type: ignore
            *args,
            **kwargs
        )
        self.message = (" " * (
            get_indentation() + 2
        )) + self.message  # type: str

    @property
    def downloaded(self):
        # type: () -> str
        return format_size(self.index)  # type: ignore

    @property
    def download_speed(self):
        # type: () -> str
        # Avoid zero division errors...
        if self.avg == 0.0:  # type: ignore
            return "..."
        return format_size(1 / self.avg) + "/s"  # type: ignore

    @property
    def pretty_eta(self):
        # type: () -> str
        if self.eta:  # type: ignore
            return "eta {}".format(self.eta_td)  # type: ignore
        return ""

    def iter(self, it):  # type: ignore
        for x in it:
            yield x
            # B305 is incorrectly raised here
            # https://github.com/PyCQA/flake8-bugbear/issues/59
            self.next(len(x))  # noqa: B305
        self.finish()


class WindowsMixin(object):

    def __init__(self, *args, **kwargs):
        # type: (List[Any], Dict[Any, Any]) -> None
        # The Windows terminal does not support the hide/show cursor ANSI codes
        # even with colorama. So we'll ensure that hide_cursor is False on
        # Windows.
        # This call needs to go before the super() call, so that hide_cursor
        # is set in time. The base progress bar class writes the "hide cursor"
        # code to the terminal in its init, so if we don't set this soon
        # enough, we get a "hide" with no corresponding "show"...
        if WINDOWS and self.hide_cursor:  # type: ignore
            self.hide_cursor = False

        # https://github.com/python/mypy/issues/5887
        super(WindowsMixin, self).__init__(*args, **kwargs)  # type: ignore

        # Check if we are running on Windows and we have the colorama module,
        # if we do then wrap our file with it.
        if WINDOWS and colorama:
            self.file = colorama.AnsiToWin32(self.file)  # type: ignore
            # The progress code expects to be able to call self.file.isatty()
            # but the colorama.AnsiToWin32() object doesn't have that, so we'll
            # add it.
            self.file.isatty = lambda: self.file.wrapped.isatty()
            # The progress code expects to be able to call self.file.flush()
            # but the colorama.AnsiToWin32() object doesn't have that, so we'll
            # add it.
            self.file.flush = lambda: self.file.wrapped.flush()


class BaseDownloadProgressBar(WindowsMixin, InterruptibleMixin,
                              DownloadProgressMixin):

    file = sys.stdout
    message = "%(percent)d%%"
    suffix = "%(downloaded)s %(download_speed)s %(pretty_eta)s"


class DefaultDownloadProgressBar(BaseDownloadProgressBar,
                                 _BaseBar):
    pass


class DownloadSilentBar(BaseDownloadProgressBar, SilentBar):
    pass


class DownloadBar(BaseDownloadProgressBar,
                  Bar):
    pass


class DownloadFillingCirclesBar(BaseDownloadProgressBar,
                                FillingCirclesBar):
    pass


class DownloadBlueEmojiProgressBar(BaseDownloadProgressBar,
                                   BlueEmojiBar):
    pass


class DownloadProgressSpinner(WindowsMixin, InterruptibleMixin,
                              DownloadProgressMixin, Spinner):

    file = sys.stdout
    suffix = "%(downloaded)s %(download_speed)s"

    def next_phase(self):
        # type: () -> str
        if not hasattr(self, "_phaser"):
            self._phaser = itertools.cycle(self.phases)
        return next(self._phaser)

    def update(self):
        # type: () -> None
        message = self.message % self
        phase = self.next_phase()
        suffix = self.suffix % self
        line = ''.join([
            message,
            " " if message else "",
            phase,
            " " if suffix else "",
            suffix,
        ])

        self.writeln(line)


BAR_TYPES = {
    "off": (DownloadSilentBar, DownloadSilentBar),
    "on": (DefaultDownloadProgressBar, DownloadProgressSpinner),
    "ascii": (DownloadBar, DownloadProgressSpinner),
    "pretty": (DownloadFillingCirclesBar, DownloadProgressSpinner),
    "emoji": (DownloadBlueEmojiProgressBar, DownloadProgressSpinner)
}


def DownloadProgressProvider(progress_bar, max=None):  # type: ignore
    if max is None or max == 0:
        return BAR_TYPES[progress_bar][1]().iter
    else:
        return BAR_TYPES[progress_bar][0](max=max).iter
                                                                                               python3.7/site-packages/pip/_internal/cli/cmdoptions.py                                             0000644                 00000070156 15107360274 0017116 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
shared options and groups

The principle here is to define options once, but *not* instantiate them
globally. One reason being that options with action='append' can carry state
between parses. pip parses general options twice internally, and shouldn't
pass on state. To be consistent, all options will follow this design.
"""

# The following comment should be removed at some point in the future.
# mypy: strict-optional=False

from __future__ import absolute_import

import os
import textwrap
import warnings
from distutils.util import strtobool
from functools import partial
from optparse import SUPPRESS_HELP, Option, OptionGroup
from textwrap import dedent

from pip._internal.cli.progress_bars import BAR_TYPES
from pip._internal.exceptions import CommandError
from pip._internal.locations import USER_CACHE_DIR, get_src_prefix
from pip._internal.models.format_control import FormatControl
from pip._internal.models.index import PyPI
from pip._internal.models.target_python import TargetPython
from pip._internal.utils.hashes import STRONG_HASHES
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from typing import Any, Callable, Dict, Optional, Tuple
    from optparse import OptionParser, Values
    from pip._internal.cli.parser import ConfigOptionParser


def raise_option_error(parser, option, msg):
    # type: (OptionParser, Option, str) -> None
    """
    Raise an option parsing error using parser.error().

    Args:
      parser: an OptionParser instance.
      option: an Option instance.
      msg: the error text.
    """
    msg = '{} error: {}'.format(option, msg)
    msg = textwrap.fill(' '.join(msg.split()))
    parser.error(msg)


def make_option_group(group, parser):
    # type: (Dict[str, Any], ConfigOptionParser) -> OptionGroup
    """
    Return an OptionGroup object
    group  -- assumed to be dict with 'name' and 'options' keys
    parser -- an optparse Parser
    """
    option_group = OptionGroup(parser, group['name'])
    for option in group['options']:
        option_group.add_option(option())
    return option_group


def check_install_build_global(options, check_options=None):
    # type: (Values, Optional[Values]) -> None
    """Disable wheels if per-setup.py call options are set.

    :param options: The OptionParser options to update.
    :param check_options: The options to check, if not supplied defaults to
        options.
    """
    if check_options is None:
        check_options = options

    def getname(n):
        # type: (str) -> Optional[Any]
        return getattr(check_options, n, None)
    names = ["build_options", "global_options", "install_options"]
    if any(map(getname, names)):
        control = options.format_control
        control.disallow_binaries()
        warnings.warn(
            'Disabling all use of wheels due to the use of --build-option '
            '/ --global-option / --install-option.', stacklevel=2,
        )


def check_dist_restriction(options, check_target=False):
    # type: (Values, bool) -> None
    """Function for determining if custom platform options are allowed.

    :param options: The OptionParser options.
    :param check_target: Whether or not to check if --target is being used.
    """
    dist_restriction_set = any([
        options.python_version,
        options.platform,
        options.abi,
        options.implementation,
    ])

    binary_only = FormatControl(set(), {':all:'})
    sdist_dependencies_allowed = (
        options.format_control != binary_only and
        not options.ignore_dependencies
    )

    # Installations or downloads using dist restrictions must not combine
    # source distributions and dist-specific wheels, as they are not
    # guaranteed to be locally compatible.
    if dist_restriction_set and sdist_dependencies_allowed:
        raise CommandError(
            "When restricting platform and interpreter constraints using "
            "--python-version, --platform, --abi, or --implementation, "
            "either --no-deps must be set, or --only-binary=:all: must be "
            "set and --no-binary must not be set (or must be set to "
            ":none:)."
        )

    if check_target:
        if dist_restriction_set and not options.target_dir:
            raise CommandError(
                "Can not use any platform or abi specific options unless "
                "installing via '--target'"
            )


def _path_option_check(option, opt, value):
    # type: (Option, str, str) -> str
    return os.path.expanduser(value)


class PipOption(Option):
    TYPES = Option.TYPES + ("path",)
    TYPE_CHECKER = Option.TYPE_CHECKER.copy()
    TYPE_CHECKER["path"] = _path_option_check


###########
# options #
###########

help_ = partial(
    Option,
    '-h', '--help',
    dest='help',
    action='help',
    help='Show help.',
)  # type: Callable[..., Option]

isolated_mode = partial(
    Option,
    "--isolated",
    dest="isolated_mode",
    action="store_true",
    default=False,
    help=(
        "Run pip in an isolated mode, ignoring environment variables and user "
        "configuration."
    ),
)  # type: Callable[..., Option]

require_virtualenv = partial(
    Option,
    # Run only if inside a virtualenv, bail if not.
    '--require-virtualenv', '--require-venv',
    dest='require_venv',
    action='store_true',
    default=False,
    help=SUPPRESS_HELP
)  # type: Callable[..., Option]

verbose = partial(
    Option,
    '-v', '--verbose',
    dest='verbose',
    action='count',
    default=0,
    help='Give more output. Option is additive, and can be used up to 3 times.'
)  # type: Callable[..., Option]

no_color = partial(
    Option,
    '--no-color',
    dest='no_color',
    action='store_true',
    default=False,
    help="Suppress colored output",
)  # type: Callable[..., Option]

version = partial(
    Option,
    '-V', '--version',
    dest='version',
    action='store_true',
    help='Show version and exit.',
)  # type: Callable[..., Option]

quiet = partial(
    Option,
    '-q', '--quiet',
    dest='quiet',
    action='count',
    default=0,
    help=(
        'Give less output. Option is additive, and can be used up to 3'
        ' times (corresponding to WARNING, ERROR, and CRITICAL logging'
        ' levels).'
    ),
)  # type: Callable[..., Option]

progress_bar = partial(
    Option,
    '--progress-bar',
    dest='progress_bar',
    type='choice',
    choices=list(BAR_TYPES.keys()),
    default='on',
    help=(
        'Specify type of progress to be displayed [' +
        '|'.join(BAR_TYPES.keys()) + '] (default: %default)'
    ),
)  # type: Callable[..., Option]

log = partial(
    PipOption,
    "--log", "--log-file", "--local-log",
    dest="log",
    metavar="path",
    type="path",
    help="Path to a verbose appending log."
)  # type: Callable[..., Option]

no_input = partial(
    Option,
    # Don't ask for input
    '--no-input',
    dest='no_input',
    action='store_true',
    default=False,
    help="Disable prompting for input."
)  # type: Callable[..., Option]

proxy = partial(
    Option,
    '--proxy',
    dest='proxy',
    type='str',
    default='',
    help="Specify a proxy in the form [user:passwd@]proxy.server:port."
)  # type: Callable[..., Option]

retries = partial(
    Option,
    '--retries',
    dest='retries',
    type='int',
    default=5,
    help="Maximum number of retries each connection should attempt "
         "(default %default times).",
)  # type: Callable[..., Option]

timeout = partial(
    Option,
    '--timeout', '--default-timeout',
    metavar='sec',
    dest='timeout',
    type='float',
    default=15,
    help='Set the socket timeout (default %default seconds).',
)  # type: Callable[..., Option]


def exists_action():
    # type: () -> Option
    return Option(
        # Option when path already exist
        '--exists-action',
        dest='exists_action',
        type='choice',
        choices=['s', 'i', 'w', 'b', 'a'],
        default=[],
        action='append',
        metavar='action',
        help="Default action when a path already exists: "
             "(s)witch, (i)gnore, (w)ipe, (b)ackup, (a)bort.",
    )


cert = partial(
    PipOption,
    '--cert',
    dest='cert',
    type='path',
    metavar='path',
    help="Path to alternate CA bundle.",
)  # type: Callable[..., Option]

client_cert = partial(
    PipOption,
    '--client-cert',
    dest='client_cert',
    type='path',
    default=None,
    metavar='path',
    help="Path to SSL client certificate, a single file containing the "
         "private key and the certificate in PEM format.",
)  # type: Callable[..., Option]

index_url = partial(
    Option,
    '-i', '--index-url', '--pypi-url',
    dest='index_url',
    metavar='URL',
    default=PyPI.simple_url,
    help="Base URL of the Python Package Index (default %default). "
         "This should point to a repository compliant with PEP 503 "
         "(the simple repository API) or a local directory laid out "
         "in the same format.",
)  # type: Callable[..., Option]


def extra_index_url():
    # type: () -> Option
    return Option(
        '--extra-index-url',
        dest='extra_index_urls',
        metavar='URL',
        action='append',
        default=[],
        help="Extra URLs of package indexes to use in addition to "
             "--index-url. Should follow the same rules as "
             "--index-url.",
    )


no_index = partial(
    Option,
    '--no-index',
    dest='no_index',
    action='store_true',
    default=False,
    help='Ignore package index (only looking at --find-links URLs instead).',
)  # type: Callable[..., Option]


def find_links():
    # type: () -> Option
    return Option(
        '-f', '--find-links',
        dest='find_links',
        action='append',
        default=[],
        metavar='url',
        help="If a URL or path to an html file, then parse for links to "
             "archives such as sdist (.tar.gz) or wheel (.whl) files. "
             "If a local path or file:// URL that's a directory,  "
             "then look for archives in the directory listing. "
             "Links to VCS project URLs are not supported.",
    )


def trusted_host():
    # type: () -> Option
    return Option(
        "--trusted-host",
        dest="trusted_hosts",
        action="append",
        metavar="HOSTNAME",
        default=[],
        help="Mark this host or host:port pair as trusted, even though it "
             "does not have valid or any HTTPS.",
    )


def constraints():
    # type: () -> Option
    return Option(
        '-c', '--constraint',
        dest='constraints',
        action='append',
        default=[],
        metavar='file',
        help='Constrain versions using the given constraints file. '
        'This option can be used multiple times.'
    )


def requirements():
    # type: () -> Option
    return Option(
        '-r', '--requirement',
        dest='requirements',
        action='append',
        default=[],
        metavar='file',
        help='Install from the given requirements file. '
        'This option can be used multiple times.'
    )


def editable():
    # type: () -> Option
    return Option(
        '-e', '--editable',
        dest='editables',
        action='append',
        default=[],
        metavar='path/url',
        help=('Install a project in editable mode (i.e. setuptools '
              '"develop mode") from a local project path or a VCS url.'),
    )


def _handle_src(option, opt_str, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    value = os.path.abspath(value)
    setattr(parser.values, option.dest, value)


src = partial(
    PipOption,
    '--src', '--source', '--source-dir', '--source-directory',
    dest='src_dir',
    type='path',
    metavar='dir',
    default=get_src_prefix(),
    action='callback',
    callback=_handle_src,
    help='Directory to check out editable projects into. '
    'The default in a virtualenv is "<venv path>/src". '
    'The default for global installs is "<current dir>/src".'
)  # type: Callable[..., Option]


def _get_format_control(values, option):
    # type: (Values, Option) -> Any
    """Get a format_control object."""
    return getattr(values, option.dest)


def _handle_no_binary(option, opt_str, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    existing = _get_format_control(parser.values, option)
    FormatControl.handle_mutual_excludes(
        value, existing.no_binary, existing.only_binary,
    )


def _handle_only_binary(option, opt_str, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    existing = _get_format_control(parser.values, option)
    FormatControl.handle_mutual_excludes(
        value, existing.only_binary, existing.no_binary,
    )


def no_binary():
    # type: () -> Option
    format_control = FormatControl(set(), set())
    return Option(
        "--no-binary", dest="format_control", action="callback",
        callback=_handle_no_binary, type="str",
        default=format_control,
        help='Do not use binary packages. Can be supplied multiple times, and '
             'each time adds to the existing value. Accepts either ":all:" to '
             'disable all binary packages, ":none:" to empty the set (notice '
             'the colons), or one or more package names with commas between '
             'them (no colons). Note that some packages are tricky to compile '
             'and may fail to install when this option is used on them.',
    )


def only_binary():
    # type: () -> Option
    format_control = FormatControl(set(), set())
    return Option(
        "--only-binary", dest="format_control", action="callback",
        callback=_handle_only_binary, type="str",
        default=format_control,
        help='Do not use source packages. Can be supplied multiple times, and '
             'each time adds to the existing value. Accepts either ":all:" to '
             'disable all source packages, ":none:" to empty the set, or one '
             'or more package names with commas between them. Packages '
             'without binary distributions will fail to install when this '
             'option is used on them.',
    )


platform = partial(
    Option,
    '--platform',
    dest='platform',
    metavar='platform',
    default=None,
    help=("Only use wheels compatible with <platform>. "
          "Defaults to the platform of the running system."),
)  # type: Callable[..., Option]


# This was made a separate function for unit-testing purposes.
def _convert_python_version(value):
    # type: (str) -> Tuple[Tuple[int, ...], Optional[str]]
    """
    Convert a version string like "3", "37", or "3.7.3" into a tuple of ints.

    :return: A 2-tuple (version_info, error_msg), where `error_msg` is
        non-None if and only if there was a parsing error.
    """
    if not value:
        # The empty string is the same as not providing a value.
        return (None, None)

    parts = value.split('.')
    if len(parts) > 3:
        return ((), 'at most three version parts are allowed')

    if len(parts) == 1:
        # Then we are in the case of "3" or "37".
        value = parts[0]
        if len(value) > 1:
            parts = [value[0], value[1:]]

    try:
        version_info = tuple(int(part) for part in parts)
    except ValueError:
        return ((), 'each version part must be an integer')

    return (version_info, None)


def _handle_python_version(option, opt_str, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    """
    Handle a provided --python-version value.
    """
    version_info, error_msg = _convert_python_version(value)
    if error_msg is not None:
        msg = (
            'invalid --python-version value: {!r}: {}'.format(
                value, error_msg,
            )
        )
        raise_option_error(parser, option=option, msg=msg)

    parser.values.python_version = version_info


python_version = partial(
    Option,
    '--python-version',
    dest='python_version',
    metavar='python_version',
    action='callback',
    callback=_handle_python_version, type='str',
    default=None,
    help=dedent("""\
    The Python interpreter version to use for wheel and "Requires-Python"
    compatibility checks. Defaults to a version derived from the running
    interpreter. The version can be specified using up to three dot-separated
    integers (e.g. "3" for 3.0.0, "3.7" for 3.7.0, or "3.7.3"). A major-minor
    version can also be given as a string without dots (e.g. "37" for 3.7.0).
    """),
)  # type: Callable[..., Option]


implementation = partial(
    Option,
    '--implementation',
    dest='implementation',
    metavar='implementation',
    default=None,
    help=("Only use wheels compatible with Python "
          "implementation <implementation>, e.g. 'pp', 'jy', 'cp', "
          " or 'ip'. If not specified, then the current "
          "interpreter implementation is used.  Use 'py' to force "
          "implementation-agnostic wheels."),
)  # type: Callable[..., Option]


abi = partial(
    Option,
    '--abi',
    dest='abi',
    metavar='abi',
    default=None,
    help=("Only use wheels compatible with Python "
          "abi <abi>, e.g. 'pypy_41'.  If not specified, then the "
          "current interpreter abi tag is used.  Generally "
          "you will need to specify --implementation, "
          "--platform, and --python-version when using "
          "this option."),
)  # type: Callable[..., Option]


def add_target_python_options(cmd_opts):
    # type: (OptionGroup) -> None
    cmd_opts.add_option(platform())
    cmd_opts.add_option(python_version())
    cmd_opts.add_option(implementation())
    cmd_opts.add_option(abi())


def make_target_python(options):
    # type: (Values) -> TargetPython
    target_python = TargetPython(
        platform=options.platform,
        py_version_info=options.python_version,
        abi=options.abi,
        implementation=options.implementation,
    )

    return target_python


def prefer_binary():
    # type: () -> Option
    return Option(
        "--prefer-binary",
        dest="prefer_binary",
        action="store_true",
        default=False,
        help="Prefer older binary packages over newer source packages."
    )


cache_dir = partial(
    PipOption,
    "--cache-dir",
    dest="cache_dir",
    default=USER_CACHE_DIR,
    metavar="dir",
    type='path',
    help="Store the cache data in <dir>."
)  # type: Callable[..., Option]


def _handle_no_cache_dir(option, opt, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    """
    Process a value provided for the --no-cache-dir option.

    This is an optparse.Option callback for the --no-cache-dir option.
    """
    # The value argument will be None if --no-cache-dir is passed via the
    # command-line, since the option doesn't accept arguments.  However,
    # the value can be non-None if the option is triggered e.g. by an
    # environment variable, like PIP_NO_CACHE_DIR=true.
    if value is not None:
        # Then parse the string value to get argument error-checking.
        try:
            strtobool(value)
        except ValueError as exc:
            raise_option_error(parser, option=option, msg=str(exc))

    # Originally, setting PIP_NO_CACHE_DIR to a value that strtobool()
    # converted to 0 (like "false" or "no") caused cache_dir to be disabled
    # rather than enabled (logic would say the latter).  Thus, we disable
    # the cache directory not just on values that parse to True, but (for
    # backwards compatibility reasons) also on values that parse to False.
    # In other words, always set it to False if the option is provided in
    # some (valid) form.
    parser.values.cache_dir = False


no_cache = partial(
    Option,
    "--no-cache-dir",
    dest="cache_dir",
    action="callback",
    callback=_handle_no_cache_dir,
    help="Disable the cache.",
)  # type: Callable[..., Option]

no_deps = partial(
    Option,
    '--no-deps', '--no-dependencies',
    dest='ignore_dependencies',
    action='store_true',
    default=False,
    help="Don't install package dependencies.",
)  # type: Callable[..., Option]


def _handle_build_dir(option, opt, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    if value:
        value = os.path.abspath(value)
    setattr(parser.values, option.dest, value)


build_dir = partial(
    PipOption,
    '-b', '--build', '--build-dir', '--build-directory',
    dest='build_dir',
    type='path',
    metavar='dir',
    action='callback',
    callback=_handle_build_dir,
    help='(DEPRECATED) '
         'Directory to unpack packages into and build in. Note that '
         'an initial build still takes place in a temporary directory. '
         'The location of temporary directories can be controlled by setting '
         'the TMPDIR environment variable (TEMP on Windows) appropriately. '
         'When passed, build directories are not cleaned in case of failures.'
)  # type: Callable[..., Option]

ignore_requires_python = partial(
    Option,
    '--ignore-requires-python',
    dest='ignore_requires_python',
    action='store_true',
    help='Ignore the Requires-Python information.'
)  # type: Callable[..., Option]

no_build_isolation = partial(
    Option,
    '--no-build-isolation',
    dest='build_isolation',
    action='store_false',
    default=True,
    help='Disable isolation when building a modern source distribution. '
         'Build dependencies specified by PEP 518 must be already installed '
         'if this option is used.'
)  # type: Callable[..., Option]


def _handle_no_use_pep517(option, opt, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    """
    Process a value provided for the --no-use-pep517 option.

    This is an optparse.Option callback for the no_use_pep517 option.
    """
    # Since --no-use-pep517 doesn't accept arguments, the value argument
    # will be None if --no-use-pep517 is passed via the command-line.
    # However, the value can be non-None if the option is triggered e.g.
    # by an environment variable, for example "PIP_NO_USE_PEP517=true".
    if value is not None:
        msg = """A value was passed for --no-use-pep517,
        probably using either the PIP_NO_USE_PEP517 environment variable
        or the "no-use-pep517" config file option. Use an appropriate value
        of the PIP_USE_PEP517 environment variable or the "use-pep517"
        config file option instead.
        """
        raise_option_error(parser, option=option, msg=msg)

    # Otherwise, --no-use-pep517 was passed via the command-line.
    parser.values.use_pep517 = False


use_pep517 = partial(
    Option,
    '--use-pep517',
    dest='use_pep517',
    action='store_true',
    default=None,
    help='Use PEP 517 for building source distributions '
         '(use --no-use-pep517 to force legacy behaviour).'
)  # type: Any

no_use_pep517 = partial(
    Option,
    '--no-use-pep517',
    dest='use_pep517',
    action='callback',
    callback=_handle_no_use_pep517,
    default=None,
    help=SUPPRESS_HELP
)  # type: Any

install_options = partial(
    Option,
    '--install-option',
    dest='install_options',
    action='append',
    metavar='options',
    help="Extra arguments to be supplied to the setup.py install "
         "command (use like --install-option=\"--install-scripts=/usr/local/"
         "bin\"). Use multiple --install-option options to pass multiple "
         "options to setup.py install. If you are using an option with a "
         "directory path, be sure to use absolute path.",
)  # type: Callable[..., Option]

global_options = partial(
    Option,
    '--global-option',
    dest='global_options',
    action='append',
    metavar='options',
    help="Extra global options to be supplied to the setup.py "
         "call before the install command.",
)  # type: Callable[..., Option]

no_clean = partial(
    Option,
    '--no-clean',
    action='store_true',
    default=False,
    help="Don't clean up build directories."
)  # type: Callable[..., Option]

pre = partial(
    Option,
    '--pre',
    action='store_true',
    default=False,
    help="Include pre-release and development versions. By default, "
         "pip only finds stable versions.",
)  # type: Callable[..., Option]

disable_pip_version_check = partial(
    Option,
    "--disable-pip-version-check",
    dest="disable_pip_version_check",
    action="store_true",
    default=False,
    help="Don't periodically check PyPI to determine whether a new version "
         "of pip is available for download. Implied with --no-index.",
)  # type: Callable[..., Option]


def _handle_merge_hash(option, opt_str, value, parser):
    # type: (Option, str, str, OptionParser) -> None
    """Given a value spelled "algo:digest", append the digest to a list
    pointed to in a dict by the algo name."""
    if not parser.values.hashes:
        parser.values.hashes = {}
    try:
        algo, digest = value.split(':', 1)
    except ValueError:
        parser.error('Arguments to {} must be a hash name '  # noqa
                     'followed by a value, like --hash=sha256:'
                     'abcde...'.format(opt_str))
    if algo not in STRONG_HASHES:
        parser.error('Allowed hash algorithms for {} are {}.'.format(  # noqa
                     opt_str, ', '.join(STRONG_HASHES)))
    parser.values.hashes.setdefault(algo, []).append(digest)


hash = partial(
    Option,
    '--hash',
    # Hash values eventually end up in InstallRequirement.hashes due to
    # __dict__ copying in process_line().
    dest='hashes',
    action='callback',
    callback=_handle_merge_hash,
    type='string',
    help="Verify that the package's archive matches this "
         'hash before installing. Example: --hash=sha256:abcdef...',
)  # type: Callable[..., Option]


require_hashes = partial(
    Option,
    '--require-hashes',
    dest='require_hashes',
    action='store_true',
    default=False,
    help='Require a hash to check each requirement against, for '
         'repeatable installs. This option is implied when any package in a '
         'requirements file has a --hash option.',
)  # type: Callable[..., Option]


list_path = partial(
    PipOption,
    '--path',
    dest='path',
    type='path',
    action='append',
    help='Restrict to the specified installation path for listing '
         'packages (can be used multiple times).'
)  # type: Callable[..., Option]


def check_list_path_option(options):
    # type: (Values) -> None
    if options.path and (options.user or options.local):
        raise CommandError(
            "Cannot combine '--path' with '--user' or '--local'"
        )


no_python_version_warning = partial(
    Option,
    '--no-python-version-warning',
    dest='no_python_version_warning',
    action='store_true',
    default=False,
    help='Silence deprecation warnings for upcoming unsupported Pythons.',
)  # type: Callable[..., Option]


unstable_feature = partial(
    Option,
    '--unstable-feature',
    dest='unstable_features',
    metavar='feature',
    action='append',
    default=[],
    choices=['resolver'],
    help=SUPPRESS_HELP,  # TODO: drop this in pip 20.3
)  # type: Callable[..., Option]

use_new_feature = partial(
    Option,
    '--use-feature',
    dest='features_enabled',
    metavar='feature',
    action='append',
    default=[],
    choices=['2020-resolver', 'fast-deps'],
    help='Enable new functionality, that may be backward incompatible.',
)  # type: Callable[..., Option]

use_deprecated_feature = partial(
    Option,
    '--use-deprecated',
    dest='deprecated_features_enabled',
    metavar='feature',
    action='append',
    default=[],
    choices=[],
    help=(
        'Enable deprecated functionality, that will be removed in the future.'
    ),
)  # type: Callable[..., Option]


##########
# groups #
##########

general_group = {
    'name': 'General Options',
    'options': [
        help_,
        isolated_mode,
        require_virtualenv,
        verbose,
        version,
        quiet,
        log,
        no_input,
        proxy,
        retries,
        timeout,
        exists_action,
        trusted_host,
        cert,
        client_cert,
        cache_dir,
        no_cache,
        disable_pip_version_check,
        no_color,
        no_python_version_warning,
        unstable_feature,
        use_new_feature,
        use_deprecated_feature,
    ]
}  # type: Dict[str, Any]

index_group = {
    'name': 'Package Index Options',
    'options': [
        index_url,
        extra_index_url,
        no_index,
        find_links,
    ]
}  # type: Dict[str, Any]
                                                                                                                                                                                                                                                                                                                                                                                                                  python3.7/site-packages/pip/_internal/cli/__init__.py                                               0000644                 00000000204 15107360274 0016461 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Subpackage containing all of pip's command line interface related code
"""

# This file intentionally does not import submodules
                                                                                                                                                                                                                                                                                                                                                                                            python3.7/site-packages/pip/_internal/cli/status_codes.py                                           0000644                 00000000234 15107360275 0017426 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import

SUCCESS = 0
ERROR = 1
UNKNOWN_ERROR = 2
VIRTUALENV_NOT_FOUND = 3
PREVIOUS_BUILD_DIR_ERROR = 4
NO_MATCHES_FOUND = 23
                                                                                                                                                                                                                                                                                                                                                                    python3.7/site-packages/pip/_internal/cli/main.py                                                   0000644                 00000005070 15107360275 0015655 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Primary application entrypoint.
"""
from __future__ import absolute_import

import locale
import logging
import os
import sys

from pip._internal.cli.autocompletion import autocomplete
from pip._internal.cli.main_parser import parse_command
from pip._internal.commands import create_command
from pip._internal.exceptions import PipError
from pip._internal.utils import deprecation
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from typing import List, Optional

logger = logging.getLogger(__name__)


# Do not import and use main() directly! Using it directly is actively
# discouraged by pip's maintainers. The name, location and behavior of
# this function is subject to change, so calling it directly is not
# portable across different pip versions.

# In addition, running pip in-process is unsupported and unsafe. This is
# elaborated in detail at
# https://pip.pypa.io/en/stable/user_guide/#using-pip-from-your-program.
# That document also provides suggestions that should work for nearly
# all users that are considering importing and using main() directly.

# However, we know that certain users will still want to invoke pip
# in-process. If you understand and accept the implications of using pip
# in an unsupported manner, the best approach is to use runpy to avoid
# depending on the exact location of this entry point.

# The following example shows how to use runpy to invoke pip in that
# case:
#
#     sys.argv = ["pip", your, args, here]
#     runpy.run_module("pip", run_name="__main__")
#
# Note that this will exit the process after running, unlike a direct
# call to main. As it is not safe to do any processing after calling
# main, this should not be an issue in practice.

def main(args=None):
    # type: (Optional[List[str]]) -> int
    if args is None:
        args = sys.argv[1:]

    # Configure our deprecation warnings to be sent through loggers
    deprecation.install_warning_logger()

    autocomplete()

    try:
        cmd_name, cmd_args = parse_command(args)
    except PipError as exc:
        sys.stderr.write("ERROR: {}".format(exc))
        sys.stderr.write(os.linesep)
        sys.exit(1)

    # Needed for locale.getpreferredencoding(False) to work
    # in pip._internal.utils.encoding.auto_decode
    try:
        locale.setlocale(locale.LC_ALL, '')
    except locale.Error as e:
        # setlocale can apparently crash if locale are uninitialized
        logger.debug("Ignoring error %s when setting locale", e)
    command = create_command(cmd_name, isolated=("--isolated" in cmd_args))

    return command.main(cmd_args)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        python3.7/site-packages/pip/_internal/build_env.py                                                  0000644                 00000017630 15107360275 0016136 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Build Environment used for isolation during sdist building
"""

import logging
import os
import sys
import textwrap
from collections import OrderedDict
from distutils.sysconfig import get_python_lib
from sysconfig import get_paths

from pip._vendor.pkg_resources import Requirement, VersionConflict, WorkingSet

from pip import __file__ as pip_location
from pip._internal.cli.spinners import open_spinner
from pip._internal.utils.subprocess import call_subprocess
from pip._internal.utils.temp_dir import TempDirectory, tempdir_kinds
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from types import TracebackType
    from typing import Tuple, Set, Iterable, Optional, List, Type
    from pip._internal.index.package_finder import PackageFinder

logger = logging.getLogger(__name__)


class _Prefix:

    def __init__(self, path):
        # type: (str) -> None
        self.path = path
        self.setup = False
        self.bin_dir = get_paths(
            'nt' if os.name == 'nt' else 'posix_prefix',
            vars={'base': path, 'platbase': path}
        )['scripts']
        # Note: prefer distutils' sysconfig to get the
        # library paths so PyPy is correctly supported.
        purelib = get_python_lib(plat_specific=False, prefix=path)
        platlib = get_python_lib(plat_specific=True, prefix=path)
        if purelib == platlib:
            self.lib_dirs = [purelib]
        else:
            self.lib_dirs = [purelib, platlib]


class BuildEnvironment(object):
    """Creates and manages an isolated environment to install build deps
    """

    def __init__(self):
        # type: () -> None
        temp_dir = TempDirectory(
            kind=tempdir_kinds.BUILD_ENV, globally_managed=True
        )

        self._prefixes = OrderedDict((
            (name, _Prefix(os.path.join(temp_dir.path, name)))
            for name in ('normal', 'overlay')
        ))

        self._bin_dirs = []  # type: List[str]
        self._lib_dirs = []  # type: List[str]
        for prefix in reversed(list(self._prefixes.values())):
            self._bin_dirs.append(prefix.bin_dir)
            self._lib_dirs.extend(prefix.lib_dirs)

        # Customize site to:
        # - ensure .pth files are honored
        # - prevent access to system site packages
        system_sites = {
            os.path.normcase(site) for site in (
                get_python_lib(plat_specific=False),
                get_python_lib(plat_specific=True),
            )
        }
        self._site_dir = os.path.join(temp_dir.path, 'site')
        if not os.path.exists(self._site_dir):
            os.mkdir(self._site_dir)
        with open(os.path.join(self._site_dir, 'sitecustomize.py'), 'w') as fp:
            fp.write(textwrap.dedent(
                '''
                import os, site, sys

                # First, drop system-sites related paths.
                original_sys_path = sys.path[:]
                known_paths = set()
                for path in {system_sites!r}:
                    site.addsitedir(path, known_paths=known_paths)
                system_paths = set(
                    os.path.normcase(path)
                    for path in sys.path[len(original_sys_path):]
                )
                original_sys_path = [
                    path for path in original_sys_path
                    if os.path.normcase(path) not in system_paths
                ]
                sys.path = original_sys_path

                # Second, add lib directories.
                # ensuring .pth file are processed.
                for path in {lib_dirs!r}:
                    assert not path in sys.path
                    site.addsitedir(path)
                '''
            ).format(system_sites=system_sites, lib_dirs=self._lib_dirs))

    def __enter__(self):
        # type: () -> None
        self._save_env = {
            name: os.environ.get(name, None)
            for name in ('PATH', 'PYTHONNOUSERSITE', 'PYTHONPATH')
        }

        path = self._bin_dirs[:]
        old_path = self._save_env['PATH']
        if old_path:
            path.extend(old_path.split(os.pathsep))

        pythonpath = [self._site_dir]

        os.environ.update({
            'PATH': os.pathsep.join(path),
            'PYTHONNOUSERSITE': '1',
            'PYTHONPATH': os.pathsep.join(pythonpath),
        })

    def __exit__(
        self,
        exc_type,  # type: Optional[Type[BaseException]]
        exc_val,  # type: Optional[BaseException]
        exc_tb  # type: Optional[TracebackType]
    ):
        # type: (...) -> None
        for varname, old_value in self._save_env.items():
            if old_value is None:
                os.environ.pop(varname, None)
            else:
                os.environ[varname] = old_value

    def check_requirements(self, reqs):
        # type: (Iterable[str]) -> Tuple[Set[Tuple[str, str]], Set[str]]
        """Return 2 sets:
            - conflicting requirements: set of (installed, wanted) reqs tuples
            - missing requirements: set of reqs
        """
        missing = set()
        conflicting = set()
        if reqs:
            ws = WorkingSet(self._lib_dirs)
            for req in reqs:
                try:
                    if ws.find(Requirement.parse(req)) is None:
                        missing.add(req)
                except VersionConflict as e:
                    conflicting.add((str(e.args[0].as_requirement()),
                                     str(e.args[1])))
        return conflicting, missing

    def install_requirements(
        self,
        finder,  # type: PackageFinder
        requirements,  # type: Iterable[str]
        prefix_as_string,  # type: str
        message  # type: str
    ):
        # type: (...) -> None
        prefix = self._prefixes[prefix_as_string]
        assert not prefix.setup
        prefix.setup = True
        if not requirements:
            return
        args = [
            sys.executable, os.path.dirname(pip_location), 'install',
            '--ignore-installed', '--no-user', '--prefix', prefix.path,
            '--no-warn-script-location',
        ]  # type: List[str]
        if logger.getEffectiveLevel() <= logging.DEBUG:
            args.append('-v')
        for format_control in ('no_binary', 'only_binary'):
            formats = getattr(finder.format_control, format_control)
            args.extend(('--' + format_control.replace('_', '-'),
                         ','.join(sorted(formats or {':none:'}))))

        index_urls = finder.index_urls
        if index_urls:
            args.extend(['-i', index_urls[0]])
            for extra_index in index_urls[1:]:
                args.extend(['--extra-index-url', extra_index])
        else:
            args.append('--no-index')
        for link in finder.find_links:
            args.extend(['--find-links', link])

        for host in finder.trusted_hosts:
            args.extend(['--trusted-host', host])
        if finder.allow_all_prereleases:
            args.append('--pre')
        if finder.prefer_binary:
            args.append('--prefer-binary')
        args.append('--')
        args.extend(requirements)
        with open_spinner(message) as spinner:
            call_subprocess(args, spinner=spinner)


class NoOpBuildEnvironment(BuildEnvironment):
    """A no-op drop-in replacement for BuildEnvironment
    """

    def __init__(self):
        # type: () -> None
        pass

    def __enter__(self):
        # type: () -> None
        pass

    def __exit__(
        self,
        exc_type,  # type: Optional[Type[BaseException]]
        exc_val,  # type: Optional[BaseException]
        exc_tb  # type: Optional[TracebackType]
    ):
        # type: (...) -> None
        pass

    def cleanup(self):
        # type: () -> None
        pass

    def install_requirements(
        self,
        finder,  # type: PackageFinder
        requirements,  # type: Iterable[str]
        prefix_as_string,  # type: str
        message  # type: str
    ):
        # type: (...) -> None
        raise NotImplementedError()
                                                                                                        python3.7/site-packages/pip/_internal/locations.py                                                  0000644                 00000015114 15107360275 0016155 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Locations where we look for configs, install stuff, etc"""

# The following comment should be removed at some point in the future.
# mypy: strict-optional=False

from __future__ import absolute_import

import os
import os.path
import platform
import site
import sys
import sysconfig
from distutils import sysconfig as distutils_sysconfig
from distutils.command.install import SCHEME_KEYS  # type: ignore
from distutils.command.install import install as distutils_install_command

from pip._internal.models.scheme import Scheme
from pip._internal.utils import appdirs
from pip._internal.utils.compat import WINDOWS
from pip._internal.utils.typing import MYPY_CHECK_RUNNING, cast
from pip._internal.utils.virtualenv import running_under_virtualenv

if MYPY_CHECK_RUNNING:
    from typing import Dict, List, Optional, Union

    from distutils.cmd import Command as DistutilsCommand


# Application Directories
USER_CACHE_DIR = appdirs.user_cache_dir("pip")


def get_major_minor_version():
    # type: () -> str
    """
    Return the major-minor version of the current Python as a string, e.g.
    "3.7" or "3.10".
    """
    return '{}.{}'.format(*sys.version_info)


def get_src_prefix():
    # type: () -> str
    if running_under_virtualenv():
        src_prefix = os.path.join(sys.prefix, 'src')
    else:
        # FIXME: keep src in cwd for now (it is not a temporary folder)
        try:
            src_prefix = os.path.join(os.getcwd(), 'src')
        except OSError:
            # In case the current working directory has been renamed or deleted
            sys.exit(
                "The folder you are executing pip from can no longer be found."
            )

    # under macOS + virtualenv sys.prefix is not properly resolved
    # it is something like /path/to/python/bin/..
    return os.path.abspath(src_prefix)


# FIXME doesn't account for venv linked to global site-packages

site_packages = sysconfig.get_path("purelib")  # type: Optional[str]

# This is because of a bug in PyPy's sysconfig module, see
# https://bitbucket.org/pypy/pypy/issues/2506/sysconfig-returns-incorrect-paths
# for more information.
if platform.python_implementation().lower() == "pypy":
    site_packages = distutils_sysconfig.get_python_lib()
try:
    # Use getusersitepackages if this is present, as it ensures that the
    # value is initialised properly.
    user_site = site.getusersitepackages()
except AttributeError:
    user_site = site.USER_SITE

if WINDOWS:
    bin_py = os.path.join(sys.prefix, 'Scripts')
    bin_user = os.path.join(user_site, 'Scripts')
    # buildout uses 'bin' on Windows too?
    if not os.path.exists(bin_py):
        bin_py = os.path.join(sys.prefix, 'bin')
        bin_user = os.path.join(user_site, 'bin')
else:
    bin_py = os.path.join(sys.prefix, 'bin')
    bin_user = os.path.join(user_site, 'bin')

    # Forcing to use /usr/local/bin for standard macOS framework installs
    # Also log to ~/Library/Logs/ for use with the Console.app log viewer
    if sys.platform[:6] == 'darwin' and sys.prefix[:16] == '/System/Library/':
        bin_py = '/usr/local/bin'


def distutils_scheme(
    dist_name, user=False, home=None, root=None, isolated=False, prefix=None
):
    # type:(str, bool, str, str, bool, str) -> Dict[str, str]
    """
    Return a distutils install scheme
    """
    from distutils.dist import Distribution

    dist_args = {'name': dist_name}  # type: Dict[str, Union[str, List[str]]]
    if isolated:
        dist_args["script_args"] = ["--no-user-cfg"]

    d = Distribution(dist_args)
    d.parse_config_files()
    obj = None  # type: Optional[DistutilsCommand]
    obj = d.get_command_obj('install', create=True)
    assert obj is not None
    i = cast(distutils_install_command, obj)
    # NOTE: setting user or home has the side-effect of creating the home dir
    # or user base for installations during finalize_options()
    # ideally, we'd prefer a scheme class that has no side-effects.
    assert not (user and prefix), "user={} prefix={}".format(user, prefix)
    assert not (home and prefix), "home={} prefix={}".format(home, prefix)
    i.user = user or i.user
    if user or home:
        i.prefix = ""
    i.prefix = prefix or i.prefix
    i.home = home or i.home
    i.root = root or i.root
    i.finalize_options()

    scheme = {}
    for key in SCHEME_KEYS:
        scheme[key] = getattr(i, 'install_' + key)

    # install_lib specified in setup.cfg should install *everything*
    # into there (i.e. it takes precedence over both purelib and
    # platlib).  Note, i.install_lib is *always* set after
    # finalize_options(); we only want to override here if the user
    # has explicitly requested it hence going back to the config
    if 'install_lib' in d.get_option_dict('install'):
        scheme.update(dict(purelib=i.install_lib, platlib=i.install_lib))

    if running_under_virtualenv():
        scheme['headers'] = os.path.join(
            i.prefix,
            'include',
            'site',
            'python{}'.format(get_major_minor_version()),
            dist_name,
        )

        if root is not None:
            path_no_drive = os.path.splitdrive(
                os.path.abspath(scheme["headers"]))[1]
            scheme["headers"] = os.path.join(
                root,
                path_no_drive[1:],
            )

    return scheme


def get_scheme(
    dist_name,  # type: str
    user=False,  # type: bool
    home=None,  # type: Optional[str]
    root=None,  # type: Optional[str]
    isolated=False,  # type: bool
    prefix=None,  # type: Optional[str]
):
    # type: (...) -> Scheme
    """
    Get the "scheme" corresponding to the input parameters. The distutils
    documentation provides the context for the available schemes:
    https://docs.python.org/3/install/index.html#alternate-installation

    :param dist_name: the name of the package to retrieve the scheme for, used
        in the headers scheme path
    :param user: indicates to use the "user" scheme
    :param home: indicates to use the "home" scheme and provides the base
        directory for the same
    :param root: root under which other directories are re-based
    :param isolated: equivalent to --no-user-cfg, i.e. do not consider
        ~/.pydistutils.cfg (posix) or ~/pydistutils.cfg (non-posix) for
        scheme paths
    :param prefix: indicates to use the "prefix" scheme and provides the
        base directory for the same
    """
    scheme = distutils_scheme(
        dist_name, user, home, root, isolated, prefix
    )
    return Scheme(
        platlib=scheme["platlib"],
        purelib=scheme["purelib"],
        headers=scheme["headers"],
        scripts=scheme["scripts"],
        data=scheme["data"],
    )
                                                                                                                                                                                                                                                                                                                                                                                                                                                    python3.7/site-packages/pip/_internal/commands/search.py                                            0000644                 00000013174 15107360275 0017234 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import

import logging
import sys
import textwrap
from collections import OrderedDict

from pip._vendor import pkg_resources
from pip._vendor.packaging.version import parse as parse_version
# NOTE: XMLRPC Client is not annotated in typeshed as on 2017-07-17, which is
#       why we ignore the type on this import
from pip._vendor.six.moves import xmlrpc_client  # type: ignore

from pip._internal.cli.base_command import Command
from pip._internal.cli.req_command import SessionCommandMixin
from pip._internal.cli.status_codes import NO_MATCHES_FOUND, SUCCESS
from pip._internal.exceptions import CommandError
from pip._internal.models.index import PyPI
from pip._internal.network.xmlrpc import PipXmlrpcTransport
from pip._internal.utils.compat import get_terminal_size
from pip._internal.utils.logging import indent_log
from pip._internal.utils.misc import get_distribution, write_output
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from optparse import Values
    from typing import List, Dict, Optional
    from typing_extensions import TypedDict
    TransformedHit = TypedDict(
        'TransformedHit',
        {'name': str, 'summary': str, 'versions': List[str]},
    )

logger = logging.getLogger(__name__)


class SearchCommand(Command, SessionCommandMixin):
    """Search for PyPI packages whose name or summary contains <query>."""

    usage = """
      %prog [options] <query>"""
    ignore_require_venv = True

    def add_options(self):
        # type: () -> None
        self.cmd_opts.add_option(
            '-i', '--index',
            dest='index',
            metavar='URL',
            default=PyPI.pypi_url,
            help='Base URL of Python Package Index (default %default)')

        self.parser.insert_option_group(0, self.cmd_opts)

    def run(self, options, args):
        # type: (Values, List[str]) -> int
        if not args:
            raise CommandError('Missing required argument (search query).')
        query = args
        pypi_hits = self.search(query, options)
        hits = transform_hits(pypi_hits)

        terminal_width = None
        if sys.stdout.isatty():
            terminal_width = get_terminal_size()[0]

        print_results(hits, terminal_width=terminal_width)
        if pypi_hits:
            return SUCCESS
        return NO_MATCHES_FOUND

    def search(self, query, options):
        # type: (List[str], Values) -> List[Dict[str, str]]
        index_url = options.index

        session = self.get_default_session(options)

        transport = PipXmlrpcTransport(index_url, session)
        pypi = xmlrpc_client.ServerProxy(index_url, transport)
        hits = pypi.search({'name': query, 'summary': query}, 'or')
        return hits


def transform_hits(hits):
    # type: (List[Dict[str, str]]) -> List[TransformedHit]
    """
    The list from pypi is really a list of versions. We want a list of
    packages with the list of versions stored inline. This converts the
    list from pypi into one we can use.
    """
    packages = OrderedDict()  # type: OrderedDict[str, TransformedHit]
    for hit in hits:
        name = hit['name']
        summary = hit['summary']
        version = hit['version']

        if name not in packages.keys():
            packages[name] = {
                'name': name,
                'summary': summary,
                'versions': [version],
            }
        else:
            packages[name]['versions'].append(version)

            # if this is the highest version, replace summary and score
            if version == highest_version(packages[name]['versions']):
                packages[name]['summary'] = summary

    return list(packages.values())


def print_results(hits, name_column_width=None, terminal_width=None):
    # type: (List[TransformedHit], Optional[int], Optional[int]) -> None
    if not hits:
        return
    if name_column_width is None:
        name_column_width = max([
            len(hit['name']) + len(highest_version(hit.get('versions', ['-'])))
            for hit in hits
        ]) + 4

    installed_packages = [p.project_name for p in pkg_resources.working_set]
    for hit in hits:
        name = hit['name']
        summary = hit['summary'] or ''
        latest = highest_version(hit.get('versions', ['-']))
        if terminal_width is not None:
            target_width = terminal_width - name_column_width - 5
            if target_width > 10:
                # wrap and indent summary to fit terminal
                summary_lines = textwrap.wrap(summary, target_width)
                summary = ('\n' + ' ' * (name_column_width + 3)).join(
                    summary_lines)

        line = '{name_latest:{name_column_width}} - {summary}'.format(
            name_latest='{name} ({latest})'.format(**locals()),
            **locals())
        try:
            write_output(line)
            if name in installed_packages:
                dist = get_distribution(name)
                assert dist is not None
                with indent_log():
                    if dist.version == latest:
                        write_output('INSTALLED: %s (latest)', dist.version)
                    else:
                        write_output('INSTALLED: %s', dist.version)
                        if parse_version(latest).pre:
                            write_output('LATEST:    %s (pre-release; install'
                                         ' with "pip install --pre")', latest)
                        else:
                            write_output('LATEST:    %s', latest)
        except UnicodeEncodeError:
            pass


def highest_version(versions):
    # type: (List[str]) -> str
    return max(versions, key=parse_version)
                                                                                                                                                                                                                                                                                                                                                                                                    python3.7/site-packages/pip/_internal/commands/freeze.py                                            0000644                 00000006574 15107360275 0017255 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import

import sys

from pip._internal.cache import WheelCache
from pip._internal.cli import cmdoptions
from pip._internal.cli.base_command import Command
from pip._internal.cli.status_codes import SUCCESS
from pip._internal.models.format_control import FormatControl
from pip._internal.operations.freeze import freeze
from pip._internal.utils.compat import stdlib_pkgs
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

DEV_PKGS = {'pip', 'setuptools', 'distribute', 'wheel'}

if MYPY_CHECK_RUNNING:
    from optparse import Values
    from typing import List


class FreezeCommand(Command):
    """
    Output installed packages in requirements format.

    packages are listed in a case-insensitive sorted order.
    """

    usage = """
      %prog [options]"""
    log_streams = ("ext://sys.stderr", "ext://sys.stderr")

    def add_options(self):
        # type: () -> None
        self.cmd_opts.add_option(
            '-r', '--requirement',
            dest='requirements',
            action='append',
            default=[],
            metavar='file',
            help="Use the order in the given requirements file and its "
                 "comments when generating output. This option can be "
                 "used multiple times.")
        self.cmd_opts.add_option(
            '-f', '--find-links',
            dest='find_links',
            action='append',
            default=[],
            metavar='URL',
            help='URL for finding packages, which will be added to the '
                 'output.')
        self.cmd_opts.add_option(
            '-l', '--local',
            dest='local',
            action='store_true',
            default=False,
            help='If in a virtualenv that has global access, do not output '
                 'globally-installed packages.')
        self.cmd_opts.add_option(
            '--user',
            dest='user',
            action='store_true',
            default=False,
            help='Only output packages installed in user-site.')
        self.cmd_opts.add_option(cmdoptions.list_path())
        self.cmd_opts.add_option(
            '--all',
            dest='freeze_all',
            action='store_true',
            help='Do not skip these packages in the output:'
                 ' {}'.format(', '.join(DEV_PKGS)))
        self.cmd_opts.add_option(
            '--exclude-editable',
            dest='exclude_editable',
            action='store_true',
            help='Exclude editable package from output.')

        self.parser.insert_option_group(0, self.cmd_opts)

    def run(self, options, args):
        # type: (Values, List[str]) -> int
        format_control = FormatControl(set(), set())
        wheel_cache = WheelCache(options.cache_dir, format_control)
        skip = set(stdlib_pkgs)
        if not options.freeze_all:
            skip.update(DEV_PKGS)

        cmdoptions.check_list_path_option(options)

        freeze_kwargs = dict(
            requirement=options.requirements,
            find_links=options.find_links,
            local_only=options.local,
            user_only=options.user,
            paths=options.path,
            isolated=options.isolated_mode,
            wheel_cache=wheel_cache,
            skip=skip,
            exclude_editable=options.exclude_editable,
        )

        for line in freeze(**freeze_kwargs):
            sys.stdout.write(line + '\n')
        return SUCCESS
                                                                                                                                    python3.7/site-packages/pip/_internal/commands/__pycache__/search.cpython-37.pyc                    0000644                 00000011440 15107360275 0023513 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re|                 @   sV  d dl mZ d dlZd dlZd dlZd dlmZ d dlmZ d dl	m
Z d dlm
Z
 d dlmZ d dlmZ d d	lmZmZ d d
lmZ d dlmZ d dlmZ d d
lmZ d dlmZ d dlm Z m!Z! d dl"m#Z# e#rd dl$m%Z% d dl&m'Z'm(Z(m)Z) d dl*m+Z+ e+de,e,e'e, dZ-e.e/Z0G dd deeZ1dd Z2dddZ3dd Z4dS )    )absolute_importN)OrderedDict)
pkg_resources)parse)
xmlrpc_client)Command)SessionCommandMixin)NO_MATCHES_FOUNDSUCCESS)CommandError)PyPI)PipXmlrpcTransport)get_terminal_size)
indent_log)get_distributionwrite_output)MYPY_CHECK_RUNNING)Values)ListDictOptional)	TypedDictTransformedHit)namesummaryversionsc               @   s0   e Zd ZdZdZdZdd Zdd Zdd	 Zd
S )
SearchCommandz@Search for PyPI packages whose name or summary contains <query>.z
      %prog [options] <query>Tc             C   s.   | j jddddtjdd | jd| j  d S )Nz-iz--indexindexURLz3Base URL of Python Package Index (default %default))destmetavardefaulthelpr   )cmd_opts
add_optionr   pypi_urlparserinsert_option_group)self r)   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/commands/search.pyadd_options,   s    zSearchCommand.add_optionsc             C   sT   |st d|}| ||}t|}d }tj r<t d }t||d |rPtS t	S )Nz)Missing required argument (search query).r   )terminal_width)
r   searchtransform_hitssysstdoutisattyr   
print_resultsr
   r	   )r(   optionsargsqueryZ	pypi_hitshitsr,   r)   r)   r*   run7   s    

zSearchCommand.runc             C   s<   |j }| |}t||}t||}|||dd}|S )N)r   r   or)r   get_default_sessionr
   r   ServerProxyr-   )r(   r5   r3   	index_urlsession	transportpypir6   r)   r)   r*   r-   H   s    

zSearchCommand.searchN)	__name__
__module____qualname____doc__usageignore_require_venvr+   r7   r-   r)   r)   r)   r*   r   %   s   r   c             C   s   t  }xv| D ]n}|d }|d }|d }|| krH|||gd||< q|| d | |t|| d kr||| d< qW t| S )z
    The list from pypi is really a list of versions. We want a list of
    packages with the list of versions stored inline. This converts the
    list from pypi into one we can use.
    r   r   version)r   r   r   r   )r   keysappendhighest_versionlistvalues)r6   packageshitr   r   rE   r)   r)   r*   r.   T   s    
r.   c          
   C   sl  | sd S |d kr&t dd | D d }dd tjD }x.| D ]$}|d }|d pVd}t|dd	g}|d k	r|| d
 }|dkrt||}	dd
|d   |	}djf ddjf t	 it	 }
yt
|
 ||krJt|}|d k	stt
 N |j|krt
d|j n.t
d|j t|jr6t
d| n
t
d| W d Q R X W q> tk
rb   Y q>X q>W d S )Nc          	   S   s.   g | ]&}t |d  t t|ddg qS )r   r   -)lenrH   get).0rL   r)   r)   r*   
<listcomp>w   s   z!print_results.<locals>.<listcomp>   c             S   s   g | ]
}|j qS r)   )project_name)rP   pr)   r)   r*   rQ   {   s    r   r    r   rM      
   
    z-{name_latest:{name_column_width}} - {summary}Zname_latestz{name} ({latest})zINSTALLED: %s (latest)z
INSTALLED: %sz=LATEST:    %s (pre-release; install with "pip install --pre")z
LATEST:    %s)maxr   working_setrH   rO   textwrapwrapjoinformatlocalsr   r   AssertionErrorr   rE   
parse_versionpreUnicodeEncodeError)r6   Zname_column_widthr,   Zinstalled_packagesrL   r   r   ZlatestZtarget_widthZ
summary_lineslinedistr)   r)   r*   r2   q   sH    

r2   c             C   s   t | tdS )N)key)r[   rc   )r   r)   r)   r*   rH      s    rH   )NN)5
__future__r   loggingr/   r]   collectionsr   pip._vendorr   pip._vendor.packaging.versionr   rc   pip._vendor.six.movesr   pip._internal.cli.base_commandr   pip._internal.cli.req_commandr   pip._internal.cli.status_codesr	   r
   pip._internal.exceptionsr   pip._internal.models.indexr   Zpip._internal.network.xmlrpcr
   pip._internal.utils.compatr   pip._internal.utils.loggingr   pip._internal.utils.miscr   r   pip._internal.utils.typingr   optparser   typingr   r   r   Ztyping_extensionsr   strr   	getLoggerr?   loggerr   r.   r2   rH   r)   r)   r)   r*   <module>   s:   
/
-                                                                                                                                                                                                                                python3.7/site-packages/pip/_internal/commands/__pycache__/completion.cpython-37.pyc                0000644                 00000006201 15107360275 0024416 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re	                 @   s   d dl mZ d dlZd dlZd dlmZ d dlmZ d dlm	Z	 d dl
mZ erhd dlm
Z
 d dlmZ d	Zd
ddd
ZG dd deZdS )    )absolute_importN)Command)SUCCESS)get_prog)MYPY_CHECK_RUNNING)List)ValueszD
# pip {shell} completion start{script}# pip {shell} completion end
a  
        _pip_completion()
        {{
            COMPREPLY=( $( COMP_WORDS="${{COMP_WORDS[*]}}" \
                           COMP_CWORD=$COMP_CWORD \
                           PIP_AUTO_COMPLETE=1 $1 2>/dev/null ) )
        }}
        complete -o default -F _pip_completion {prog}
    aM  
        function _pip_completion {{
          local words cword
          read -Ac words
          read -cn cword
          reply=( $( COMP_WORDS="$words[*]" \
                     COMP_CWORD=$(( cword-1 )) \
                     PIP_AUTO_COMPLETE=1 $words[1] 2>/dev/null ))
        }}
        compctl -K _pip_completion {prog}
    au  
        function __fish_complete_pip
            set -lx COMP_WORDS (commandline -o) ""
            set -lx COMP_CWORD ( \
                math (contains -i -- (commandline -t) $COMP_WORDS)-1 \
            )
            set -lx PIP_AUTO_COMPLETE 1
            string split \  -- (eval $COMP_WORDS[1])
        end
        complete -fa "(__fish_complete_pip)" -c {prog}
    )bashzshfishc               @   s$   e Zd ZdZdZdd Zdd ZdS )CompletionCommandz3A helper command to be used for command completion.Tc             C   s\   | j jddddddd | j jdd	dd
ddd | j jdd
ddddd | jd| j  d S )Nz--bashz-bstore_constr	   shellzEmit completion code for bash)actionconstdesthelpz--zshz-zr
   zEmit completion code for zshz--fishz-fr   zEmit completion code for fishr   )cmd_opts
add_optionparserinsert_option_group)self r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/commands/completion.pyadd_options;   s&    zCompletionCommand.add_optionsc             C   sz   t  }dd t|D }|j|krZtt |jdjt d}t	t
j||jd tS tj
dd| tS dS )	z-Prints the completion code of the given shellc             S   s   g | ]}d | qS )z--r   ).0r   r   r   r   
<listcomp>V   s    z)CompletionCommand.run.<locals>.<listcomp> )prog)scriptr   zERROR: You must pass {}
z or N)COMPLETION_SCRIPTSkeyssortedr   textwrapdedentgetformatr   printBASE_COMPLETIONr   sysstderrwritejoin)r   optionsargsZshellsZ
shell_optionsr   r   r   r   runR   s    
zCompletionCommand.runN)__name__
__module____qualname____doc__ignore_require_venvr   r/   r   r   r   r   r   6   s   r   )
__future__r   r)   r#   pip._internal.cli.base_commandr   pip._internal.cli.status_codesr   pip._internal.utils.miscr   pip._internal.utils.typingr   typingr   optparser   r(   r    r   r   r   r   r   <module>   s                                                                                                                                                                                                                                                                                                                                                                                                  python3.7/site-packages/pip/_internal/commands/__pycache__/uninstall.cpython-37.pyc                 0000644                 00000005647 15107360275 0024273 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   s   d dl mZ d dlmZ d dlmZ d dlmZ d dlm	Z	 d dl
mZ d dlm
Z
 d dlmZmZ d d	lmZ d d
lmZ erd dlmZ d dlmZ G d
d deeZdS )    )absolute_import)canonicalize_name)Command)SessionCommandMixin)SUCCESS)InstallationError)parse_requirements)install_req_from_line#install_req_from_parsed_requirement)(protect_pip_from_modification_on_windows)MYPY_CHECK_RUNNING)Values)Listc               @   s$   e Zd ZdZdZdd Zdd ZdS )UninstallCommandaB  
    Uninstall packages.

    pip is able to uninstall most installed packages. Known exceptions are:

    - Pure distutils packages installed with ``python setup.py install``, which
      leave behind no metadata to determine what files were installed.
    - Script wrappers installed by ``python setup.py develop``.
    zU
      %prog [options] <package> ...
      %prog [options] -r <requirements file> ...c          	   C   sD   | j jddddg ddd | j jdd	d
ddd
 | jd| j  d S )Nz-rz
--requirementrequirementsappendfilezjUninstall all the packages listed in the given requirements file.  This option can be used multiple times.)destactiondefaultmetavarhelpz-yz--yesyes
store_truez2Don't ask for confirmation of uninstall deletions.)r   r   r   r   )cmd_opts
add_optionparserinsert_option_group)self r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/commands/uninstall.pyadd_options%   s    zUninstallCommand.add_optionsc       
      C   s   |  |}i }x.|D ]&}t||jd}|jr||t|j< qW xH|jD ]>}x8t|||dD ]&}t||jd}|jrZ||t|j< qZW qFW |stdj	f t
 td|kd x2| D ]&}|j
|j| jdkd}	|	r|	  qW tS )N)isolated)optionssessionzRYou must give at least one requirement to {self.name} (see "pip help {self.name}")pip)
modifying_pipr   )auto_confirmverbose)get_default_sessionr	   
isolated_modenamer   r   r   r
   r   formatlocalsr   values	uninstallr   	verbositycommitr   )
r   r#   argsr$   Zreqs_to_uninstallr+   reqfilename
parsed_reqZuninstall_pathsetr   r   r    run8   s:    



zUninstallCommand.runN)__name__
__module____qualname____doc__usager!   r6   r   r   r   r    r      s   	r   N)
__future__r   Zpip._vendor.packaging.utilsr   pip._internal.cli.base_commandr   pip._internal.cli.req_commandr   pip._internal.cli.status_codesr   pip._internal.exceptionsr   Zpip._internal.reqr   pip._internal.req.constructorsr	   r
   pip._internal.utils.miscr   pip._internal.utils.typingr   optparser
   typingr   r   r   r   r   r    <module>   s                                                                                            python3.7/site-packages/pip/_internal/commands/__pycache__/show.cpython-37.pyc                      0000644                 00000014565 15107360275 0023241 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    ReT                 @   s   d dl mZ d dlZd dlZd dlmZ d dlmZ d dlm	Z	 d dl
mZ d dlm
Z
mZ d dlmZ d d	lmZ erd d
lmZ d dlmZmZmZ eeZG dd
 d
eZdd ZdddZdS )    )absolute_importN)
FeedParser)
pkg_resources)canonicalize_name)Command)ERRORSUCCESS)write_output)MYPY_CHECK_RUNNING)Values)ListDictIteratorc               @   s(   e Zd ZdZdZdZdd Zdd ZdS )	ShowCommandzx
    Show information about one or more installed packages.

    The output is in RFC-compliant mail header format.
    z$
      %prog [options] <package> ...Tc             C   s,   | j jddddddd | jd| j  d S )	Nz-fz--filesfiles
store_trueFz7Show the full list of installed files for each package.)destactiondefaulthelpr   )cmd_opts
add_optionparserinsert_option_group)self r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/commands/show.pyadd_options!   s    zShowCommand.add_optionsc             C   s8   |st d tS |}t|}t||j|jds4tS tS )Nz.ERROR: Please provide a package name or names.)
list_filesverbose)loggerwarningr   search_packages_info
print_resultsr   r   r   )r   optionsargsqueryresultsr   r   r   run,   s    
zShowCommand.runN)__name__
__module____qualname____doc__usageignore_require_venvr   r(   r   r   r   r   r      s
   r   c             #   sf  i xt jD ]}|t|j< qW dd | D }tfddt| |D }|rbtdd| dd }xfdd|D D ]܉  j j	 j
d	d   D | jd
}d}d}t t j
r& d
r d
}dd |D }	 fdd|	D }	 fdd|	D } drv d}nP dr` d}	 fdd|	D }	 fdd|	D } drv d} dr d}
|
|d<  drx, dD ]}| r| |d< P qW t }|| | }
xdD ]}|
|||< qW g }x4| D ](}|dr||tdd  qW ||d< |rXt||d< |V  qW dS )z
    Gather details from installed distributions. Print distribution name,
    version, location, and installed files. Installed files requires a
    pip generated 'installed-files.txt' in the distributions '.egg-info'
    directory.
    c             S   s   g | ]}t |qS r   )r   ).0namer   r   r   
<listcomp>F   s    z(search_packages_info.<locals>.<listcomp>c                s   g | ]\}}| kr|qS r   r   )r/   r0   pkg)	installedr   r   r1   H   s    zPackage(s) not found: %sz, c                s   t |   fddtjD S )Nc                s(   g | ] } d d |  D kr|jqS )c             S   s   g | ]}t |jqS r   )r   r0   )r/   requiredr   r   r   r1   S   s    zSsearch_packages_info.<locals>.get_requiring_packages.<locals>.<listcomp>.<listcomp>)requiresproject_name)r/   r2   )canonical_namer   r   r1   Q   s    zHsearch_packages_info.<locals>.get_requiring_packages.<locals>.<listcomp>)r   r   working_set)package_namer   )r7   r   get_requiring_packagesM   s    z4search_packages_info.<locals>.get_requiring_packagesc                s   g | ]}| kr | qS r   r   )r/   r2   )r3   r   r   r1   W   s    c             S   s   g | ]
}|j qS r   )r6   )r/   depr   r   r   r1   \   s    )r0   versionlocationr5   required_byN RECORDc             S   s   g | ]}| d d qS ),r   )split)r/   liner   r   r   r1   e   s    c                s   g | ]}t j j|qS r   )ospathjoinr=   )r/   p)distr   r   r1   f   s    c                s   g | ]}t j| jqS r   )rD   rE   relpathr=   )r/   rG   )rH   r   r   r1   g   s    METADATAzinstalled-files.txtc                s   g | ]}t j j|qS r   )rD   rE   rF   egg_info)r/   rG   )rH   r   r   r1   o   s    c                s   g | ]}t j| jqS r   )rD   rE   rI   r=   )r/   rG   )rH   r   r   r1   p   s    zPKG-INFOzentry_points.txtentry_points	INSTALLER	installer)zmetadata-versionsummaryz	home-pageauthorzauthor-emaillicensezClassifier: classifiersr   )r   r8   r   r6   sortedzipr    r!   rF   r<   r=   r5   
isinstanceDistInfoDistributionhas_metadataget_metadata_linesget_metadatastripr   feedcloseget
splitlines
startswithappendlen)r&   rG   Zquery_namesmissingr:   package	file_listmetadatalinespathsrL   rC   feed_parser
pkg_info_dictkeyrR   r   )rH   r3   r   r"   :   sh    







r"   Fc       	   	   C   s  d}xt | D ]\}}d}|dkr.td td|dd td|d	d td
|dd td|d
d td|dd td|dd td|dd td|dd tdd|dg  tdd|dg  |rptd|dd td|dd td x |d g D ]}td!| q.W td" x$|d#g D ]}td!|  qXW |rtd$ x$|d%g D ]}td!|  qW d%|krtd& qW |S )'zC
    Print the information from installed distributions found.
    FTr   z---zName: %sr0   r?   zVersion: %sr<   zSummary: %srO   z
Home-page: %sz	home-pagez
Author: %srP   zAuthor-email: %szauthor-emailzLicense: %srQ   zLocation: %sr=   zRequires: %sz, r5   zRequired-by: %sr>   zMetadata-Version: %szmetadata-versionz
Installer: %srN   zClassifiers:rR   z  %sz
Entry-points:rL   zFiles:r   z!Cannot locate installed-files.txt)	enumerater	   r]   rF   rZ   )	
distributionsr   r   Zresults_printedirH   
classifierentryrC   r   r   r   r#      s@    r#   )FF)
__future__r   loggingrD   email.parserr   pip._vendorr   Zpip._vendor.packaging.utilsr   pip._internal.cli.base_commandr   pip._internal.cli.status_codesr   r   pip._internal.utils