           value = '(Error decoding value)'
    return value


def to_string(value):
    try:
        return binary_type(value.decode('utf-8').encode('utf-8'))
    except Exception:
        return to_unicode(value).encode('utf-8')
                                                                                                                                                                                                                                                                                         python3.7/site-packages/raven/exceptions.py                                                         0000644                 00000001154 15107360262 0014706 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import

from raven.utils.compat import text_type


class APIError(Exception):
    def __init__(self, message, code=0):
        self.code = code
        self.message = message

    def __unicode__(self):
        return text_type("%s: %s" % (self.message, self.code))


class RateLimited(APIError):
    def __init__(self, message, retry_after=0):
        self.retry_after = retry_after
        super(RateLimited, self).__init__(message, 429)


class InvalidGitRepository(Exception):
    pass


class ConfigurationError(ValueError):
    pass


class InvalidDsn(ConfigurationError):
    pass
                                                                                                                                                                                                                                                                                                                                                                                                                    python3.7/site-packages/raven/contrib/paste.py                                                      0000644                 00000000612 15107360262 0015277 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.paste
~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from raven.middleware import Sentry
from raven.base import Client


def sentry_filter_factory(app, global_conf, **kwargs):
    client = Client(**kwargs)
    return Sentry(app, client)
                                                                                                                      python3.7/site-packages/raven/contrib/zerorpc/__pycache__/__init__.cpython-37.pyc                   0000644                 00000004343 15107360262 0023700 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    YR
                 @   s8   d Z ddlmZ ddlZddlmZ G dd deZdS )z
raven.contrib.zerorpc
~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)Clientc               @   s"   e Zd ZdZdddZdd ZdS )	SentryMiddlewareal  Sentry/Raven middleware for ZeroRPC.

    >>> import zerorpc
    >>> from raven.contrib.zerorpc import SentryMiddleware
    >>> sentry = SentryMiddleware(dsn='udp://..../')
    >>> zerorpc.Context.get_instance().register_middleware(sentry)

    Exceptions detected server-side in ZeroRPC will be submitted to Sentry (and
    propagated to the client as well).
    TNc             K   s   |pt f || _|| _dS )a  
        Create a middleware object that can be injected in a ZeroRPC server.

        - hide_zerorpc_frames: modify the exception stacktrace to remove the
                               internal zerorpc frames (True by default to make
                               the stacktrace as readable as possible);
        - client: use an existing raven.Client object, otherwise one will be
                  instantiated from the keyword arguments.
        N)r   _sentry_client_hide_zerorpc_frames)selfZhide_zerorpc_framesZclientkwargs r	   O/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/zerorpc/__init__.py__init__   s    
zSentryMiddleware.__init__c             C   sb   | j rN|d }x>|rL|j}d|jd< t|}|jdksB|jdkrDP |j}qW | jj||d dS )zU
        Called when an exception has been raised in the code run by ZeroRPC
           TZ__traceback_hide____call__Z	_receiver)extraN)	r   tb_framef_localsinspectgetframeinfofunctiontb_nextr   ZcaptureException)r   Z	req_eventZ	rep_eventZtask_ctxexc_info	tracebackZ
zerorpc_frameZ
frame_infor	   r	   r
   server_inspect_exception(   s    




z)SentryMiddleware.server_inspect_exception)TN)__name__
__module____qualname____doc__r   r   r	   r	   r	   r
   r      s   


r   )r   
__future__r   r   Z
raven.baser   objectr   r	   r	   r	   r
   <module>   s                                                                                                                                                                                                                                                                                                python3.7/site-packages/raven/contrib/zerorpc/__init__.py              