ializer):
    types = (types.FunctionType,)

    def serialize(self, value, **kwargs):
        return '<function %s from %s at 0x%x>' % (
            value.__name__, value.__module__, id(value))


if PY2:
    class LongSerializer(Serializer):
        types = (long,)  # noqa

        def serialize(self, value, **kwargs):
            return long(value)  # noqa


# register all serializers, order matters
serialization_manager.register(IterableSerializer)
serialization_manager.register(DictSerializer)
serialization_manager.register(UnicodeSerializer)
serialization_manager.register(StringSerializer)
serialization_manager.register(TypeSerializer)
serialization_manager.register(BooleanSerializer)
serialization_manager.register(FloatSerializer)
serialization_manager.register(IntegerSerializer)
serialization_manager.register(FunctionSerializer)
if PY2:
    serialization_manager.register(LongSerializer)
                                                                                                                     python3.7/site-packages/raven/utils/serializer/__init__.py                                          0000644                 00000000477 15107360260 0017602 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.utils.serializer
~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from raven.utils.serializer.base import *  # NOQA
from raven.utils.serializer.manager import *  # NOQA
                                                                                                                                                                                                 python3.7/site-packages/raven/utils/http.py                                                         0000644                 00000003720 15107360260 0014643 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.utils.http
~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import socket
import ssl
import sys

from raven.conf import defaults
from raven.utils.compat import urllib2, httplib
from raven.utils.ssl_match_hostname import match_hostname


def urlopen(url, data=None, timeout=defaults.TIMEOUT, ca_certs=None,
            verify_ssl=False, assert_hostname=None):

    class ValidHTTPSConnection(httplib.HTTPConnection):
        default_port = httplib.HTTPS_PORT

        def __init__(self, *args, **kwargs):
            httplib.HTTPConnection.__init__(self, *args, **kwargs)

        def connect(self):
            sock = socket.create_connection(
                address=(self.host, self.port),
                timeout=self.timeout,
            )
            if self._tunnel_host:
                self.sock = sock
                self._tunnel()

            self.sock = ssl.wrap_socket(
                sock, ca_certs=ca_certs, cert_reqs=ssl.CERT_REQUIRED)

            if assert_hostname is not None:
                match_hostname(self.sock.getpeercert(),
                               self.assert_hostname or self.host)

    class ValidHTTPSHandler(urllib2.HTTPSHandler):
        def https_open(self, req):
            return self.do_open(ValidHTTPSConnection, req)

    if verify_ssl:
        handlers = [ValidHTTPSHandler]
    else:
        try:
            handlers = [urllib2.HTTPSHandler(
                context=ssl._create_unverified_context())]
        except AttributeError:
            handlers = []

    opener = urllib2.build_opener(*handlers)

    if sys.version_info < (2, 6):
        default_timeout = socket.getdefaulttimeout()
        socket.setdefaulttimeout(timeout)
        try:
            return opener.open(url, data)
        finally:
            socket.setdefaulttimeout(default_timeout)
    return opener.open(url, data, timeout)
                                                python3.7/site-packages/raven/utils/__pycache__/json.cpython-37.pyc                                 0000644                 00000007535 15107360261 0021133 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y-
                 @   s  d Z ddlmZ ddlZddlZddlZddlZy
ejZW n ek
rR   e	ZY nX G dd dej
Zdd Zdd	 Z
d
d ZedZdddZedZd ddZG dd dejZG dd dejZG dd dejZG dd deejZG dd deejZdd Zee dS )!z
raven.utils.json
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importNc                   sD   e Zd Zejdd ejdd eeeee	dd iZ
 fddZ  ZS )BetterJSONEncoderc             C   s   | j S )N)hex)o r   A/opt/alt/python37/lib/python3.7/site-packages/raven/utils/json.py<lambda>       zBetterJSONEncoder.<lambda>c             C   s
   |  dS )Nz%Y-%m-%dT%H:%M:%SZ)strftime)r   r   r   r   r      r	   c             C   s   | j dddS )Nzutf-8replace)errors)decode)r   r   r   r   r      r	   c                sZ   y| j t| }W n> tk
rP   ytt| |S  tk
rJ   t|S X Y nX ||S )N)ENCODER_BY_TYPEtypeKeyErrorsuperr   default	TypeErrorrepr)selfobjencoder)	__class__r   r   r      s    zBetterJSONEncoder.default)
__name__
__module____qualname__uuidUUIDdatetimesetlist	frozensetbytesr   r   
__classcell__r   r   )r   r   r      s   

r   c             C   s   | S )Nr   )datar   r   r   better_decoder*   s    r%   c             K   sJ   yt j| fdti|S  tk
rD   d|d< t j| fdti|S X d S )Nclsz
safe-utf-8encoding)jsondumpsr   	Exception)valuekwargsr   r   r   r)   .   s
    r)   c             K   s   t j| tdS )N)object_hook)r(   loadsr%   )r+   r,   r   r   r   r.   6   s    r.   zutf-8backslashreplacec             C   s
   t | |S )N)
_utf8_encoder)inputr   r   r   r   safe_encode=   s    r2   r   c             C   s
   t | |S )N)
_utf8_decoder)r1   r   r   r   r   safe_decodeD   s    r4   c               @   s    e Zd ZdddZd	ddZdS )
Codecr/   c             C   s
   t ||S )N)r2   )r   r1   r   r   r   r   encodeJ   s    zCodec.encoder   c             C   s
   t ||S )N)r4   )r   r1   r   r   r   r   r
   M   s    zCodec.decodeN)r/   )r   )r   r   r   r6   r
   r   r   r   r   r5   H   s   
r5   c               @   s   e Zd ZdddZdS )IncrementalEncoderFc             C   s   t || jd S )Nr   )r2   r   )r   r1   finalr   r   r   r6   R   s    zIncrementalEncoder.encodeN)F)r   r   r   r6   r   r   r   r   r7   Q   s   r7   c               @   s   e Zd ZdddZdS )IncrementalDecoderFc             C   s   t || jd S )Nr   )r4   r   )r   r1   r8   r   r   r   r
   W   s    zIncrementalDecoder.decodeN)F)r   r   r   r
   r   r   r   r   r9   V   s   r9   c               @   s   e Zd ZdS )StreamWriterN)r   r   r   r   r   r   r   r:   [   s   r:   c               @   s   e Zd ZdS )StreamReaderN)r   r   r   r   r   r   r   r;   _   s   r;   c          	   C   s$   | dkrd S t jdttttttdS )Nz
safe-utf-8)namer6   r
   incrementalencoderincrementaldecoderstreamreaderstreamwriter)codecs	CodecInfor2   r4   r7   r9   r;   r:   )r<   r   r   r   getregentryc   s    rC   )r/   )r   )__doc__
__future__r   rA   r   r   r(   JSONDecodeErrorAttributeError
ValueErrorJSONEncoderr   r%   r)   r.   
getencoderr0   r2   
getdecoderr3   r4   r5   r7   r9   r:   r;   rC   registerr   r   r   r   <module>   s0   





	                                                                                                                                                                   python3.7/site-packages/raven/utils/__pycache__/conf.cpython-37.pyc                                 0000644                 00000003363 15107360261 0021102 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   sB   d dl mZ d dlZd dlZd dlmZ d dlmZ dddZdS )    )absolute_importN)string_types)
import_stringc                s   dkri  t trFd fdd	}tdp@dp@i }n2d fdd	}ttddpttddpti }|d|dg  |d|dg  |d	|d	 |d
|d
 |d|d |d|d |d
|d
 |d|d |d|d |d|dtjd |d|d |d|d |d|d |d|d |d|d |d|d |d|d |dp|d}t |trt	|}||d< |S )zy
    Convert a settings object (or dictionary) to parameters which may be passed
    to a new ``Client()`` instance.
    Nc                s    d|     | |S )Nz	SENTRY_%s)getupper)keydefault)defaultssettings A/opt/alt/python37/lib/python3.7/site-packages/raven/utils/conf.pygetopt   s    
zconvert_options.<locals>.getoptZ
SENTRY_CONFIGZRAVEN_CONFIGc                s   t d|    | |S )Nz	SENTRY_%s)getattrr   r   )r   r   )r	   r
   r   r   r
      s    Z
include_pathsZ
exclude_pathstimeoutnameZauto_log_stacksZstring_max_lengthZlist_max_lengthsiteZ
processorsZdsnZ
SENTRY_DSNcontextZtagsreleaseZreposenvironmentZignore_exceptionsZsample_rate	transport)N)N)

isinstancedictcopyr   r   
setdefaultosenvironr   r   )r
   r	   r
   optionsr   r   )r	   r
   r   convert_options
   sF    


r   )N)	
__future__r   r   r   Zraven.utils.compatr   Zraven.utils.importsr   r   r   r   r   r   <module>   s
                                                                                                                                                                                                                                                                                python3.7/site-packages/raven/utils/__pycache__/http.cpython-37.pyc                                 0000644                 00000004542 15107360261 0021134 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   sj   d Z ddlmZ ddlZddlZddlZddlmZ ddlm	Z	m
Z
 ddlmZ dej
dddfdd	ZdS )
z
raven.utils.http
~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)defaults)urllib2httplib)match_hostnameFc       
   	      s   G fdddt j G  fdddtj}|r:|g}n0ytjt dg}W n tk
rh   g }Y nX tj| }tj	dk rt
 }	t
| z|
| |S t
|	 X |
| ||S )Nc                   s(   e Zd ZejZdd Z fddZdS )z%urlopen.<locals>.ValidHTTPSConnectionc             _   s   t jj| f|| d S )N)r   HTTPConnection__init__)selfargskwargs r   A/opt/alt/python37/lib/python3.7/site-packages/raven/utils/http.pyr      s    z.urlopen.<locals>.ValidHTTPSConnection.__init__c                sd   t j| j| jf| jd}| jr,|| _|   tj	|tj
d| _ d k	r`t| j | j
p\| j d S )N)addresstimeout)ca_certsZ	cert_reqs)socketcreate_connectionhostportr   Z_tunnel_hostsockZ_tunnelsslZwrap_socketZ
CERT_REQUIREDr   Zgetpeercertassert_hostname)r	   r   )r   r   r   r
   connect   s    


z-urlopen.<locals>.ValidHTTPSConnection.connectN)__name__
__module____qualname__r   Z
HTTPS_PORTZdefault_portr   r   r   )r   r   r   r
   ValidHTTPSConnection   s   r   c                   s   e Zd Z fddZdS )z"urlopen.<locals>.ValidHTTPSHandlerc                s   |   |S )N)Zdo_open)r	   req)r   r   r
   
https_open-   s    z-urlopen.<loca