 | ` | `d S )N)r   r   )r	   r
   r
   r   close0   s    zSerializer.closec             K   s   |dkrdS t |}|| jkr"dS | j| zx\| jD ]R}||r8y|j|f|S  tk
r } zt| t	t
|S d}~X Y q8X q8W yt|S  tk
r } zt| t	t
|S d}~X Y nX W d| j| X dS )zn
        Primary function which handles recursively transforming
        values via their serializers
        Nz<...>)
idr   addr   Zcan	serialize	Exceptionr   	exceptionr   typereprremove)r	   valuekwargsobjidr
   er
   r
   r   r   4   s(    



zSerializer.transformN)r   r   r   r   r   r   r   r
   r
   r
   r   r   &   s   r   c          	   K   s&   t t|}|j| f|S Q R X d S )N)r   r   r   )r"   r   r#   r
   r
   r
   r   r   \   s    r   )__doc__
__future__r   logging
contextlibr   Zraven.utils.compatr   __all__	getLoggerr   objectr   r   r   r   r   r
   r
   r
   r   <module>   s   
2                                                                                                                                                                                                                                                                                                                                                                                                                                              python3.7/site-packages/raven/utils/serializer/__pycache__/base.cpython-37.pyc                      0000644                 00000015463 15107360260 0023243 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s  d Z ddlmZ ddlZddlZddlmZmZmZm	Z	m
Z
mZmZ ddl
mZ ddlmZ dZd	d
 ZG dd deZG d
d deZG dd deZG dd deZG dd deZG dd deZG dd deZG dd deZG dd deZG dd deZerG dd  d eZee ee ee ee ee ee ee ee ee eree dS )!z
raven.utils.serializer.base
~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)	text_typebinary_typestring_types	iteritemsclass_typesPY2PY3)
to_unicode   )manager)
Serializerc             C   s(   yt | dS  tk
r"   dS X d S )N
__sentry__F)callable__getattribute__	Exception)value r   L/opt/alt/python37/lib/python3.7/site-packages/raven/utils/serializer/base.pyhas_sentry_metadata   s    r   c               @   s2   e Zd ZdZdd Zdd Zdd Zd
d
dZdS )r
   r   c             C   s
   || _ d S )N)r   )selfr   r   r   r   __init__    s    zSerializer.__init__c             C   s   t || jS )z|
        Given ``value``, return a boolean describing whether this
        serializer can operate on the given type
        )
isinstancetypes)r   r   r   r   r   can#   s    zSerializer.canc             K   s   |S )z@
        Given ``value``, coerce into a JSON-safe type.
        r   )r   r   kwargsr   r   r   	serialize*   s    zSerializer.serialize   r   c          
   K   s   | dd}|d7 }||kr~ytt|d| }W nH tk
r| } z*ddl}|  | jj| tt	|S d}~X Y nX | jj
|f||d|S )z|
        Given ``value``, recurse (using the parent serializer) to handle
        coercing of newly defined values.
        string_max_lengthNr   r   )	max_depth_depth)getr   reprr   	traceback	print_excr   logger	exceptiontypeZ	transform)r   r   r   r    r   r   er#   r   r   r   recurse0   s    zSerializer.recurseN)r   r   )__name__
__module____qualname__r   r   r   r   r)   r   r   r   r   r
      s
   r
   c               @   s    e Zd ZeeeefZdd ZdS )IterableSerializerc                s>     dptdt fddtfddt|D S )Nlist_max_lengthinfc             3   s    | ]\}}j |f V  qd S )N)r)   ).0no)r   r   r   r   	<genexpr>J   s   z/IterableSerializer.serialize.<locals>.<genexpr>c                s   | d  k S )Nr   r   )x)r.   r   r   <lambda>L       z.IterableSerializer.serialize.<locals>.<lambda>)r!   floattuple	itertools	takewhile	enumerate)r   r   r   r   )r   r.   r   r   r   G   s
    zIterableSerializer.serializeN)	r*   r+   r,   r8   listset	frozensetr   r   r   r   r   r   r-   D   s   r-   c               @   s"   e Zd ZefZdd Zdd ZdS )DictSerializerc             C   s   t |tst|S |S )N)r   r   r
   )r   keyr   r   r   make_keyT   s    
zDictSerializer.make_keyc                sB     dptdt fddtfddtt|D S )Nr.   r/   c             3   s8   | ]0\}\}} j|f j|f fV  qd S )N)rA   r)   )r0   r1   kv)r   r   r   r   r3   \   s   z+DictSerializer.serialize.<locals>.<genexpr>c                s   | d  k S )Nr   r   )r4   )r.   r   r   r5   ^   r6   z*DictSerializer.serialize.<locals>.<lambda>)r!   r7   dictr9   r:   r;   r   )r   r   r   r   )r   r.   r   r   r   Y   s
    zDictSerializer.serializeN)r*   r+   r,   rD   r   rA   r   r   r   r   r   r?   Q   s   r?   c               @   s   e Zd ZefZdd ZdS )UnicodeSerializerc             K   s&   | dd }ttd|d | f S )Nr   z%s)r!   r"   r   )r   r   r   r   r   r   r   r   f   s    zUnicodeSerializer.serializeN)r*   r+   r,   r   r   r   r   r   r   r   rE   c   s   rE   c               @   s   e Zd ZefZdd ZdS )StringSerializerc             K   sf   | dd }tr t|d | S y d|dd | d d S  tk
rT   Y nX t|d | S )Nr   'utf8)r!   r	   r"   decodeencodeUnicodeDecodeError)r   r   r   r   r   r   r   r   r   s     zStringSerializer.serializeN)r*   r+   r,   r   r   r   r   r   r   r   rF   o   s   rF   c                   s(   e Zd ZeZ fddZdd Z  ZS )TypeSerializerc                s   t t| | ot|S )N)superrL   r   r   )r   r   )	__class__r   r   r      s    zTypeSerializer.canc             K   s   | j | f|S )N)r)   r   )r   r   r   r   r   r   r      s    zTypeSerializer.serialize)r*   r+   r,   r   r   r   r   
__classcell__r   r   )rN   r   rL      s   rL   c               @   s   e Zd ZefZdd ZdS )BooleanSerializerc             K   s   t |S )N)bool)r   r   r   r   r   r   r      s    zBooleanSerializer.serializeN)r*   r+   r,   rQ   r   r   r   r   r   r   rP      s   rP   c               @   s   e Zd ZefZdd ZdS )FloatSerializerc             K   s   t |S )N)r7   )r   r   r   r   r   r   r      s    zFloatSerializer.serializeN)r*   r+   r,   r7   r   r   r   r   r   r   rR      s   rR   c               @   s   e Zd ZefZdd ZdS )IntegerSerializerc             K   s   t |S )N)int)r   r   r   r   r   r   r      s    zIntegerSerializer.serializeN)r*   r+   r,   rT   r   r   r   r   r   r   rS      s   rS   c               @   s   e Zd ZejfZdd ZdS )FunctionSerializerc             K   s   d|j |jt|f S )Nz<function %s from %s at 0x%x>)r*   r+   id)r   r   r   r   r   r   r      s    zFunctionSerializer.serializeN)r*   r+   r,   r   FunctionTyper   r   r   r   r   rU      s   rU   c               @   s   e Zd ZefZdd ZdS )LongSerializerc             K   s   t |S )N)long)r   r   r   r   r   r   r      s    zLongSerializer.serializeN)r*   r+   r,   rY   r   r   r   r   r   r   rX      s   rX   ) __doc__
__future__r   r9   r   Zraven.utils.compatr   r   r   r   r   r   r	   Zraven.utils.encodingr
   r   Zserialization_manager__all__r   objectr
   r-   r?   rE   rF   rL   rP   rR   rS   rU   rX   registerr   r   r   r   <module>   s>   $'









                                                                                                                                                                                                             python3.7/site-packages/raven/utils/serializer/base.py                                              0000644                 00000012613 15107360260 0016750 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # -*- coding: utf-8 -*-
"""
raven.utils.serializer.base
~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import itertools
import types

from raven.utils.compat import text_type, binary_type, string_types, iteritems, \
    class_types, PY2, PY3
from raven.utils.encoding import to_unicode
from .manager import manager as serialization_manager

__all__ = ('Serializer',)


def has_sentry_metadata(value):
    try:
        return callable(value.__getattribute__('__sentry__'))
    except Exception:
        return False


class Serializer(object):
    types = ()

    def __init__(self, manager):
        self.manager = manager

    def can(self, value):
        """
        Given ``value``, return a boolean describing whether this
        serializer can operate on the given type
        """
        return isinstance(value, self.types)

    def serialize(self, value, **kwargs):
        """
        Given ``value``, coerce into a JSON-safe type.
        """
        return value

    def recurse(self, value, max_depth=6, _depth=0, **kwargs):
        """
        Given ``value``, recurse (using the parent serializer) to handle
        coercing of newly defined values.
        """
        string_max_length = kwargs.get('string_max_length', None)

        _depth += 1
        if _depth >= max_depth:
            try:
                value = text_type(repr(value))[:string_max_length]
            except Exception as e:
                import traceback
                traceback.print_exc()
                self.manager.logger.exception(e)
                return text_type(type(value))
        return self.manager.transform(value, max_depth=max_depth,
                                      _depth=_depth, **kwargs)


class IterableSerializer(Serializer):
    types = (tuple, list, set, frozenset)

    def serialize(self, value, **kwargs):
        list_max_length = kwargs.get('list_max_length') or float('inf')
        return tuple(
            self.recurse(o, **kwargs)
            for n, o
            in itertools.takewhile(lambda x: x[0] < list_max_length,
                                   enumerate(value))
        )


class DictSerializer(Serializer):
    types = (dict,)

    def make_key(self, key):
        if not isinstance(key, string_types):
            return to_unicode(key)
        return key

    def serialize(self, value, **kwargs):
        list_max_length = kwargs.get('list_max_length') or float('inf')
        return dict(
            (self.make_key(self.recurse(k, **kwargs)), self.recurse(v, **kwargs))
            for n, (k, v)
            in itertools.takewhile(lambda x: x[0] < list_max_length, enumerate(
                iteritems(value)))
        )


class UnicodeSerializer(Serializer):
    types = (text_type,)

    def serialize(self, value, **kwargs):
        # try to return a reasonable string that can be decoded
        # correctly by the server so it doesn't show up as \uXXX for each
        # unicode character
        # e.g. we want the output to be like: "u'רונית מגן'"
        string_max_length = kwargs.get('string_max_length', None)
        return repr(text_type('%s')) % (value[:string_max_length],)


class StringSerializer(Serializer):
    types = (binary_type,)

    def serialize(self, value, **kwargs):
        string_max_length = kwargs.get('string_max_length', None)
        if PY3:
            return repr(value[:string_max_length])

        try:
            # Python2 madness: let's try to recover from developer's issues
            # Try to process the string as if it was a unicode.
            return "'" + value.decode('utf8')[:string_max_length] \
                .encode('utf8') + "'"
        except UnicodeDecodeError:
            pass

        return repr(value[:string_max_length])


class TypeSerializer(Serializer):
    types = class_types

    def can(self, va