 kwargs["connect_timeout"] = self.timeout
        kwargs["ca_certs"] = self.ca_certs

        # only use async if ioloop is running, otherwise it will never send
        if ioloop.IOLoop.initialized():
            client = AsyncHTTPClient()
            kwargs['callback'] = None

            future = client.fetch(url, **kwargs)
            ioloop.IOLoop.current().add_future(future, partial(self.handler, success_cb, failure_cb))
        else:
            client = HTTPClient()
            try:
                client.fetch(url, **kwargs)
                success_cb()
            except Exception as e:
                failure_cb(e)

    @staticmethod
    def handler(success, error, future):
        try:
            future.result()
            success()
        except Exception as e:
            error(e)
                                                                                                                                                                                                                       python3.7/site-packages/raven/transport/threaded.py                                                 0000644                 00000012165 15107360270 0016344 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.threaded
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import atexit
import logging
import threading
import os

from time import sleep, time

from raven.transport.base import AsyncTransport
from raven.transport.http import HTTPTransport
from raven.utils.compat import Queue, check_threads

DEFAULT_TIMEOUT = 10

logger = logging.getLogger('sentry.errors')


class AsyncWorker(object):
    _terminator = object()

    def __init__(self, shutdown_timeout=DEFAULT_TIMEOUT):
        check_threads()
        self._queue = Queue(-1)
        self._lock = threading.Lock()
        self._thread = None
        self._thread_for_pid = None
        self.options = {
            'shutdown_timeout': shutdown_timeout,
        }
        self.start()

    def is_alive(self):
        if self._thread_for_pid != os.getpid():
            return False
        return self._thread and self._thread.is_alive()

    def _ensure_thread(self):
        if self.is_alive():
            return
        self.start()

    def main_thread_terminated(self):
        self._lock.acquire()
        try:
            if not self.is_alive():
                # thread not started or already stopped - nothing to do
                return

            # wake the processing thread up
            self._queue.put_nowait(self._terminator)

            timeout = self.options['shutdown_timeout']

            # wait briefly, initially
            initial_timeout = min(0.1, timeout)

            if not self._timed_queue_join(initial_timeout):
                # if that didn't work, wait a bit longer
                # NB that size is an approximation, because other threads may
                # add or remove items
                size = self._queue.qsize()

                print("Sentry is attempting to send %i pending error messages"
                      % size)
                print("Waiting up to %s seconds" % timeout)

                if os.name == 'nt':
                    print("Press Ctrl-Break to quit")
                else:
                    print("Press Ctrl-C to quit")

                self._timed_queue_join(timeout - initial_timeout)

            self._thread = None

        finally:
            self._lock.release()

    def _timed_queue_join(self, timeout):
        """
        implementation of Queue.join which takes a 'timeout' argument

        returns true on success, false on timeout
        """
        deadline = time() + timeout
        queue = self._queue

        queue.all_tasks_done.acquire()
        try:
            while queue.unfinished_tasks:
                delay = deadline - time()
                if delay <= 0:
                    # timed out
                    return False

                queue.all_tasks_done.wait(timeout=delay)

            return True

        finally:
            queue.all_tasks_done.release()

    def start(self):
        """
        Starts the task thread.
        """
        self._lock.acquire()
        try:
            if not self.is_alive():
                self._thread = threading.Thread(target=self._target, name="raven.AsyncWorker")
                self._thread.setDaemon(True)
                self._thread.start()
                self._thread_for_pid = os.getpid()
        finally:
            self._lock.release()
            atexit.register(self.main_thread_terminated)

    def stop(self, timeout=None):
        """
        Stops the task thread. Synchronous!
        """
        self._lock.acquire()
        try:
            if self._thread:
                self._queue.put_nowait(self._terminator)
                self._thread.join(timeout=timeout)
                self._thread = None
                self._thread_for_pid = None
        finally:
            self._lock.release()

    def queue(self, callback, *args, **kwargs):
        self._ensure_thread()
        self._queue.put_nowait((callback, args, kwargs))

    def _target(self):
        while True:
            record = self._queue.get()
            try:
                if record is self._terminator:
                    break
                callback, args, kwargs = record
                try:
                    callback(*args, **kwargs)
                except Exception:
                    logger.error('Failed processing job', exc_info=True)
            finally:
                self._queue.task_done()

            sleep(0)


class ThreadedHTTPTransport(AsyncTransport, HTTPTransport):

    scheme = ['http', 'https', 'threaded+http', 'threaded+https']

    def get_worker(self):
        if not hasattr(self, '_worker') or not self._worker.is_alive():
            self._worker = AsyncWorker()
        return self._worker

    def send_sync(self, url, data, headers, success_cb, failure_cb):
        try:
            super(ThreadedHTTPTransport, self).send(url, data, headers)
        except Exception as e:
            failure_cb(e)
        else:
            success_cb()

    def async_send(self, url, data, headers, success_cb, failure_cb):
        self.get_worker().queue(
            self.send_sync, url, data, headers, success_cb, failure_cb)
                                                                                                                                                                                                                                                                                                                                                                                                           python3.7/site-packages/raven/transport/gevent.py                                                   0000644                 00000003172 15107360270 0016052 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.gevent
~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from raven.transport.base import AsyncTransport
from raven.transport.http import HTTPTransport

try:
    import gevent
    # gevent 1.0bN renamed coros to lock
    try:
        from gevent.lock import Semaphore
    except ImportError:
        from gevent.coros import Semaphore  # NOQA
    has_gevent = True
except ImportError:
    has_gevent = None


class GeventedHTTPTransport(AsyncTransport, HTTPTransport):

    scheme = ['gevent+http', 'gevent+https']

    def __init__(self, maximum_outstanding_requests=100, *args, **kwargs):
        if not has_gevent:
            raise ImportError('GeventedHTTPTransport requires gevent.')

        self._lock = Semaphore(maximum_outstanding_requests)

        super(GeventedHTTPTransport, self).__init__(*args, **kwargs)

    def async_send(self, url, data, headers, success_cb, failure_cb):
        """
        Spawn an async request to a remote webserver.
        """
        # this can be optimized by making a custom self.send that does not
        # read the response since we don't use it.
        self._lock.acquire()
        return gevent.spawn(
            super(GeventedHTTPTransport, self).send, url, data, headers
        ).link(lambda x: self._done(x, success_cb, failure_cb))

    def _done(self, greenlet, success_cb, failure_cb, *args):
        self._lock.release()
        if greenlet.successful():
            success_cb()
        else:
            failure_cb(greenlet.exception)
                                                                                                                                                                                                                                                                                                                                                                                                      python3.7/site-packages/raven/transport/threaded_requests.py                                        0000644                 00000002106 15107360270 0020271 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.threaded_requests
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from raven.transport.base import AsyncTransport
from raven.transport import RequestsHTTPTransport
from raven.transport.threaded import AsyncWorker


class ThreadedRequestsHTTPTransport(AsyncTransport, RequestsHTTPTransport):

    scheme = ['threaded+requests+http', 'threaded+requests+https']

    def get_worker(self):
        if not hasattr(self, '_worker'):
            self._worker = AsyncWorker()
        return self._worker

    def send_sync(self, url, data, headers, success_cb, failure_cb):
        try:
            super(ThreadedRequestsHTTPTransport, self).send(url, data, headers)
        except Exception as e:
            failure_cb(e)
        else:
            success_cb()

    def async_send(self, url, data, headers, success_cb, failure_cb):
        self.get_worker().queue(
            self.send_sync, url, data, headers, success_cb, failure_cb)
                                                                                                                                                                                                                                                                                                                                                                                                                                                          python3.7/site-packages/raven/transport/http.py                                                     0000644                 00000003433 15107360270 0015541 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.http
~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from raven.utils.compat import string_types, urllib2
from raven.conf import defaults
from raven.exceptions import APIError, RateLimited
from raven.transport.base import Transport
from raven.utils.http import urlopen


class HTTPTransport(Transport):
    scheme = ['sync+http', 'sync+https']

    def __init__(self, timeout=defaults.TIMEOUT, verify_ssl=True,
                 ca_certs=defaults.CA_BUNDLE):
        if isinstance(timeout, string_types):
            timeout = int(timeout)
        if isinstance(verify_ssl, string_types):
            verify_ssl = bool(int(verify_ssl))

        self.timeout = timeout
        self.verify_ssl = verify_ssl
        self.ca_certs = ca_certs

    def send(self, url, data, headers):
        """
        Sends a request to a remote webserver using HTTP POST.
        """
        req = urllib2.Request(url, headers=headers)

        try:
            response = urlopen(
                url=req,
                data=data,
                timeout=self.timeout,
                verify_ssl=self.verify_ssl,
                ca_certs=self.ca_certs,
            )
        except urllib2.HTTPError as exc:
            msg = exc.headers.get('x-sentry-error')
            code = exc.getcode()
            if code == 429:
                try:
                    retry_after = int(exc.headers.get('retry-after'))
                except (ValueError, TypeError):
                    retry_after = 0
                raise RateLimited(msg, retry_after)
            elif msg:
                raise APIError(msg, code)
            else:
                raise
        return response
                                                                                                                                                                                                                                     python3.7/site-packages/raven/transport/__pycache__/http.cpython-37.pyc                             0000644                 00000003442 15107360270 0022026 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   sh   d Z ddlmZ ddlmZmZ ddlmZ ddlm	Z	m
Z
 ddlmZ ddl
mZ G dd	 d	eZd
S )z
raven.transport.http
~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)string_typesurllib2)defaults)APIErrorRateLimited)	Transport)urlopenc               @   s0   e Zd ZddgZejdejfddZdd ZdS )	
HTTPTransportz	sync+httpz
sync+httpsTc             C   s>   t |trt|}t |tr(tt|}|| _|| _|| _d S )N)
isinstancer   intbooltimeout
verify_sslca_certs)selfr   r   r    r   E/opt/alt/python37/lib/python3.7/site-packages/raven/transport/http.py__init__   s    

zHTTPTransport.__init__c       
      C   s   t j||d}yt||| j| j| jd}W n t jk
r } zp|jd}|	 }|dkryt
|jd}	W n ttfk
r   d}	Y nX t
||	n|rt||n W dd}~X Y nX |S )zH
        Sends a request to a remote webserver using HTTP POST.
        )headers)urldatar   r   r   zx-sentry-errori  zretry-afterr   N)r   ZRequestr	   r   r   r   	HTTPErrorr   getZgetcoder   
ValueError	TypeErrorr   r   )
r   r   r   r   reqresponseexcmsgcodeZretry_afterr   r   r   send   s*    
zHTTPTransport.sendN)	__name__
__module____qualname__schemer   ZTIMEOUTZ	CA_BUNDLEr   r!   r   r   r   r   r
      s   
r
   N)__doc__
__future__r   Zraven.utils.compatr   r   Z
raven.confr   Zraven.exceptionsr   r   Zraven.transport.baser   Zraven.utils.httpr	   r
   r   r   r   r   <module>   s                                                                                                                                                                                                                                 python3.7/site-packages/raven/transport/__pycache__/registry.cpython-37.pyc                         0000644                 00000005230 15107360271 0022715 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y.
                 @   s   d Z ddlmZ ddlmZ ddlmZ ddlmZ ddl	m
Z
 ddlmZ ddl
mZ dd	lmZ dd
lmZ ddlmZ ddlmZ G d
d deZeee
eeeeegZdS )z
raven.transport.registry
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)EventletHTTPTransport)DuplicateScheme)
HTTPTransport)GeventedHTTPTransport)RequestsHTTPTransport)ThreadedHTTPTransport)ThreadedRequestsHTTPTransport)TwistedHTTPTransport)TornadoHTTPTransport)urlparsec               @   s>   e Zd ZdddZdd Zdd Zdd	 Zd
d Zdd
 ZdS )TransportRegistryNc             C   s,   i | _ i | _|r(x|D ]}| | qW d S )N)_schemes_transportsregister_transport)selfZ
transports	transport r   I/opt/alt/python37/lib/python3.7/site-packages/raven/transport/registry.py__init__   s
    
zTransportRegistry.__init__c             C   sD   t |drt |jds$td|jjx|jD ]}| || q,W d S )Nscheme__iter__z$Transport %s must have a scheme list)hasattrr   AttributeError	__class____name__register_scheme)r   r   r   r   r   r   r   !   s    z$TransportRegistry.register_transportc             C   s(   || j krt t| || j |< dS )zA
        It is possible to inject new schemes at runtime
        N)r   r   r   r   )r   r   clsr   r   r   r   (   s    

z!TransportRegistry.register_schemec             C   s
   || j kS )N)r   )r   r   r   r   r   supported_scheme3   s    z"TransportRegistry.supported_schemec             K   sJ   |  }|| jkr@t|dd }| j|j |f|| j|< | j| S )N?r   )geturlr   r   splitr   r   )r   
parsed_urloptionsZfull_urlr   r   r   
get_transport6   s
    
zTransportRegistry.get_transportc             C   s
   | j | S )N)r   )r   r   r   r   r   get_transport_cls>   s    z#TransportRegistry.get_transport_cls)N)	r   
__module____qualname__r   r   r   r   r$   r%   r   r   r   r   r
      s   
	r
   N)__doc__
__future__r   Zraven.transport.eventletr   Zraven.transport.exceptionsr   Zraven.transport.httpr   Zraven.transport.geventr   Zraven.transport.requestsr   Zraven.transport.threadedr   Z!raven.transport.threaded_requestsr	   Zraven.transport.twistedr
   Zraven.transport.tornador   Zraven.utilsr   objectr
   Zdefault_transportsr   r   r   r   <module>   s(   ,                                                                                                                                                                                                                                                                                                                                                                        python3.7/site-packages/raven/transport/__pycache__/__init__.cpython-37.pyc                         0000644                 00000001341 15107360271 0022603 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   sd   d Z ddlmZ ddlT ddlT ddlT ddlT ddlT ddlT ddl	T ddl
T ddlT ddlT dS )z
raven.transport
~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)
__doc__
__future__r   Zraven.transport.baseZraven.transport.eventletZraven.transport.exceptionsZraven.transport.geventZraven.transport.httpZraven.transport.requestsZraven.transport.registryZraven.transport.twistedZraven.transport.threadedZraven.transport.tornado r   r   I/opt/alt/python37/lib/python3.7/site-packages/raven/transport/__init__.py<module>   s                                                                                                                                                                                                                                                                                                  python3.7/site-packages/raven/transport/__pycache__/eventlet.cpython-37.pyc                         0000644                 00000003475 15107360271 0022704 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s   d Z ddlmZ ddlZddlmZ yBddlZyddlmZ	 W n  e
k
r^   ddlmZ	 Y nX dZ
W n e
k
r~   dZ
Y nX G d	d
 d
eZdS )z
raven.transport.eventlet
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)
HTTPTransport)urllib2)requestTFc                   s6   e Zd ZddgZd
 fdd	Zdd Zdd	 Z  ZS )EventletHTTPTransportz
eventlet+httpzeventlet+httpsd   c                s"   t stdtt| jf | d S )Nz(EventletHTTPTransport requires eventlet.)has_eventletImportErrorsuperr   __init__)selfZ	pool_sizekwargs)	__class__ I/opt/alt/python37/lib/python3.7/site-packages/raven/transport/eventlet.pyr      s    zEventletHTTPTransport.__init__c          
   C   st   |\}}}t j||d}y4tjdk r6t || }nt ||| j }|S  tk
rn } z|S d }~X Y nX d S )N)headers)      )eventlet_urllib2ZRequestsysversion_infourlopenreadtimeout	Exception)r   payloadurldatar   reqresponseerrr   r   r   
_send_payload"   s    

z#EventletHTTPTransport._send_payloadc             C   s   t | j|||f dS )z?
        Spawn an async request to a remote webserver.
        N)eventletspawnr!   )r   r   r   r   r   r   r   send/   s    zEventletHTTPTransport.send)r   )__name__
__module____qualname__schemer   r!   r$   
__classcell__r   r   )r   r   r      s   
r   )__doc__
__future__r   r   Zraven.transport.httpr   r"   Zeventlet.greenr   r   r	   Zeventlet.green.urllibr   r   r   r   r   r   r   <module>   s   
                                                                                                                                                                                                   python3.7/site-packages/raven/transport/__pycache__/exceptions.cpython-37.pyc                       0000644                 00000001665 15107360271 0023236 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s4   d Z ddlmZ G dd deZG dd deZdS )z
raven.transport.exceptions
~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importc               @   s   e Zd ZdZdS )
InvalidSchemezf
    Raised when a transport is constructed using a URI which is not
    handled by the transport
    N)__name__
__module____qualname____doc__ r   r   K/opt/alt/python37/lib/python3.7/site-packages/raven/transport/exceptions.pyr      s   r   c               @   s   e Zd ZdZdS )DuplicateSchemezc
    Raised when registering a handler for a particular scheme which
    is already registered
    N)r   r   r   r   r   r   r   r	   r
      s   r
   N)r   
__future__r   
ValueErrorr   	Exceptionr
   r   r   r   r	   <module>   s                                                                              python3.7/site-packages/raven/transport/__pycache__/tornado.cpython-37.pyc                          0000644                 00000004034 15107360271 0022514 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y)                 @   s   d Z ddlmZ ddlmZ ddlmZ ddlmZ y$ddl	m
Z
 ddlmZm
Z
 dZW n ek
rp   d	ZY nX G d
d deeZdS )
z
raven.transport.tornado
~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)partial)AsyncTransport)
HTTPTransport)ioloop)AsyncHTTPClient
HTTPClientTFc                   s8   e Zd ZddgZ fddZdd Zedd Z  ZS )	TornadoHTTPTransportztornado+httpz
tornado+httpsc                s"   t stdtt| j|| d S )Nz&TornadoHTTPTransport requires tornado.)has_tornadoImportErrorsuperr	   __init__)selfargskwargs)	__class__ H/opt/alt/python37/lib/python3.7/site-packages/raven/transport/tornado.pyr
      s    zTornadoHTTPTransport.__init__c       
   
   C   s   t d||d}| j|d< | j|d< | j|d< tj rpt }d |d< |j|f|}tj	 
|t| j|| nJt
 }y|j|f| |  W n* tk
r }	 z||	 W d d }	~	X Y nX d S )NZPOST)methodheadersbodyZ
validate_certZconnect_timeoutca_certscallback)dictZ
verify_ssltimeoutr   r   ZIOLoopZinitializedr   ZfetchcurrentZ
add_futurer   handlerr   	Exception)
r   urldatar   Z
success_cbZ
failure_cbr   Zclientfutureer   r   r   
async_send!   s    




zTornadoHTTPTransport.async_sendc          
   C   sB   y|   |   W n* tk
r< } z|| W d d }~X Y nX d S )N)resultr   )successerrorr    r!   r   r   r   r   6   s
    
zTornadoHTTPTransport.handler)	__name__
__module____qualname__schemer
   r"   staticmethodr   
__classcell__r   r   )r   r   r	      s   r	   N)__doc__
__future__r   	functoolsr   Zraven.transport.baser   Zraven.transport.httpr   Ztornador   Ztornado.httpclientr   r   r
   r   r	   r   r   r   r   <module>   s   
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    python3.7/site-packages/raven/transport/__pycache__/twisted.cpython-37.pyc                          0000644                 00000005635 15107360271 0022541 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y	                 @   s   d Z ddlmZ ddlmZ ddlmZ ddlmZ y0ddl	m
Z
mZmZm
Z
mZ ddlmZ dZW n ek
r|   d	ZY nX G d
d deeZdS )
z
raven.transport.twisted
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)BytesIO)AsyncTransport)
HTTPTransport)AgentFileBodyProducerHTTPConnectionPoolResponseNeverReceivedreadBody)HeadersTFc                   s,   e Zd ZddgZ fddZdd Z  ZS )TwistedHTTPTransportztwisted+httpz
twisted+httpsc                s@   t stdtt| j|| ddlm} t|t|d| _	d S )Nz*TwistedHTTPTransport requires twisted.web.r   )reactor)pool)
has_twistedImportErrorsuperr   __init__Ztwisted.internetr
   r   r   _agent)selfargskwargsr
   )	__class__ H/opt/alt/python37/lib/python3.7/site-packages/raven/transport/twisted.pyr      s
    zTwistedHTTPTransport.__init__c       	   	      s`   | j jd|tt|ttdd | D d} fdd} fdd}||| d S )	Ns   POSTc             s   s   | ]\}}||gfV  qd S )Nr   ).0kvr   r   r   	<genexpr>-   s    z2TwistedHTTPTransport.async_send.<locals>.<genexpr>)ZbodyProducerheadersc                s4   |  t}|r& dd | jjD  n
 | j d S )Nc             S   s   g | ]
}|j qS r   )value)r   fr   r   r   
<listcomp>4   s    zGTwistedHTTPTransport.async_send.<locals>.on_failure.<locals>.<listcomp>)checkr	   r   Zreasons)Zfailureex)
failure_cbr   r   
on_failure0   s    
z3TwistedHTTPTransport.async_send.<locals>.on_failurec                s2    j dkr  n fdd}t |S dS )z
            Success only means that the request succeeded, *not* that the
            actual submission was successful.
               c                s    t jj|  d S )N)	Exceptioncodephrase)body)r$   responser   r   
on_error_body@   s    zJTwistedHTTPTransport.async_send.<locals>.on_success.<locals>.on_error_bodyN)r(   r
   addCallback)r+   r,   )r$   
success_cb)r+   r   
on_success8   s
    
z3TwistedHTTPTransport.async_send.<locals>.on_success)	r   Zrequestr   r   r   dictitemsr-   Z
addErrback)	r   urldatar   r.   r$   dr%   r/   r   )r$   r.   r   
async_send)   s    
zTwistedHTTPTransport.async_send)__name__
__module____qualname__schemer   r5   
__classcell__r   r   )r   r   r      s   r   N)__doc__
__future__r   Zraven.utils.compatr   Zraven.transport.baser   Zraven.transport.httpr   Ztwisted.web.clientr   r   r   r	   r
   Ztwisted.web.http_headersr   r   r   r   r   r   r   r   <module>   s   
                                                                                                   python3.7/site-packages/raven/transport/__pycache__/gevent.cpython-37.pyc                           0000644                 00000003701 15107360271 0022336 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Yz                 @   s   d Z ddlmZ ddlmZ ddlmZ yBddlZyddlm	Z	 W n  e
k
rb   ddlm	Z	 Y nX dZW n e
k
r   dZY nX G dd	 d	eeZ
dS )
z
raven.transport.gevent
~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)AsyncTransport)
HTTPTransportN)	SemaphoreTc                   s:   e Zd ZddgZd
 fdd	Z fddZdd	 Z  ZS )GeventedHTTPTransportzgevent+httpzgevent+httpsd   c                s,   t stdt|| _tt| j|| d S )Nz&GeventedHTTPTransport requires gevent.)
has_geventImportErrorr   _locksuperr   __init__)selfZmaximum_outstanding_requestsargskwargs)	__class__ G/opt/alt/python37/lib/python3.7/site-packages/raven/transport/gevent.pyr      s    
zGeventedHTTPTransport.__init__c                s4   j   tttj||| fddS )z?
        Spawn an async request to a remote webserver.
        c                s    |  S )N)_done)x)
failure_cbr
   
success_cbr   r   <lambda>.       z2GeventedHTTPTransport.async_send.<locals>.<lambda>)r
   acquiregeventspawnr   r   sendlink)r
   urldataheadersr   r   )r   )r   r
   r   r   
async_send%   s    
z GeventedHTTPTransport.async_sendc             G   s(   | j   | r|  n
||j d S )N)r
   releaseZ
successful	exception)r
   Zgreenletr   r   r   r   r   r   r   0   s    
zGeventedHTTPTransport._done)r   )__name__
__module____qualname__schemer   r!   r   
__classcell__r   r   )r   r   r      s   r   )__doc__
__future__r   Zraven.transport.baser   Zraven.transport.httpr   r   Zgevent.lockr   r	   Zgevent.corosr   r   r   r   r   r   <module>   s   
                                                               python3.7/site-packages/raven/transport/__pycache__/requests.cpython-37.pyc                         0000644                 00000002405 15107360271 0022721 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                  @   sZ   d Z ddlmZ ddlmZ yddlZdZW n ek
rD   dZY nX G dd deZdS )	z
raven.transport.requests
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)
HTTPTransportNTFc                   s,   e Zd ZddgZ fddZdd Z  ZS )RequestsHTTPTransportz
requests+httpzrequests+httpsc                s"   t stdtt| j|| d S )Nz(RequestsHTTPTransport requires requests.)has_requestsImportErrorsuperr   __init__)selfargskwargs)	__class__ I/opt/alt/python37/lib/python3.7/site-packages/raven/transport/requests.pyr      s    zRequestsHTTPTransport.__init__c             C   s*   | j r| j| _ tj|||| j | jd d S )N)dataheadersZverifytimeout)Z
verify_sslZca_certsrequestspostr   )r	   urlr   r   r
   r
   r   send   s    
zRequestsHTTPTransport.send)__name__
__module____qualname__schemer   r   
__classcell__r
   r
   )r   r   r      s   r   )	__doc__
__future__r   Zraven.transport.httpr   r   r   r   r   r
   r
   r
   r   <module>   s   
                                                                                                                                                                                                                                                           python3.7/site-packages/raven/transport/__pycache__/threaded.cpython-37.pyc                         0000644                 00000011402 15107360271 0022623 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Yu                 @   s   d Z ddlmZ ddlZddlZddlZddlZddlmZmZ ddl	m
Z
 ddlmZ ddl
mZmZ dZed	ZG d
d deZG dd
 d
e
eZdS )z
raven.transport.threaded
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)sleeptime)AsyncTransport)
HTTPTransport)Queue
check_threads
   z
sentry.errorsc               @   s`   e Zd Ze ZefddZdd Zdd Zdd Z	d	d
 Z
dd ZdddZdd Z
dd Zd
S )AsyncWorkerc             C   s<   t   td| _t | _d | _d | _d|i| _| 	  d S )Nshutdown_timeout)
r   r   _queue	threadingLock_lock_thread_thread_for_pidoptionsstart)selfr    r   I/opt/alt/python37/lib/python3.7/site-packages/raven/transport/threaded.py__init__   s    


zAsyncWorker.__init__c             C   s"   | j t krdS | jo | j S )NF)r   osgetpidr   is_alive)r   r   r   r   r   (   s    zAsyncWorker.is_alivec             C   s   |   rd S |   d S )N)r   r   )r   r   r   r   _ensure_thread-   s    zAsyncWorker._ensure_threadc             C   s   | j   z|  sd S | j| j | jd }td|}| |s| j	 }t
d|  t
d|  tjdkrzt
d nt
d | ||  d | _
W d | j   X d S )Nr   g?z6Sentry is attempting to send %i pending error messageszWaiting up to %s secondsntzPress Ctrl-Break to quitzPress Ctrl-C to quit)r   acquirer   r
   
put_nowait_terminatorr   min_timed_queue_joinqsizeprintr   namer   release)r   timeoutZinitial_timeoutsizer   r   r   main_thread_terminated2   s$    







z"AsyncWorker.main_thread_terminatedc             C   s`   t  | }| j}|j  z4x.|jrJ|t   }|dkr:dS |jj|d qW dS |j  X dS )z
        implementation of Queue.join which takes a 'timeout' argument

        returns true on success, false on timeout
        r   F)r'   TN)r   r
   all_tasks_doner   unfinished_taskswaitr&   )r   r'   Zdeadlinequeuedelayr   r   r   r"   W   s    


zAsyncWorker._timed_queue_joinc          	   C   sf   | j   z>|  sFtj| jdd| _| jd | j  t	
 | _W d| j   t
| j X dS )z)
        Starts the task thread.
        zraven.AsyncWorker)targetr%   TN)r   r   r   r   Thread_targetr   	setDaemonr   r   r   r   r&   atexitregisterr)   )r   r   r   r   r   o   s    


zAsyncWorker.startNc             C   sN   | j   z2| jr:| j| j | jj|d d| _d| _W d| j   X dS )z5
        Stops the task thread. Synchronous!
        )r'   N)	r   r   r   r
   r   r    joinr   r&   )r   r'   r   r   r   stop~   s    

zAsyncWorker.stopc             O   s   |    | j|||f d S )N)r   r
   r   )r   callbackargskwargsr   r   r   r-      s    zAsyncWorker.queuec             C   sv   xp| j  }zL|| jkrP |\}}}y||| W n" tk
rT   tjddd Y nX W d | j   X td qW d S )NzFailed processing jobT)exc_infor   )r
   getr    	Exceptionloggererror	task_doner   )r   recordr7   r8   r9   r   r   r   r1      s    


zAsyncWorker._target)N)__name__
__module____qualname__objectr    DEFAULT_TIMEOUTr   r   r   r)   r"   r   r6   r-   r1   r   r   r   r   r
      s   %
r
   c                   s8   e Zd ZddddgZdd Z fddZd	d
 Z  ZS )ThreadedHTTPTransporthttphttpsz
threaded+httpzthreaded+httpsc             C   s"   t | dr| j st | _| jS )N_worker)hasattrrI   r   r
   )r   r   r   r   
get_worker   s    z ThreadedHTTPTransport.get_workerc          
      sN   yt t| ||| W n* tk
rB } z|| W d d }~X Y nX |  d S )N)superrF   sendr<   )r   urldataheaders
success_cb
failure_cbe)	__class__r   r   	send_sync   s
    zThreadedHTTPTransport.send_syncc             C   s   |   | j||||| d S )N)rK   r-   rU   )r   rN   rO   rP   rQ   rR   r   r   r   
async_send   s    z ThreadedHTTPTransport.async_send)rA   rB   rC   schemerK   rU   rV   
__classcell__r   r   )rT   r   rF      s   rF   )__doc__
__future__r   r3   loggingr   r   r   r   Zraven.transport.baser   Zraven.transport.httpr   Zraven.utils.compatr   r   rE   	getLoggerr=   rD   r
   rF   r   r   r   r   <module>   s   
                                                                                                                                                                                                                                                               python3.7/site-packages/raven/transport/__pycache__/base.cpython-37.pyc                             0000644                 00000003243 15107360271 0021761 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s8   d Z ddlmZ dZG dd deZG dd deZdS )	z
raven.transport.base
~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importTc               @   s    e Zd ZdZdZg Zdd ZdS )	Transportz
    All transport implementations need to subclass this class

    You must implement a send method (or an async_send method if
    sub-classing AsyncTransport).
    Fc             C   s   t dS )z
        You need to override this to do something with the actual
        data. Usually - this is sending to a server
        N)NotImplementedError)selfurldataheaders r	   E/opt/alt/python37/lib/python3.7/site-packages/raven/transport/base.pysend   s    zTransport.sendN)__name__
__module____qualname____doc__is_asyncschemer   r	   r	   r	   r
   r      s   r   c               @   s   e Zd ZdZdZdd ZdS )AsyncTransportz
    All asynchronous transport implementations should subclass this
    class.

    You must implement a async_send method.
    Tc             C   s   t dS )z
        Override this method for asynchronous transports. Call
        `success_cb()` if the send succeeds or `error_cb(exception)`
        if the send fails.
        N)r   )r   r   r   r   Z
success_cbZerror_cbr	   r	   r
   
async_send,   s    zAsyncTransport.async_sendN)r   r
   r   r   r   r   r	   r	   r	   r
   r   "   s   r   N)r   
__future__r   Zhas_newstyle_transportsobjectr   r   r	   r	   r	   r
   <module>   s                                                                                                                                                                                                                                                                                                                                                                python3.7/site-packages/raven/transport/__pycache__/threaded_requests.cpython-37.pyc                0000644                 00000003031 15107360271 0024555 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    YF                 @   sJ   d Z ddlmZ ddlmZ ddlmZ ddlmZ G dd deeZ	dS )	z
raven.transport.threaded_requests
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)AsyncTransport)RequestsHTTPTransport)AsyncWorkerc                   s4   e Zd ZddgZdd Z fddZdd Z  ZS )	ThreadedRequestsHTTPTransportzthreaded+requests+httpzthreaded+requests+httpsc             C   s   t | dst | _| jS )N_worker)hasattrr   r   )self r
   R/opt/alt/python37/lib/python3.7/site-packages/raven/transport/threaded_requests.py
get_worker   s    
z(ThreadedRequestsHTTPTransport.get_workerc          
      sN   yt t| ||| W n* tk
rB } z|| W d d }~X Y nX |  d S )N)superr   send	Exception)r	   urldataheaders
success_cb
failure_cbe)	__class__r
   r   	send_sync   s
    z'ThreadedRequestsHTTPTransport.send_syncc             C   s   |   | j||||| d S )N)r   queuer   )r	   r   r   r   r   r   r
   r
   r   
async_send    s    z(ThreadedRequestsHTTPTransport.async_send)__name__
__module____qualname__schemer   r   r   
__classcell__r
   r
   )r   r   r      s   r   N)
__doc__
__future__r   Zraven.transport.baser   Zraven.transportr   Zraven.transport.threadedr   r   r
   r
   r
   r   <module>   s
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          python3.7/site-packages/raven/transport/requests.py                                                 0000644                 00000002000 15107360271 0016423 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.requests
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from raven.transport.http import HTTPTransport

try:
    import requests
    has_requests = True
except ImportError:
    has_requests = False


class RequestsHTTPTransport(HTTPTransport):

    scheme = ['requests+http', 'requests+https']

    def __init__(self, *args, **kwargs):
        if not has_requests:
            raise ImportError('RequestsHTTPTransport requires requests.')

        super(RequestsHTTPTransport, self).__init__(*args, **kwargs)

    def send(self, url, data, headers):
        if self.verify_ssl:
            # If SSL verification is enabled use the provided CA bundle to
            # perform the verification.
            self.verify_ssl = self.ca_certs
        requests.post(url, data=data, headers=headers,
                      verify=self.verify_ssl, timeout=self.timeout)
python3.7/site-packages/raven/transport/registry.py                                                 0000644                 00000005056 15107360271 0016436 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.registry
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

# TODO(dcramer): we really should need to import all of these by default
from raven.transport.eventlet import EventletHTTPTransport
from raven.transport.exceptions import DuplicateScheme
from raven.transport.http import HTTPTransport
from raven.transport.gevent import GeventedHTTPTransport
from raven.transport.requests import RequestsHTTPTransport
from raven.transport.threaded import ThreadedHTTPTransport
from raven.transport.threaded_requests import ThreadedRequestsHTTPTransport
from raven.transport.twisted import TwistedHTTPTransport
from raven.transport.tornado import TornadoHTTPTransport
from raven.utils import urlparse


class TransportRegistry(object):
    def __init__(self, transports=None):
        # setup a default list of senders
        self._schemes = {}
        self._transports = {}

        if transports:
            for transport in transports:
                self.register_transport(transport)

    def register_transport(self, transport):
        if not hasattr(transport, 'scheme') or not hasattr(transport.scheme, '__iter__'):
            raise AttributeError('Transport %s must have a scheme list', transport.__class__.__name__)

        for scheme in transport.scheme:
            self.register_scheme(scheme, transport)

    def register_scheme(self, scheme, cls):
        """
        It is possible to inject new schemes at runtime
        """
        if scheme in self._schemes:
            raise DuplicateScheme()

        urlparse.register_scheme(scheme)
        # TODO (vng): verify the interface of the new class
        self._schemes[scheme] = cls

    def supported_scheme(self, scheme):
        return scheme in self._schemes

    def get_transport(self, parsed_url, **options):
        full_url = parsed_url.geturl()
        if full_url not in self._transports:
            # Remove the options from the parsed_url
            parsed_url = urlparse.urlparse(full_url.split('?')[0])
            self._transports[full_url] = self._schemes[parsed_url.scheme](parsed_url, **options)
        return self._transports[full_url]

    def get_transport_cls(self, scheme):
        return self._schemes[scheme]


default_transports = [
    HTTPTransport,
    ThreadedHTTPTransport,
    GeventedHTTPTransport,
    TwistedHTTPTransport,
    RequestsHTTPTransport,
    ThreadedRequestsHTTPTransport,
    TornadoHTTPTransport,
    EventletHTTPTransport,
]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  python3.7/site-packages/raven/transport/base.py                                                     0000644                 00000002303 15107360271 0015470 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.base
~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import


# Helper for external transports
has_newstyle_transports = True


class Transport(object):
    """
    All transport implementations need to subclass this class

    You must implement a send method (or an async_send method if
    sub-classing AsyncTransport).
    """

    is_async = False
    scheme = []

    def send(self, url, data, headers):
        """
        You need to override this to do something with the actual
        data. Usually - this is sending to a server
        """
        raise NotImplementedError


class AsyncTransport(Transport):
    """
    All asynchronous transport implementations should subclass this
    class.

    You must implement a async_send method.
    """

    is_async = True

    def async_send(self, url, data, headers, success_cb, error_cb):
        """
        Override this method for asynchronous transports. Call
        `success_cb()` if the send succeeds or `error_cb(exception)`
        if the send fails.
        """
        raise NotImplementedError
                                                                                                                                                                                                                                                                                                                             python3.7/site-packages/raven/transport/exceptions.py                                               0000644                 00000001005 15107360271 0016735 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.exceptions
~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import


class InvalidScheme(ValueError):
    """
    Raised when a transport is constructed using a URI which is not
    handled by the transport
    """


class DuplicateScheme(Exception):
    """
    Raised when registering a handler for a particular scheme which
    is already registered
    """
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           python3.7/site-packages/raven/transport/eventlet.py                                                 0000644                 00000002777 15107360271 0016423 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.eventlet
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import sys

from raven.transport.http import HTTPTransport

try:
    import eventlet
    try:
        from eventlet.green import urllib2 as eventlet_urllib2
    except ImportError:
        from eventlet.green.urllib import request as eventlet_urllib2
    has_eventlet = True
except ImportError:
    has_eventlet = False


class EventletHTTPTransport(HTTPTransport):

    scheme = ['eventlet+http', 'eventlet+https']

    def __init__(self, pool_size=100, **kwargs):
        if not has_eventlet:
            raise ImportError('EventletHTTPTransport requires eventlet.')
        super(EventletHTTPTransport, self).__init__(**kwargs)

    def _send_payload(self, payload):
        url, data, headers = payload
        req = eventlet_urllib2.Request(url, headers=headers)
        try:
            if sys.version_info < (2, 6):
                response = eventlet_urllib2.urlopen(req, data).read()
            else:
                response = eventlet_urllib2.urlopen(req, data,
                                                    self.timeout).read()
            return response
        except Exception as err:
            return err

    def send(self, url, data, headers):
        """
        Spawn an async request to a remote webserver.
        """
        eventlet.spawn(self._send_payload, (url, data, headers))
 python3.7/site-packages/raven/transport/__init__.py                                                 0000644                 00000001420 15107360272 0016315 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport
~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
# TODO: deprecate this namespace and force non-default (sync + threaded) to
# manually import/register transports somehow
from __future__ import absolute_import

from raven.transport.base import *  # NOQA
from raven.transport.eventlet import *  # NOQA
from raven.transport.exceptions import *  # NOQA
from raven.transport.gevent import *  # NOQA
from raven.transport.http import *  # NOQA
from raven.transport.requests import *  # NOQA
from raven.transport.registry import *  # NOQA
from raven.transport.twisted import *  # NOQA
from raven.transport.threaded import *  # NOQA
from raven.transport.tornado import *  # NOQA
                                                                                                                                                                                                                                                python3.7/site-packages/raven/transport/twisted.py                                                  0000644                 00000004422 15107360272 0016246 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.transport.twisted
~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import


from raven.utils.compat import BytesIO
from raven.transport.base import AsyncTransport
from raven.transport.http import HTTPTransport

try:
    from twisted.web.client import (
        Agent, FileBodyProducer, HTTPConnectionPool, ResponseNeverReceived,
        readBody,
    )
    from twisted.web.http_headers import Headers
    has_twisted = True
except ImportError:
    has_twisted = False


class TwistedHTTPTransport(AsyncTransport, HTTPTransport):
    scheme = ['twisted+http', 'twisted+https']

    def __init__(self, *args, **kwargs):
        if not has_twisted:
            raise ImportError('TwistedHTTPTransport requires twisted.web.')

        super(TwistedHTTPTransport, self).__init__(*args, **kwargs)

        # Import reactor as late as possible.
        from twisted.internet import reactor

        # Use a persistent connection pool.
        self._agent = Agent(reactor, pool=HTTPConnectionPool(reactor))

    def async_send(self, url, data, headers, success_cb, failure_cb):
        d = self._agent.request(
            b"POST", url,
            bodyProducer=FileBodyProducer(BytesIO(data)),
            headers=Headers(dict((k, [v]) for k, v in headers.items()))
        )

        def on_failure(failure):
            ex = failure.check(ResponseNeverReceived)
            if ex:
                # ResponseNeverReceived wraps the actual error(s).
                failure_cb([f.value for f in failure.value.reasons])
            else:
                failure_cb(failure.value)

        def on_success(response):
            """
            Success only means that the request succeeded, *not* that the
            actual submission was successful.
            """
            if response.code == 200:
                success_cb()
            else:
                def on_error_body(body):
                    failure_cb(Exception(response.code, response.phrase, body))

                return readBody(response).addCallback(
                    on_error_body,
                )

        d.addCallback(
            on_success,
        ).addErrback(
            on_failure,
        )
                                                                                                                                                                                                                                              python3.7/site-packages/raven/__init__.py                                                           0000644                 00000002434 15107360272 0014267 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven
~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import os
import os.path

__all__ = ('VERSION', 'Client', 'get_version')

VERSION = '6.3.0'


def _get_git_revision(path):
    revision_file = os.path.join(path, 'refs', 'heads', 'master')
    if not os.path.exists(revision_file):
        return None
    fh = open(revision_file, 'r')
    try:
        return fh.read().strip()[:7]
    finally:
        fh.close()


def get_revision():
    """
    :returns: Revision number of this branch/checkout, if available. None if
        no revision number can be determined.
    """
    package_dir = os.path.dirname(__file__)
    checkout_dir = os.path.normpath(os.path.join(package_dir, os.pardir, os.pardir))
    path = os.path.join(checkout_dir, '.git')
    if os.path.exists(path):
        return _get_git_revision(path)
    return None


def get_version():
    base = VERSION
    if __build__:
        base = '%s (%s)' % (base, __build__)
    return base


__build__ = get_revision()
__docformat__ = 'restructuredtext en'


# Declare child imports last to prevent recursion
from raven.base import *  # NOQA
from raven.conf import *  # NOQA
from raven.versioning import *  # NOQA
                                                                                                                                                                                                                                    python3.7/site-packages/raven/versioning.py                                                         0000644                 00000005050 15107360272 0014710 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import

import os.path

try:
    import pkg_resources
except ImportError:
    # pkg_resource is not available on Google App Engine
    pkg_resources = None

from raven.utils.compat import text_type
from .exceptions import InvalidGitRepository

__all__ = ('fetch_git_sha', 'fetch_package_version')


def fetch_git_sha(path, head=None):
    """
    >>> fetch_git_sha(os.path.dirname(__file__))
    """
    if not head:
        head_path = os.path.join(path, '.git', 'HEAD')
        if not os.path.exists(head_path):
            raise InvalidGitRepository(
                'Cannot identify HEAD for git repository at %s' % (path,))

        with open(head_path, 'r') as fp:
            head = text_type(fp.read()).strip()

        if head.startswith('ref: '):
            head = head[5:]
            revision_file = os.path.join(
                path, '.git', *head.split('/')
            )
        else:
            return head
    else:
        revision_file = os.path.join(path, '.git', 'refs', 'heads', head)

    if not os.path.exists(revision_file):
        if not os.path.exists(os.path.join(path, '.git')):
            raise InvalidGitRepository(
                '%s does not seem to be the root of a git repository' % (path,))

        # Check for our .git/packed-refs' file since a `git gc` may have run
        # https://git-scm.com/book/en/v2/Git-Internals-Maintenance-and-Data-Recovery
        packed_file = os.path.join(path, '.git', 'packed-refs')
        if os.path.exists(packed_file):
            with open(packed_file, 'r') as fh:
                for line in fh:
                    line = line.rstrip()
                    if not line:
                        continue
                    if line[:1] in ('#', '^'):
                        continue
                    try:
                        revision, ref = line.split(' ', 1)
                    except ValueError:
                        continue
                    if ref == head:
                        return text_type(revision)

        raise InvalidGitRepository(
            'Unable to find ref to head "%s" in repository' % (head,))

    fh = open(revision_file, 'r')
    try:
        return text_type(fh.read()).strip()
    finally:
        fh.close()


def fetch_package_version(dist_name):
    """
    >>> fetch_package_version('sentry')
    """
    if pkg_resources is None:
        raise NotImplementedError('pkg_resources is not available '
                                  'on this Python install')
    dist = pkg_resources.get_distribution(dist_name)
    return dist.version
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        python3.7/site-packages/raven/conf/defaults.py                                                      0000644                 00000002616 15107360272 0015266 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.conf.defaults
~~~~~~~~~~~~~~~~~~~

Represents the default values for all Sentry settings.

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import os
import os.path
import socket

ROOT = os.path.normpath(os.path.join(os.path.dirname(__file__), os.pardir))

TIMEOUT = 5

# TODO: this is specific to Django
CLIENT = 'raven.contrib.django.DjangoClient'

# Not all environments have access to socket module, for example Google App Engine
# Need to check to see if the socket module has ``gethostname``, if it doesn't we
# will set it to None and require it passed in to ``Client`` on initializtion.
NAME = socket.gethostname() if hasattr(socket, 'gethostname') else None

# The maximum number of elements to store for a list-like structure.
MAX_LENGTH_LIST = 50

# The maximum length to store of a string-like structure.
MAX_LENGTH_STRING = 400

# Automatically log frame stacks from all ``logging`` messages.
AUTO_LOG_STACKS = False

# Collect locals variables
CAPTURE_LOCALS = True

# Client-side data processors to apply
PROCESSORS = (
    'raven.processors.SanitizePasswordsProcessor',
)

try:
    # Try for certifi first since they likely keep their bundle more up to date
    import certifi
    CA_BUNDLE = certifi.where()
except ImportError:
    CA_BUNDLE = '/etc/pki/tls/certs/ca-bundle.crt'
                                                                                                                  python3.7/site-packages/raven/conf/__pycache__/remote.cpython-37.pyc                                0000644                 00000006747 15107360272 0021250 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s   d dl mZ d dlZd dlZd dlZd dlmZmZ d dlm	Z	 d dl
mZ d dlm
Z
mZ dZedZd	d
 Ze ZG dd deZdS )
    )absolute_importN)PY2	text_type)
InvalidDsn)	to_string)	parse_qslurlparsez(Unsupported Sentry DSN scheme: {0} ({1})ravenc              C   sV   ddl m}  ddlm} dtjkr:dtjkr:td |S dtjkrRtd |S | S )	Nr   )ThreadedHTTPTransport)
HTTPTransportZCURRENT_VERSION_IDZINSTANCE_IDzODetected environment to be Google App Engine. Using synchronous HTTP transport.ZLAMBDA_TASK_ROOTzHDetected environment to be AWS Lambda. Using synchronous HTTP transport.)Zraven.transport.threadedr
   Zraven.transport.httpr   osenvironloggerinfo)r
   r    r   B/opt/alt/python37/lib/python3.7/site-packages/raven/conf/remote.pydiscover_default_transport   s    


r   c               @   sD   e Zd ZdddZdd Zdd Zdd	 Zd
d Zeddd
Z	dS )RemoteConfigNc             C   sV   |r| d}d||f }nd }|| _|| _|| _|| _|p>i | _|| _|pNt| _d S )N/z%s/api/%s/store/)	rstripbase_urlproject
public_key
secret_keyoptionsstore_endpointDEFAULT_TRANSPORT_transport_cls)selfr   r   r   r   	transportr   r   r   r   r   __init__(   s    

zRemoteConfig.__init__c             C   s
   t | jS )N)r   r   )r   r   r   r   __unicode__9   s    zRemoteConfig.__unicode__c             C   s   t | j| j| j| jgS )N)allr   r   r   r   )r   r   r   r   	is_active<   s    zRemoteConfig.is_activec             C   s*   | j s
d S t| ds$| jf | j| _| jS )N
_transport)r   hasattrr   r   r$   )r   r   r   r   
get_transport?   s
    
zRemoteConfig.get_transportc             C   s:   t | j}|j}|jr$|d|j 7 }d| j||j| jf S )Nz:%sz//%s@%s%s/%s)r   r   hostnameportr   pathr   )r   urlnetlocr   r   r   get_public_dsnG   s
    
zRemoteConfig.get_public_dsnc             C   s&  t rt|}t| }|jdkr,td |d krz|sPddlm}m	} ||}|
|jsntt
|j|||j}|j}|jr|d|j 7 }|jdd}t|dkr|d }	nd}	|d	 }
t||
|j|jgstd
|  d|jddd	 ||	f }| ||
|j|jtt|j|d
S )N)httphttpsznTransport selection via DSN is deprecated. You should explicitly pass the transport class to Client() instead.r   )TransportRegistrydefault_transportsz:%sr       zInvalid Sentry DSN: %rz	%s://%s%s+)r   r   r   r   r   r   )r   r   r   stripschemewarningswarnZraven.transportr/   r0   Zsupported_schemer   ERR_UNKNOWN_SCHEMEformatZget_transport_clsr'   r(   r)   rsplitlenr"   usernamepasswordgeturldictr   query)clsvaluer   Ztransport_registryr*   r/   r0   r+   Z	path_bitsr)   r   r   r   r   r   from_stringN   s<    


zRemoteConfig.from_string)NNNNNN)NN)
__name__
__module____qualname__r    r!   r#   r&   r,   classmethodrD   r   r   r   r   r   '   s    
r   )
__future__r   loggingr   r7   Zraven.utils.compatr   r   Zraven.exceptionsr   Zraven.utils.encodingr   Zraven.utils.urlparser   r   r9   	getLoggerr   r   r   objectr   r   r   r   r   <module>   s   
                         python3.7/site-packages/raven/conf/__pycache__/__init__.cpython-37.pyc                              0000644                 00000002421 15107360272 0021475 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s2   d Z ddlmZ ddlZdgZdZefddZdS )z
raven.conf
~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN
setup_logging)ravenZgunicornZsouthz
sentry.errorszdjango.requestc             C   sX   t  }| jtt|jkrdS ||  x*|D ]"}t |}d|_|t   q.W dS )a  
    Configures logging to pipe to Sentry.

    - ``exclude`` is a list of loggers that shouldn't go to Sentry.

    For a typical Python install:

    >>> from raven.handlers.logging import SentryHandler
    >>> client = Sentry(...)
    >>> setup_logging(SentryHandler(client))

    Within Django:

    >>> from raven.contrib.django.handlers import SentryHandler
    >>> setup_logging(SentryHandler())

    Returns a boolean based on if logging was configured or not.
    FT)	logging	getLogger	__class__maptypehandlers
addHandler	propagate
StreamHandler)handlerexcludeloggerlogger_name r   D/opt/alt/python37/lib/python3.7/site-packages/raven/conf/__init__.pyr      