B

    ߀Se                 @   s   d Z ddlmZ ddlZddlZddlZejejej	e
ejZdZ
dZeedrbe ndZdZdZd	Zd
ZdZyddlZe ZW n ek
r   dZY nX dS )
z
raven.conf.defaults
~~~~~~~~~~~~~~~~~~~

Represents the default values for all Sentry settings.

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN   z!raven.contrib.django.DjangoClientgethostname2   i  FT)z+raven.processors.SanitizePasswordsProcessorz /etc/pki/tls/certs/ca-bundle.crt)__doc__
__future__r   osos.pathsocketpathnormpathjoindirname__file__pardirZROOTZTIMEOUTZCLIENThasattrr   NAMEZMAX_LENGTH_LISTZMAX_LENGTH_STRINGZAUTO_LOG_STACKSZCAPTURE_LOCALSZ
PROCESSORSZcertifiwhereZ	CA_BUNDLEImportError r   r   D/opt/alt/python37/lib/python3.7/site-packages/raven/conf/defaults.py<module>	   s$                     python3.7/site-packages/raven/conf/remote.py                                                        0000644                 00000010022 15107360272 0014740 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import

import logging
import os
import warnings

from raven.utils.compat import PY2, text_type
from raven.exceptions import InvalidDsn
from raven.utils.encoding import to_string
from raven.utils.urlparse import parse_qsl, urlparse

ERR_UNKNOWN_SCHEME = 'Unsupported Sentry DSN scheme: {0} ({1})'

logger = logging.getLogger('raven')


def discover_default_transport():
    from raven.transport.threaded import ThreadedHTTPTransport
    from raven.transport.http import HTTPTransport

    # Google App Engine
    # https://cloud.google.com/appengine/docs/python/how-requests-are-handled#Python_The_environment
    if 'CURRENT_VERSION_ID' in os.environ and 'INSTANCE_ID' in os.environ:
        logger.info('Detected environment to be Google App Engine. Using synchronous HTTP transport.')
        return HTTPTransport

    # AWS Lambda
    # https://alestic.com/2014/11/aws-lambda-environment/
    if 'LAMBDA_TASK_ROOT' in os.environ:
        logger.info('Detected environment to be AWS Lambda. Using synchronous HTTP transport.')
        return HTTPTransport

    return ThreadedHTTPTransport


DEFAULT_TRANSPORT = discover_default_transport()


class RemoteConfig(object):
    def __init__(self, base_url=None, project=None, public_key=None,
                 secret_key=None, transport=None, options=None):
        if base_url:
            base_url = base_url.rstrip('/')
            store_endpoint = '%s/api/%s/store/' % (base_url, project)
        else:
            store_endpoint = None

        self.base_url = base_url
        self.project = project
        self.public_key = public_key
        self.secret_key = secret_key
        self.options = options or {}
        self.store_endpoint = store_endpoint

        self._transport_cls = transport or DEFAULT_TRANSPORT

    def __unicode__(self):
        return text_type(self.base_url)

    def is_active(self):
        return all([self.base_url, self.project, self.public_key, self.secret_key])

    def get_transport(self):
        if not self.store_endpoint:
            return

        if not hasattr(self, '_transport'):
            self._transport = self._transport_cls(**self.options)
        return self._transport

    def get_public_dsn(self):
        url = urlparse(self.base_url)
        netloc = url.hostname
        if url.port:
            netloc += ':%s' % url.port
        return '//%s@%s%s/%s' % (self.public_key, netloc, url.path, self.project)

    @classmethod
    def from_string(cls, value, transport=None, transport_registry=None):
        # in Python 2.x sending the DSN as a unicode value will eventually
        # cause issues in httplib
        if PY2:
            value = to_string(value)

        url = urlparse(value.strip())

        if url.scheme not in ('http', 'https'):
            warnings.warn('Transport selection via DSN is deprecated. You should explicitly pass the transport class to Client() instead.')

        if transport is None:
            if not transport_registry:
                from raven.transport import TransportRegistry, default_transports
                transport_registry = TransportRegistry(default_transports)

            if not transport_registry.supported_scheme(url.scheme):
                raise InvalidDsn(ERR_UNKNOWN_SCHEME.format(url.scheme, value))

            transport = transport_registry.get_transport_cls(url.scheme)

        netloc = url.hostname
        if url.port:
            netloc += ':%s' % url.port

        path_bits = url.path.rsplit('/', 1)
        if len(path_bits) > 1:
            path = path_bits[0]
        else:
            path = ''
        project = path_bits[-1]

        if not all([netloc, project, url.username, url.password]):
            raise InvalidDsn('Invalid Sentry DSN: %r' % url.geturl())

        base_url = '%s://%s%s' % (url.scheme.rsplit('+', 1)[-1], netloc, path)

        return cls(
            base_url=base_url,
            project=project,
            public_key=url.username,
            secret_key=url.password,
            options=dict(parse_qsl(url.query)),
            transport=transport,
        )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              python3.7/site-packages/raven/conf/__init__.py                                                      0000644                 00000002426 15107360272 0015215 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.conf
~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import logging

__all__ = ['setup_logging']

EXCLUDE_LOGGER_DEFAULTS = (
    'raven',
    'gunicorn',
    'south',
    'sentry.errors',
    'django.request',
)


def setup_logging(handler, exclude=EXCLUDE_LOGGER_DEFAULTS):
    """
    Configures logging to pipe to Sentry.

    - ``exclude`` is a list of loggers that shouldn't go to Sentry.

    For a typical Python install:

    >>> from raven.handlers.logging import SentryHandler
    >>> client = Sentry(...)
    >>> setup_logging(SentryHandler(client))

    Within Django:

    >>> from raven.contrib.django.handlers import SentryHandler
    >>> setup_logging(SentryHandler())

    Returns a boolean based on if logging was configured or not.
    """
    logger = logging.getLogger()
    if handler.__class__ in map(type, logger.handlers):
        return False

    logger.addHandler(handler)

    # Add StreamHandler to sentry's default so you can catch missed exceptions
    for logger_name in exclude:
        logger = logging.getLogger(logger_name)
        logger.propagate = False
        logger.addHandler(logging.StreamHandler())

    return True
                                                                                                                                                                                                                                          python3.7/site-packages/filelock/_soft.py                                                           0000644                 00000003162 15107360272 0014316 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import annotations

import os
import sys
from errno import EACCES, EEXIST, ENOENT

from ._api import BaseFileLock
from ._util import raise_on_exist_ro_file


class SoftFileLock(BaseFileLock):
    """Simply watches the existence of the lock file."""

    def _acquire(self) -> None:
        raise_on_exist_ro_file(self._lock_file)
        # first check for exists and read-only mode as the open will mask this case as EEXIST
        mode = (
            os.O_WRONLY  # open for writing only
            | os.O_CREAT
            | os.O_EXCL  # together with above raise EEXIST if the file specified by filename exists
            | os.O_TRUNC  # truncate the file to zero byte
        )
        try:
            fd = os.open(self._lock_file, mode)
        except OSError as exception:
            if exception.errno == EEXIST:  # expected if cannot lock
                pass
            elif exception.errno == ENOENT:  # No such file or directory - parent directory is missing
                raise
            elif exception.errno == EACCES and sys.platform != "win32":  # pragma: win32 no cover
                # Permission denied - parent dir is R/O
                raise  # note windows does not allow you to make a folder r/o only files
        else:
            self._lock_file_fd = fd

    def _release(self) -> None:
        os.close(self._lock_file_fd)  # type: ignore # the lock file is definitely not None
        self._lock_file_fd = None
        try:
            os.remove(self._lock_file)
        except OSError:  # the file is already deleted and that's what we want
            pass


__all__ = [
    "SoftFileLock",
]
                                                                                                                                                                                                                                                                                                                                                                                                              python3.7/site-packages/filelock/__pycache__/_util.cpython-37.pyc                                   0000644                 00000001103 15107360272 0020576 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    aR                 @  s6   d dl mZ d dlZd dlZdddddZdgZdS )    )annotationsNstrNone)filenamereturnc             C  sL   yt | }W n tk
r"   d S X |jdkrH|jtj@ sHtd| d S )Nr   zPermission denied: )osstatOSErrorst_mtimest_modeS_IWUSRPermissionError)r   Z	file_stat r   ?/opt/alt/python37/lib/python3.7/site-packages/filelock/_util.pyraise_on_exist_ro_file   s    
r   )
__future__r   r   r   r   __all__r   r   r   r   <module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                python3.7/site-packages/filelock/__pycache__/__init__.cpython-37.pyc                                0000644                 00000001744 15107360272 0021234 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    a                 @  s   U d Z ddlmZ ddlZddlZddlmZmZ ddlm	Z	 ddl
mZ ddlm
Z
mZ dd	lmZ dd
lmZ eZded< ejd
kreZded< n(ere
Zded< neZedk	red eZded< ddddddddgZdS )zw
A platform independent file lock that supports the with-statement.

.. autodata:: filelock.__version__
   :no-value:

    )annotationsN   )AcquireReturnProxyBaseFileLock)Timeout)SoftFileLock)UnixFileLock	has_fcntl)WindowsFileLock)versionstr__version__win32ztype[BaseFileLock]	_FileLockz only soft file lock is availableFileLockr   r   r   r
   r   r   )__doc__
__future__r   syswarningsZ_apir   r   _errorr   Z_softr   Z_unixr   r	   Z_windowsr
   r   r
   __annotations__platformr   warnr   __all__ r   r   B/opt/alt/python37/lib/python3.7/site-packages/filelock/__init__.py<module>   s4   

                            python3.7/site-packages/filelock/__pycache__/version.cpython-37.pyc                                 0000644                 00000000317 15107360272 0021155 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    a                  @   s   d Z dZdS )z3.4.2)         N)versionZ
version_tuple r   r   A/opt/alt/python37/lib/python3.7/site-packages/filelock/version.py<module>   s                                                                                                                                                                                                                                                                                                                    python3.7/site-packages/filelock/__pycache__/_api.cpython-37.pyc                                    0000644                 00000016473 15107360272 0020412 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    a                  @  s   d dl mZ d dlZd dlZd dlZd dlZd dlmZmZ d dl	m
Z
 d dlmZ d dl
mZ ddlmZ ed	ZG d
d dZG dd
 d
eZd
dgZdS )    )annotationsN)ABCabstractmethod)Lock)
TracebackType)Any   )TimeoutZfilelockc               @  sB   e Zd ZdZdddddZdddd	Zd
dddd
ddZdS )AcquireReturnProxyzDA context aware object that will release the lock file when exiting.BaseFileLockNone)lockreturnc             C  s
   || _ d S )N)r
   )selfr
    r   >/opt/alt/python37/lib/python3.7/site-packages/filelock/_api.py__init__   s    zAcquireReturnProxy.__init__)r   c             C  s   | j S )N)r
   )r   r   r   r   	__enter__   s    zAcquireReturnProxy.__enter__ztype[BaseException] | NonezBaseException | NonezTracebackType | None)exc_type	exc_value	tracebackr   c             C  s   | j   d S )N)r
   release)r   r   r   r   r   r   r   __exit__   s    zAcquireReturnProxy.__exit__N)__name__
__module____qualname____doc__r   r   r   r   r   r   r   r
      s   r
   c               @  s   e Zd ZdZd/ddddddZed	d
ddZedd
d
dZejdddddZe	dd
ddZ
e	dd
ddZedd
ddZd0ddddddddd Z
d1ddd"d#d$Zd d
d%d&Zd'd(d)dd*d+d,Zdd
d-d.ZdS )2r   z+Abstract base class for a file lock object.zstr | os.PathLike[Any]floatr   )	lock_filetimeoutr   c             C  s*   t || _d| _|| _t | _d| _dS )a  
        Create a new lock object.

        :param lock_file: path to the file
        :param timeout: default timeout when acquiring the lock. It will be used as fallback value in the acquire
        method, if no timeout value (``None``) is given. If you want to disable the timeout, set it to a negative value.
         A timeout of 0 means, that there is exactly one attempt to acquire the file lock.
        Nr   )osfspath
_lock_file
_lock_file_fdr    r   _thread_lock
_lock_counter)r   r   r    r   r   r   r   )   s
    
zBaseFileLock.__init__str)r   c             C  s   | j S )z:return: path to the lock file)r#   )r   r   r   r   r   C   s    zBaseFileLock.lock_filec             C  s   | j S )zU
        :return: the default timeout value

        .. versionadded:: 2.0.0
        )_timeout)r   r   r   r   r    H   s    zBaseFileLock.timeoutzfloat | str)valuer   c             C  s   t || _dS )zX
        Change the default timeout value.

        :param value: the new value
        N)r   r(   )r   r)   r   r   r   r    Q   s    c             C  s   t dS )zbIf the file lock could be acquired, self._lock_file_fd holds the file descriptor of the lock file.N)NotImplementedError)r   r   r   r   _acquireZ   s    zBaseFileLock._acquirec             C  s   t dS )z6Releases the lock and sets self._lock_file_fd to None.N)r*   )r   r   r   r   _release_   s    zBaseFileLock._releaseboolc             C  s
   | j dk	S )z

        :return: A boolean indicating if the lock file is holding the lock currently.

        .. versionchanged:: 2.0.0

            This was previously a method and is now a property.
        N)r$   )r   r   r   r   	is_lockedd   s    
zBaseFileLock.is_lockedN皙?)poll_intervallzfloat | Noner
   )r    
poll_intervalr0   r   c            C  sT  |dkr| j }|dk	r.d}tj|tdd |}| j |  jd7  _W dQ R X t| }| j}t }yx| j" | j	st
d|| |   W dQ R X | j	rt
d|| P qhd|  krt | k rn nt
d	|| t
| jqhd
}t
|||| t| qhW W n< tk
rH   | j td| jd | _W dQ R X  Y nX t| dS )az  
        Try to acquire the file lock.

        :param timeout: maximum wait time for acquiring the lock, ``None`` means use the default :attr:`~timeout` is and
         if ``timeout < 0``, there is no timeout and this method will block until the lock could be acquired
        :param poll_interval: interval of trying to acquire the lock file
        :param poll_intervall: deprecated, kept for backwards compatibility, use ``poll_interval`` instead
        :raises Timeout: if fails to acquire lock within the timeout period
        :return: a context object that will unlock the file when the context is exited

        .. code-block:: python

            # You can use this method in the context manager (recommended)
            with lock.acquire():
                pass

            # Or use an equivalent try-finally construct:
            lock.acquire()
            try:
                pass
            finally:
                lock.release()

        .. versionchanged:: 2.0.0

            This method returns now a *proxy* object instead of *self*,
            so that it can be used in a with statement without side effects.

        Nz+use poll_interval instead of poll_intervall   )
stacklevelr   z#Attempting to acquire lock %s on %szLock %s acquired on %sr   z"Timeout on acquiring lock %s on %sz2Lock %s not acquired on %s, waiting %s seconds ...)r
   )r    warningswarnDeprecationWarningr%   r&   idr#   timer.   _LOGGERdebugr+   r	   sleep
BaseExceptionmaxr
   )r   r    r1   r0   msglock_id
lock_filenameZ
start_timer   r   r   acquirep   s>    % zBaseFileLock.acquireF)forcer   c          	   C  sr   | j b | jrd|  jd8  _| jdks*|rdt| | j }}td|| |   d| _td|| W dQ R X dS )a*  
        Releases the file lock. Please note, that the lock is only completely released, if the lock counter is 0. Also
        note, that the lock file itself is not automatically deleted.

        :param force: If true, the lock counter is ignored and the lock is released in every case/
        r   r   z#Attempting to release lock %s on %szLock %s released on %sN)r%   r.   r&   r7   r#   r9   r:   r,   )r   rB   r?   r@   r   r   r   r      s    zBaseFileLock.releasec             C  s   |    | S )zE
        Acquire the lock.

        :return: the lock object
        )rA   )r   r   r   r   r      s    zBaseFileLock.__enter__ztype[BaseException] | NonezBaseException | NonezTracebackType | None)r   r   r   r   c             C  s   |    dS )z
        Release the lock.

        :param exc_type: the exception type if raised
        :param exc_value: the exception value if raised
        :param traceback: the exception traceback if raised
        N)r   )r   r   r   r   r   r   r   r      s    
zBaseFileLock.__exit__c             C  s   | j dd dS )z'Called when the lock object is deleted.T)rB   N)r   )r   r   r   r   __del__   s    zBaseFileLock.__del__)r   )Nr/   )F)r   r   r   r   r   propertyr   r    setterr   r+   r,   r.   rA   r   r   r   rC   r   r   r   r   r   &   s   		 F	r   )
__future__r   loggingr!   r8   r4   abcr   r   	threadingr   typesr   typingr   _errorr	   	getLoggerr9   r
   r   __all__r   r   r   r   <module>   s   
 H                                                                                                                                                                                                     python3.7/site-packages/filelock/__pycache__/_soft.cpython-37.pyc                                   0000644                 00000002431 15107360273 0020602 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    ar                 @  sb   d dl mZ d dlZd dlZd dlmZmZmZ ddlm	Z	 ddl
mZ G dd de	ZdgZ
dS )	    )annotationsN)EACCESEEXISTENOENT   )BaseFileLock)raise_on_exist_ro_filec               @  s,   e Zd ZdZddddZddddZdS )	SoftFileLockz.Simply watches the existence of the lock file.None)returnc          
   C  s   t | j tjtjB tjB tjB }yt| j|}W nR tk
r } z4|j	t
krRn$|j	tkr` n|j	tkrvt
jdkrv W d d }~X Y nX || _d S )Nwin32)r   
_lock_fileosO_WRONLYO_CREATO_EXCLO_TRUNCopenOSErrorerrnor   r   r   sysplatform
_lock_file_fd)selfmodefd	exception r   ?/opt/alt/python37/lib/python3.7/site-packages/filelock/_soft.py_acquire   s    


zSoftFileLock._acquirec             C  s<   t | j d | _yt | j W n tk
r6   Y nX d S )N)r   closer   remover
   r   )r   r   r   r   _release$   s    zSoftFileLock._releaseN)__name__
__module____qualname____doc__r   r"   r   r   r   r   r	      s   r	   )
__future__r   r   r   r   r   r   r   Z_apir   Z_utilr   r	   __all__r   r   r   r   <module>   s   #                                                                                                                                                                                                                                       python3.7/site-packages/filelock/__pycache__/_windows.cpython-37.pyc                                0000644                 00000003300 15107360273 0021315 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    a                 @  s   d dl mZ d dlZd dlZd dlmZ d dlmZ d dlm	Z	 ddl
mZ ddlm
Z
 ejd	kr|d dlZG d
d deZnG dd deeZdgZdS )
    )annotationsN)ABC)ENOENT)cast   )BaseFileLock)raise_on_exist_ro_filewin32c               @  s,   e Zd ZdZddddZddddZdS )	WindowsFileLockzWUses the :func:`msvcrt.locking` function to hard lock the lock file on windows systems.None)returnc          
   C  s   t | j tjtjB tjB }yt| j|}W n. tk
r\ } z|jt	krL W d d }~X Y n<X yt
|t
jd W n tk
r   t
| Y nX || _d S )Nr   )r   
_lock_fileosO_RDWRO_CREATO_TRUNCopenOSErrorerrnor   msvcrtlockingZLK_NBLCKclose
_lock_file_fd)selfmodefd	exception r   B/opt/alt/python37/lib/python3.7/site-packages/filelock/_windows.py_acquire   s    

zWindowsFileLock._acquirec             C  sV   t t| j}d | _t|tjd t| yt| j	 W n t
k
rP   Y nX d S )Nr   )r   intr   r   r   ZLK_UNLCKr   r   remover
   r   )r   r   r   r   r   _release&   s    
zWindowsFileLock._releaseN)__name__
__module____qualname____doc__r   r"   r   r   r   r   r
      s   r
   c               @  s   e Zd ZdZdS )r
   zWUses the :func:`msvcrt.locking` function to hard lock the lock file on windows systems.N)r#   r$   r%   r&   r   r   r   r   r
   4   s   )
__future__r   r   sysabcr   r   r   typingr   Z_apir   Z_utilr   platformr   r
   __all__r   r   r   r   <module>   s   
%                                                                                                                                                                                                                                                                                                                                python3.7/site-packages/filelock/__pycache__/_error.cpython-37.pyc                                  0000644                 00000001447 15107360273 0020766 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    a                 @  s&   d dl mZ G dd deZdgZdS )    )annotationsc               @  s.   e Zd ZdZdddddZdddd	Zd
S )Timeoutz@Raised when the lock could not be acquired in *timeout* seconds.strNone)	lock_filereturnc             C  s
   || _ d S )N)r   )selfr    r	   @/opt/alt/python37/lib/python3.7/site-packages/filelock/_error.py__init__   s    zTimeout.__init__)r   c             C  s   d| j  dS )NzThe file lock 'z' could not be acquired.)r   )r   r	   r	   r
   __str__   s    zTimeout.__str__N)__name__
__module____qualname____doc__r   r   r	   r	   r	   r
   r      s   r   N)
__future__r   TimeoutErrorr   __all__r	   r	   r	   r
   <module>   s                                                                                                                                                                                                                            python3.7/site-packages/filelock/__pycache__/_unix.cpython-37.pyc                                   0000644                 00000002754 15107360273 0020622 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    a                 @  s   d dl mZ d dlZd dlZd dlmZ d dlmZ ddlm	Z	 dZ
ejdkrbG d	d
 d
e	eZn6yd dl
Z
W n ek
r   Y nX dZ
G dd
 d
e	Zd
d
gZdS )    )annotationsN)ABC)cast   )BaseFileLockFwin32c               @  s   e Zd ZdZdS )UnixFileLockzHUses the :func:`fcntl.flock` to hard lock the lock file on unix systems.N)__name__
__module____qualname____doc__ r
   r
   ?/opt/alt/python37/lib/python3.7/site-packages/filelock/_unix.pyr      s   r   Tc               @  s,   e Zd ZdZddddZddddZdS )	r   zHUses the :func:`fcntl.flock` to hard lock the lock file on unix systems.None)returnc             C  sb   t jt jB t jB }t | j|}yt|tjtj	B  W n t
k
rV   t | Y nX || _d S )N)
osO_RDWRO_CREATO_TRUNCopenZ
_lock_filefcntlflockZLOCK_EXZLOCK_NBOSErrorc