python3.7/site-packages/raven/contrib/__init__.py                                                   0000644                 00000000305 15107360270 0015720 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib
~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import
                                                                                                                                                                                                                                                                                                                           python3.7/site-packages/raven/contrib/webpy/__pycache__/__init__.cpython-37.pyc                     0000644                 00000004732 15107360270 0023343 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Yd                 @   sZ   d Z ddlmZ ddlZddlZddlmZ ddlmZ ddl	m
Z
 G dd dejZdS )	z
raven.contrib.webpy
~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)
setup_logging)
SentryHandler)get_data_from_requestc               @   s:   e Zd ZdZdddZdd Zdd Zd	d
 Zdd Zd
S )SentryApplicationa  
    Web.py application for Sentry.

    >>> sentry = Sentry(client, mapping=urls, fvars=globals())

    Automatically configure logging::

    >>> sentry = Sentry(client, logging=True, mapping=urls, fvars=globals())

    Capture an exception::

    >>> try:
    >>>     1 / 0
    >>> except ZeroDivisionError:
    >>>     sentry.captureException()

    Capture a message::

    >>> sentry.captureMessage('hello, world!')
    Fc             K   s4   || _ || _| jr tt| j  tjj| f| d S )N)clientloggingr   r   webapplication__init__)selfr   r   kwargs r   M/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/webpy/__init__.pyr   )   s
    zSentryApplication.__init__c             O   s"   | j j|dt d| id d S )Nexc_infoZapp)r   dataextra)r   captureExceptiongetr   )r   argsr
   r   r   r   handle_exception0   s    z"SentryApplication.handle_exceptionc             C   s8   yt j| S  tk
r2   | jt d  Y nX d S )N)r   )r	   r
   handle	Exceptionr   sysr   )r   r   r   r   r   9   s
    zSentryApplication.handlec             O   s8   | j std|d}|d kr*t |d< | j j||S )Nz5captureException called before application configuredr   )r   AssertionErrorr   r   r   )r   r   r
   r   r   r   r   r   @   s
    

z"SentryApplication.captureExceptionc             O   s8   | j std|d}|d kr*t |d< | j j||S )Nz3captureMessage called before application configuredr   )r   r   r   r   captureMessage)r   r   r
   r   r   r   r   r   H   s
    

z SentryApplication.captureMessageN)F)	__name__
__module____qualname____doc__r   r   r   r   r   r   r   r   r   r      s   
	r   )
r   
__future__r   r   r	   Z
raven.confr   Zraven.handlers.loggingr   Zraven.contrib.webpy.utilsr   r
   r   r   r   r   r   <module>   s                                         python3.7/site-packages/raven/contrib/webpy/__pycache__/utils.cpython-37.pyc                        0000644                 00000001564 15107360270 0022744 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s4   d Z ddlmZ ddlZddlmZmZ dd ZdS )z
raven.contrib.webpy.utils
~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)get_headersget_environc            	   C   sV   ddt jd t jd t jd f t jjt jjt  ttt jjttt jjdiS )z,Returns request data extracted from web.ctx.Zrequestz	%s://%s%sprotocolhostpath)urlZquery_stringmethoddataheadersenv)	webctxqueryr	   r
   dictr   environr    r   r   J/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/webpy/utils.pyget_data_from_request   s    r   )__doc__
__future__r   r
   Zraven.utils.wsgir   r   r   r   r   r   r   <module>   s                                                                                                                                               python3.7/site-packages/raven/contrib/webpy/utils.py                                                0000644                 00000001346 15107360270 0016455 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.webpy.utils
~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import web

from raven.utils.wsgi import get_headers, get_environ


def get_data_from_request():
    """Returns request data extracted from web.ctx."""
    return {
        'request': {
            'url': '%s://%s%s' % (web.ctx['protocol'], web.ctx['host'], web.ctx['path']),
            'query_string': web.ctx.query,
            'method': web.ctx.method,
            'data': web.data(),
            'headers': dict(get_headers(web.ctx.environ)),
            'env': dict(get_environ(web.ctx.environ)),
        }
    }
                                                                                                                                                                                                                                                                                          python3.7/site-packages/raven/contrib/webpy/__init__.py                                             0000644                 00000004144 15107360270 0017053 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.webpy
~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import sys

import web

from raven.conf import setup_logging
from raven.handlers.logging import SentryHandler
from raven.contrib.webpy.utils import get_data_from_request


class SentryApplication(web.application):
    """
    Web.py application for Sentry.

    >>> sentry = Sentry(client, mapping=urls, fvars=globals())

    Automatically configure logging::

    >>> sentry = Sentry(client, logging=True, mapping=urls, fvars=globals())

    Capture an exception::

    >>> try:
    >>>     1 / 0
    >>> except ZeroDivisionError:
    >>>     sentry.captureException()

    Capture a message::

    >>> sentry.captureMessage('hello, world!')
    """

    def __init__(self, client, logging=False, **kwargs):
        self.client = client
        self.logging = logging
        if self.logging:
            setup_logging(SentryHandler(self.client))
        web.application.__init__(self, **kwargs)

    def handle_exception(self, *args, **kwargs):
        self.client.captureException(
            exc_info=kwargs.get('exc_info'),
            data=get_data_from_request(),
            extra={
                'app': self,
            },
        )

    def handle(self):
        try:
            return web.application.handle(self)
        except Exception:
            self.handle_exception(exc_info=sys.exc_info())
            raise

    def captureException(self, *args, **kwargs):
        assert self.client, 'captureException called before application configured'
        data = kwargs.get('data')
        if data is None:
            kwargs['data'] = get_data_from_request()

        return self.client.captureException(*args, **kwargs)

    def captureMessage(self, *args, **kwargs):
        assert self.client, 'captureMessage called before application configured'
        data = kwargs.get('data')
        if data is None:
            kwargs['data'] = get_data_from_request()

        return self.client.captureMessage(*args, **kwargs)
                                                                                                                                                                                                                                                                                                                                                                                                                            python3.7/site-packages/raven/contrib/async.py                                                      0000644                 00000001533 15107360270 0015302 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.async
~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

import warnings

from raven.base import Client
from raven.transport.threaded import AsyncWorker


class AsyncClient(Client):
    """
    This client uses a single background thread to dispatch errors.
    """

    def __init__(self, worker=None, *args, **kwargs):
        warnings.warn('AsyncClient is deprecated. Use the threaded+http transport instead.', DeprecationWarning)
        self.worker = worker or AsyncWorker()
        super(AsyncClient, self).__init__(*args, **kwargs)

    def send_sync(self, **kwargs):
        super(AsyncClient, self).send(**kwargs)

    def send(self, **kwargs):
        self.worker.queue(self.send_sync, **kwargs)
                                                                                                                                                                     python3.7/site-packages/raven/events.py                                                             0000644                 00000011101 15107360270 0014021 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.events
~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.

"""
from __future__ import absolute_import

import logging
import sys

from raven.utils.encoding import to_unicode
from raven.utils.stacks import get_stack_info, iter_traceback_frames

__all__ = ('BaseEvent', 'Exception', 'Message', 'Query')


class BaseEvent(object):
    def __init__(self, client):
        self.client = client
        self.logger = logging.getLogger(__name__)

    def to_string(self, data):
        raise NotImplementedError

    def capture(self, **kwargs):
        return {
        }

    def transform(self, value):
        return self.client.transform(value)


# The __suppress_context__ attribute was added in Python 3.3.
# See PEP 415 for details:
# https://www.python.org/dev/peps/pep-0415/
if hasattr(Exception, '__suppress_context__'):
    def _chained_exceptions(exc_info):
        """
        Return a generator iterator over an exception's chain.

        The exceptions are yielded from outermost to innermost (i.e. last to
        first when viewing a stack trace).

        """
        yield exc_info
        exc_type, exc, exc_traceback = exc_info

        context = set()
        context.add(exc)
        while True:
            if exc.__suppress_context__:
                # Then __cause__ should be used instead.
                exc = exc.__cause__
            else:
                exc = exc.__context__
            if exc in context:
                break
            context.add(exc)
            if exc is None:
                break
            yield type(exc), exc, exc.__traceback__
else:
    # Then we do not support reporting exception chains.
    def _chained_exceptions(exc_info):
        yield exc_info


class Exception(BaseEvent):
    """
    Exceptions store the following metadata:

    - value: 'My exception value'
    - type: 'ClassName'
    - module '__builtin__' (i.e. __builtin__.TypeError)
    - frames: a list of serialized frames (see _get_traceback_frames)

    """

    name = 'exception'

    def to_string(self, data):
        exc = data[self.name]['values'][-1]
        if exc['value']:
            return '%s: %s' % (exc['type'], exc['value'])
        return exc['type']

    def _get_value(self, exc_type, exc_value, exc_traceback):
        """
        Convert exception info to a value for the values list.
        """
        stack_info = get_stack_info(
            iter_traceback_frames(exc_traceback),
            transformer=self.transform,
            capture_locals=self.client.capture_locals,
        )

        exc_module = getattr(exc_type, '__module__', None)
        if exc_module:
            exc_module = str(exc_module)
        exc_type = getattr(exc_type, '__name__', '<unknown>')

        return {
            'value': to_unicode(exc_value),
            'type': str(exc_type),
            'module': to_unicode(exc_module),
            'stacktrace': stack_info,
        }

    def capture(self, exc_info=None, **kwargs):
        if not exc_info or exc_info is True:
            exc_info = sys.exc_info()

        if not exc_info:
            raise ValueError('No exception found')

        values = []
        for exc_info in _chained_exceptions(exc_info):
            value = self._get_value(*exc_info)
            values.insert(0, value)

        return {
            'level': kwargs.get('level', logging.ERROR),
            self.name: {'values': values},
        }


class Message(BaseEvent):
    """
    Messages store the following metadata:

    - message: 'My message from %s about %s'
    - params: ('foo', 'bar')
    """

    name = 'sentry.interfaces.Message'

    def to_string(self, data):
        return data[self.name]['message']

    def capture(self, message, params=(), formatted=None, **kwargs):
        message = to_unicode(message)
        data = {
            self.name: {
                'message': message,
                'params': self.transform(params),
                'formatted': formatted,
            },
        }
        if 'message' not in data:
            data['message'] = formatted or message
        return data


class Query(BaseEvent):
    """
    Messages store the following metadata:

    - query: 'SELECT * F