                s>   | j d}t|st S  | f||}||d< d|d< |S )NZHTTP_ORIGINzAccess-Control-Allow-OriginzGET, POST, OPTIONSzAccess-Control-Allow-Methods)METAgetr   r   )requestargskwargsr   response)funcr   r   wrapped.   s    zwith_origin.<locals>.wrapped)r   )r   r   r   )r   r   with_origin-   s    r   c             C   sf   | j dddr| j d S | j dddr<| j d S dd | j D }|rbdd| S d	S )
zy
    raven-js will pass both Authorization and X-Sentry-Auth depending on the browser
    and server configurations.
    ZHTTP_X_SENTRY_AUTH SentryZHTTP_AUTHORIZATIONc             S   s.   g | ]&}|d   dr|d  dkrd| qS )r   Zsentry_sentry_dataz%s=%s)
startswith).0ir   r   r   
<listcomp>I   s   z%extract_auth_vars.<locals>.<listcomp>z	Sentry %sz, N)r   r   r#   GETitemsjoin)r   r   r   r   r   extract_auth_vars=   s    

r*   r'   POSTOPTIONSNc             C   s   | j dkrt S | j dkr4t| dr,| j}q@| j}n| jd}|sJt S yt	|
d}W n tjk
rv   t S X tj
f dt| i| t S )Nr,   r+   bodyr"   utf8Zauth_header)methodr   hasattrr-   Z
raw_post_datar'   r   r   r
   loadsdecodeJSONDecodeErrorr   sendr*   )r   Z
project_iddatadecodedr   r   r   reportR   s    


r7   )N)__doc__
__future__r   	functoolsr   Zdjango.confr   Zdjango.httpr   r   r   Zdjango.views.decorators.cacher   Zdjango.views.decorators.csrfr	   Zdjango.views.decorators.httpr
   Zraven.utils.compatr   Zraven.contrib.django.modelsr   Zraven.utilsr
   r   r   r*   r7   r   r   r   r   <module>   s$                                                                                                                                                                                                 python3.7/site-packages/raven/contrib/django/__pycache__/models.cpython-37.pyc                      0000644                 00000025510 15107360265 0023204 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y$                 @   s  d Z ddlmZmZ ddlZddlZddlZddlZddlm	Z	 ddl
mZmZ ddl
mZ ddlmZ ddlmZmZmZ dd	lmZ ed
Zdd Zd
aG dd deZe ZdddZdddZG dd deZ dd Z!d ddZ"e Z#da$dd Z%ej&dk re%  dS )!z
raven.contrib.django.models
~~~~~~~~~~~~~~~~~~~~~~~~~~~

Acts as an implicit hook for Django installs.

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importunicode_literalsN)settings)got_request_exceptionrequest_started)Lock)convert_options)PY2binary_type	text_type)
import_stringzsentry.errors.clientc               C   s
   t tjS )z6
    Modules in settings.INSTALLED_APPS as a set.
    )setr   ZINSTALLED_APPS r   r   L/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/models.pyget_installed_apps   s    r   )NNc               @   s  e Zd ZdZedd Zedd Zedd Zdd Zdd Z	dd Z
d	d Zd
d Zdd Z
dd Zd
d Zdd Zdd Zerdd Zdd Zdd Zdd Zdd Zdd Zdd Zdd Zdd Zdd Zdd Zdd Zdd Zdd Z dd Z!dd Z"d d Z#d!d Z$d"d Z%d#d Z&d$d Z'd%d Z(d&d Z)d'd Z*d(d Z+d)d Z,d*d Z-d+d Z.errd,d Z/d-d Z0d.d Z1d/d Z2d0d Z3d1d Z4d2d Z5d3d Z6d4d Z7d5d Z8d6S )7ProxyClientzE
    A proxy which represents the currently client at all times.
    c             C   s   |   S )N)__dir__)xr   r   r   <lambda>-       zProxyClient.<lambda>c             C   s   t  jS )N)
get_client	__class__)r   r   r   r   r   1   r   c             C   s   t  jS )N)r   __dict__)or   r   r   r   3   r   c             C   s
   t t S )N)reprr   )r   r   r   r   r   5   r   c             C   s   t t |S )N)getattrr   )r   r   r   r   r   r   6   r   c             C   s   t t ||S )N)setattrr   )r   r   vr   r   r   r   7   r   c             C   s   t t |S )N)delattrr   )r   r   r   r   r   r   8   r   c             C   s
   t  |k S )N)r   )r   r   r   r   r   r   :   r   c             C   s
   t  |kS )N)r   )r   r   r   r   r   r   ;   r   c             C   s
   t  |kS )N)r   )r   r   r   r   r   r   <   r   c             C   s
   t  |kS )N)r   )r   r   r   r   r   r   =   r   c             C   s
   t  |kS )N)r   )r   r   r   r   r   r   >   r   c             C   s
   t  |kS )N)r   )r   r   r   r   r   r   ?   r   c             C   s   t t |S )N)Zcmpr   )r   r   r   r   r   r   A   r   c             C   s
   t t S )N)hashr   )r   r   r   r   r   B   r   c             C   s
   t t S )N)boolr   )r   r   r   r   r   E   r   c             C   s
   t t S )N)lenr   )r   r   r   r   r   F   r   c             C   s
   t  | S )N)r   )r   ir   r   r   r   G   r   c             C   s
   t t S )N)iterr   )r   r   r   r   r   H   r   c             C   s
   |t  kS )N)r   )r   r"   r   r   r   r   I   r   c             C   s   t  || S )N)r   )r   r"   jr   r   r   r   J   r   c             C   s
   t  | S )N)r   )r   r   r   r   r   r   K   r   c             C   s
   t  | S )N)r   )r   r   r   r   r   r   L   r   c             C   s
   t  | S )N)r   )r   r   r   r   r   r   M   r   c             C   s
   t  | S )N)r   )r   r   r   r   r   r   N   r   c             C   s
   t  | S )N)r   )r   r   r   r   r   r   O   r   c             C   s   t  |S )N)r   
__divmod__)r   r   r   r   r   r   P   r   c             C   s
   t  | S )N)r   )r   r   r   r   r   r   Q   r   c             C   s
   t  |> S )N)r   )r   r   r   r   r   r   R   r   c             C   s
   t  |? S )N)r   )r   r   r   r   r   r   S   r   c             C   s
   t  |@ S )N)r   )r   r   r   r   r   r   T   r   c             C   s
   t  |A S )N)r   )r   r   r   r   r   r   U   r   c             C   s
   t  |B S )N)r   )r   r   r   r   r   r   V   r   c             C   s   t  |S )N)r   __div__)r   r   r   r   r   r   W   r   c             C   s   t  |S )N)r   __truediv__)r   r   r   r   r   r   X   r   c             C   s   t   S )N)r   )r   r   r   r   r   Y   r   c             C   s   t  
 S )N)r   )r   r   r   r   r   Z   r   c             C   s
   t t S )N)absr   )r   r   r   r   r   [   r   c             C   s   t   S )N)r   )r   r   r   r   r   \   r   c             C   s
   t t S )N)complexr   )r   r   r   r   r   ]   r   c             C   s
   t t S )N)intr   )r   r   r   r   r   ^   r   c             C   s
   t t S )N)longr   )r   r   r   r   r   `   r   c             C   s
   t t S )N)floatr   )r   r   r   r   r   a   r   c             C   s
   t t S )N)r
   r   )r   r   r   r   r   b   r   c             C   s
   t t S )N)r   r   )r   r   r   r   r   c   r   c             C   s
   t t S )N)octr   )r   r   r   r   r   d   r   c             C   s
   t t S )N)hexr   )r   r   r   r   r   e   r   c             C   s
   t   S )N)r   	__index__)r   r   r   r   r   f   r   c             C   s   |  | |S )N)
__coerce__)r   r   r   r   r   r   g   r   c             C   s   |   S )N)	__enter__)r   r   r   r   r   h   r   c             O   s   | j ||S )N)__exit__)r   akwr   r   r   r   i   r   N)9__name__
__module____qualname____doc__property__members__r   r   __repr____getattr____setattr____delattr____lt____le____eq____ne____gt____ge__r	   Z__cmp____hash____nonzero____len____getitem____iter____contains__Z__getslice____add____sub____mul____floordiv____mod__r%   __pow__
__lshift__
__rshift____and____xor____or__r&   r'   __neg____pos____abs__
__invert____complex____int__Z__long__	__float____str__Z__unicode__Z__oct__Z__hex__r/   r0   r1   r2   r   r   r   r   r   (   sl   r   Fc             C   s   | d k	}|st tdd} td | ks(|rttdt id}yt| }W n8 tk
r~   td|  td szd} | t	| faY nX |f |}|s| |fa|S td S )NZ
SENTRY_CLIENTz!raven.contrib.django.DjangoClientr   Z
include_paths)defaultszFailed to import client: %s   )
r   r   _clientr   r   r   ImportErrorlogger	exceptionr   )clientresetZ
tmp_clientoptionsZClientinstancer   r   r   r   n   s&    
r   c          
   K   s   yt jt | d W nj tk
r } zLytd|f  W n2 tk
rn } ztd|f  W d d }~X Y nX W d d }~X Y nX d S )N)exc_inforequestzUnable to process log entry: %s)	rd   captureExceptionsysrh   	Exceptionrb   rc   warningswarn)ri   kwargsexcr   r   r   sentry_exception_handler   s    rq   c               @   sB   e Zd ZefddZdd Zdd Zdd Zdd
dZdd
 Z	d	S )SentryDjangoHandlerc             C   sD   || _ ydd l}W n tk
r,   d| _Y nX |jdk| _d | _d S )Nr   F)      )rd   celeryra   
has_celeryVERSIONcelery_handler)selfrd   ru   r   r   r   __init__   s    zSentryDjangoHandler.__init__c             C   s2   ddl m}m} ttdd}|t|d | _d S )Nr   )SentryCeleryHandlerregister_logger_signalZSENTRY_CELERY_IGNORE_EXPECTEDF)ignore_expected)Zraven.contrib.celeryr{   r|   r   r   rd   installrx   )ry   r{   r|   r}   r   r   r   install_celery   s    z"SentryDjangoHandler.install_celeryc             C   sV   t j| jdd tj| jdd | jrRy|   W n tk
rP   t	d Y nX d S )NF)Zweakz&Failed to install Celery error handler)
r   connectbefore_requestr   exception_handlerrv   r   rl   rb   rc   )ry   r   r   r   r~      s    zSentryDjangoHandler.installc             C   s,   t | j t| j | jr(| j  d S )N)r   Z
disconnectr   r   r   rx   	uninstall)ry   r   r   r   r      s    zSentryDjangoHandler.uninstallNc          
   K   s   y| j jt |d W nj tk
r } zLytd|f  W n2 tk
rp } ztd|f  W d d }~X Y nX W d d }~X Y nX d S )N)rh   ri   zUnable to process log entry: %s)	rd   rj   rk   rh   rl   rb   rc   rm   rn   )ry   ri   ro   rp   r   r   r   r      s    z%SentryDjangoHandler.exception_handlerc             O   s   | j j  d S )N)rd   contextactivate)ry   argsro   r   r   r   r      s    z"SentryDjangoHandler.before_request)N)
r5   r6   r7   rd   rz   r   r~   r   r   r   r   r   r   r   rr      s   

	rr   c              C   s   dd l } d S )Nr   )Z raven.contrib.django.serializers)ravenr   r   r   register_serializers   s    r   c             C   sf   |dkr| f}t tdddk	r"dnd}t t|dp4d}t|t|rbtt|t|| f|  dS )z&
    Install specified middleware
    NZ
MIDDLEWAREZMIDDLEWARE_CLASSESr   )r   r   r
   
isdisjointr   type)Zmiddleware_nameZlookup_namesZmiddleware_attrZ
middlewarer   r   r   install_middleware   s    r   c           	   C   sv   t h trd S day<t  tdd td ttddsFt } |   t  W n t	k
rf   daY nX W d Q R X d S )NTz0raven.contrib.django.middleware.SentryMiddleware)z0raven.contrib.django.middleware.SentryMiddlewarez3raven.contrib.django.middleware.SentryLogMiddlewarezCraven.contrib.django.middleware.DjangoRestFrameworkCompatMiddlewareZDISABLE_SENTRY_INSTRUMENTATIONF)
_setup_lock_initializedr   r   r   r   rr   r~   r   rl   )handlerr   r   r   
initialize   s"    
r   )r_      r   )NF)N)N)'r8   
__future__r   r   loggingrk   rm   ZdjangoZdjango.confr   Zdjango.core.signalsr   r   	threadingr   Zraven.utils.confr   Zraven.utils.compatr	   r
   r   Zraven.utils.importsr   	getLoggerrb   r   r`   objectr   rd   r   rq   rr   r   r   r   r   r   rw   r   r   r   r   <module>	   s4   
C


B
                                                                                                                                                                                        python3.7/site-packages/raven/contrib/django/__pycache__/utils.cpython-37.pyc                       0000644                 00000004521 15107360265 0023060 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Yh                 @   sB   d Z ddlmZ ddlZddlmZ dd ZdddZd	d
 ZdS )z
raven.contrib.django.utils
~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)settingsc             c   sJ   dV  |  d}x&|dkr6|d V  |  d|d }qW t| d V  d S )Nr   
   )findlen)template_sourcep r
   K/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/utils.pylinebreak_iter   s    


r   c             C   s  dd }|d k	rn|d }|d }g }|dg|d d d  7 }x|d D ]\}}| | qHW |dgd 7 }n| r| \}\}	}
t|d	d  }}| }d }d}
g }xBtt|D ]2\}}|	|
kr|
|kr|}| ||
|  |}
qW |r|d kri S ntd
|d krd}d}n|dd
 }||t|d d| }|||d |d  }||| gd }tj	
||||||d|dS )Nc             S   sB   g }x8| D ]0}t |ttfr0t|dkr0|d }|| q
W |S )N   r   )
isinstancelisttupler   append)itemsrvitemr
   r
   r   _remove_numbers   s    
z/get_data_from_template.<locals>._remove_numberslinename source_linesr      ZloadnamezSource or debug neededz<unknown filename>z/templates/   r   )filenameZabs_pathpre_contextcontext_linelinenopost_context)templateculprit)r   getattrreload	enumerater   	TypeErrorsplitmaxospathbasename)sourcedebugr   r    r   r   numr   originstartendr#   r   Zuptonextr   r!   r   r
   r
   r   get_data_from_template   sL    


r4   c             C   sn   t jrd| jkr| jd }nNd| jkr2| jd }n8| jd }t| jd }||  rXdpZdkrjd||f }|S )z]
    A reimplementation of Django's get_host, without the
    SuspiciousOperation check.
    ZHTTP_X_FORWARDED_HOSTZ	HTTP_HOSTZSERVER_NAMEZSERVER_PORTZ443Z80z%s:%s)r   ZUSE_X_FORWARDED_HOSTZMETAstrZ	is_secure)ZrequesthostZserver_portr
   r
   r   get_hostT   s    


r7   )N)	__doc__
__future__r   r*   Zdjango.confr   r   r4   r7   r
   r
   r
   r   <module>   s   	
<                                                                                                                                                                               python3.7/site-packages/raven/contrib/django/views.py                                               0000644                 00000005654 15107360265 0016600 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.views
~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from functools import wraps

from django.conf import settings
from django.http import HttpResponse, HttpResponseForbidden, HttpResponseBadRequest
from django.views.decorators.cache import never_cache
from django.views.decorators.csrf import csrf_exempt
from django.views.decorators.http import require_http_methods

from raven.utils.compat import string_types
from raven.contrib.django.models import client
from raven.utils import json


def is_valid_origin(origin):
    if not settings.SENTRY_ALLOW_ORIGIN:
        return False

    if settings.SENTRY_ALLOW_ORIGIN == '*':
        return True

    if not origin:
        return False

    origin = origin.lower()
    for value in settings.SENTRY_ALLOW_ORIGIN:
        if isinstance(value, string_types):
            if value.lower() == origin:
                return True
        else:
            if value.match(origin):
                return True

    return False


def with_origin(func):
    @wraps(func)
    def wrapped(request, *args, **kwargs):
        origin = request.META.get('HTTP_ORIGIN')

        if not is_valid_origin(origin):
            return HttpResponseForbidden()

        response = func(request, *args, **kwargs)
        response['Access-Control-Allow-Origin'] = origin
        response['Access-Control-Allow-Methods'] = 'GET, POST, OPTIONS'

        return response
    return wrapped


def extract_auth_vars(request):
    """
    raven-js will pass both Authorization and X-Sentry-Auth depending on the browser
    and server configurations.
    """
    if request.META.get('HTTP_X_SENTRY_AUTH', '').startswith('Sentry'):
        return request.META['HTTP_X_SENTRY_AUTH']
    elif request.META.get('HTTP_AUTHORIZATION', '').startswith('Sentry'):
        return request.META['HTTP_AUTHORIZATION']
    else:
        # Try to construct from GET request
        args = [
            '%s=%s' % i
            for i in request.GET.items()
            if i[0].startswith('sentry_') and i[0] != 'sentry_data'
        ]
        if args:
            return 'Sentry %s' % ', '.join(args)
    return None


@csrf_exempt
@require_http_methods(['GET', 'POST', 'OPTIONS'])
@never_cache
@with_origin
def report(request, project_id=None):
    if request.method == 'OPTIONS':
        return HttpResponse()

    if request.method == 'POST':
        if hasattr(request, 'body'):
            data = request.body
        else:
            data = request.raw_post_data
    else:
        data = request.GET.get('sentry_data')

    if not data:
        return HttpResponseBadRequest()

    try:
        decoded = json.loads(data.decode('utf8'))
    except json.JSONDecodeError:
        return HttpResponseBadRequest()

    client.send(auth_header=extract_auth_vars(request), **decoded)

    return HttpResponse()
                                                                                    python3.7/site-packages/raven/contrib/django/middleware/wsgi.py                                     0000644                 00000001364 15107360265 0020523 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.middleware.wsgi
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from raven.middleware import Sentry
from raven.utils import memoize


class Sentry(Sentry):
    """
    Identical to the default WSGI middleware except that
    the client comes dynamically via ``get_client

    >>> from raven.contrib.django.middleware.wsgi import Sentry
    >>> application = Sentry(application)
    """

    def __init__(self, application):
        self.application = application

    @memoize
    def client(self):
        from raven.contrib.django.models import client
        return client
                                                                                                                                                                                                                                                                            python3.7/site-packages/raven/contrib/django/middleware/__pycache__/__init__.cpython-37.pyc         0000644                 00000010170 15107360265 0025571 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s   d Z ddlmZ ddlZddlZddlmZ ddlmZ yddl	m
Z
 W n ek
r`   eZ
Y nX dd Z
G d	d
 d
e
ZG dd de
ZG d
d de
ZeZG dd de
ZdS )z
raven.contrib.django.middleware
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_importN)settings)request_finished)MiddlewareMixinc                s   t  fddttddD S )zV
    Returns True if a 404 at the given URL *shouldn't* notify the site managers.
    c             3   s   | ]}|  V  qd S )N)search).0pattern)uri Y/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/middleware/__init__.py	<genexpr>   s   z#is_ignorable_404.<locals>.<genexpr>ZIGNORABLE_404_URLSr
   )anygetattrr   )r	   r
   )r	   r   is_ignorable_404   s    
r   c               @   s   e Zd Zdd ZdS )Sentry404CatchMiddlewarec             C   s   |j dkr|S t| r|S ddlm} | s6|S ||}|tj	dd |j
d|  |d}|spd S |d|j
j||d	|_|S )
Ni  r   )clientZhttp404)levelloggerzPage Not Found: %s)messagedataproject)Z
project_idid)Zstatus_coder   Z
get_full_pathraven.contrib.django.modelsr   
is_enabledZget_data_from_requestupdateloggingINFOZcaptureMessageZbuild_absolute_urigetZremoter   	get_identsentry)selfrequestresponser   r   resultr
   r
   r   process_response%   s"    


z)Sentry404CatchMiddleware.process_responseN)__name__
__module____qualname__r$   r
   r
   r
   r   r   $   s   r   c               @   s   e Zd ZdZdd ZdS )SentryResponseErrorIdMiddlewarezl
    Appends the X-Sentry-ID response header for referencing a message within
    the Sentry datastore.
    c             C   s"   t |dd s|S |jd |d< |S )Nr   r   zX-Sentry-ID)r   r   )r    r!   r"   r
   r
   r   r$   I   s    z0SentryResponseErrorIdMiddleware.process_responseN)r%   r&   r'   __doc__r$   r
   r
   r
   r   r(   C   s   r(   c               @   s,   e Zd Ze Zdd Zdd Zdd ZdS )SentryMiddlewarec             C   s"   d | _ |tj_tj| jdd d S )NF)Zweak)_txidr*   threadr!   r   connect)r    r!   r
   r
   r   process_requestS   s    z SentryMiddleware.process_requestc          
   C   sd   ddl m} y|j||| _W n: tk
r^ } z|jjt	|d|id W d d }~X Y nX d S )Nr   )r   r!   )extra)
r   r   transactionpushZget_transaction_from_requestr+   	ExceptionZerror_logger	exceptionrepr)r    r!   funcargskwargsr   excr
   r
   r   process_view`   s    *zSentryMiddleware.process_viewc             K   sD   ddl m} t| dd r,|j| j d | _d tj_t	
| j	 d S )Nr   )r   r+   )r   r   r   r0   popr+   r*   r,   r!   r   Z
disconnect)r    r7   r   r
   r
   r   r   l   s    z!SentryMiddleware.request_finishedN)	r%   r&   r'   	threadinglocalr,   r.   r9   r   r
   r
   r
   r   r*   P   s   
r*   c               @   s   e Zd ZdZdd ZdS )#DjangoRestFrameworkCompatMiddleware)z!application/x-www-form-urlencodedzmultipart/form-datazapplication/octet-streamc             C   s4   |j dd}x| jD ]}||krdS qW |j dS )z~
        Access request.body, otherwise it might not be accessible later
        after request has been read/streamed
        ZCONTENT_TYPE N)ZMETAr   non_cacheable_typesbody)r    r!   content_typeZnon_cacheable_typer
   r
   r   r.      s
    z3DjangoRestFrameworkCompatMiddleware.process_requestN)r%   r&   r'   r?   r.   r
   r
   r
   r   r=   {   s   r=   )r)   
__future__r   r   r;   Zdjango.confr   Zdjango.core.signalsr   Zdjango.utils.deprecationr   ImportErrorobjectr   r   r(   r*   ZSentryLogMiddlewarer=   r
   r
   r
   r   <module>   s   


(                                                                                                                                                                                                                                                                                                                                                                                                        python3.7/site-packages/raven/contrib/django/middleware/__pycache__/wsgi.cpython-37.pyc             0000644                 00000002276 15107360265 0025013 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s<   d Z ddlmZ ddlmZ ddlmZ G dd deZdS )z
raven.contrib.django.middleware.wsgi
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)Sentry)memoizec               @   s$   e Zd ZdZdd Zedd ZdS )r   z
    Identical to the default WSGI middleware except that
    the client comes dynamically via ``get_client

    >>> from raven.contrib.django.middleware.wsgi import Sentry
    >>> application = Sentry(application)
    c             C   s
   || _ d S )N)application)selfr    r   U/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/middleware/wsgi.py__init__   s    zSentry.__init__c             C   s   ddl m} |S )Nr   )client)Zraven.contrib.django.modelsr
   )r   r
   r   r   r   r
      s    z
Sentry.clientN)__name__
__module____qualname____doc__r	   r   r
   r   r   r   r   r      s   r   N)r   
__future__r   Zraven.middlewarer   Zraven.utilsr   r   r   r   r   <module>   s                                                                                                                                                                                                                                                                                                                                     python3.7/site-packages/raven/contrib/django/middleware/__init__.py                                 0000644                 00000010360 15107360265 0021305 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.middleware
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

import logging
import threading

from django.conf import settings
from django.core.signals import request_finished

try:
    # Django >= 1.10
    from django.utils.deprecation import MiddlewareMixin
except ImportError:
    # Not required for Django <= 1.9, see:
    # https://docs.djangoproject.com/en/1.10/topics/http/middleware/#upgrading-pre-django-1-10-style-middleware
    MiddlewareMixin = object


def is_ignorable_404(uri):
    """
    Returns True if a 404 at the given URL *shouldn't* notify the site managers.
    """
    return any(
        pattern.search(uri)
        for pattern in getattr(settings, 'IGNORABLE_404_URLS', ())
    )


class Sentry404CatchMiddleware(MiddlewareMixin):
    def process_response(self, request, response):
        if response.status_code != 404:
            return response

        if is_ignorable_404(request.get_full_path()):
            return response

        from raven.contrib.django.models import client

        if not client.is_enabled():
            return response

        data = client.get_data_from_request(request)
        data.update({
            'level': logging.INFO,
            'logger': 'http404',
        })
        result = client.captureMessage(message='Page Not Found: %s' % request.build_absolute_uri(), data=data)
        if not result:
            return

        request.sentry = {
            'project_id': data.get('project', client.remote.project),
            'id': client.get_ident(result),
        }
        return response

    # sentry_exception_handler(sender=Sentry404CatchMiddleware, request=request)


class SentryResponseErrorIdMiddleware(MiddlewareMixin):
    """
    Appends the X-Sentry-ID response header for referencing a message within
    the Sentry datastore.
    """

    def process_response(self, request, response):
        if not getattr(request, 'sentry', None):
            return response
        response['X-Sentry-ID'] = request.sentry['id']
        return response


class SentryMiddleware(MiddlewareMixin):
    thread = threading.local()

    def process_request(self, request):
        self._txid = None

        SentryMiddleware.thread.request = request
        # we utilize request_finished as the exception gets reported
        # *after* process_response is executed, and thus clearing the
        # transaction there would leave it empty
        # XXX(dcramer): weakref's cause a threading issue in certain
        # versions of Django (e.g. 1.6). While they'd be ideal, we're under
        # the assumption that Django will always call our function except
        # in the situation of a process or thread dying.
        request_finished.connect(self.request_finished, weak=False)

    def process_view(self, request, func, args, kwargs):
        from raven.contrib.django.models import client

        try:
            self._txid = client.transaction.push(
                client.get_transaction_from_request(request)
            )
        except Exception as exc:
            client.error_logger.exception(repr(exc), extra={'request': request})

        return None

    def request_finished(self, **kwargs):
        from raven.contrib.django.models import client

        if getattr(self, '_txid', None):
            client.transaction.pop(self._txid)
            self._txid = None

        SentryMiddleware.thread.request = None

        request_finished.disconnect(self.request_finished)


SentryLogMiddleware = SentryMiddleware


class DjangoRestFrameworkCompatMiddleware(MiddlewareMixin):

    non_cacheable_types = (
        'application/x-www-form-urlencoded',
        'multipart/form-data',
        'application/octet-stream'
    )

    def process_request(self, request):
        """
        Access request.body, otherwise it might not be accessible later
        after request has been read/streamed
        """
        content_type = request.META.get('CONTENT_TYPE', '')
        for non_cacheable_type in self.non_cacheable_types:
            if non_cacheable_type in content_type:
                return
        request.body  # forces stream to be read into memory
                                                                                                                                                                                                                                                                                python3.7/site-packages/raven/contrib/django/raven_compat/models.py                                 0000644                 00000000457 15107360266 0021401 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.models
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

from raven.contrib.django.models import *  # NOQA
                                                                                                                                                                                                                 site-packages/raven/contrib/django/raven_compat/templatetags/__pycache__/__init__.cpython-37.pyc    0000644                 00000001015 15107360266 0030544 0                                                                                                    ustar 00                                                                                python3.7                                                                                                                                                              B

    YA                 @   s   d Z ddlmZ ddlT dS )z
raven.contrib.django.raven_compat.templatetags
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)__doc__
__future__r   Z!raven.contrib.django.templatetags r   r   h/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/templatetags/__init__.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      site-packages/raven/contrib/django/raven_compat/templatetags/__pycache__/raven.cpython-37.pyc       0000644                 00000001034 15107360266 0030121 0                                                                                                    ustar 00                                                                                python3.7                                                                                                                                                              B

    YS                 @   s   d Z ddlmZ ddlT dS )z
raven.contrib.django.raven_compat.templatetags.raven
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)__doc__
__future__r   Z'raven.contrib.django.templatetags.raven r   r   e/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/templatetags/raven.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       python3.7/site-packages/raven/contrib/django/raven_compat/templatetags/__init__.py                  0000644                 00000000501 15107360266 0024335 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.templatetags
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

from raven.contrib.django.templatetags import *  # NOQA
                                                                                                                                                                                               python3.7/site-packages/raven/contrib/django/raven_compat/templatetags/raven.py                     0000644                 00000000523 15107360266 0023715 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.templatetags.raven
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

from raven.contrib.django.templatetags.raven import *  # NOQA
                                                                                                                                                                             python3.7/site-packages/raven/contrib/django/raven_compat/handlers.py                               0000644                 00000000465 15107360266 0021715 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.handlers
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

from raven.contrib.django.handlers import *  # NOQA
                                                                                                                                                                                                           python3.7/site-packages/raven/contrib/django/raven_compat/__pycache__/__init__.cpython-37.pyc       0000644                 00000000731 15107360266 0026135 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y                 @   s   d Z ddlmZ ddlT dS )z
raven.contrib.django.raven_compat
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)__doc__
__future__r   Zraven.contrib.django r   r   [/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/__init__.py<module>   s                                          python3.7/site-packages/raven/contrib/django/raven_compat/__pycache__/handlers.cpython-37.pyc       0000644                 00000000764 15107360266 0026204 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y5                 @   s   d Z ddlmZ ddlT dS )z
raven.contrib.django.raven_compat.handlers
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)__doc__
__future__r   Zraven.contrib.django.handlers r   r   [/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/handlers.py<module>   s               python3.7/site-packages/raven/contrib/django/raven_compat/__pycache__/models.cpython-37.pyc         0000644                 00000000754 15107360266 0025666 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y/                 @   s   d Z ddlmZ ddlT dS )z
raven.contrib.django.raven_compat.models
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)__doc__
__future__r   Zraven.contrib.django.models r   r   Y/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/models.py<module>   s                       python3.7/site-packages/raven/contrib/django/raven_compat/middleware/wsgi.py                        0000644                 00000000512 15107360266 0023174 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.middleware.wsgi
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

from raven.contrib.django.middleware.wsgi import *  # NOQA
                                                                                                                                                                                      site-packages/raven/contrib/django/raven_compat/middleware/__pycache__/__init__.cpython-37.pyc      0000644                 00000001005 15107360266 0030166 0                                                                                                    ustar 00                                                                                python3.7                                                                                                                                                              B

    Y;                 @   s   d Z ddlmZ ddlT dS )z
raven.contrib.django.raven_compat.middleware
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)__doc__
__future__r   Zraven.contrib.django.middleware r   r   f/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/middleware/__init__.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              python3.7/site-packages/raven/contrib/django/raven_compat/middleware/__pycache__/wsgi.cpython-37.pyc0000644                 00000001020 15107360266 0027454 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    YJ                 @   s   d Z ddlmZ ddlT dS )z
raven.contrib.django.raven_compat.middleware.wsgi
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)*N)__doc__
__future__r   Z$raven.contrib.django.middleware.wsgi r   r   b/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/middleware/wsgi.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   python3.7/site-packages/raven/contrib/django/raven_compat/middleware/__init__.py                    0000644                 00000000473 15107360266 0023770 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.middleware
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

from raven.contrib.django.middleware import *  # NOQA
                                                                                                                                                                                                     python3.7/site-packages/raven/contrib/django/raven_compat/__init__.py                               0000644                 00000000432 15107360266 0021646 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

from raven.contrib.django import *  # NOQA
                                                                                                                                                                                                                                      raven/contrib/django/raven_compat/management/commands/__pycache__/__init__.cpython-37.pyc           0000644                 00000001101 15107360266 0031763 0                                                                                                    ustar 00                                                                                python3.7/site-packages                                                                                                                                                B

    Yd                 @   s    d Z ddlmZmZ ddlT dS )z
raven.contrib.django.raven_compat.management.commands
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
    )absolute_importprint_function)*N)__doc__
__future__r   r   Z(raven.contrib.django.management.commands r   r   o/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/management/commands/__init__.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                  site-packages/raven/contrib/django/raven_compat/management/commands/__pycache__/raven.cpython-37.pyc0000644                 00000001120 15107360266 0031340 0                                                                                                    ustar 00                                                                                python3.7                                                                                                                                                              B

    Yv                 @   s    d Z ddlmZmZ ddlT dS )z
raven.contrib.django.raven_compat.management.commands.raven
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
    )absolute_importprint_function)*N)__doc__
__future__r   r   Z.raven.contrib.django.management.commands.raven r   r   l/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/management/commands/raven.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                   python3.7/site-packages/raven/contrib/django/raven_compat/management/commands/__init__.py           0000644                 00000000544 15107360266 0025567 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.management.commands
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import, print_function

from raven.contrib.django.management.commands import *  # NOQA
                                                                                                                                                            python3.7/site-packages/raven/contrib/django/raven_compat/management/commands/raven.py              0000644                 00000000566 15107360266 0025147 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.management.commands.raven
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import, print_function

from raven.contrib.django.management.commands.raven import *  # NOQA
                                                                                                                                          site-packages/raven/contrib/django/raven_compat/management/__pycache__/__init__.cpython-37.pyc      0000644                 00000001035 15107360266 0030170 0                                                                                                    ustar 00                                                                                python3.7                                                                                                                                                              B

    YI                 @   s    d Z ddlmZmZ ddlT dS )z
raven.contrib.django.raven_compat.management
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
    )absolute_importprint_function)*N)__doc__
__future__r   r   Zraven.contrib.django.management r   r   f/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/raven_compat/management/__init__.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      python3.7/site-packages/raven/contrib/django/raven_compat/management/__init__.py                    0000644                 00000000511 15107360267 0023761 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.raven_compat.management
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import, print_function

from raven.contrib.django.management import *  # NOQA
                                                                                                                                                                                       python3.7/site-packages/raven/contrib/django/urls.py                                                0000644                 00000001122 15107360267 0016414 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.urls
~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

try:
    from django.conf.urls import url
except ImportError:
    # for Django version less than 1.4
    from django.conf.urls.defaults import url  # NOQA

import raven.contrib.django.views

urlpatterns = (
    url(r'^api/(?P<project_id>[\w_-]+)/store/$', raven.contrib.django.views.report, name='raven-report'),
    url(r'^report/', raven.contrib.django.views.report),
)
                                                                                                                                                                                                                                                                                                                                                                                                                                              python3.7/site-packages/raven/contrib/django/utils.py                                               0000644                 00000006150 15107360267 0016575 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.utils
~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""

from __future__ import absolute_import

import os
from django.conf import settings


def linebreak_iter(template_source):
    yield 0
    p = template_source.find('\n')
    while p >= 0:
        yield p + 1
        p = template_source.find('\n', p + 1)
    yield len(template_source) + 1


def get_data_from_template(source, debug=None):
    def _remove_numbers(items):
        rv = []
        for item in items:
            # Some debug info from django has tuples in the form (lineno,
            # code) instead of just the code there.
            if isinstance(item, (list, tuple)) and len(item) == 2:
                item = item[1]
            rv.append(item)
        return rv

    if debug is not None:
        lineno = debug['line']
        filename = debug['name']
        source_lines = []
        source_lines += [''] * (debug['source_lines'][0][0])
        for num, line in debug['source_lines']:
            source_lines.append(line)
        source_lines += [''] * 4
    elif source:
        origin, (start, end) = source
        filename = culprit = getattr(origin, 'loadname', None)
        template_source = origin.reload()
        lineno = None
        upto = 0
        source_lines = []
        for num, next in enumerate(linebreak_iter(template_source)):
            if start >= upto and end <= next:
                lineno = num
            source_lines.append(template_source[upto:next])
            upto = next

        if not source_lines or lineno is None:
            return {}
    else:
        raise TypeError('Source or debug needed')

    if filename is None:
        filename = '<unknown filename>'
        culprit = '<unknown filename>'
    else:
        culprit = filename.split('/templates/')[-1]

    pre_context = _remove_numbers(source_lines[max(lineno - 3, 0):lineno])
    post_context = _remove_numbers(source_lines[(lineno + 1):(lineno + 4)])
    context_line = _remove_numbers([source_lines[lineno]])[0]

    return {
        'template': {
            'filename': os.path.basename(filename),
            'abs_path': filename,
            'pre_context': pre_context,
            'context_line': context_line,
            'lineno': lineno,
            'post_context': post_context,
        },
        'culprit': culprit,
    }


def get_host(request):
    """
    A reimplementation of Django's get_host, without the
    SuspiciousOperation check.
    """
    # We try three options, in order of decreasing preference.
    if settings.USE_X_FORWARDED_HOST and (
            'HTTP_X_FORWARDED_HOST' in request.META):
        host = request.META['HTTP_X_FORWARDED_HOST']
    elif 'HTTP_HOST' in request.META:
        host = request.META['HTTP_HOST']
    else:
        # Reconstruct the host using the algorithm from PEP 333.
        host = request.META['SERVER_NAME']
        server_port = str(request.META['SERVER_PORT'])
        if server_port != (request.is_secure() and '443' or '80'):
            host = '%s:%s' % (host, server_port)
    return host
                                                                                                                                                                                                                                                                                                                                                                                                                        python3.7/site-packages/raven/contrib/django/resolver.py                                            0000644                 00000005534 15107360267 0017303 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import

import re

try:
    from django.urls import get_resolver
except ImportError:
    from django.core.urlresolvers import get_resolver


class RouteResolver(object):
    _optional_group_matcher = re.compile(r'\(\?\:([^\)]+)\)')
    _named_group_matcher = re.compile(r'\(\?P<(\w+)>[^\)]+\)')
    _non_named_group_matcher = re.compile(r'\([^\)]+\)')
    # [foo|bar|baz]
    _either_option_matcher = re.compile(r'\[([^\]]+)\|([^\]]+)\]')
    _camel_re = re.compile(r'([A-Z]+)([a-z])')

    _cache = {}

    def _simplify(self, pattern):
        r"""
        Clean up urlpattern regexes into something readable by humans:

        From:
        > "^(?P<sport_slug>\w+)/athletes/(?P<athlete_slug>\w+)/$"

        To:
        > "{sport_slug}/athletes/{athlete_slug}/"
        """
        # remove optional params
        # TODO(dcramer): it'd be nice to change these into [%s] but it currently
        # conflicts with the other rules because we're doing regexp matches
        # rather than parsing tokens
        result = self._optional_group_matcher.sub(lambda m: '%s' % m.group(1), pattern)

        # handle named groups first
        result = self._named_group_matcher.sub(lambda m: '{%s}' % m.group(1), result)

        # handle non-named groups
        result = self._non_named_group_matcher.sub('{var}', result)

        # handle optional params
        result = self._either_option_matcher.sub(lambda m: m.group(1), result)

        # clean up any outstanding regex-y characters.
        result = result.replace('^', '').replace('$', '') \
            .replace('?', '').replace('//', '/').replace('\\', '')

        return result

    def _resolve(self, resolver, path, parents=None):
        match = resolver.regex.search(path)
        if not match:
            return

        if parents is None:
            parents = [resolver]
        elif resolver not in parents:
            parents = parents + [resolver]

        new_path = path[match.end():]
        for pattern in resolver.url_patterns:
            # this is an include()
            if not pattern.callback:
                match = self._resolve(pattern, new_path, parents)
                if match:
                    return match
                continue

            elif not pattern.regex.search(new_path):
                continue

            try:
                return self._cache[pattern]
            except KeyError:
                pass

            prefix = ''.join(self._simplify(p.regex.pattern) for p in parents)
            result = prefix + self._simplify(pattern.regex.pattern)
            if not result.startswith('/'):
                result = '/' + result
            self._cache[pattern] = result
            return result

    def resolve(self, path, urlconf=None):
        resolver = get_resolver(urlconf)
        match = self._resolve(resolver, path)
        return match or path
                                                                                                                                                                    python3.7/site-packages/raven/contrib/django/__init__.py                                            0000644                 00000000473 15107360267 0017176 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django
~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

default_app_config = 'raven.contrib.django.apps.RavenConfig'

from .client import DjangoClient  # NOQA
                                                                                                                                                                                                     python3.7/site-packages/raven/contrib/django/serializers.py                                         0000644                 00000004167 15107360267 0017777 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.serializers
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2012 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import
from __future__ import unicode_literals

from django.conf import settings
from django.http import HttpRequest
from django.utils.functional import Promise
from raven.utils.serializer import Serializer, register
from raven.utils.compat import text_type

__all__ = ('PromiseSerializer',)


class PromiseSerializer(Serializer):
    types = (Promise,)

    def can(self, value):
        if not super(PromiseSerializer, self).can(value):
            return False

        pre = value.__class__.__name__[1:]
        if not (hasattr(value, '%s__func' % pre) or
                hasattr(value, '%s__unicode_cast' % pre) or
                hasattr(value, '%s__text_cast' % pre)):
            return False

        return True

    def serialize(self, value, **kwargs):
        # EPIC HACK
        # handles lazy model instances (which are proxy values that don't
        # easily give you the actual function)
        pre = value.__class__.__name__[1:]
        if hasattr(value, '%s__func' % pre):
            value = getattr(value, '%s__func' % pre)(
                *getattr(value, '%s__args' % pre),
                **getattr(value, '%s__kw' % pre))
        else:
            return self.recurse(text_type(value))
        return self.recurse(value, **kwargs)


register(PromiseSerializer)


class HttpRequestSerializer(Serializer):
    types = (HttpRequest,)

    def serialize(self, value, **kwargs):
        return '<%s at 0x%s>' % (type(value).__name__, id(value))


register(HttpRequestSerializer)


if getattr(settings, 'DATABASES', None):
    from django.db.models.query import QuerySet

    class QuerySetSerializer(Serializer):
        types = (QuerySet,)

        def serialize(self, value, **kwargs):
            qs_name = type(value).__name__
            if value.model:
                return '<%s: model=%s>' % (qs_name, value.model.__name__)
            return '<%s: (Unbound)>' % (qs_name,)

    register(QuerySetSerializer)
                                                                                                                                                                                                                                                                                                                                                                                                         python3.7/site-packages/raven/contrib/django/management/commands/__pycache__/__init__.cpython-37.pyc0000644                 00000000741 15107360267 0027376 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y
                 @   s   d Z ddlmZmZ dS )z
raven.contrib.django.management.commands
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
    )absolute_importprint_functionN)__doc__
__future__r   r    r   r   b/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/management/commands/__init__.py<module>   s                                  python3.7/site-packages/raven/contrib/django/management/commands/__pycache__/raven.cpython-37.pyc   0000644                 00000004541 15107360267 0026754 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y^                 @   s   d Z ddlmZmZ ddlmZ ddlmZ ddlm	Z	m
Z
 ddlZddlZddl
Z
ddlZddlZejdkZG dd	 d	ejZG d
d deZdS )z
raven.contrib.django.management.commands.raven
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2016 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
    )absolute_importprint_function)BaseCommand)make_option)
store_jsonsend_test_messageN)      r   c               @   s   e Zd ZdddZdS )StoreJsonActionNc             C   sZ   yt |d }W n4 tk
rF   td| j|d f  td Y nX t|| j| d S )Nr   z2Invalid JSON was used for option %s.  Received: %sr   )jsonloads
ValueErrorprintdestsysexitsetattr)selfparser	namespacevalues
option_stringvalue r   _/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/management/commands/raven.py__call__   s    zStoreJsonAction.__call__)N)__name__
__module____qualname__r   r   r   r   r   r
      s   r
   c            
   @   sV   e Zd ZdZes@ejeddeddddeddeddd	df Znd
d Z	dd
dZ
dS )Commandz+Commands to interact with the Sentry clientz--datacallbackstringr   data)actionr    typenargsr   z--tagstagsc             C   s6   |j ddd |j dtddd |j dtddd d S )	Ncommandr   )r%   z--datar"   )r#   r%   r   z--tagsr&   )add_argumentr
   )r   r   r   r   r   
add_arguments/   s    

zCommand.add_argumentsNc             O   sV   |ddgfkr t d td ddlm} t||d|dd td	 d S )
NtestzUsage: manage.py raven testr   r   )clientr&   r"   )r&   r"      )	r   r   r   Zraven.contrib.django.modelsr+   r   gettimesleep)r   r'   argsoptionsr+   r   r   r   handle<   s    
zCommand.handle)N)r   r   r   help	DJANGO_18r   Zoption_listr   r   r)   r2   r   r   r   r   r   "   s   

r   )__doc__
__future__r   r   Zdjango.core.management.baser   optparser   Zraven.scripts.runnerr   r   argparseZdjangor   r   r.   VERSIONr4   Actionr
   r   r   r   r   r   <module>   s   
                                                                                                                                                               python3.7/site-packages/raven/contrib/django/management/commands/__init__.py                        0000644                 00000000412 15107360267 0023104 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.management.commands
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import, print_function
                                                                                                                                                                                                                                                      python3.7/site-packages/raven/contrib/django/management/commands/raven.py                           0000644                 00000004136 15107360267 0022467 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
raven.contrib.django.management.commands.raven
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2016 by the Sentry Team, see AUTHORS for more details
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import, print_function

from django.core.management.base import BaseCommand
from optparse import make_option
from raven.scripts.runner import store_json, send_test_message

import argparse
import django
import json
import sys
import time

DJANGO_18 = django.VERSION >= (1, 8, 0)


class StoreJsonAction(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        try:
            value = json.loads(values[0])
        except ValueError:
            print("Invalid JSON was used for option %s.  Received: %s" % (self.dest, values[0]))
            sys.exit(1)

        setattr(namespace, self.dest, value)


class Command(BaseCommand):
    help = 'Commands to interact with the Sentry client'

    if not DJANGO_18:
        option_list = BaseCommand.option_list + (
            make_option(
                '--data', action='callback', callback=store_json,
                type='string', nargs=1, dest='data'),
            make_option(
                '--tags', action='callback', callback=store_json,
                type='string', nargs=1, dest='tags'),
        )
    else:
        def add_arguments(self, parser):
            parser.add_argument(
                'command', nargs=1,
            )
            parser.add_argument(
                '--data', action=StoreJsonAction,
                nargs=1, dest='data',
            )
            parser.add_argument(
                '--tags', action=StoreJsonAction,
                nargs=1, dest='tags',
            )

    def handle(self, command=None, *args, **options):
        if command not in ('test', ['test']):
            print('Usage: manage.py raven test')
            sys.exit(1)

        from raven.contrib.django.models import client

        send_test_message(client, {
            'tags': options.get('tags'),
            'data': options.get('data'),
        })
        time.sleep(3)
                                                                                                                                                                                                                                                                                                                                                                                                                                  python3.7/site-packages/raven/contrib/django/management/__pycache__/__init__.cpython-37.pyc         0000644                 00000000373 15107360267 0025576 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y7                  @   s   d dl mZmZ dS )    )absolute_importprint_functionN)
__future__r   r    r   r   Y/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/django/management/__init__.py<module>                                                                                                                                                                                                                                                                            python3.7/site-packages/raven/contrib/django/management/__init__.py                                 0000644                 00000000067 15107360267 0021311 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import, print_function
                                                                                                                                                                                                                                                                                                                                                                                                                                                                         python3.7/site-packages/raven/contrib/zope/__pycache__/__init__.cpython-37.pyc                      0000644                 00000006770 15107360267 0023204 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Y%                 @   s   d Z ddlmZ ddlmZmZmZ ddlmZ ddl	m
Z
 ddlZddlm
Z
 ddlmZ eeZG d	d
 d
e
ZG dd deZdS )
z
raven.contrib.zope
~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
    )absolute_import)getouterframescurrentframegetinnerframes)
SentryHandler)FactoryN)nobody)iter_stack_framesc               @   s$   e Zd Zdd Zdd Zdd ZdS )ZopeSentryHandlerFactoryc             C   s   | j jS )N)sectionlevel)self r   L/opt/alt/python37/lib/python3.7/site-packages/raven/contrib/zope/__init__.pygetLevel   s    z!ZopeSentryHandlerFactory.getLevelc             C   s   t f | jjS )N)ZopeSentryHandlerr   __dict__)r
   r   r   r   create   s    zZopeSentryHandlerFactory.createc             C   s   t |  || _d S )N)r   __init__r   )r
   r   r   r   r   r      s    
z!ZopeSentryHandlerFactory.__init__N)__name__
__module____qualname__r   r   r   r   r   r   r   r
      s   r
   c                   s4   e Zd ZdZ fddZdd Z fddZ  ZS )r   z
    Zope unfortunately eats the stack trace information.
    To get the stack trace information and other useful information
    from the request object, this class looks into the different stack
    frames when the emit method is invoked.
    c                s.   t t| j|| |dtj}| | d S )Nr   )superr   r   getloggingERRORsetLevel)r
   argskwr   )	__class__r   r   r   *   s    zZopeSentryHandler.__init__c             C   s   |j dkp|j d S )Nraven)z
sentry.errorszraven.)name
startswith)r
   recordr   r   r   
can_record/   s    
zZopeSentryHandler.can_recordc          	      s  |j tjkr| |rd }d }xtt D ]}|d }|s|jdd }|s|jdd }yt|dd }W n t	k
r   d }Y nX |s|jdd }t
|dsd }|r.|r.P q.W |r||_tt
|d |_|ry|j }|jd |j }|j| t|j| |j|jdd|d	}	d
|	d krZd|	d krZ|	d d
 |	d d< d
|	d krx|	d d
 |	d< t|d|	 |dd }
|
d k	r|
tkr|
 |
dpdd}ni }t|d| W n( ttfk
r   tjddd Y nX tt | !|S )Nr   requestr
   exc_info__getitem__   ZREMOTE_ADDR )headersurlmethodhostdataZHTTP_USER_AGENTr*   z
User-AgentZQUERY_STRINGZquery_stringZAUTHENTICATED_USERemail)idr/   userz#Could not extract data from requestT)r&   )"levelnor   r   r$   r   r   f_localsr   getattrRuntimeErrorhasattrr&   r	   r   stackstdintellseekreaddictenvironZgetURLr,   setattrr   ZgetIdgetPropertyAttributeErrorKeyErrorloggerwarningr   r   emit)r
   r#   r%   r&   Z
frame_infoframeviewZbody_posbodyhttpr1   Z	user_dict)r   r   r   rD   5   s`    



zZopeSentryHandler.emit)r   r   r   __doc__r   r$   rD   
__classcell__r   r   )r   r   r   "   s   r   )rI   
__future__r   inspectr   r   r   Zraven.handlers.loggingr   Z!ZConfig.components.logger.factoryr   r   ZAccessControl.usersr   Zraven.utils.stacksr	   	getLoggerr   rB   r
   r   r   r   r   r   <module>   s   

        python3.7/site-packages/raven/contrib/zope/__init__.py                                              0000644                 00000010045 15107360267 0016705 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # -*- coding: utf-8 -*-
"""
raven.contrib.zope
~~~~~~~~~~~~~~~~~~

:copyright: (c) 2010-2013 by the Sentry Team, see AUTHORS for more details.
:license: BSD, see LICENSE for more details.
"""
from __future__ import absolute_import

from inspect import getouterframes, currentframe, getinnerframes
from raven.handlers.logging import SentryHandler
from ZConfig.components.logger.factory import Factory
import logging
from AccessControl.users import nobody
from raven.utils.stacks import iter_stack_frames

logger = logging.getLogger(__name__)


class ZopeSentryHandlerFactory(Factory):

    def getLevel(self):
        return self.section.level

    def create(self):
        return ZopeSentryHandler(**self.section.__dict__)

    def __init__(self, section):
        Factory.__init__(self)
        self.section = sectio