    C   s   | j S )N)r>   )r@   r'   r'   r7   rC     s    zPackageFinder.target_pythonc             C   s   | j jS )N)r   search_scope)r@   r'   r'   r7   r     s    zPackageFinder.search_scopec             C   s   || j _d S )N)r   r   )r@   r   r'   r'   r7   r     s    c             C   s   | j jS )N)r   
find_links)r@   r'   r'   r7   r     s    zPackageFinder.find_linksc             C   s   | j jS )N)r   
index_urls)r@   r'   r'   r7   r     s    zPackageFinder.index_urlsc             c   s"   x| j jjD ]}t| V  qW d S )N)r   sessionpip_trusted_originsr   )r@   	host_portr'   r'   r7   
trusted_hosts  s    zPackageFinder.trusted_hostsc             C   s   | j jS )N)r   r}   )r@   r'   r'   r7   r}     s    z#PackageFinder.allow_all_prereleasesc             C   s   d| j _d S )NT)r   r}   )r@   r'   r'   r7   set_allow_all_prereleases  s    z'PackageFinder.set_allow_all_prereleasesc             C   s   | j jS )N)r   r~   )r@   r'   r'   r7   r~     s    zPackageFinder.prefer_binaryc             C   s   d| j _d S )NT)r   r~   )r@   r'   r'   r7   set_prefer_binary  s    zPackageFinder.set_prefer_binaryc             C   s.   t |}| j|}t|||| j| j| jdS )N)r?   rA   rB   rC   rD   r4   )r   r   get_allowed_formatsr9   r>   r:   r<   )r@   r?   rA   rB   r'   r'   r7   make_link_evaluator  s    z!PackageFinder.make_link_evaluatorc             C   sT   g g  }}t  }x:|D ]2}||kr|| |jr>|| q|| qW || S )z
        Returns elements of links in order, non-egg links first, egg links
        second, while eliminating duplicates
        )r   addrM   rs   )r@   linkseggsno_eggsseenr3   r'   r'   r7   _sort_links  s    


zPackageFinder._sort_linksc             C   s(   || j kr$td|| | j | d S )NzSkipping link: %s: %s)r   r.   r/   r   )r@   r3   r]   r'   r'   r7   _log_skipped_link  s    
zPackageFinder._log_skipped_linkc             C   s<   | |\}}|s(|r$| j||d dS t|j|t|dS )z
        If the link is a candidate for install, convert it to an
        InstallationCandidate and return it. Otherwise, return None.
        )r]   N)rR   r3   r6   )rd   r   r   r?   r2   )r@   link_evaluatorr3   is_candidateresultr'   r'   r7   get_install_candidate  s    z#PackageFinder.get_install_candidatec             C   s:   g }x0|  |D ]"}| ||}|dk	r|| qW |S )zU
        Convert links that are candidates to InstallationCandidate objects.
        N)r   r   rs   )r@   r   r   ru   r3   rm   r'   r'   r7   evaluate_links  s    zPackageFinder.evaluate_linksc          	   C   sT   t d| | j|}|d kr$g S tt|}t  | j||d}W d Q R X |S )Nz-Fetching project page and analyzing links: %s)r   )r.   r/   r   
fetch_pagerp   r
   r   r   )r@   project_urlr   	html_page
page_links
package_linksr'   r'   r7   process_project_url  s    z!PackageFinder.process_project_url)maxsizec       	      C   s   | j |}| |}| j||jd}g }x&|jD ]}| j||d}|| q2W | j||jd}|r|j	dd t
dddd |D  || | S )	a  Find all available InstallationCandidate for project_name

        This checks index_urls and find_links.
        All versions found are returned as an InstallationCandidate list.

        See LinkEvaluator.evaluate_link() for details on which files
        are accepted.
        )r   )r   T)reversezLocal files found: %sz, c             S   s   g | ]}t |jjqS r'   )r   r3   url)rl   rm   r'   r'   r7   r   I  s   z5PackageFinder.find_all_candidates.<locals>.<listcomp>)
r   
collect_linksr   r   r   project_urlsr   extendfilessortr.   r/   r0   )	r@   r?   collected_linksr   find_links_versions
page_versionsr   r   
file_versionsr'   r'   r7   find_all_candidates%  s*    



z!PackageFinder.find_all_candidatesc             C   s"   | j }tj|| j|j|j||dS )z3Create a CandidateEvaluator object to use.
        )r?   rC   r~   r}   r   rk   )r   r   r   r>   r~   r}   )r@   r?   r   rk   r   r'   r'   r7   make_candidate_evaluatorQ  s    	z&PackageFinder.make_candidate_evaluatorc             C   s$   |  |}| j|||d}||S )a  Find matches for the given project and specifier.

        :param specifier: An optional object implementing `filter`
            (e.g. `packaging.specifiers.SpecifierSet`) to filter applicable
            versions.

        :return: A `BestCandidateResult` instance.
        )r?   r   rk   )r   r   r   )r@   r?   r   rk   ru   candidate_evaluatorr'   r'   r7   find_best_candidated  s    
z!PackageFinder.find_best_candidatec       	      C   s  |j dd}| j|j|j|d}|j}d}|jdk	r@t|jj}dd }|dkr||dkr|t	d|||
  td|d}|r|dks|j|krd	}|s|dk	r|rt
d
| nt
d||j dS |rt
d|||  tt
d
|j||  |S )zTry to find a Link matching req

        Expects req, an InstallRequirement and upgrade, a boolean
        Returns a InstallationCandidate if found,
        Raises DistributionNotFound or BestVersionAlreadyInstalled otherwise
        F)trust_internet)r   rk   Nc             S   s    d tdd | D tdpdS )Nz, c             S   s   h | ]}t |jqS r'   )r2   r6   )rl   r   r'   r'   r7   r     s    zKPackageFinder.find_requirement.<locals>._format_versions.<locals>.<setcomp>)r   none)r0   r   
parse_version)	cand_iterr'   r'   r7   _format_versions  s    
z8PackageFinder.find_requirement.<locals>._format_versionszNCould not find a version that satisfies the requirement %s (from versions: %s)z%No matching distribution found for {}TzLExisting installed version (%s) is most up-to-date and satisfies requirementzUExisting installed version (%s) satisfies requirement (most up-to-date version is %s)z=Installed version (%s) is most up-to-date (past versions: %s)z)Using version %s (newest of versions: %s))rk   r   rR   r   r   satisfied_byr   r6   r.   criticalr   r   rL   r/   r   r   )	r@   requpgraderk   best_candidate_resultr   installed_versionr   best_installedr'   r'   r7   find_requirement{  sT    

zPackageFinder.find_requirement)NNN)N)NN)NN)re   rf   rg   rh   rE   r   r   propertyrC   r   setterr   r   r   r}   r   r~   r   r   r   r   r   r   r   r   r   r   r   r   r'   r'   r'   r7   r)   F  s8     
!
/ 
 
c             C   sL   x6t | D ]*\}}|dkrq
t| d| |kr
|S q
W td| |dS )a  Find the separator's index based on the package's canonical name.

    :param fragment: A <package>+<version> filename "fragment" (stem) or
        egg fragment.
    :param canonical_name: The package's canonical name.

    This function is needed since the canonicalized name does not necessarily
    have the same length as the egg info's name part. An example::

    >>> fragment = 'foo__bar-1.0'
    >>> canonical_name = 'foo-bar'
    >>> _find_name_version_sep(fragment, canonical_name)
    8
    -Nz{} does not match {})	enumerater   
ValueErrorrL   )fragmentrA   ir   r'   r'   r7   _find_name_version_sep  s    r   c             C   s@   yt | |d }W n tk
r&   dS X | |d }|s<dS |S )zParse the version string from a <package>+<version> filename
    "fragment" (stem) or egg fragment.

    :param fragment: The string to parse. E.g. foo-2.1
    :param canonical_name: The canonicalized name of the package this
        belongs to.
    rI   N)r   r   )r   rA   
version_startr6   r'   r'   r7   rV     s    	rV   )F)Trh   
__future__r   loggingri   Zpip._vendor.packagingr   Zpip._vendor.packaging.utilsr   pip._vendor.packaging.versionr   r   pip._internal.exceptionsr   r   r   r	   pip._internal.index.collectorr
   pip._internal.models.candidater   #pip._internal.models.format_controlr   pip._internal.models.linkr
   $pip._internal.models.selection_prefsr   "pip._internal.models.target_pythonr   pip._internal.models.wheelr   pip._internal.utils.compatr   pip._internal.utils.filetypesr   pip._internal.utils.loggingr   pip._internal.utils.miscr   pip._internal.utils.packagingr   pip._internal.utils.typingr   pip._internal.utils.unpackingr   pip._internal.utils.urlsr   typingr   r   r   r   r   r   r   r    pip._vendor.packaging.tagsr!   r"   r#   !pip._internal.models.search_scoper$   Zpip._internal.reqr%   pip._internal.utils.hashesr&   r   r2   ZBuildTagZCandidateSortingKey__all__	getLoggerre   r.   r8   objectr9   r{   r|   r(   r   r)   r   rV   r'   r'   r'   r7   <module>   s`   (


( K- E   
                                                                                                                                                                                                                                                            python3.7/site-packages/pip/_internal/index/collector.py                                            0000644                 00000053500 15107360303 0017250 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
The main purpose of this module is to expose LinkCollector.collect_links().
"""

import cgi
import functools
import itertools
import logging
import mimetypes
import os
import re
from collections import OrderedDict

from pip._vendor import html5lib, requests
from pip._vendor.distlib.compat import unescape
from pip._vendor.requests.exceptions import RetryError, SSLError
from pip._vendor.six.moves.urllib import parse as urllib_parse
from pip._vendor.six.moves.urllib import request as urllib_request

from pip._internal.exceptions import NetworkConnectionError
from pip._internal.models.link import Link
from pip._internal.models.search_scope import SearchScope
from pip._internal.network.utils import raise_for_status
from pip._internal.utils.compat import lru_cache
from pip._internal.utils.filetypes import ARCHIVE_EXTENSIONS
from pip._internal.utils.misc import pairwise, redact_auth_from_url
from pip._internal.utils.typing import MYPY_CHECK_RUNNING
from pip._internal.utils.urls import path_to_url, url_to_path
from pip._internal.vcs import is_url, vcs

if MYPY_CHECK_RUNNING:
    from optparse import Values
    from typing import (
        Callable,
        Iterable,
        List,
        MutableMapping,
        Optional,
        Sequence,
        Tuple,
        Union,
    )
    import xml.etree.ElementTree

    from pip._vendor.requests import Response

    from pip._internal.network.session import PipSession

    HTMLElement = xml.etree.ElementTree.Element
    ResponseHeaders = MutableMapping[str, str]


logger = logging.getLogger(__name__)


def _match_vcs_scheme(url):
    # type: (str) -> Optional[str]
    """Look for VCS schemes in the URL.

    Returns the matched VCS scheme, or None if there's no match.
    """
    for scheme in vcs.schemes:
        if url.lower().startswith(scheme) and url[len(scheme)] in '+:':
            return scheme
    return None


def _is_url_like_archive(url):
    # type: (str) -> bool
    """Return whether the URL looks like an archive.
    """
    filename = Link(url).filename
    for bad_ext in ARCHIVE_EXTENSIONS:
        if filename.endswith(bad_ext):
            return True
    return False


class _NotHTML(Exception):
    def __init__(self, content_type, request_desc):
        # type: (str, str) -> None
        super(_NotHTML, self).__init__(content_type, request_desc)
        self.content_type = content_type
        self.request_desc = request_desc


def _ensure_html_header(response):
    # type: (Response) -> None
    """Check the Content-Type header to ensure the response contains HTML.

    Raises `_NotHTML` if the content type is not text/html.
    """
    content_type = response.headers.get("Content-Type", "")
    if not content_type.lower().startswith("text/html"):
        raise _NotHTML(content_type, response.request.method)


class _NotHTTP(Exception):
    pass


def _ensure_html_response(url, session):
    # type: (str, PipSession) -> None
    """Send a HEAD request to the URL, and ensure the response contains HTML.

    Raises `_NotHTTP` if the URL is not available for a HEAD request, or
    `_NotHTML` if the content type is not text/html.
    """
    scheme, netloc, path, query, fragment = urllib_parse.urlsplit(url)
    if scheme not in {'http', 'https'}:
        raise _NotHTTP()

    resp = session.head(url, allow_redirects=True)
    raise_for_status(resp)

    _ensure_html_header(resp)


def _get_html_response(url, session):
    # type: (str, PipSession) -> Response
    """Access an HTML page with GET, and return the response.

    This consists of three parts:

    1. If the URL looks suspiciously like an archive, send a HEAD first to
       check the Content-Type is HTML, to avoid downloading a large file.
       Raise `_NotHTTP` if the content type cannot be determined, or
       `_NotHTML` if it is not HTML.
    2. Actually perform the request. Raise HTTP exceptions on network failures.
    3. Check the Content-Type header to make sure we got HTML, and raise
       `_NotHTML` otherwise.
    """
    if _is_url_like_archive(url):
        _ensure_html_response(url, session=session)

    logger.debug('Getting page %s', redact_auth_from_url(url))

    resp = session.get(
        url,
        headers={
            "Accept": "text/html",
            # We don't want to blindly returned cached data for
            # /simple/, because authors generally expecting that
            # twine upload && pip install will function, but if
            # they've done a pip install in the last ~10 minutes
            # it won't. Thus by setting this to zero we will not
            # blindly use any cached data, however the benefit of
            # using max-age=0 instead of no-cache, is that we will
            # still support conditional requests, so we will still
            # minimize traffic sent in cases where the page hasn't
            # changed at all, we will just always incur the round
            # trip for the conditional GET now instead of only
            # once per 10 minutes.
            # For more information, please see pypa/pip#5670.
            "Cache-Control": "max-age=0",
        },
    )
    raise_for_status(resp)

    # The check for archives above only works if the url ends with
    # something that looks like an archive. However that is not a
    # requirement of an url. Unless we issue a HEAD request on every
    # url we cannot know ahead of time for sure if something is HTML
    # or not. However we can check after we've downloaded it.
    _ensure_html_header(resp)

    return resp


def _get_encoding_from_headers(headers):
    # type: (ResponseHeaders) -> Optional[str]
    """Determine if we have any encoding information in our headers.
    """
    if headers and "Content-Type" in headers:
        content_type, params = cgi.parse_header(headers["Content-Type"])
        if "charset" in params:
            return params['charset']
    return None


def _determine_base_url(document, page_url):
    # type: (HTMLElement, str) -> str
    """Determine the HTML document's base URL.

    This looks for a ``<base>`` tag in the HTML document. If present, its href
    attribute denotes the base URL of anchor tags in the document. If there is
    no such tag (or if it does not have a valid href attribute), the HTML
    file's URL is used as the base URL.

    :param document: An HTML document representation. The current
        implementation expects the result of ``html5lib.parse()``.
    :param page_url: The URL of the HTML document.
    """
    for base in document.findall(".//base"):
        href = base.get("href")
        if href is not None:
            return href
    return page_url


def _clean_url_path_part(part):
    # type: (str) -> str
    """
    Clean a "part" of a URL path (i.e. after splitting on "@" characters).
    """
    # We unquote prior to quoting to make sure nothing is double quoted.
    return urllib_parse.quote(urllib_parse.unquote(part))


def _clean_file_url_path(part):
    # type: (str) -> str
    """
    Clean the first part of a URL path that corresponds to a local
    filesystem path (i.e. the first part after splitting on "@" characters).
    """
    # We unquote prior to quoting to make sure nothing is double quoted.
    # Also, on Windows the path part might contain a drive letter which
    # should not be quoted. On Linux where drive letters do not
    # exist, the colon should be quoted. We rely on urllib.request
    # to do the right thing here.
    return urllib_request.pathname2url(urllib_request.url2pathname(part))


# percent-encoded:                   /
_reserved_chars_re = re.compile('(@|%2F)', re.IGNORECASE)


def _clean_url_path(path, is_local_path):
    # type: (str, bool) -> str
    """
    Clean the path portion of a URL.
    """
    if is_local_path:
        clean_func = _clean_file_url_path
    else:
        clean_func = _clean_url_path_part

    # Split on the reserved characters prior to cleaning so that
    # revision strings in VCS URLs are properly preserved.
    parts = _reserved_chars_re.split(path)

    cleaned_parts = []
    for to_clean, reserved in pairwise(itertools.chain(parts, [''])):
        cleaned_parts.append(clean_func(to_clean))
        # Normalize %xx escapes (e.g. %2f -> %2F)
        cleaned_parts.append(reserved.upper())

    return ''.join(cleaned_parts)


def _clean_link(url):
    # type: (str) -> str
    """
    Make sure a link is fully quoted.
    For example, if ' ' occurs in the URL, it will be replaced with "%20",
    and without double-quoting other characters.
    """
    # Split the URL into parts according to the general structure
    # `scheme://netloc/path;parameters?query#fragment`.
    result = urllib_parse.urlparse(url)
    # If the netloc is empty, then the URL refers to a local filesystem path.
    is_local_path = not result.netloc
    path = _clean_url_path(result.path, is_local_path=is_local_path)
    return urllib_parse.urlunparse(result._replace(path=path))


def _create_link_from_element(
    anchor,    # type: HTMLElement
    page_url,  # type: str
    base_url,  # type: str
):
    # type: (...) -> Optional[Link]
    """
    Convert an anchor element in a simple repository page to a Link.
    """
    href = anchor.get("href")
    if not href:
        return None

    url = _clean_link(urllib_parse.urljoin(base_url, href))
    pyrequire = anchor.get('data-requires-python')
    pyrequire = unescape(pyrequire) if pyrequire else None

    yanked_reason = anchor.get('data-yanked')
    if yanked_reason:
        # This is a unicode string in Python 2 (and 3).
        yanked_reason = unescape(yanked_reason)

    link = Link(
        url,
        comes_from=page_url,
        requires_python=pyrequire,
        yanked_reason=yanked_reason,
    )

    return link


class CacheablePageContent(object):
    def __init__(self, page):
        # type: (HTMLPage) -> None
        assert page.cache_link_parsing
        self.page = page

    def __eq__(self, other):
        # type: (object) -> bool
        return (isinstance(other, type(self)) and
                self.page.url == other.page.url)

    def __hash__(self):
        # type: () -> int
        return hash(self.page.url)


def with_cached_html_pages(
    fn,    # type: Callable[[HTMLPage], Iterable[Link]]
):
    # type: (...) -> Callable[[HTMLPage], List[Link]]
    """
    Given a function that parses an Iterable[Link] from an HTMLPage, cache the
    function's result (keyed by CacheablePageContent), unless the HTMLPage
    `page` has `page.cache_link_parsing == False`.
    """

    @lru_cache(maxsize=None)
    def wrapper(cacheable_page):
        # type: (CacheablePageContent) -> List[Link]
        return list(fn(cacheable_page.page))

    @functools.wraps(fn)
    def wrapper_wrapper(page):
        # type: (HTMLPage) -> List[Link]
        if page.cache_link_parsing:
            return wrapper(CacheablePageContent(page))
        return list(fn(page))

    return wrapper_wrapper


@with_cached_html_pages
def parse_links(page):
    # type: (HTMLPage) -> Iterable[Link]
    """
    Parse an HTML document, and yield its anchor elements as Link objects.
    """
    document = html5lib.parse(
        page.content,
        transport_encoding=page.encoding,
        namespaceHTMLElements=False,
    )

    url = page.url
    base_url = _determine_base_url(document, url)
    for anchor in document.findall(".//a"):
        link = _create_link_from_element(
            anchor,
            page_url=url,
            base_url=base_url,
        )
        if link is None:
            continue
        yield link


class HTMLPage(object):
    """Represents one page, along with its URL"""

    def __init__(
        self,
        content,                  # type: bytes
        encoding,                 # type: Optional[str]
        url,                      # type: str
        cache_link_parsing=True,  # type: bool
    ):
        # type: (...) -> None
        """
        :param encoding: the encoding to decode the given content.
        :param url: the URL from which the HTML was downloaded.
        :param cache_link_parsing: whether links parsed from this page's url
                                   should be cached. PyPI index urls should
                                   have this set to False, for example.
        """
        self.content = content
        self.encoding = encoding
        self.url = url
        self.cache_link_parsing = cache_link_parsing

    def __str__(self):
        # type: () -> str
        return redact_auth_from_url(self.url)


def _handle_get_page_fail(
    link,  # type: Link
    reason,  # type: Union[str, Exception]
    meth=None  # type: Optional[Callable[..., None]]
):
    # type: (...) -> None
    if meth is None:
        meth = logger.debug
    meth("Could not fetch URL %s: %s - skipping", link, reason)


def _make_html_page(response, cache_link_parsing=True):
    # type: (Response, bool) -> HTMLPage
    encoding = _get_encoding_from_headers(response.headers)
    return HTMLPage(
        response.content,
        encoding=encoding,
        url=response.url,
        cache_link_parsing=cache_link_parsing)


def _get_html_page(link, session=None):
    # type: (Link, Optional[PipSession]) -> Optional[HTMLPage]
    if session is None:
        raise TypeError(
            "_get_html_page() missing 1 required keyword argument: 'session'"
        )

    url = link.url.split('#', 1)[0]

    # Check for VCS schemes that do not support lookup as web pages.
    vcs_scheme = _match_vcs_scheme(url)
    if vcs_scheme:
        logger.warning('Cannot look at %s URL %s because it does not support '
                       'lookup as web pages.', vcs_scheme, link)
        return None

    # Tack index.html onto file:// URLs that point to directories
    scheme, _, path, _, _, _ = urllib_parse.urlparse(url)
    if (scheme == 'file' and os.path.isdir(urllib_request.url2pathname(path))):
        # add trailing slash if not present so urljoin doesn't trim
        # final segment
        if not url.endswith('/'):
            url += '/'
        url = urllib_parse.urljoin(url, 'index.html')
        logger.debug(' file: URL is directory, getting %s', url)

    try:
        resp = _get_html_response(url, session=session)
    except _NotHTTP:
        logger.warning(
            'Skipping page %s because it looks like an archive, and cannot '
            'be checked by a HTTP HEAD request.', link,
        )
    except _NotHTML as exc:
        logger.warning(
            'Skipping page %s because the %s request got Content-Type: %s.'
            'The only supported Content-Type is text/html',
            link, exc.request_desc, exc.content_type,
        )
    except NetworkConnectionError as exc:
        _handle_get_page_fail(link, exc)
    except RetryError as exc:
        _handle_get_page_fail(link, exc)
    except SSLError as exc:
        reason = "There was a problem confirming the ssl certificate: "
        reason += str(exc)
        _handle_get_page_fail(link, reason, meth=logger.info)
    except requests.ConnectionError as exc:
        _handle_get_page_fail(link, "connection error: {}".format(exc))
    except requests.Timeout:
        _handle_get_page_fail(link, "timed out")
    else:
        return _make_html_page(resp,
                               cache_link_parsing=link.cache_link_parsing)
    return None


def _remove_duplicate_links(links):
    # type: (Iterable[Link]) -> List[Link]
    """
    Return a list of links, with duplicates removed and ordering preserved.
    """
    # We preserve the ordering when removing duplicates because we can.
    return list(OrderedDict.fromkeys(links))


def group_locations(locations, expand_dir=False):
    # type: (Sequence[str], bool) -> Tuple[List[str], List[str]]
    """
    Divide a list of locations into two groups: "files" (archives) and "urls."

    :return: A pair of lists (files, urls).
    """
    files = []
    urls = []

    # puts the url for the given file path into the appropriate list
    def sort_path(path):
        # type: (str) -> None
        url = path_to_url(path)
        if mimetypes.guess_type(url, strict=False)[0] == 'text/html':
            urls.append(url)
        else:
            files.append(url)

    for url in locations:

        is_local_path = os.path.exists(url)
        is_file_url = url.startswith('file:')

        if is_local_path or is_file_url:
            if is_local_path:
                path = url
            else:
                path = url_to_path(url)
            if os.path.isdir(path):
                if expand_dir:
                    path = os.path.realpath(path)
                    for item in os.listdir(path):
                        sort_path(os.path.join(path, item))
                elif is_file_url:
                    urls.append(url)
                else:
                    logger.warning(
                        "Path '%s' is ignored: it is a directory.", path,
                    )
            elif os.path.isfile(path):
                sort_path(path)
            else:
                logger.warning(
                    "Url '%s' is ignored: it is neither a file "
                    "nor a directory.", url,
                )
        elif is_url(url):
            # Only add url with clear scheme
            urls.append(url)
        else:
            logger.warning(
                "Url '%s' is ignored. It is either a non-existing "
                "path or lacks a specific scheme.", url,
            )

    return files, urls


class CollectedLinks(object):

    """
    Encapsulates the return value of a call to LinkCollector.collect_links().

    The return value includes both URLs to project pages containing package
    links, as well as individual package Link objects collected from other
    sources.

    This info is stored separately as:

    (1) links from the configured file locations,
    (2) links from the configured find_links, and
    (3) urls to HTML project pages, as described by the PEP 503 simple
        repository API.
    """

    def __init__(
        self,
        files,         # type: List[Link]
        find_links,    # type: List[Link]
        project_urls,  # type: List[Link]
    ):
        # type: (...) -> None
        """
        :param files: Links from file locations.
        :param find_links: Links from find_links.
        :param project_urls: URLs to HTML project pages, as described by
            the PEP 503 simple repository API.
        """
        self.files = files
        self.find_links = find_links
        self.project_urls = project_urls


class LinkCollector(object):

    """
    Responsible for collecting Link objects from all configured locations,
    making network requests as needed.

    The class's main method is its collect_links() method.
    """

    def __init__(
        self,
        session,       # type: PipSession
        search_scope,  # type: SearchScope
    ):
        # type: (...) -> None
        self.search_scope = search_scope
        self.session = session

    @classmethod
    def create(cls, session, options, suppress_no_index=False):
        # type: (PipSession, Values, bool) -> LinkCollector
        """
        :param session: The Session to use to make requests.
        :param suppress_no_index: Whether to ignore the --no-index option
            when constructing the SearchScope object.
        """
        index_urls = [options.index_url] + options.extra_index_urls
        if options.no_index and not suppress_no_index:
            logger.debug(
                'Ignoring indexes: %s',
                ','.join(redact_auth_from_url(url) for url in index_urls),
            )
            index_urls = []

        # Make sure find_links is a list before passing to create().
        find_links = options.find_links or []

        search_scope = SearchScope.create(
            find_links=find_links, index_urls=index_urls,
        )
        link_collector = LinkCollector(
            session=session, search_scope=search_scope,
        )
        return link_collector

    @property
    def find_links(self):
        # type: () -> List[str]
        return self.search_scope.find_links

    def fetch_page(self, location):
        # type: (Link) -> Optional[HTMLPage]
        """
        Fetch an HTML page containing package links.
        """
        return _get_html_page(location, session=self.session)

    def collect_links(self, project_name):
        # type: (str) -> CollectedLinks
        """Find all available links for the given project name.

        :return: All the Link objects (unfiltered), as a CollectedLinks object.
        """
        search_scope = self.search_scope
        index_locations = search_scope.get_index_urls_locations(project_name)
        index_file_loc, index_url_loc = group_locations(index_locations)
        fl_file_loc, fl_url_loc = group_locations(
            self.find_links, expand_dir=True,
        )

        file_links = [
            Link(url) for url in itertools.chain(index_file_loc, fl_file_loc)
        ]

        # We trust every directly linked archive in find_links
        find_link_links = [Link(url, '-f') for url in self.find_links]

        # We trust every url that the user has given us whether it was given
        # via --index-url or --find-links.
        # We want to filter out anything that does not have a secure origin.
        url_locations = [
            link for link in itertools.chain(
                # Mark PyPI indices as "cache_link_parsing == False" -- this
                # will avoid caching the result of parsing the page for links.
                (Link(url, cache_link_parsing=False) for url in index_url_loc),
                (Link(url) for url in fl_url_loc),
            )
            if self.session.is_secure_origin(link)
        ]

        url_locations = _remove_duplicate_links(url_locations)
        lines = [
            '{} location(s) to search for versions of {}:'.format(
                len(url_locations), project_name,
            ),
        ]
        for link in url_locations:
            lines.append('* {}'.format(link))
        logger.debug('\n'.join(lines))

        return CollectedLinks(
            files=file_links,
            find_links=find_link_links,
            project_urls=url_locations,
        )
                                                                                                                                                                                                python3.7/site-packages/pip/_internal/index/__init__.py                                             0000644                 00000000036 15107360303 0017015 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Index interaction code
"""
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  python3.7/site-packages/pip/_internal/index/package_finder.py                                       0000644                 00000111102 15107360303 0020175 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Routines related to PyPI, indexes"""

# The following comment should be removed at some point in the future.
# mypy: strict-optional=False

from __future__ import absolute_import

import logging
import re

from pip._vendor.packaging import specifiers
from pip._vendor.packaging.utils import canonicalize_name
from pip._vendor.packaging.version import parse as parse_version

from pip._internal.exceptions import (
    BestVersionAlreadyInstalled,
    DistributionNotFound,
    InvalidWheelFilename,
    UnsupportedWheel,
)
from pip._internal.index.collector import parse_links
from pip._internal.models.candidate import InstallationCandidate
from pip._internal.models.format_control import FormatControl
from pip._internal.models.link import Link
from pip._internal.models.selection_prefs import SelectionPreferences
from pip._internal.models.target_python import TargetPython
from pip._internal.models.wheel import Wheel
from pip._internal.utils.compat import lru_cache
from pip._internal.utils.filetypes import WHEEL_EXTENSION
from pip._internal.utils.logging import indent_log
from pip._internal.utils.misc import build_netloc
from pip._internal.utils.packaging import check_requires_python
from pip._internal.utils.typing import MYPY_CHECK_RUNNING
from pip._internal.utils.unpacking import SUPPORTED_EXTENSIONS
from pip._internal.utils.urls import url_to_path

if MYPY_CHECK_RUNNING:
    from typing import (
        FrozenSet, Iterable, List, Optional, Set, Text, Tuple, Union,
    )

    from pip._vendor.packaging.tags import Tag
    from pip._vendor.packaging.version import _BaseVersion

    from pip._internal.index.collector import LinkCollector
    from pip._internal.models.search_scope import SearchScope
    from pip._internal.req import InstallRequirement
    from pip._internal.utils.hashes import Hashes

    BuildTag = Union[Tuple[()], Tuple[int, str]]
    CandidateSortingKey = (
        Tuple[int, int, int, _BaseVersion, BuildTag, Optional[int]]
    )


__all__ = ['FormatControl', 'BestCandidateResult', 'PackageFinder']


logger = logging.getLogger(__name__)


def _check_link_requires_python(
    link,  # type: Link
    version_info,  # type: Tuple[int, int, int]
    ignore_requires_python=False,  # type: bool
):
    # type: (...) -> bool
    """
    Return whether the given Python version is compatible with a link's
    "Requires-Python" value.

    :param version_info: A 3-tuple of ints representing the Python
        major-minor-micro version to check.
    :param ignore_requires_python: Whether to ignore the "Requires-Python"
        value if the given Python version isn't compatible.
    """
    try:
        is_compatible = check_requires_python(
            link.requires_python, version_info=version_info,
        )
    except specifiers.InvalidSpecifier:
        logger.debug(
            "Ignoring invalid Requires-Python (%r) for link: %s",
            link.requires_python, link,
        )
    else:
        if not is_compatible:
            version = '.'.join(map(str, version_info))
            if not ignore_requires_python:
                logger.debug(
                    'Link requires a different Python (%s not in: %r): %s',
                    version, link.requires_python, link,
                )
                return False

            logger.debug(
                'Ignoring failed Requires-Python check (%s not in: %r) '
                'for link: %s',
                version, link.requires_python, link,
            )

    return True


class LinkEvaluator(object):

    """
    Responsible for evaluating links for a particular project.
    """

    _py_version_re = re.compile(r'-py([123]\.?[0-9]?)$')

    # Don't include an allow_yanked default value to make sure each call
    # site considers whether yanked releases are allowed. This also causes
    # that decision to be made explicit in the calling code, which helps
    # people when reading the code.
    def __init__(
       