2pip {} will remove support for this functionality.zA possible replacement is {}.zPYou can find discussion regarding this at https://github.com/pypa/pip/issues/{}. c             s   s$   | ]\}}|d k	r| |V  qd S )N)format).0valtemplater   r   r
   	<genexpr>a   s    zdeprecated.<locals>.<genexpr>N   )r   
stacklevel)DEPRECATION_MSG_PREFIXjoinr   current_versionr   r   warn)reasonreplacementgone_inissue	sentencesr   r   r   r
   
deprecated>   s    
r2   )NN)N)__doc__
__future__r   r   r   pip._vendor.packaging.versionr   pipr   r+   pip._internal.utils.typingr   typingr   r   r)   Warningr   r   r   r    r2   r   r   r   r
   <module>   s   
                                                                                                                                                                                                                                     python3.7/site-packages/pip/_internal/utils/__pycache__/hashes.cpython-37.pyc                       0000644                 00000011030 15107360301 0023041 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    ReF                 @   s   d dl mZ d dlZd dlmZmZmZ d dlmZm	Z	m
Z
 d dlmZ d dl
mZ erd dlmZmZmZmZmZ d dlmZ erd d	lmZ nd d
lmZ dZddd
gZG dd deZG dd deZdS )    )absolute_importN)	iteritemsiterkeys
itervalues)HashMismatchHashMissingInstallationError)read_chunks)MYPY_CHECK_RUNNING)DictListBinaryIONoReturnIterator)PY3)_Hash)_hashsha256sha384sha512c               @   sf   e Zd ZdZdddZdd Zedd Zd	d
 Zdd Z	d
d Z
dd Zdd Zdd Z
dd ZdS )HasheszaA wrapper that builds multiple hashes at once and checks them against
    known-good values

    Nc             C   s   |dkri n|| _ dS )zo
        :param hashes: A dict of algorithm names pointing to lists of allowed
            hex digests
        N)_allowed)selfhashes r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/hashes.py__init__)   s    zHashes.__init__c                sf   t |tstS |sS s|S i }x:t|jD ],\ } jkrBq. fdd|D | < q.W t|S )Nc                s   g | ]}|j   kr|qS r   )r   ).0v)algr   r   r   
<listcomp>B   s    z"Hashes.__and__.<locals>.<listcomp>)
isinstancer   NotImplementedr   r   )r   othernewvaluesr   )r   r   r   __and__1   s    

zHashes.__and__c             C   s   t dd | j D S )Nc             s   s   | ]}t |V  qd S )N)len)r   digestsr   r   r   	<genexpr>H   s    z&Hashes.digest_count.<locals>.<genexpr>)sumr   r%   )r   r   r   r   digest_countE   s    zHashes.digest_countc             C   s   || j |g kS )z/Return whether the given hex digest is allowed.)r   get)r   	hash_name
hex_digestr   r   r   is_hash_allowedJ   s    zHashes.is_hash_allowedc          
   C   s   i }xLt | jD ]>}yt|||< W q ttfk
rL   td|Y qX qW x(|D ] }xt|D ]}|	| qfW qXW x*t
|D ]\}}| | j| krdS qW | | dS )zCheck good hashes against ones built from iterable of chunks of
        data.

        Raise HashMismatch if none match.

        zUnknown hash name: {}N)
r   r   hashlibr$   
ValueError	TypeErrorr   formatr   updater   	hexdigest_raise)r   chunksgotsr-   chunkhashgotr   r   r   check_against_chunksS   s    
zHashes.check_against_chunksc             C   s   t | j|d S )N)r   r   )r   r8   r   r   r   r6   m   s    z
Hashes._raisec             C   s   |  t|S )zaCheck good hashes against a file-like object

        Raise HashMismatch if none match.

        )r<   r	   )r   filer   r   r   check_against_fileq   s    zHashes.check_against_filec          	   C   s    t |d}| |S Q R X d S )Nrb)openr>   )r   pathr=   r   r   r   check_against_pathz   s    zHashes.check_against_pathc             C   s
   t | jS )z,Return whether I know any known-good hashes.)boolr   )r   r   r   r   __nonzero__   s    zHashes.__nonzero__c             C   s   |   S )N)rD   )r   r   r   r   __bool__   s    zHashes.__bool__)N)__name__
__module____qualname____doc__r   r&   propertyr+   r/   r<   r6   r>   rB   rD   rE   r   r   r   r   r   $   s   
		r   c                   s(   e Zd ZdZ fddZdd Z  ZS )
MissingHasheszA workalike for Hashes used when we're missing a hash for a requirement

    It computes the actual hash of the requirement and raises a HashMissing
    exception showing it to the user.

    c                s   t t| jtg id dS )z!Don't offer the ``hashes`` kwarg.)r   N)superrK   r   
FAVORITE_HASH)r   )	__class__r   r   r      s    zMissingHashes.__init__c             C   s   t |t  d S )N)r   rM   r5   )r   r8   r   r   r   r6      s    zMissingHashes._raise)rF   rG   rH   rI   r   r6   
__classcell__r   r   )rN   r   rK      s   rK   )
__future__r   r0   Zpip._vendor.sixr   r   r   pip._internal.exceptionsr   r   r   pip._internal.utils.miscr	   pip._internal.utils.typingr
   typingr   r   r
   r   r   r   r   r   rM   
STRONG_HASHESobjectr   rK   r   r   r   r   <module>   s   
e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        python3.7/site-packages/pip/_internal/utils/__pycache__/parallel.cpython-37.pyc                     0000644                 00000006143 15107360301 0023373 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    ReL
                 @   s&  d Z ddgZddlmZ ddlmZ ddlmZ ddl	m
Z
 ddlmZ ddl
mZ dd	lmZ erdd
lmZmZmZmZmZ ddlmZ eejejf ZedZed
ZyddlZW n ek
r   dZY nX dZdZedd ZdddZdddZ dddZ!esere Z"Z#ne Z"e!Z#dS )ab  Convenient parallelization of higher order functions.

This module provides two helper functions, with appropriate fallbacks on
Python 2 and on systems lacking support for synchronization mechanisms:

- map_multiprocess
- map_multithread

These helpers work like Python 3's map, with two differences:

- They don't guarantee the order of processing of
  the elements of the iterable.
- The underlying process/thread pools chop the iterable into
  a number of chunks, so that for very long iterables using
  a large value for chunksize can make the job complete much faster
  than using the default value of 1.
map_multiprocessmap_multithread    )contextmanager)Pool)DEFAULT_POOLSIZE)PY2)map)MYPY_CHECK_RUNNING)CallableIterableIteratorUnionTypeVar)poolSTNTFi c             c   s*   z
| V  W d|    |   |   X dS )z>Return a context manager making sure the pool closes properly.N)closejoin	terminate)r    r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/parallel.pyclosing4   s
    
r      c             C   s
   t | |S )zMake an iterator applying func to each element in iterable.

    This function is the sequential fallback either on Python 2
    where Pool.imap* doesn't react to KeyboardInterrupt
    or when sem_open is unavailable.
    )r   )funciterable	chunksizer   r   r   
_map_fallbackB   s    r   c          	   C   s$   t t }|| ||S Q R X dS )zChop iterable into chunks and submit them to a process pool.

    For very long iterables using a large value for chunksize can make
    the job complete much faster than using the default value of 1.

    Return an unordered iterator of the results.
    N)r   ProcessPoolimap_unordered)r   r   r   r   r   r   r   _map_multiprocessM   s    	r   c          	   C   s&   t tt}|| ||S Q R X dS )zChop iterable into chunks and submit them to a thread pool.

    For very long iterables using a large value for chunksize can make
    the job complete much faster than using the default value of 1.

    Return an unordered iterator of the results.
    N)r   
ThreadPoolr   r   )r   r   r   r   r   r   r   _map_multithreadZ   s    	r!   )r   )r   )r   )$__doc____all__
contextlibr   multiprocessingr   r   Zmultiprocessing.dummyr    Zpip._vendor.requests.adaptersr   Zpip._vendor.sixr   pip._vendor.six.movesr   pip._internal.utils.typingr	   typingr
   r   r   r
   r   r   r   r   Zmultiprocessing.synchronizeImportErrorZ
LACK_SEM_OPENTIMEOUTr   r   r   r!   r   r   r   r   r   r   <module>   s8   





                                                                                                                                                                                                                                                                                                                                                                                                                             python3.7/site-packages/pip/_internal/utils/__pycache__/__init__.cpython-37.pyc                     0000644                 00000000342 15107360301 0023331 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                   @   s   d S )N r   r   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/__init__.py<module>                                                                                                                                                                                                                                                                                                     python3.7/site-packages/pip/_internal/utils/__pycache__/temp_dir.cpython-37.pyc                     0000644                 00000015722 15107360301 0023405 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                  @   s&  d dl mZ d dlZd dlZd dlZd dlZd dlZd dlm	Z	 d dl
mZ d dlm
Z
 d dlmZmZ d dlmZ erd dlmZmZmZmZmZmZ ed	d
dZeeZedd
ddZdae	dd Z G dd de!Z"da#e	dd Z$G dd de!Z%e% Z&G dd
 d
e!Z'G dd de'Z(dS )    )absolute_importN)contextmanager)	ExitStack)ensure_text)enumrmtree)MYPY_CHECK_RUNNING)AnyDictIteratorOptionalTypeVarUnion_T
TempDirectory)boundz	build-envzephem-wheel-cachez	req-build)	BUILD_ENVEPHEM_WHEEL_CACHE	REQ_BUILDc           	   c   s2   t  "} t|  }az
d V  W d |aX W d Q R X d S )N)r   _tempdir_manager)stackold_tempdir_manager r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/temp_dir.pyglobal_tempdir_manager%   s
    

r   c               @   s(   e Zd ZdZdd Zdd Zdd ZdS )	TempDirectoryTypeRegistryz$Manages temp directory behavior
    c             C   s
   i | _ d S )N)_should_delete)selfr   r   r   __init__5   s    z"TempDirectoryTypeRegistry.__init__c             C   s   || j |< dS )z[Indicate whether a TempDirectory of the given kind should be
        auto-deleted.
        N)r   )r   kindvaluer   r   r   
set_delete9   s    z$TempDirectoryTypeRegistry.set_deletec             C   s   | j |dS )z^Get configured auto-delete flag for a given TempDirectory type,
        default True.
        T)r   get)r   r   r   r   r   
get_delete@   s    z$TempDirectoryTypeRegistry.get_deleteN)__name__
__module____qualname____doc__r   r!   r#   r   r   r   r   r   1   s   r   c              c   s    t } t a z
t V  W d| a X dS )zuProvides a scoped global tempdir registry that can be used to dictate
    whether directories should be deleted.
    N)_tempdir_registryr   )old_tempdir_registryr   r   r   tempdir_registryK   s
    
r*   c               @   s   e Zd ZdS )_DefaultN)r$   r%   r&   r   r   r   r   r+   Z   s   r+   c                   s^   e Zd ZdZdeddf fdd	Zedd Zd	d
 Zdd Z	d
d Z
dd Zdd Z  Z
S )r   aM  Helper class that owns and cleans up a temporary directory.

    This class can be used as a context manager or as an OO representation of a
    temporary directory.

    Attributes:
        path
            Location to the created temporary directory
        delete
            Whether the directory should be deleted when exiting
            (when used as a contextmanager)

    Methods:
        cleanup()
            Deletes the temporary directory

    When used as a context manager, if the delete attribute is True, on
    exiting the context the temporary directory is deleted.
    NtempFc                sp   t t|   |tkr(|d k	r$d}nd }|d kr:| |}|| _d| _|| _|| _|rlt	d k	sbt
t	|  d S )NF)superr   r   _default_create_path_deleteddeleter   r   AssertionError
enter_context)r   pathr2   r   globally_managed)	__class__r   r   r   v   s    
zTempDirectory.__init__c             C   s   | j rtd| j| jS )Nz$Attempted to access deleted path: {})r1   r3   formatr0   )r   r   r   r   r5      s    zTempDirectory.pathc             C   s   d | jj| jS )Nz	<{} {!r}>)r8   r7   r$   r5   )r   r   r   r   __repr__   s    zTempDirectory.__repr__c             C   s   | S )Nr   )r   r   r   r   	__enter__   s    zTempDirectory.__enter__c             C   s8   | j d k	r| j }ntr$t| j}nd}|r4|   d S )NT)r2   r(   r#   r   cleanup)r   excr    tbr2   r   r   r   __exit__   s    
zTempDirectory.__exit__c             C   s*   t jtjd|d}td| |S )zECreate a temporary directory and store its path in self.path
        zpip-{}-)prefixzCreated temporary directory: %s)osr5   realpathtempfilemkdtempr8   loggerdebug)r   r   r5   r   r   r   r/      s    zTempDirectory._createc             C   s&   d| _ tj| jr"tt| j dS )z?Remove the temporary directory created and reset state
        TN)r1   r@   r5   existsr0   r   r   )r   r   r   r   r;      s    zTempDirectory.cleanup)r$   r%   r&   r'   r.   r   propertyr5   r9   r:   r>   r/   r;   
__classcell__r   r   )r7   r   r   a   s   c                   s:   e Zd ZdZdZd
 fdd	Zedd Zdd	 Z  Z	S )AdjacentTempDirectorya  Helper class that creates a temporary directory adjacent to a real one.

    Attributes:
        original
            The original directory to create a temp directory for.
        path
            After calling create() or entering, contains the full
            path to the temporary directory.
        delete
            Whether the directory should be deleted when exiting
            (when used as a contextmanager)

    z-~.=%0123456789Nc                s"   | d| _tt| j|d d S )Nz/\)r2   )rstriporiginalr-   rI   r   )r   rK   r2   )r7   r   r   r      s    zAdjacentTempDirectory.__init__c             c   s   xZt dt|D ]H}xBt| j|d D ],}dd| ||d  }||kr(|V  q(W qW xNt t| jD ]<}x6t| j|D ]$}dd| | }||kr|V  qW qlW dS )a  Generates a series of temporary names.

        The algorithm replaces the leading characters in the name
        with ones that are valid filesystem characters, but are not
        valid package names (for both Python and pip definitions of
        package).
           ~ N)rangelen	itertoolscombinations_with_replacement
LEADING_CHARSjoin)clsnamei	candidatenew_namer   r   r   _generate_names   s    
z%AdjacentTempDirectory._generate_namesc             C   s   t j| j\}}x| |D ]`}t j||}yt | W n0 tk
rn } z|jtj	kr^ W d d }~X Y qX t j
|}P qW t j
tjd
|d}td| |S )Nzpip-{}-)r?   zCreated temporary directory: %s)r@   r5   splitrK   rZ   rT   mkdirOSErrorerrnoEEXISTrA   rB   rC   r8   rD   rE   )r   r   rootrV   rX   r5   exr   r   r   r/      s    zAdjacentTempDirectory._create)N)
r$   r%   r&   r'   rS   r   classmethodrZ   r/   rH   r   r   )r7   r   rI      s
   
rI   ))
__future__r   r^   rQ   loggingos.pathr@   rB   
contextlibr   pip._vendor.contextlib2r   Zpip._vendor.sixr   pip._internal.utils.miscr   r   pip._internal.utils.typingr   typingr	   r
   r   r   r
   r   r   	getLoggerr$   rD   
tempdir_kindsr   r   objectr   r(   r*   r+   r.   r   rI   r   r   r   r   <module>   s6    
i                                              python3.7/site-packages/pip/_internal/utils/__pycache__/setuptools_build.cpython-37.pyc             0000644                 00000005653 15107360301 0025204 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   sf   d dl Z d dlmZ er,d dlmZmZmZ dZdddZdd	 Z	d
d Z
dd
 Zdd Zdd Z
dS )    N)MYPY_CHECK_RUNNING)ListOptionalSequencezimport sys, setuptools, tokenize; sys.argv[0] = {0!r}; __file__={0!r};f=getattr(tokenize, 'open', open)(__file__);code=f.read().replace('\r\n', '\n');f.close();exec(compile(code, __file__, 'exec'))Fc             C   sF   t jg}|r|dg7 }|dt| g7 }|r4||7 }|rB|dg7 }|S )ao  
    Get setuptools command arguments with shim wrapped setup file invocation.

    :param setup_py_path: The path to setup.py to be wrapped.
    :param global_options: Additional global options.
    :param no_user_config: If True, disables personal user configuration.
    :param unbuffered_output: If True, adds the unbuffered switch to the
     argument list.
    z-uz-cz
--no-user-cfg)sys
executable_SETUPTOOLS_SHIMformat)
setup_py_pathglobal_optionsno_user_configunbuffered_outputargs r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/setuptools_build.pymake_setuptools_shim_args   s    

r   c             C   s(   t | |dd}|dd|g7 }||7 }|S )NT)r   r
   bdist_wheelz-d)r   )r
   r   
build_optionsdestination_dirr   r   r   r    make_setuptools_bdist_wheel_args2   s    r   c             C   s   t | |dd}|ddg7 }|S )NT)r   r
   cleanz--all)r   )r
   r   r   r   r   r   make_setuptools_clean_argsG   s    r   c             C   sf   |r|rt t| ||d}|ddg7 }||7 }|r>|d|g7 }|d k	rR|d|g7 }|rb|ddg7 }|S )N)r   r   developz	--no-depsz--prefixz--homez--userz	--prefix=)AssertionErrorr   )r
   r   install_optionsr   prefixhome
use_user_siter   r   r   r   make_setuptools_develop_argsU   s    
r   c             C   s*   t | |d}|dg7 }|r&|d|g7 }|S )N)r   egg_infoz
--egg-base)r   )r
   egg_info_dirr   r   r   r   r   make_setuptools_egg_info_argsv   s    

r!   c             C   s   |r|rt |r|rt t| ||	dd}|dd|g7 }|dg7 }|d k	rT|d|g7 }|d k	rh|d|g7 }|d k	r||d|g7 }|r|d	d
g7 }|
r|dg7 }n
|dg7 }|r|d
|g7 }||7 }|S )NT)r   r   r
   installz--recordz#--single-version-externally-managedz--rootz--prefixz--homez--userz	--prefix=z	--compilez--no-compilez--install-headers)r   r   )r
   r   r   record_filenamerootr   
header_dirr   r   r   	pycompiler   r   r   r   make_setuptools_install_args   s0    

r'   )NFF)r   pip._internal.utils.typingr   typingr   r   r   r   r   r   r   r   r!   r'   r   r   r   r   <module>   s   	
  
!                                                                                     python3.7/site-packages/pip/_internal/utils/__pycache__/filetypes.cpython-37.pyc                    0000644                 00000001161 15107360301 0023576 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re;                 @   sL   d Z ddlmZ er ddlmZ dZdZdZdefZdZ	ee e	 e Z
d	S )
zFiletype information.
    )MYPY_CHECK_RUNNING)Tuplez.whl)z.tar.bz2z.tbz)z.tar.xzz.txzz.tlzz.tar.lzz	.tar.lzmaz.zip)z.tar.gzz.tgzz.tarN)__doc__pip._internal.utils.typingr   typingr   WHEEL_EXTENSIONBZ2_EXTENSIONS
XZ_EXTENSIONSZIP_EXTENSIONSTAR_EXTENSIONSARCHIVE_EXTENSIONS r
   r
   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/filetypes.py<module>   s                                                                                                                                                                                                                                                                                                                                                                                                                  python3.7/site-packages/pip/_internal/utils/__pycache__/filesystem.cpython-37.pyc                   0000644                 00000012741 15107360301 0023764 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   sR  d dl Z d dlZd dlZd dlZd dlZd dlZd dlZd dlZd dlm	Z	 d dl
mZ d dlm
Z
 d dlmZ d dlmZ d dlmZ d dlmZmZ erd d	lmZmZmZmZmZ G d
d deZdd
 Zdd Zdd Z e	dd Z!e
dddZ"ere"dd Z#n
e"ej#Z#dd Z$dd Z%dd Z&dd  Z'd!d" Z(d#d$ Z)d%d& Z*dS )'    N)contextmanager)NamedTemporaryFile)retry)PY2)get_path_uid)format_size)MYPY_CHECK_RUNNINGcast)AnyBinaryIOIteratorListUnionc               @   s   e Zd Zedd ZdS )NamedTemporaryFileResultc             C   s   d S )N )selfr   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/filesystem.pyfile   s    zNamedTemporaryFileResult.fileN)__name__
__module____qualname__propertyr   r   r   r   r   r      s   r   c             C   s   t jdksttdsdS tj| s(td }xp| |krtj| rt dkrxyt	| }W n t
k
rn   dS X |dkS t| tjS q.| tj
|  }} q.W dS )Nwin32geteuidTr   F)sysplatformhasattrospathisabsAssertionErrorlexistsr   r   OSErroraccessW_OKdirname)r   previouspath_uidr   r   r   check_path_owner   s    
r(   c             C   s|   yt | | W nf ttfk
rv   xJ| |gD ]>}yt|}W n tk
rR   Y q.X |r.t djf t q.W  Y nX dS )zWrap shutil.copy2() but map errors copying socket files to
    SpecialFileError as expected.

    See also https://bugs.python.org/issue37700.
    z`{f}` is a socketN)shutilcopy2r"   IOError	is_socketSpecialFileErrorformatlocals)srcdestfis_socket_filer   r   r   copy2_fixed;   s    r4   c             C   s   t t| jS )N)statS_ISSOCKr   lstatst_mode)r   r   r   r   r,   T   s    r,   c             k   sj   t f dtj| tj| dd|8}td|}z
|V  W d|j  t|j	  X W dQ R X dS )a%  Return a file-like object pointing to a tmp file next to path.

    The file is created securely and is ensured to be written to disk
    after the context reaches its end.

    kwargs will be passed to tempfile.NamedTemporaryFile to control
    the way the temporary file will be opened.
    Fz.tmp)deletedirprefixsuffixr   N)
r   r   r   r%   basenamer	   r   flushfsyncfileno)r   kwargsr2   resultr   r   r   adjacent_tmp_fileY   s    




rC   i     )stop_max_delay
wait_fixedc             C   s@   yt | | W n* tk
r:   t | t | | Y nX d S )N)r   renamer"   remove)r0   r1   r   r   r   replacev   s
    
rI   c             C   sL   x*t j| s*t j| }|| kr$P |} qW t jdkrDt | t jS t| S )zgCheck if a directory is writable.

    Uses os.access() on POSIX, tries creating files on Windows.
    posix)r   r   isdirr%   namer#   r$   _test_writable_dir_win)r   parentr   r   r   test_writable_dir   s    
rO   c                s   d}d xt dD ]}|d fddt dD  }tj| |}yt|tjtjB tjB }W nN tk
r } z0|j	t	j
krw|j	t	jks|j	t	jkrdS  W d d }~X Y qX t
| t| d	S qW td
d S )N(accesstest_deleteme_fishfingers_custard_$abcdefghijklmnopqrstuvwxyz0123456789
    c             3   s   | ]}t  V  qd S )N)randomchoice).0_)alphabetr   r   	<genexpr>   s    z)_test_writable_dir_win.<locals>.<genexpr>   FTz3Unexpected condition testing for writable directory)rangejoinr   r   openO_RDWRO_CREATO_EXCLr"   errnoEEXISTEPERMEACCEScloseunlinkEnvironmentError)r   r=   rW   rL   r   fder   )rX   r   rM      s$     

rM   c                sF   g }x<t | D ].\ }}t||}| fdd|D  qW |S )zReturns a list of absolute paths of files beneath path, recursively,
    with filenames which match the UNIX-style shell glob pattern.c             3   s   | ]}t j |V  qd S )N)r   r   r\   )rV   r2   )rootr   r   rY      s    zfind_files.<locals>.<genexpr>)r   walkfnmatchfilterextend)r   patternrB   rW   filesmatchesr   )rj   r   
find_files   s
    rr   c             C   s   t j| rdS t j| S )Nr   )r   r   islinkgetsize)r   r   r   r   	file_size   s    ru   c             C   s   t t| S )N)r   ru   )r   r   r   r   format_file_size   s    rv   c             C   sJ   d}x@t | D ]2\}}}x&|D ]}t j||}|t|7 }q W qW |S )Ng        )r   rk   r   r\   ru   )r   sizerj   _dirsrp   filename	file_pathr   r   r   directory_size   s    
r{   c             C   s   t t| S )N)r   r{   )r   r   r   r   format_directory_size   s    r|   )+ra   rl   r   os.pathrT   r)   r5   r   
contextlibr   tempfiler   pip._vendor.retryingr   Zpip._vendor.sixr   pip._internal.utils.compatr   pip._internal.utils.miscr   pip._internal.utils.typingr   r	   typingr
   r   r   r
   r   r   r(   r4   r,   rC   _replace_retryrI   rO   rM   rr   ru   rv   r{   r|   r   r   r   r   <module>   s@   

$
                               python3.7/site-packages/pip/_internal/utils/__pycache__/entrypoints.cpython-37.pyc                  0000644                 00000002545 15107360301 0024177 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   sB   d dl Z d dlmZ d dlmZ er4d dlmZmZ dddZdS )	    N)main)MYPY_CHECK_RUNNING)OptionalListFc             C   s   |st jd t| S )a  Central wrapper for all old entrypoints.

    Historically pip has had several entrypoints defined. Because of issues
    arising from PATH, sys.path, multiple Pythons, their interactions, and most
    of them having a pip installed, users suffer every time an entrypoint gets
    moved.

    To alleviate this pain, and provide a mechanism for warning users and
    directing them to an appropriate place for help, we now define all of
    our old entrypoints as wrappers for the current one.
    a  WARNING: pip is being invoked by an old script wrapper. This will fail in a future version of pip.
Please see https://github.com/pypa/pip/issues/5599 for advice on fixing the underlying issue.
To avoid this problem you can invoke Python with '-m pip' instead of running pip directly.
)sysstderrwriter   )args_nowarn r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/entrypoints.py_wrapper
   s    
r
   )NF)	r   pip._internal.cli.mainr   pip._internal.utils.typingr   typingr   r   r
   r   r   r   r   <module>   s
                                                                                                                                                              python3.7/site-packages/pip/_internal/utils/__pycache__/subprocess.cpython-37.pyc                   0000644                 00000013036 15107360301 0023766 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re&              	   @   s   d dl mZ d dlZd dlZd dlZd dlmZ d dlmZm	Z	 d dl
mZ d dlm
Z
mZ d dlmZ d dlmZmZ d d	lmZ erd d
lmZmZmZmZmZmZmZmZ eeeef  Z dZ!dd
 Z"dd Z#dd Z$dd Z%dddZ&dd Z'dS )    )absolute_importN)shlex_quote)SpinnerInterfaceopen_spinner)InstallationError)console_to_strstr_to_display)subprocess_logger)
HiddenTextpath_to_display)MYPY_CHECK_RUNNING)AnyCallableIterableListMappingOptionalTextUnionz(----------------------------------------c              G   s6   g }x,| D ]$}t |tr$|| q
|| q
W |S )z&
    Create a CommandArgs object.
    )
isinstancelistextendappend)argscommand_argsarg r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/subprocess.pymake_command   s    

r   c             C   s   d dd | D S )z/
    Format command arguments for display.
     c             s   s,   | ]$}t |trtt|nt|V  qd S )N)r   r
   r   str).0r   r   r   r   	<genexpr>8   s   z&format_command_args.<locals>.<genexpr>)join)r   r   r   r   format_command_args-   s    
r$   c             C   s   dd | D S )z=
    Return the arguments in their raw, unredacted form.
    c             S   s    g | ]}t |tr|jn|qS r   )r   r
   secret)r!   r   r   r   r   
<listcomp>C   s    z'reveal_command_args.<locals>.<listcomp>r   )r   r   r   r   reveal_command_args=   s    r'   c       	      C   sD   t | }t|dd}t|}d|}dj|||t||td}|S )z
    Create and return the error message to use to log a subprocess error
    with command output.

    :param lines: A list of lines, each ending with a newline.
    z
command bytes)desc zCommand errored out with exit status {exit_status}:
 command: {command_display}
     cwd: {cwd_display}
Complete output ({line_count} lines):
{output}{divider})exit_statuscommand_displaycwd_display
line_countoutputdivider)r$   r   r   r#   formatlenLOG_DIVIDER)	cmd_argscwdlinesr*   commandr+   r,   r.   msgr   r   r   make_subprocess_output_errorG   s    

r8   FraiseTc
          
   C   sd  |dkrg }|dkrg }|r*t j}
tj}nt j}
tj}t  |k}| oN|dk	}
|dkr`t| }|
d| tj	
 }|r|| x|D ]}||d qW yBt
jt| t
jt
jt
j||d}|jst|jst|j  W n: tk
r } z|	rt d||  W dd}~X Y nX g }xRt|j }|s6P | }||d  |
| |
r |sdt|  q W z|  W d|jr|j  X |jo|j|k}|
r|st|r|d n
|d |rZ|dkr"|s
|	r
t | |||jd	}t !| d
"|j|}t#|n8|dkr@t $d||j| n|d
krLnt%d"|d&|S )a  
    Args:
      show_stdout: if true, use INFO to log the subprocess's stderr and
        stdout streams.  Otherwise, use DEBUG.  Defaults to False.
      extra_ok_returncodes: an iterable of integer return codes that are
        acceptable, in addition to 0. Defaults to None, which means [].
      unset_environ: an iterable of environment variable names to unset
        prior to calling subprocess.Popen().
      log_failed_cmd: if false, failed commands are not logged, only raised.
    NzRunning command %s)stderrstdinstdoutr4   envz#Error %s while executing command %s
errordoner9   )r3   r4   r5   r*   zSCommand errored out with exit status {}: {} Check the logs for full command output.warnz$Command "%s" had error code %s in %signorez!Invalid value: on_returncode={!r}r)   )'r	   infologgingINFOdebugDEBUGgetEffectiveLevelr$   osenvironcopyupdatepop
subprocessPopenr'   STDOUTPIPEr;   AssertionErrorr<   close	Exceptioncriticalr   readlinerstripr   spinwait
returncodefinishr8   r?   r0   r   warning
ValueErrorr#   )cmdshow_stdoutr4   
on_returncodeextra_ok_returncodescommand_desc
extra_environ
unset_environspinnerlog_failed_cmdlog_subprocess
used_levelshowing_subprocessuse_spinnerr=   nameprocexc
all_outputlineproc_had_errorr7   exc_msgr   r   r   call_subprocessq   s    
















rr   c                s   d fdd	}|S )zProvide a subprocess_runner that shows a spinner message.

    Intended for use with for pep517's Pep517HookCaller. Thus, the runner has
    an API that matches what's expected by Pep517HookCaller.subprocess_runner.
    Nc          	      s(   t  }t| |||d W d Q R X d S )N)r4   rc   re   )r   rr   )r^   r4   rc   re   )messager   r   runner
  s    
z+runner_with_spinner_message.<locals>.runner)NNr   )rs   rt   r   )rs   r   runner_with_spinner_message  s    
 ru   )	FNr9   NNNNNT)(
__future__r   rD   rI   rN   pip._vendor.six.movesr   pip._internal.cli.spinnersr   r   pip._internal.exceptionsr   pip._internal.utils.compatr   r   pip._internal.utils.loggingr	   pip._internal.utils.miscr
   r   pip._internal.utils.typingr   typingr
   r   r   r   r   r   r   r   r    ZCommandArgsr2   r   r$   r'   r8   rr   ru   r   r   r   r   <module>   s:   (
,        
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   python3.7/site-packages/pip/_internal/utils/__pycache__/unpacking.cpython-37.pyc                    0000644                 00000014544 15107360301 0023562 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re%                 @   st  d Z ddlmZ ddlZddlZddlZddlZddlZddlZddl	m
Z
 ddlmZm
Z
mZmZ ddlmZ ddlmZ erddlmZmZmZmZmZ dd	lmZ eeZee
 ZyddlZee7 ZW n e k
r   e!d
 Y nX yddl"Z"ee7 ZW n  e k
r"   e!d Y nX dd
 Z#dd Z$dd Z%dd Z&dd Z'dd Z(dddZ)dd Z*d ddZ+dS )!zUtilities related archives.
    )absolute_importN)InstallationError)BZ2_EXTENSIONSTAR_EXTENSIONS
XZ_EXTENSIONSZIP_EXTENSIONS)
ensure_dir)MYPY_CHECK_RUNNING)IterableListOptionalTextUnion)ZipInfozbz2 module is not availablezlzma module is not availablec              C   s   t d} t |  | S )zBGet the current umask which involves having to set it temporarily.r   )osumask)mask r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/unpacking.py
current_umask/   s    

r   c             C   sh   |  d d} d| krHd| kr4| d| dk s<d| krH| ddS d| kr\| ddS | dgS d S )N/\    )lstripfindsplit)pathr   r   r   split_leading_dir7   s    r   c             C   sD   d}x:| D ]2}t |\}}|s"dS |dkr0|}q
||kr
dS q
W dS )zyReturns true if all the paths have the same leading path name
    (i.e., everything is in one subdirectory in an archive)NFT)r   )paths
common_prefixr   prefixrestr   r   r   has_leading_dirG   s    
r#   c             C   s0   t j| }t j|}t j||g}||kS )zL
    Return true if the absolute path of target is within the directory
    )r   r   abspathcommonprefix)	directorytarget
abs_directory
abs_targetr!   r   r   r   is_within_directoryW   s    r*   c             C   s   t | dt  @ dB  dS )zx
    Make file present at path have execute for user/group/world
    (chmod +x) is no-op on windows per python docs
    i  I   N)r   chmodr   )r   r   r   r   2set_extracted_file_to_default_mode_plus_executablec   s    r-   c             C   s$   | j d? }t|o t|o |d@ S )N   r+   )
external_attrboolstatS_ISREG)infomoder   r   r   zip_item_is_executablel   s    
r5   Tc       
   
   C   s  t | t| d}ztj|dd}t| o0|}x| D ]}|j}|}|rZt|d }t	j
||}t	j
|}	t
||sd}
t|
| |||ds|drt | q<t |	 ||}z&t|d}t|| W d	Q R X W d	|  t|rt| X q<W W d	|  X d	S )
a  
    Unzip the file (with path `filename`) to the destination `location`.  All
    files are written based on system defaults and umask (i.e. permissions are
    not preserved), except that regular file members with any execute
    permissions (user, group, or world) have "chmod +x" applied after being
    written. Note that for windows, any execute changes using os.chmod are
    no-ops per the python docs.
    rbT)
allowZip64r   zQThe zip file ({}) has a file ({}) trying to install outside target directory ({})r   r   wbN)r   openzipfileZipFiler#   namelistinfolistfilenamer   r   r   joindirnamer*   r   formatendswithshutilcopyfileobjcloser5   r-   )
r>   locationflattenzipfpzipleadingr3   namefndirmessagefpdestfpr   r   r   
unzip_filet   s4    





rQ   c             C   s$  t | |  ds$|  dr*d}nL|  tr>d}n8|  trRd}n$|  drfd}ntd|  d	}t| |}zt	d
d |
 D }xr|
 D ]d}|j}|rt|d }t
j||}t||sd
}t|| ||| rt | q| r\y||| W n8 tk
rX }	 ztd| |j|	 wW dd}	~	X Y nX qy||}
W n< ttfk
r }	 ztd| |j|	 wW dd}	~	X Y nX t t
j| |
dk	stt|d}t|
| W dQ R X |
  ||| |j d@ rt!| qW W d|  X dS )a  
    Untar the file (with path `filename`) to the destination `location`.
    All files are written based on system defaults and umask (i.e. permissions
    are not preserved), except that regular file members with any execute
    permissions (user, group, or world) have "chmod +x" applied after being
    written.  Note that for windows, any execute changes using os.chmod are
    no-ops per the python docs.
    z.gzz.tgzzr:gzzr:bz2zr:xzz.tarrz-Cannot determine compression type for file %szr:*c             S   s   g | ]
}|j qS r   )rK   ).0memberr   r   r   
<listcomp>   s    zuntar_file.<locals>.<listcomp>r   zQThe tar file ({}) has a file ({}) trying to install outside target directory ({})z/In the tar file %s the member %s is invalid: %sNr8   r+   )"r   lowerrB   r   r   loggerwarningtarfiler9   r#   
getmembersrK   r   r   r   r?   r*   r   rA   isdirissym_extract_member	ExceptionextractfileKeyErrorAttributeErrorr@   AssertionErrorrC   rD   rE   utimer4   r-   )r>   rF   r4   tarrJ   rT   rL   r   rN   excrO   rP   r   r   r   
untar_file   sf    





rf   c             C   s   t j| } |dks,|  ts,t| rDt| || d d nR|dkslt	
| sl|  tt t
 rxt| | ntd| || td|d S )Nzapplication/zipz.whl)rG   zapplication/x-gzipzZCannot unpack file %s (downloaded from %s, content-type: %s); cannot detect archive formatz%Cannot determine archive format of {})r   r   realpathrV   rB   r   r:   
is_zipfilerQ   rY   
is_tarfiler   r   r   rf   rW   criticalr   rA   )r>   rF   content_typer   r   r   unpack_file   s$    


rl   )T)N),__doc__
__future__r   loggingr   rC   r1   rY   r:   pip._internal.exceptionsr   pip._internal.utils.filetypesr   r   r   r   pip._internal.utils.miscr   pip._internal.utils.typingr	   typingr
   r   r   r
   r   r   	getLogger__name__rW   SUPPORTED_EXTENSIONSbz2ImportErrordebuglzmar   r   r#   r*   r-   r5   rQ   rf   rl   r   r   r   r   <module>   sF   
	
/V                                                                                                                                                            python3.7/site-packages/pip/_internal/utils/__pycache__/compatibility_tags.cpython-37.pyc           0000644                 00000006752 15107360302 0025475 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re?                 @   s   d Z ddlmZ ddlZddlmZmZmZmZm	Z	m
Z
mZ ddlm
Z
 e
rlddlmZmZmZ ddlmZ edZd	d
 Zdd Zd
d Zdd Zdd ZdddZdddZdS )z3Generate and work with PEP 425 Compatibility Tags.
    )absolute_importN)Tagcompatible_tagscpython_tagsgeneric_tagsinterpreter_nameinterpreter_version
mac_platforms)MYPY_CHECK_RUNNING)ListOptionalTuple)
PythonVersionz(.+)_(\d+)_(\d+)_(.+)c             C   s   d tt| d d S )N    )joinmapstr)version_info r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/compatibility_tags.pyversion_info_to_nodot   s    r   c                sR   t | }|rH| \ }}}t|t|f} fddt||D }n| g}|S )Nc                s$   g | ]}d   |tdd qS )z{}_{}macosx_N)formatlen).0arch)namer   r   
<listcomp>.   s   z"_mac_platforms.<locals>.<listcomp>)
_osx_arch_patmatchgroupsintr	   )r   r    majorminoractual_archmac_versionarchesr   )r   r   _mac_platforms"   s    

r(   c             C   sj   | g}|  d\}}}|dkrL|dkrf|d| |  |d| |  n|dkrf|d| |  |S )N_
manylinux2014>   i686x86_64
manylinux2010
manylinux1)	partitionappend)r   r'   arch_prefixarch_separch_suffixr   r   r   _custom_manylinux_platforms7   s    r4   c             C   s@   |  d\}}}| dr$t| }n|dkr6t| }n| g}|S )Nr)   macosx)r*   r-   )r/   
startswithr(   r4   )r   r1   r2   r3   r'   r   r   r   _get_custom_platformsM   s    


r7   c             C   s:   t | dkr(t| d t| dd  fS t| d fS d S )N   r   )r   r"   )versionr   r   r   _get_python_versionY   s    r:   c             C   s(   | d krt  } |d krt }d| |S )Nz{}{})r   r   r   )implementationr9   r   r   r   _get_custom_interpretera   s
    r<   c       
      C   s   g }d}| dk	rt | }t|| }d}|dk	r4|g}d}|dk	rHt|}|pPt dk}	|	rp|t|||d n|t|||d |t|||d |S )aS  Return a list of supported tags for each version specified in
    `versions`.

    :param version: a string version, of the form "33" or "32",
        or None. The version will be assumed to support our ABI.
    :param platform: specify the exact platform you want valid
        tags for, or None. If None, use the local system platform.
    :param impl: specify the exact implementation you want valid
        tags for, or None. If None, use the local interpreter impl.
    :param abi: specify the exact abi you want valid
        tags for, or None. If None, use the local interpreter abi.
    Ncp)python_versionabis	platforms)interpreterr?   r@   )r>   rA   r@   )r:   r<   r7   r   extendr   r   r   )
r9   platformimplabi	supportedr>   rA   r?   r@   
is_cpythonr   r   r   
get_supportedj   s:    


rH   )NN)NNNN)__doc__
__future__r   repip._vendor.packaging.tagsr   r   r   r   r   r   r	   pip._internal.utils.typingr
   typingr   r   r
   r   compiler   r   r(   r4   r7   r:   r<   rH   r   r   r   r   <module>   s$   $



                         python3.7/site-packages/pip/_internal/utils/__pycache__/logging.cpython-37.pyc                      0000644                 00000022001 15107360302 0023215 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re%3              