candidate` is False, an optional string to log the reason
            the link fails to qualify.
        Nz<none given>Fzyanked for reason: {})Fz
not a filezunsupported archive format: {}binaryzNo binaries permitted for {}macosx10z.zip)Fzmacosx10 one)Fzinvalid wheel filenamezwrong project name (not {})z"none of the wheel's tags match: {}z, sourcezNo sources permitted for {}zMissing project version for {}   )FzPython version is incorrect)r*   r4   )FNzFound link %s, version: %sT)#	is_yankedr:   
yanked_reasonformategg_fragmentextsplitextr   r=   r   r?   pathr   filenamer   r   namer;   r>   get_tags	supportedget_formatted_file_tagsr0   r6   _extract_version_from_fragment_py_version_researchstartgroup
py_versionr8   py_version_infor<   r.   r/   )r@   r3   r6   reasonegg_inforN   wheelsupported_tags	file_tagsmatchr[   supports_pythonr'   r'   r7   
evaluate_link   sp    






zLinkEvaluator.evaluate_link)N)	__name__
__module____qualname____doc__recompilerW   rE   rd   r'   r'   r'   r7   r9   i   s   

r9   c       
   	   C   s   |st dt| | t| S g }g }d}xF| D ]>}|j}|jsBn"|j|drX|d7 }n|| q0|| q0W |r||}nt| }t|t| krd}	n dt|d	dd	 |D }	t d
t| ||j
|t|| |	 |S )a  
    Filter out candidates whose hashes aren't allowed, and return a new
    list of candidates.

    If at least one candidate has an allowed hash, then all candidates with
    either an allowed hash or no hash specified are returned.  Otherwise,
    the given candidates are returned.

    Including the candidates with no hash specified when there is a match
    allows a warning to be logged if there is a more preferred candidate
    with no hash specified.  Returning all candidates in the case of no
    matches lets pip report the hash of the candidate that would otherwise
    have been installed (e.g. permitting the user to more easily update
    their requirements file with the desired hash).
    zJGiven no hashes to check %s links for project %r: discarding no candidatesr   )hashesrI   zdiscarding no candidateszdiscarding {} non-matches:
  {}z
  c             s   s   | ]}t |jV  qd S )N)r2   r3   ).0	candidater'   r'   r7   	<genexpr>0  s    z*filter_unallowed_hashes.<locals>.<genexpr>zPChecked %s links for project %r against %s hashes (%s matches, %s no digest): %s)r.   r/   lenlistr3   has_hashis_hash_allowedappendrL   r0   digest_count)

candidatesrk   r?   matches_or_no_digestnon_matchesmatch_countrm   r3   filtereddiscard_messager'   r'   r7   filter_unallowed_hashes   sF    



r{   c               @   s   e Zd ZdZdddZdS )CandidatePreferenceszk
    Encapsulates some of the preferences for filtering and sorting
    InstallationCandidate objects.
    Fc             C   s   || _ || _dS )zR
        :param allow_all_prereleases: Whether to allow all pre-releases.
        N)allow_all_prereleases
prefer_binary)r@   r~   r}   r'   r'   r7   rE   H  s    	zCandidatePreferences.__init__N)FF)re   rf   rg   rh   rE   r'   r'   r'   r7   r|   A  s    r|   c               @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r(   zA collection of candidates, returned by `PackageFinder.find_best_candidate`.

    This class is only intended to be instantiated by CandidateEvaluator's
    `compute_best_candidate()` method.
    c             C   sH   t |t |kst|dkr&|r2tn||ks2t|| _|| _|| _dS )a  
        :param candidates: A sequence of all available candidates found.
        :param applicable_candidates: The applicable candidates.
        :param best_candidate: The most preferred candidate found, or None
            if no applicable candidates were found.
        N)setAssertionError_applicable_candidates_candidatesbest_candidate)r@   ru   applicable_candidatesr   r'   r'   r7   rE   \  s    

zBestCandidateResult.__init__c             C   s
   t | jS )z(Iterate through all candidates.
        )iterr   )r@   r'   r'   r7   iter_allu  s    zBestCandidateResult.iter_allc             C   s
   t | jS )z3Iterate through the applicable candidates.
        )r   r   )r@   r'   r'   r7   iter_applicable{  s    z#BestCandidateResult.iter_applicableN)re   rf   rg   rh   rE   r   r   r'   r'   r'   r7   r(   U  s   c               @   sH   e Zd ZdZedddZdddZdd	 Zd
d Zdd
 Z	dd Z
dS )CandidateEvaluatorzm
    Responsible for filtering and sorting candidates for installation based
    on what tags are valid.
    NFc             C   s:   |dkrt  }|dkrt }| }| ||||||dS )a  Create a CandidateEvaluator object.

        :param target_python: The target Python interpreter to use when
            checking compatibility. If None (the default), a TargetPython
            object will be constructed from the running Python.
        :param specifier: An optional object implementing `filter`
            (e.g. `packaging.specifiers.SpecifierSet`) to filter applicable
            versions.
        :param hashes: An optional collection of allowed hashes.
        N)r?   r`   	specifierr~   r}   rk   )r   r   SpecifierSetrS   )clsr?   rC   r~   r}   r   rk   r`   r'   r'   r7   create  s    zCandidateEvaluator.createc             C   s(   || _ || _|| _|| _|| _|| _dS )z
        :param supported_tags: The PEP 425 tags supported by the target
            Python in order of preference (most preferred first).
        N)_allow_all_prereleases_hashes_prefer_binary
_project_name
_specifier_supported_tags)r@   r?   r`   r   r~   r}   rk   r'   r'   r7   rE     s    zCandidateEvaluator.__init__c                sd   | j pd}| j}dd |jdd |D |dD   fdd|D }t|| j| jd	}t|| jd
S )zM
        Return the applicable candidates from a list of candidates.
        Nc             S   s   h | ]}t |qS r'   )r2   )rl   vr'   r'   r7   	<setcomp>  s   z?CandidateEvaluator.get_applicable_candidates.<locals>.<setcomp>c             s   s   | ]}t |jV  qd S )N)r2   r6   )rl   cr'   r'   r7   rn     s    z?CandidateEvaluator.get_applicable_candidates.<locals>.<genexpr>)prereleasesc                s   g | ]}t |j kr|qS r'   )r2   r6   )rl   r   )versionsr'   r7   
<listcomp>  s    z@CandidateEvaluator.get_applicable_candidates.<locals>.<listcomp>)ru   rk   r?   )key)r   r   filterr{   r   r   sorted	_sort_key)r@   ru   allow_prereleasesr   r   filtered_applicable_candidatesr'   )r   r7   get_applicable_candidates  s    	

z,CandidateEvaluator.get_applicable_candidatesc       
      C   s   | j }t|}d}d}|j}|jrt|j}||sFtd|j| j	rPd}|
| }|jdk	rt
d|j}	|	 }
t|
d |
d f}n| }t|| j}dt|j }||||j||fS )a)  
        Function to pass as the `key` argument to a call to sorted() to sort
        InstallationCandidates by preference.

        Returns a tuple such that tuples sorting as greater using Python's
        default comparison operator are more preferred.

        The preference is as follows:

        First and foremost, candidates with allowed (matching) hashes are
        always preferred over candidates without matching hashes. This is
        because e.g. if the only candidate with an allowed hash is yanked,
        we still want to use that candidate.

        Second, excepting hash considerations, candidates that have been
        yanked (in the sense of PEP 592) are always less preferred than
        candidates that haven't been yanked. Then:

        If not finding wheels, they are sorted by version only.
        If finding wheels, then the sort order is by version, then:
          1. existing installs
          2. wheels ordered via Wheel.support_index_min(self._supported_tags)
          3. source archives
        If prefer_binary was set, then all wheels are sorted above sources.

        Note: it was considered to embed this logic into the Link
              comparison operators, but then different sdist links
              with the same version, would have to be considered equal
        r'   r   zB{} is not a supported wheel for this platform. It can't be sorted.rI   Nz^(\d+)(.*)$)r   ro   r3   is_wheelr   rQ   rT   r	   rL   r   support_index_min	build_tagri   rb   groupsintrr   r   rJ   r6   )
r@   rm   
valid_tagssupport_numr   binary_preferencer3   r_   prirb   build_tag_groupshas_allowed_hash
yank_valuer'   r'   r7   r     s.    




zCandidateEvaluator._sort_keyc             C   s   |sdS t || jd}|S )zy
        Return the best candidate per the instance's sort order, or None if
        no candidate is acceptable.
        N)r   )maxr   )r@   ru   r   r'   r'   r7   sort_best_c