e InstallationError(exc_msg)
        elif on_returncode == 'warn':
            subprocess_logger.warning(
                'Command "%s" had error code %s in %s',
                command_desc,
                proc.returncode,
                cwd,
            )
        elif on_returncode == 'ignore':
            pass
        else:
            raise ValueError('Invalid value: on_returncode={!r}'.format(
                             on_returncode))
    return ''.join(all_output)


def runner_with_spinner_message(message):
    # type: (str) -> Callable[..., None]
    """Provide a subprocess_runner that shows a spinner message.

    Intended for use with for pep517's Pep517HookCaller. Thus, the runner has
    an API that matches what's expected by Pep517HookCaller.subprocess_runner.
    """

    def runner(
        cmd,  # type: List[str]
        cwd=None,  # type: Optional[str]
        extra_environ=None  # type: Optional[Mapping[str, Any]]
    ):
        # type: (...) -> None
        with open_spinner(message) as spinner:
            call_subprocess(
                cmd,
                cwd=cwd,
                extra_environ=extra_environ,
                spinner=spinner,
            )

    return runner
                                                                                                                                                                                                                                                                                                                            python3.7/site-packages/pip/_internal/utils/models.py                                               0000644                 00000002261 15107360301 0016572 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Utilities for defining models
"""
# The following comment should be removed at some point in the future.
# mypy: disallow-untyped-defs=False

import operator


class KeyBasedCompareMixin(object):
    """Provides comparison capabilities that is based on a key
    """

    __slots__ = ['_compare_key', '_defining_class']

    def __init__(self, key, defining_class):
        self._compare_key = key
        self._defining_class = defining_class

    def __hash__(self):
        return hash(self._compare_key)

    def __lt__(self, other):
        return self._compare(other, operator.__lt__)

    def __le__(self, other):
        return self._compare(other, operator.__le__)

    def __gt__(self, other):
        return self._compare(other, operator.__gt__)

    def __ge__(self, other):
        return self._compare(other, operator.__ge__)

    def __eq__(self, other):
        return self._compare(other, operator.__eq__)

    def __ne__(self, other):
        return self._compare(other, operator.__ne__)

    def _compare(self, other, method):
        if not isinstance(other, self._defining_class):
            return NotImplemented

        return method(self._compare_key, other._compare_key)
                                                                                                                                                                                                                                                                                                                                               python3.7/site-packages/pip/_internal/utils/deprecation.py                                          0000644                 00000006366 15107360301 0017616 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
A module that implements tooling to enable easy warnings about deprecations.
"""

# The following comment should be removed at some point in the future.
# mypy: disallow-untyped-defs=False

from __future__ import absolute_import

import logging
import warnings

from pip._vendor.packaging.version import parse

from pip import __version__ as current_version
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from typing import Any, Optional


DEPRECATION_MSG_PREFIX = "DEPRECATION: "


class PipDeprecationWarning(Warning):
    pass


_original_showwarning = None  # type: Any


# Warnings <-> Logging Integration
def _showwarning(message, category, filename, lineno, file=None, line=None):
    if file is not None:
        if _original_showwarning is not None:
            _original_showwarning(
                message, category, filename, lineno, file, line,
            )
    elif issubclass(category, PipDeprecationWarning):
        # We use a specially named logger which will handle all of the
        # deprecation messages for pip.
        logger = logging.getLogger("pip._internal.deprecations")
        logger.warning(message)
    else:
        _original_showwarning(
            message, category, filename, lineno, file, line,
        )


def install_warning_logger():
    # type: () -> None
    # Enable our Deprecation Warnings
    warnings.simplefilter("default", PipDeprecationWarning, append=True)

    global _original_showwarning

    if _original_showwarning is None:
        _original_showwarning = warnings.showwarning
        warnings.showwarning = _showwarning


def deprecated(reason, replacement, gone_in, issue=None):
    # type: (str, Optional[str], Optional[str], Optional[int]) -> None
    """Helper to deprecate existing functionality.

    reason:
        Textual reason shown to the user about why this functionality has
        been deprecated.
    replacement:
        Textual suggestion shown to the user about what alternative
        functionality they can use.
    gone_in:
        The version of pip does this functionality should get removed in.
        Raises errors if pip's current version is greater than or equal to
        this.
    issue:
        Issue number on the tracker that would serve as a useful place for
        users to find related discussion and provide feedback.

    Always pass replacement, gone_in and issue as keyword arguments for clarity
    at the call site.
    """

    # Construct a nice message.
    #   This is eagerly formatted as we want it to get logged as if someone
    #   typed this entire message out.
    sentences = [
        (reason, DEPRECATION_MSG_PREFIX + "{}"),
        (gone_in, "pip {} will remove support for this functionality."),
        (replacement, "A possible replacement is {}."),
        (issue, (
            "You can find discussion regarding this at "
            "https://github.com/pypa/pip/issues/{}."
        )),
    ]
    message = " ".join(
        template.format(val) for val, template in sentences if val is not None
    )

    # Raise as an error if it has to be removed.
    if gone_in is not None and parse(current_version) >= parse(gone_in):
        raise PipDeprecationWarning(message)

    warnings.warn(message, category=PipDeprecationWarning, stacklevel=2)
                                                                                                                                                                                                                                                                          python3.7/site-packages/pip/_internal/utils/__pycache__/pkg_resources.cpython-37.pyc                0000644                 00000003522 15107360301 0024450 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   sP   d dl mZ d dlmZ d dlmZ er<d dlmZmZm	Z	 G dd de
ZdS )    )yield_lines)
ensure_str)MYPY_CHECK_RUNNING)DictIterableListc               @   sH   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dS )DictMetadatazCIMetadataProvider that reads metadata files from a dictionary.
    c             C   s
   || _ d S )N)	_metadata)selfmetadata r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/pkg_resources.py__init__
   s    zDictMetadata.__init__c             C   s
   || j kS )N)r	   )r
   namer   r   r
   has_metadata   s    zDictMetadata.has_metadatac          
   C   sL   yt | j| S  tk
rF } z| jd|7  _ W d d }~X Y nX d S )Nz in {} file)r   r	   UnicodeDecodeErrorreasonformat)r
   r   er   r   r
   get_metadata   s
    zDictMetadata.get_metadatac             C   s   t | |S )N)r   r   )r
   r   r   r   r
   get_metadata_lines   s    zDictMetadata.get_metadata_linesc             C   s   dS )NFr   )r
   r   r   r   r
   metadata_isdir"   s    zDictMetadata.metadata_isdirc             C   s   g S )Nr   )r
   r   r   r   r
   metadata_listdir&   s    zDictMetadata.metadata_listdirc             C   s   d S )Nr   )r
   script_name	namespacer   r   r
   
run_script*   s    zDictMetadata.run_scriptN)__name__
__module____qualname____doc__r   r   r   r   r   r   r   r   r   r   r
   r   
   s   	r   N)Zpip._vendor.pkg_resourcesr   Zpip._vendor.sixr   pip._internal.utils.typingr   typingr   r   r   objectr   r   r   r   r
   <module>   s
                                                                                                                                                                                 python3.7/site-packages/pip/_internal/utils/__pycache__/inject_securetransport.cpython-37.pyc       0000644                 00000001743 15107360301 0026377 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re*                 @   s   d Z ddlZdd Ze  dS )a-  A helper module that injects SecureTransport, on import.

The import should be done as early as possible, to ensure all requests and
sessions (or whatever) are created after injecting SecureTransport.

Note that we only do the injection on macOS, when the linked OpenSSL is too
old to handle TLSv1.2.
    Nc           	   C   st   t jdkrd S ydd l} W n tk
r.   d S X | jdkr>d S yddlm} W n ttfk
rf   d S X |  d S )Ndarwinr   i )securetransport)	sysplatformsslImportErrorOPENSSL_VERSION_NUMBERpip._vendor.urllib3.contribr   OSErrorinject_into_urllib3)r   r    r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/inject_securetransport.pyinject_securetransport
   s    

r   )__doc__r   r   r   r   r   r
   <module>   s                                python3.7/site-packages/pip/_internal/utils/__pycache__/packaging.cpython-37.pyc                    0000644                 00000005145 15107360301 0023524 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   s   d dl mZ d dlZd dlmZ d dlmZ d dlmZm	Z	 d dl
mZ d dlm
Z
 d dlmZ erd d	lmZmZ d d
lmZ d dlmZ eeZdd
 Zdd Zdd Zdd ZdS )    )absolute_importN)
FeedParser)
pkg_resources)
specifiersversion)NoneMetadataError)display_path)MYPY_CHECK_RUNNING)OptionalTuple)Message)Distributionc             C   s4   | dkrdS t | }tdtt|}||kS )a  
    Check if the given Python version matches a "Requires-Python" specifier.

    :param version_info: A 3-tuple of ints representing a Python
        major-minor-micro version to check (e.g. `sys.version_info[:3]`).

    :return: `True` if the given Python version satisfies the requirement.
        Otherwise, return `False`.

    :raises InvalidSpecifier: If `requires_python` has an invalid format.
    NT.)r   SpecifierSetr   parsejoinmapstr)requires_pythonversion_inforequires_python_specifierpython_version r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/packaging.pycheck_requires_python   s
    

r   c             C   s   d}t | tjr&| |r&| |}n0| dr@d}| |}ntdt| j d}|dkrht	| |t
 }|| | S )z
    :raises NoneMetadataError: if the distribution reports `has_metadata()`
        True but `get_metadata()` returns None.
    METADATAzPKG-INFOzNo metadata found in %s N)
isinstancer   DistInfoDistributionhas_metadataget_metadataloggerwarningr   locationr   r   feedclose)dist
metadata_namemetadatafeed_parserr   r   r   r    ,   s    



r    c             C   s&   t | }|d}|dk	r"t|}|S )z_
    Return the "Requires-Python" metadata for a distribution, or None
    if not present.
    zRequires-PythonN)r    getr   )r&   
pkg_info_dictr   r   r   r   get_requires_pythonG   s
    
r,   c             C   s2   |  dr.x"| dD ]}| r| S qW dS )N	INSTALLERr   )r   get_metadata_linesstrip)r&   liner   r   r   
get_installerX   s
    
r1   )
__future__r   loggingemail.parserr   pip._vendorr   Zpip._vendor.packagingr   r   pip._internal.exceptionsr   pip._internal.utils.miscr   pip._internal.utils.typingr	   typingr
   r   
email.messager   Zpip._vendor.pkg_resourcesr
   	getLogger__name__r!   r   r    r,   r1   r   r   r   r   <module>   s    
                                                                                                                                                                                                                                                                                                                                                                                                                           python3.7/site-packages/pip/_internal/utils/__pycache__/urls.cpython-37.pyc                         0000644                 00000003030 15107360301 0022554 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   sh   d dl Z d dlZd dlmZ d dlmZ d dlmZ erLd dl	m
Z
mZmZ dd Z
dd	 Zd
d ZdS )    N)parse)request)MYPY_CHECK_RUNNING)OptionalTextUnionc             C   s    d| krd S |  ddd  S )N:   r   )splitlower)url r
   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/urls.pyget_url_scheme
   s    r   c             C   s*   t jt j| } tdt| }|S )zh
    Convert a path to a file: URL.  The path will be made absolute and have
    quoted path parts.
    zfile:)ospathnormpathabspathurllib_parseurljoinurllib_requestpathname2url)r   r   r
   r
   r   path_to_url   s    r   c             C   sz   |  dstdjf t t| \}}}}}|r<|dkrBd}n&tjdkrVd| }ntdjf t t	
|| }|S )z(
    Convert a file: URL to a path.
    zfile:z9You can only turn file: urls into filenames (not {url!r})	localhost win32z\\z?non-local file URIs are not supported on this platform: {url!r})
startswithAssertionErrorformatlocalsr   urlsplitsysplatform
ValueErrorr   url2pathname)r   _netlocr   r
   r
   r   url_to_path   s    



r'   )r   r!   Zpip._vendor.six.moves.urllibr   r   r   r   pip._internal.utils.typingr   typingr   r   r   r   r   r'   r
   r
   r
   r   <module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           python3.7/site-packages/pip/_internal/utils/__pycache__/deprecation.cpython-37.pyc                  0000644                 00000005433 15107360301 0024075 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   s   d Z ddlmZ ddlZddlZddlmZ ddlmZ	 ddl
mZ erXddlm
Z
mZ dZG d	d
 d
eZdadddZd
d ZdddZdS )zN
A module that implements tooling to enable easy warnings about deprecations.
    )absolute_importN)parse)__version__)MYPY_CHECK_RUNNING)AnyOptionalz
DEPRECATION: c               @   s   e Zd ZdS )PipDeprecationWarningN)__name__
__module____qualname__ r   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/utils/deprecation.pyr      s   r   c             C   sZ   |d k	r$t d k	rVt | ||||| n2t|trDtd}||  nt | ||||| d S )Nzpip._internal.deprecations)_original_showwarning
issubclassr   logging	getLoggerwarning)messagecategoryfilenamelinenofilelineloggerr   r   r
   _showwarning!   s    

r   c               C   s(   t jdtdd td kr$t ja