 scripts generated for
        # entry point EP by setuptools
        path = file.dest_path
        name = os.path.basename(path)
        if name.lower().endswith('.exe'):
            matchname = name[:-4]
        elif name.lower().endswith('-script.py'):
            matchname = name[:-10]
        elif name.lower().endswith(".pya"):
            matchname = name[:-4]
        else:
            matchname = name
        # Ignore setuptools-generated scripts
        return (matchname in console or matchname in gui)

    script_scheme_files = map(make_data_scheme_file, script_scheme_paths)
    script_scheme_files = filterfalse(
        is_entrypoint_wrapper, script_scheme_files
    )
    script_scheme_files = map(ScriptFile, script_scheme_files)
    files = chain(files, script_scheme_files)

    for file in files:
        file.save()
        record_installed(file.src_record_path, file.dest_path, file.changed)

    def pyc_source_file_paths():
        # type: () -> Iterator[text_type]
        # We de-duplicate installation paths, since there can be overlap (e.g.
        # file in .data maps to same location as file in wheel root).
        # Sorting installation paths makes it easier to reproduce and debug
        # issues related to permissions on existing files.
        for installed_path in sorted(set(installed.values())):
            full_installed_path = os.path.join(lib_dir, installed_path)
            if not os.path.isfile(full_installed_path):
                continue
            if not full_installed_path.endswith('.py'):
                continue
            yield full_installed_path

    def pyc_output_path(path):
        # type: (text_type) -> text_type
        """Return the path the pyc file would have been written to.
        """
        if PY2:
            if sys.flags.optimize:
                return path + 'o'
            else:
                return path + 'c'
        else:
            return importlib.util.cache_from_source(path)

    # Compile all of the pyc files for the installed files
    if pycompile:
        with captured_stdout() as stdout:
            with warnings.catch_warnings():
                warnings.filterwarnings('ignore')
                for path in pyc_source_file_paths():
                    # Python 2's `compileall.compile_file` requires a str in
                    # error cases, so we must convert to the native type.
                    path_arg = ensure_str(
                        path, encoding=sys.getfilesystemencoding()
                    )
                    success = compileall.compile_file(
                        path_arg, force=True, quiet=True
                    )
                    if success:
                        pyc_path = pyc_output_path(path)
                        assert os.path.exists(pyc_path)
                        pyc_record_path = cast(
                            "RecordPath", pyc_path.replace(os.path.sep, "/")
                        )
                        record_installed(pyc_record_path, pyc_path)
        logger.debug(stdout.getvalue())

    maker = PipScriptMaker(None, scheme.scripts)

    # Ensure old scripts are overwritten.
    # See https://github.com/pypa/pip/issues/1800
    maker.clobber = True

    # Ensure we don't generate any variants for scripts because this is almost
    # never what somebody wants.
    # See https://bitbucket.org/pypa/distlib/issue/35/
    maker.variants = {''}

    # This is required because otherwise distlib creates scripts that are not
    # executable.
    # See https://bitbucket.org/pypa/distlib/issue/32/
    maker.set_mode = True

    # Generate the console and GUI entry points specified in the wheel
    scripts_to_generate = get_console_script_specs(console)

    gui_scripts_to_generate = list(starmap('{} = {}'.format, gui.items()))

    generated_console_scripts = maker.make_multiple(scripts_to_generate)
    generated.extend(generated_console_scripts)

    generated.extend(
        maker.make_multiple(gui_scripts_to_generate, {'gui': True})
    )

    if warn_script_location:
        msg = message_about_scripts_not_on_PATH(generated_console_scripts)
        if msg is not None:
            logger.warning(msg)

    generated_file_mode = 0o666 & ~current_umask()

    @contextlib.contextmanager
    def _generate_file(path, **kwargs):
        # type: (str, **Any) -> Iterator[NamedTemporaryFileResult]
        with adjacent_tmp_file(path, **kwargs) as f:
            yield f
        os.chmod(f.name, generated_file_mode)
        replace(f.name, path)

    dest_info_dir = os.path.join(lib_dir, info_dir)

    # Record pip as the installer
    installer_path = os.path.join(dest_info_dir, 'INSTALLER')
    with _generate_file(installer_path) as installer_file:
        installer_file.write(b'pip\n')
    generated.append(installer_path)

    # Record the PEP 610 direct URL reference
    if direct_url is not None:
        direct_url_path = os.path.join(dest_info_dir, DIRECT_URL_METADATA_NAME)
        with _generate_file(direct_url_path) as direct_url_file:
            direct_url_file.write(direct_url.to_json().encode("utf-8"))
        generated.append(direct_url_path)

    # Record the REQUESTED file
    if requested:
        requested_path = os.path.join(dest_info_dir, 'REQUESTED')
        with open(requested_path, "w"):
            pass
        generated.append(requested_path)

    record_text = distribution.get_metadata('RECORD')
    record_rows = list(csv.reader(record_text.splitlines()))

    rows = get_csv_rows_for_installed(
        record_rows,
        installed=installed,
        changed=changed,
        generated=generated,
        lib_dir=lib_dir)

    # Record details of all files installed
    record_path = os.path.join(dest_info_dir, 'RECORD')

    with _generate_file(record_path, **csv_io_kwargs('w')) as record_file:
        # The type mypy infers for record_file is different for Python 3
        # (typing.IO[Any]) and Python 2 (typing.BinaryIO). We explicitly
        # cast to typing.IO[str] as a workaround.
        writer = csv.writer(cast('IO[str]', record_file))
        writer.writerows(_normalized_outrows(rows))


@contextlib.contextmanager
def req_error_context(req_description):
    # type: (str) -> Iterator[None]
    try:
        yield
    except InstallationError as e:
        message = "For req: {}. {}".format(req_description, e.args[0])
        reraise(
            InstallationError, InstallationError(message), sys.exc_info()[2]
        )


def install_wheel(
    name,  # type: str
    wheel_path,  # type: str
    scheme,  # type: Scheme
    req_description,  # type: str
    pycompile=True,  # type: bool
    warn_script_location=True,  # type: bool
    direct_url=None,  # type: Optional[DirectUrl]
    requested=False,  # type: bool
):
    # type: (...) -> None
    with ZipFile(wheel_path, allowZip64=True) as z:
        with req_error_context(req_description):
            _install_wheel(
                name=name,
                wheel_zip=z,
                wheel_path=wheel_path,
                scheme=scheme,
                pycompile=pycompile,
                warn_script_location=warn_script_location,
                direct_url=direct_url,
                requested=requested,
            )
                                                                                                                                                                                                                                                                                                                                                                                                                                                  python3.7/site-packages/pip/_internal/operations/__init__.py                                        0000644                 00000000000 15107360303 0020060 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       python3.7/site-packages/pip/_internal/operations/build/__pycache__/metadata_legacy.cpython-37.pyc   0000644                 00000003700 15107360303 0027023 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   s~   d Z ddlZddlZddlmZ ddlmZ ddlmZ ddl	m
Z
 ddlmZ er`ddl
mZ eeZd	d
 Zdd ZdS )
z;Metadata generation logic for legacy source distributions.
    N)InstallationError)make_setuptools_egg_info_args)call_subprocess)
TempDirectory)MYPY_CHECK_RUNNING)BuildEnvironmentc             C   sR   dd t | D }|s&td| t|dkr@td| t j| |d S )z3Find an .egg-info subdirectory in `directory`.
    c             S   s   g | ]}| d r|qS )z	.egg-info)endswith).0f r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/operations/build/metadata_legacy.py
<listcomp>   s    z"_find_egg_info.<locals>.<listcomp>z"No .egg-info directory found in {}   z-More than one .egg-info directory found in {}r   )oslistdirr   formatlenpathjoin)	directory	filenamesr   r   r   _find_egg_info   s    r   c          	   C   sP   t d|| tdddj}t|||d}|  t||dd W dQ R X t|S )	znGenerate metadata using setup.py-based defacto mechanisms.

    Returns the generated metadata directory.
    z2Running setup.py (path:%s) egg_info for package %szpip-egg-infoT)kindglobally_managed)egg_info_dirno_user_configzpython setup.py egg_info)cwdcommand_descN)loggerdebugr   r   r   r   r   )	build_env
setup_py_path
source_dirisolateddetailsr   argsr   r   r   generate_metadata*   s    r&   )__doc__loggingr   pip._internal.exceptionsr   $pip._internal.utils.setuptools_buildr   pip._internal.utils.subprocessr   pip._internal.utils.temp_dirr   pip._internal.utils.typingr   pip._internal.build_envr   	getLogger__name__r   r   r&   r   r   r   r   <module>   s   
                                                                python3.7/site-packages/pip/_internal/operations/build/__pycache__/__init__.cpython-37.pyc          0000644                 00000000355 15107360303 0025461 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                   @   s   d S )N r   r   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/operations/build/__init__.py<module>                                                                                                                                                                                                                                                                                          python3.7/site-packages/pip/_internal/operations/build/__pycache__/wheel_legacy.cpython-37.pyc      0000644                 00000005043 15107360303 0026351 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re
                 @   s   d dl Z d dlZd dlmZ d dlmZ d dlmZm	Z	m
Z
 d dlmZ er`d dl
mZmZmZ e eZdd Zd	d
 Zdd ZdS )
    N)open_spinner) make_setuptools_bdist_wheel_args)LOG_DIVIDERcall_subprocessformat_command_args)MYPY_CHECK_RUNNING)ListOptionalTextc             C   s^   t | }d|}|s |d7 }n:t tjkr8|d7 }n"|dsJ|d7 }|d|t7 }|S )z'Format command information for logging.zCommand arguments: {}
zCommand output: Nonez'Command output: [use --verbose to show]
zCommand output:
{}{})r   formatloggergetEffectiveLevelloggingDEBUGendswithr   )command_argscommand_outputcommand_desctext r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/operations/build/wheel_legacy.pyformat_command_result   s    



r   c             C   st   t | } | s2d|}|t||7 }t| dS t| dkrbd|| }|t||7 }t| tj|| d S )z>Return the path to the wheel in the temporary build directory.z1Legacy build of wheel for {!r} created no files.
N   zZLegacy build of wheel for {!r} created more than one file.
Filenames (choosing first): {}
r   )	sortedr   r   r
   warninglenospathjoin)namestemp_dirnamer   r   msgr   r   r   get_legacy_build_wheel_path*   s    


r$   c          	   C   s   t ||||d}d| }t|l}td| yt|||d}	W n* tk
rl   |d td|  dS X t	
|}
t|
|| ||	d}|S Q R X dS )	zBuild one unpacked package using the "legacy" build process.

    Returns path to wheel if successfully built. Otherwise, returns None.
    )global_options
build_optionsdestination_dirz Building wheel for {} (setup.py)zDestination directory: %s)cwdspinnererrorzFailed building wheel for %sN)r    r!   r"   r   r   )r   r   r   r
   debugr   	Exceptionfinishr*   r   listdirr$   )r"   
setup_py_path
source_dirr%   r&   tempd
wheel_argsspin_messager)   outputr    
wheel_pathr   r   r   build_wheel_legacyH   s2    




r6   )r   os.pathr   pip._internal.cli.spinnersr   $pip._internal.utils.setuptools_buildr   pip._internal.utils.subprocessr   r   r   pip._internal.utils.typingr   typingr   r	   r
   	getLogger__name__r
   r   r$   r6   r   r   r   r   <module>   s   
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             python3.7/site-packages/pip/_internal/operations/build/__pycache__/metadata.cpython-37.pyc          0000644                 00000002272 15107360303 0025502 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   sX   d Z ddlZddlmZ ddlmZ ddlmZ erLddlm	Z	 ddl
mZ dd	 ZdS )
z4Metadata generation logic for source distributions.
    N)runner_with_spinner_message)
TempDirectory)MYPY_CHECK_RUNNING)BuildEnvironment)Pep517HookCallerc          
   C   sX   t ddd}|j}| . td}|| ||}W dQ R X W dQ R X tj||S )zlGenerate metadata using mechanisms described in PEP 517.

    Returns the generated metadata directory.
    zmodern-metadataT)kindglobally_managedzPreparing wheel metadataN)r   pathr   subprocess_runner prepare_metadata_for_build_wheelosjoin)	build_envbackendmetadata_tmpdirmetadata_dirrunnerdistinfo_dir r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/operations/build/metadata.pygenerate_metadata   s    
r   )
__doc__r   pip._internal.utils.subprocessr   pip._internal.utils.temp_dirr   pip._internal.utils.typingr   pip._internal.build_envr   pip._vendor.pep517.wrappersr   r   r   r   r   r   <module>   s                                                                                                                                                                                                                                                                                                                                         python3.7/site-packages/pip/_internal/operations/build/__pycache__/wheel.cpython-37.pyc             0000644                 00000002521 15107360303 0025023 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   s^   d dl Z d dlZd dlmZ d dlmZ erHd dlmZmZ d dl	m
Z
 e eZ
dd ZdS )    N)runner_with_spinner_message)MYPY_CHECK_RUNNING)ListOptional)Pep517HookCallerc          	   C   s   |dk	st |r td|  dS yBtd| td| }|| |j||d}W dQ R X W n  tk
r   td|  dS X t	j
||S )zBuild one InstallRequirement using the PEP 517 build process.

    Returns path to wheel if successfully built. Otherwise, returns None.
    NzFCannot build wheel for %s using PEP 517 when --build-option is presentzDestination directory: %szBuilding wheel for {} (PEP 517))metadata_directoryzFailed building wheel for %s)AssertionErrorloggererrordebugr   formatsubprocess_runnerbuild_wheel	Exceptionospathjoin)namebackendr   
build_optionstempdrunner
wheel_name r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_internal/operations/build/wheel.pybuild_wheel_pep517   s"    r   )loggingr   pip._internal.utils.subprocessr   pip._internal.utils.typingr   typingr   r   pip._vendor.pep517.wrappersr   	getLogger__name__r	   r   r   r   r   r   <module>   s   
                                                                                                                                                                               python3.7/site-packages/pip/_internal/operations/build/metadata.py                                  0000644                 00000002346 15107360303 0021217 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Metadata generation logic for source distributions.
"""

import os

from pip._internal.utils.subprocess import runner_with_spinner_message
from pip._internal.utils.temp_dir import TempDirectory
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from pip._internal.build_env import BuildEnvironment
    from pip._vendor.pep517.wrappers import Pep517HookCaller


def generate_metadata(build_env, backend):
    # type: (BuildEnvironment, Pep517HookCaller) -> str
    """Generate metadata using mechanisms described in PEP 517.

    Returns the generated metadata directory.
    """
    metadata_tmpdir = TempDirectory(
        kind="modern-metadata", globally_managed=True
    )

    metadata_dir = metadata_tmpdir.path

    with build_env:
        # Note that Pep517HookCaller implements a fallback for
        # prepare_metadata_for_build_wheel, so we don't have to
        # consider the possibility that this hook doesn't exist.
        runner = runner_with_spinner_message("Preparing wheel metadata")
        with backend.subprocess_runner(runner):
            distinfo_dir = backend.prepare_metadata_for_build_wheel(
                metadata_dir
            )

    return os.path.join(metadata_dir, distinfo_dir)
                                                                                                                                                                                                                                                                                          python3.7/site-packages/pip/_internal/operations/build/wheel_legacy.py                              0000644                 00000006434 15107360303 0022071 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       import logging
import os.path

from pip._internal.cli.spinners import open_spinner
from pip._internal.utils.setuptools_build import (
    make_setuptools_bdist_wheel_args,
)
from pip._internal.utils.subprocess import (
    LOG_DIVIDER,
    call_subprocess,
    format_command_args,
)
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from typing import List, Optional, Text

logger = logging.getLogger(__name__)


def format_command_result(
    command_args,  # type: List[str]
    command_output,  # type: Text
):
    # type: (...) -> str
    """Format command information for logging."""
    command_desc = format_command_args(command_args)
    text = 'Command arguments: {}\n'.format(command_desc)

    if not command_output:
        text += 'Command output: None'
    elif logger.getEffectiveLevel() > logging.DEBUG:
        text += 'Command output: [use --verbose to show]'
    else:
        if not command_output.endswith('\n'):
            command_output += '\n'
        text += 'Command output:\n{}{}'.format(command_output, LOG_DIVIDER)

    return text


def get_legacy_build_wheel_path(
    names,  # type: List[str]
    temp_dir,  # type: str
    name,  # type: str
    command_args,  # type: List[str]
    command_output,  # type: Text
):
    # type: (...) -> Optional[str]
    """Return the path to the wheel in the temporary build directory."""
    # Sort for determinism.
    names = sorted(names)
    if not names:
        msg = (
            'Legacy build of wheel for {!r} created no files.\n'
        ).format(name)
        msg += format_command_result(command_args, command_output)
        logger.warning(msg)
        return None

    if len(names) > 1:
        msg = (
            'Legacy build of wheel for {!r} created more than one file.\n'
            'Filenames (choosing first): {}\n'
        ).format(name, names)
        msg += format_command_result(command_args, command_output)
        logger.warning(msg)

    return os.path.join(temp_dir, names[0])


def build_wheel_legacy(
    name,  # type: str
    setup_py_path,  # type: str
    source_dir,  # type: str
    global_options,  # type: List[str]
    build_options,  # type: List[str]
    tempd,  # type: str
):
    # type: (...) -> Optional[str]
    """Build one unpacked package using the "legacy" build process.

    Returns path to wheel if successfully built. Otherwise, returns None.
    """
    wheel_args = make_setuptools_bdist_wheel_args(
        setup_py_path,
        global_options=global_options,
        build_options=build_options,
        destination_dir=tempd,
    )

    spin_message = 'Building wheel for {} (setup.py)'.format(name)
    with open_spinner(spin_message) as spinner:
        logger.debug('Destination directory: %s', tempd)

        try:
            output = call_subprocess(
                wheel_args,
                cwd=source_dir,
                spinner=spinner,
            )
        except Exception:
            spinner.finish("error")
            logger.error('Failed building wheel for %s', name)
            return None

        names = os.listdir(tempd)
        wheel_path = get_legacy_build_wheel_path(
            names=names,
            temp_dir=tempd,
            name=name,
            command_args=wheel_args,
            command_output=output,
        )
        return wheel_path
                                                                                                                                                                                                                                    python3.7/site-packages/pip/_internal/operations/build/metadata_legacy.py                           0000644                 00000003733 15107360303 0022544 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """Metadata generation logic for legacy source distributions.
"""

import logging
import os

from pip._internal.exceptions import InstallationError
from pip._internal.utils.setuptools_build import make_setuptools_egg_info_args
from pip._internal.utils.subprocess import call_subprocess
from pip._internal.utils.temp_dir import TempDirectory
from pip._internal.utils.typing import MYPY_CHECK_RUNNING

if MYPY_CHECK_RUNNING:
    from pip._internal.build_env import BuildEnvironment

logger = logging.getLogger(__name__)


def _find_egg_info(directory):
    # type: (str) -> str
    """Find an .egg-info subdirectory in `directory`.
    """
    filenames = [
        f for f in os.listdir(directory) if f.endswith(".egg-info")
    ]

    if not filenames:
        raise InstallationError(
            "No .egg-info directory found in {}".format(dire