meters:

    * ``attribute`` (string): Key of the information item.

    Returns:

    * (string): Value of the information item, if the item exists.
      The empty string, if the item does not exist.

    See `lsb_release command output`_ for details about these information
    items.
    )r   lsb_release_attr)r"   r   r   r   r#     s    r#   c             C   s
   t | S )a  
    Return a single named information item from the distro release file
    data source of the current OS distribution.

    Parameters:

    * ``attribute`` (string): Key of the information item.

    Returns:

    * (string): Value of the information item, if the item exists.
      The empty string, if the item does not exist.

    See `distro release file`_ for details about these information items.
    )r   distro_release_attr)r"   r   r   r   r$     s    r$   c             C   s
   t | S )aZ  
    Return a single named information item from the distro release file
    data source of the current OS distribution.

    Parameters:

    * ``attribute`` (string): Key of the information item.

    Returns:

    * (string): Value of the information item, if the item exists.
                The empty string, if the item does not exist.
    )r   
uname_attr)r"   r   r   r   r%     s    r%   c               @   s    e Zd ZdZdd Zdd ZdS )cached_propertyzA version of @property which caches the value.  On access, it calls the
    underlying function and sets the value in `__dict__` so future accesses
    will not re-call the property.
    c             C   s   |j | _|| _d S )N)__name___fname_f)selffr   r   r   __init__&  s    zcached_property.__init__c             C   s2   |d k	st d| j| | }|j| j< |S )Nzcall {} on an instance)AssertionErrorformatr(   r)   __dict__)r*   objownerretr   r   r   __get__*  s    zcached_property.__get__N)r'   
__module____qualname____doc__r,   r3   r   r   r   r   r&   !  s   r&   c               @   s>  e Zd ZdZdDddZdd ZdEdd	Zd
d ZdFd
dZdGddZ	dHddZ
dIddZdJddZdKddZ
dd Zdd ZdLddZdd  Zd!d" Zd#d$ Zd%d& Zd'd( Zd)d* Zd+d, Zd-d. Zed/d0 Zed1d2 Zed3d4 Zed5d6 Zed7d8 Zed9d: Z ed;d< Z!ed=d> Z"d?d@ Z#edAdB Z$dCS )MLinuxDistributiona  
    Provides information about a OS distribution.

    This package creates a private module-global instance of this class with
    default initialization arguments, that is used by the
    `consolidated accessor functions`_ and `single source accessor functions`_.
    By using default initialization arguments, that module-global instance
    returns data about the current OS distribution (i.e. the distro this
    package runs on).

    Normally, it is not necessary to create additional instances of this class.
    However, in situations where control is needed over the exact data sources
    that are used, instances of this class can be created with a specific
    distro release file, or a specific os-release file, or without invoking the
    lsb_release command.
    T c             C   s.   |pt jtt| _|pd| _|| _|| _dS )ap  
        The initialization method of this class gathers information from the
        available data sources, and stores that in private instance attributes.
        Subsequent access to the information items uses these private instance
        attributes, so that the data sources are read only once.

        Parameters:

        * ``include_lsb`` (bool): Controls whether the
          `lsb_release command output`_ is included as a data source.

          If the lsb_release command is not available in the program execution
          path, the data source for the lsb_release command will be empty.

        * ``os_release_file`` (string): The path name of the
          `os-release file`_ that is to be used as a data source.

          An empty string (the default) will cause the default path name to
          be used (see `os-release file`_ for details).

          If the specifie