eController.cache_url(url)
    return filecache._fn(key)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       python3.7/site-packages/pip/_vendor/cachecontrol/caches/__init__.py                                 0000644                 00000000126 15107360303 0021261 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from .file_cache import FileCache  # noqa
from .redis_cache import RedisCache  # noqa
                                                                                                                                                                                                                                                                                                                                                                                                                                          python3.7/site-packages/pip/_vendor/cachecontrol/wrapper.py                                         0000644                 00000001262 15107360303 0017756 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from .adapter import CacheControlAdapter
from .cache import DictCache


def CacheControl(
    sess,
    cache=None,
    cache_etags=True,
    serializer=None,
    heuristic=None,
    controller_class=None,
    adapter_class=None,
    cacheable_methods=None,
):

    cache = DictCache() if cache is None else cache
    adapter_class = adapter_class or CacheControlAdapter
    adapter = adapter_class(
        cache,
        cache_etags=cache_etags,
        serializer=serializer,
        heuristic=heuristic,
        controller_class=controller_class,
        cacheable_methods=cacheable_methods,
    )
    sess.mount("http://", adapter)
    sess.mount("https://", adapter)

    return sess
                                                                                                                                                                                                                                                                                                                                              python3.7/site-packages/pip/_vendor/cachecontrol/cache.py                                           0000644                 00000001445 15107360303 0017344 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """
The cache object API for implementing caches. The default is a thread
safe in-memory dictionary.
"""
from threading import Lock


class BaseCache(object):

    def get(self, key):
        raise NotImplementedError()

    def set(self, key, value):
        raise NotImplementedError()

    def delete(self, key):
        raise NotImplementedError()

    def close(self):
        pass


class DictCache(BaseCache):

    def __init__(self, init_dict=None):
        self.lock = Lock()
        self.data = init_dict or {}

    def get(self, key):
        return self.data.get(key, None)

    def set(self, key, value):
        with self.lock:
            self.data.update({key: value})

    def delete(self, key):
        with self.lock:
            if key in self.data:
                self.data.pop(key)
                                                                                                                                                                                                                           python3.7/site-packages/pip/_vendor/cachecontrol/__init__.py                                        0000644                 00000000456 15107360303 0020041 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       """CacheControl import Interface.

Make it easy to import from cachecontrol without long namespaces.
"""
__author__ = "Eric Larson"
__email__ = "eric@ionrock.org"
__version__ = "0.12.6"

from .wrapper import CacheControl
from .adapter import CacheControlAdapter
from .controller import CacheController
                                                                                                                                                                                                                  python3.7/site-packages/pip/_vendor/cachecontrol/filewrapper.py                                     0000644                 00000004745 15107360303 0020627 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from io import BytesIO


class CallbackFileWrapper(object):
    """
    Small wrapper around a fp object which will tee everything read into a
    buffer, and when that file is closed it will execute a callback with the
    contents of that buffer.

    All attributes are proxied to the underlying file object.

    This class uses members with a double underscore (__) leading prefix so as
    not to accidentally shadow an attribute.
    """

    def __init__(self, fp, callback):
        self.__buf = BytesIO()
        self.__fp = fp
        self.__callback = callback

    def __getattr__(self, name):
        # The vaguaries of garbage collection means that self.__fp is
        # not always set.  By using __getattribute__ and the private
        # name[0] allows looking up the attribute value and raising an
        # AttributeError when it doesn't exist. This stop thigns from
        # infinitely recursing calls to getattr in the case where
        # self.__fp hasn't been set.
        #
        # [0] https://docs.python.org/2/reference/expressions.html#atom-identifiers
        fp = self.__getattribute__("_CallbackFileWrapper__fp")
        return getattr(fp, name)

    def __is_fp_closed(self):
        try:
            return self.__fp.fp is None

        except AttributeError:
            pass

        try:
            return self.__fp.closed

        except AttributeError:
            pass

        # We just don't cache it then.
        # TODO: Add some logging here...
        return False

    def _close(self):
        if self.__callback:
            self.__callback(self.__buf.getvalue())

        # We assign this to None here, because otherwise we can get into
        # really tricky problems where the CPython interpreter dead locks
        # because the callback is holding a reference to something which
        # has a __del__ method. Setting this to None breaks the cycle
        # and allows the garbage collector to do it's thing normally.
        self.__callback = None

    def read(self, amt=None):
        data = self.__fp.read(amt)
        self.__buf.write(data)
        if self.__is_fp_closed():
            self._close()

        return data

    def _safe_read(self, amt):
        data = self.__fp._safe_read(amt)
        if amt == 2 and data == b"\r\n":
            # urllib executes this read to toss the CRLF at the end
            # of the chunk.
            return data

        self.__buf.write(data)
        if self.__is_fp_closed():
            self._close()

        return data
                           python3.7/site-packages/pip/_vendor/appdirs.py                                                      0000644                 00000062463 15107360303 0015306 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       #!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) 2005-2010 ActiveState Software Inc.
# Copyright (c) 2013 Eddy Petrișor

"""Utilities for determining application-specific dirs.

See <http://github.c