<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module			Twig Template Engine
 * @author			LEPTON Project
 * @copyright       2010-2025 LEPTON 
 * @link			https://lepton-cms.org
 * @license			http://www.gnu.org/licenses/gpl.html
 * @license_terms	please see info.php of this module
 *
 */

namespace lib_twig\classes\tokenParsers;

class Line extends \Twig\TokenParser\AbstractTokenParser
{
    public function parse(\Twig\Token $token)
    {     
        $parser = $this->parser;
        $lineno = $token->getLine();
        $stream = $parser->getStream();

        // die(\LEPTON_tools::display($stream->getSourceContext()->getPath()));
        $sPathToCurrentTemplate = $stream->getSourceContext()->getPath();
        
        $stream->expect(\Twig\Token::BLOCK_END_TYPE);

        return new \lib_twig\classes\nodes\Line($lineno, $sPathToCurrentTemplate);
    }

    public function getTag()
    {
        return '__line__';
    }
}
