<?php

/**
 * Module handles the first entry backend page after new login by user.
 *
 * @module          initial_page
 * @author          LEPTON project 
 * @copyright       2010-2025 LEPTON Project 
 * @link            https://lepton-cms.org
 * @license         copyright, all rights reserved
 * @license_terms   please see info.php of this module
 *
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file

//  [1] install table
$table_fields="
    `id` int NOT NULL AUTO_INCREMENT,
    `user_id` INT(11) NOT NULL DEFAULT 1,
    `init_page` TEXT NOT NULL,
    `page_param` VARCHAR(255) NOT NULL DEFAULT '',	
    PRIMARY KEY ( `id` )
    ";

LEPTON_handle::install_table("mod_initial_page", $table_fields);

//  [2] insert values
$field_values="
    (NULL, 1, 'start/index.php', '')
";

LEPTON_handle::insert_values("mod_initial_page", $field_values);	
