
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `lepton740`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addons`
--

CREATE TABLE `[[dbprefix]]addons` (
  `addon_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(128) NOT NULL DEFAULT '',
  `directory` varchar(128) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `function` varchar(255) NOT NULL DEFAULT '',
  `to_delete` int(1) NOT NULL DEFAULT '1',
  `version` varchar(255) NOT NULL DEFAULT '',
  `guid` varchar(50) DEFAULT NULL,
  `platform` varchar(255) NOT NULL DEFAULT '',
  `author` varchar(255) NOT NULL DEFAULT '',
  `license` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`addon_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=38 ;

--
-- Dumping data for table `[[dbprefix]]addons`
--

INSERT INTO `[[dbprefix]]addons` VALUES
(1, 'module', 'droplets', 'Droplets', 'This tool allows you to manage your local droplets.', 'tool', 0, '2.6.0', '8b5b5074-993e-421a-9aff-2e32ae1601d5', '7.x', 'LEPTON Project', 'GNU General Public License'),
(2, 'module', 'captcha_control', 'Captcha and Advanced-Spam-Protection (ASP) Control', 'Admin-Tool to control CAPTCHA and ASP', 'tool', 0, '2.6.5', 'c29c5f1a-a72a-4137-b5cd-62982809bd38', '7.x', 'W. Studer, LEPTON Project', 'GNU General Public License'),
(3, 'module', 'code2', 'Code2', 'This module allows you to execute PHP, HTML, Javascript commands and internal comments (<span style="color:#FF0000;">limit access to users you can trust!</span>).', 'page', 1, '3.1.1', 'e5e36d7f-877a-4233-8dac-e1481c681c8d', '7.x', 'Ryan Djurovich, Chio Maisriml, Thorn, Aldus.', 'GNU General Public License'),
(4, 'module', 'cookie', 'Cookie', 'Tool to get users informed about cookies.', 'tool', 1, '3.5.0', 'd7a7c31e-a197-45a4-9131-66297f0c0cc8', '7.4.x', '<a href="https://cms-lab.com" target="_blank">CMS-LAB</a>', '<a href="https://cms-lab.com/_documentation/cookie/license.php" class="info" target="_blank">Custom license</a>'),
(5, 'module', 'edit_area', 'Editarea', 'Small and easy code editor.', 'wysiwyg', 0, '2.3.2', '7E293596-59AC-4010-8351-5836313DE387', '6.x', 'Christophe Dolivet, Christian Sommer, LEPTON Project', 'GNU General Public License'),
(6, 'module', 'initial_page', 'Initial Page', 'This module allows to set up an initial_page in the backend for each user.', 'tool', 1, '1.6.0', '237D63F7-4199-48C7-89B2-DF8E2D8AEE5F', '7.x', 'LEPTON project', 'copyright, all rights reserved'),
(7, 'module', 'lib_comp', 'Library-Compatibility', 'Library for LEPTON to secure backward compatibility for outdated addons', 'library', 1, '1.1.0', '0e87e505-3a84-470b-a21e-85d3668a62b7', '7.x', 'various', 'GNU General Public License'),
(8, 'module', 'lib_fomantic', 'Fomantic Library', 'This module installs basic files <a href="https://fomantic-ui.com/" target="_blank">Fomantic UI</a>.', 'library', 0, '2.9.4.0', '316ca2d0-cb0a-4d23-89d0-424a7a51e125', '7.x', 'cms-lab', '<a href="http://opensource.org/licenses/MIT" target="_blank">MIT license</a>'),
(9, 'module', 'lib_jquery', 'jQuery Initial Library', 'This module installs basic files of jQuery JavaScript Library. You may use it as a lib for your own JavaScripts and modules.', 'library', 0, '3.7.1.4', '8FB09FFD-B11C-4B75-984E-F54082B4DEEA', '7.x', 'LEPTON Project', 'GNU General Public License'),
(10, 'module', 'lib_lepton', 'LEPTON Library', 'Library, scripts to improve LEPTON', 'library', 0, '1.4.0', '64ed06d4-c3f6-4e88-b7f3-248594c2f9a7', '7.x', 'LEPTON team, several independent authors', 'GNU General Public License'),
(11, 'module', 'lib_phpmailer', 'PHPMailer Library', 'PHP Mailer for LEPTON', 'library', 0, '6.10.0.0', '5BF5013A-1204-4AE7-88B2-2E2662AF0E4D', '7.x', 'Andy Prevost, Marcus Bointon, Brent R. Matzelle', 'GNU General Public License'),
(12, 'module', 'lib_r_filemanager', 'Responsive Filemanager', 'Filemanager for use with LEPTON', 'library', 0, '9.14.0.14', '071e6320-e081-4d50-a3a7-e84bd8080f2d', '7.x', 'Alberto Peripolli, LEPTON team', 'special license, see <a href="[[softurl]]/modules/lib_r_filemanager/license.txt" target="_blank">included license file</a>.'),
(13, 'module', 'lib_search', 'LEPTON Search Engine', 'The search engine for LEPTON CMS', 'library', 0, '2.2.6', '3EAE6351-30A1-4DDB-8F25-A2EB3CF3ECE5', '7.x', 'LEPTON team', 'GNU General Public License'),
(14, 'module', 'lib_twig', 'Twig Library for LEPTON', 'Twig PHP Template Engine. Please visit <a href="https://twig.symfony.com/" target="_new">https://twig.symfony.com/" for details.</a>', 'library', 0, '3.21.1.0', '19fb9aba-7f31-4fee-81ea-1db03e83c6cc', '7.x', 'sensiolabs.org, LEPTON Team', 'GNU General Public License for LEPTON Addon, https://twig.symfony.com/license for Twig'),
(15, 'module', 'menu_link', 'Menu Link', 'This module allows you to insert a link into the menu.', 'page', 1, '3.7.0', '452f0da3-3bc1-43bc-b2ad-491ae8494c6e', '7.x', 'Ryan Djurovich, thorn, LEPTON Project ', 'GNU General Public License'),
(16, 'module', 'news', 'News', 'This page type is designed for making a news page (including patch with backend pagination and image upload).', 'page', 1, '5.1.1', '200a3816-e0f6-4fb9-aea8-8e7749896a34', '7.x', 'Ryan Djurovich, Rob Smith, Christian M. Stefan, Jurgen Nijhuis, Dietrich Roland Pehlke (last)', 'GNU General Public License'),
(17, 'module', 'quickform', 'QuickForm', 'This module allows you to create a quick and simple form without complicated settings using TWIG template engine.', 'page', 1, '2.1.4', '6d1a4304-88f0-4356-a1bf-7b5fcb69cf9f', '7.x', 'LEPTON project, W. Studer', '<a href="http://www.gnu.org/licenses/lgpl.html" target="_blank">GNU Lesser General Public License</a>'),
(18, 'module', 'reset_pin', 'Reset PIN', 'Tool to reset PIN if <a href=''https://doc.lepton-cms.org/docu/english/home/core/features/two-factor-authentication.php'' class=''admintools_link'' target=''_blank''>TFA</a> failed', 'tool', 1, '1.0.0', '767281a0-096a-40dc-8987-bc132d76578b', '7.x', '<a href=''https://cms-lab.com'' target=''_blank''>CMS-LAB</a>', '<a href=''https://cms-lab.com/_documentation/reset-pin/license.php'' class=''admintools_link'' target=''_blank''>Custom license</a>'),
(19, 'module', 'show_menu2', 'show_menu2', 'A code snippet providing menu functions. See <a href="https://doc.lepton-cms.org/documentation/sm2" target="_blank">documentation</a> for details or view the <a href="[[softurl]]/modules/show_menu2/README.en.txt" target="_blank">readme</a> file.', 'snippet', 0, '5.3.0', 'b859d102-881d-4259-b91d-b5a1b57ab100', '7.x', 'Brodie Thiesfield, Aldus, erpe', '<a href="https://gnu.org/licenses/gpl-3.0.html" target="_blank">GNU General Public License</a>'),
(20, 'module', 'tinymce', 'TinyMCE', '<a href="https://www.tiny.cloud" target="_blank">Current TinyMCE </a>allows you to edit the content<br />of a page and see media image folder.\r\n						<br />Please keep in mind that there are <a href="[[softurl]]/modules/tinymce/tinymce/TinyMCE-kbd-shortcuts-rev1701.pdf" target="_blank"><b>shortcuts</b></a> to use tinymce', 'wysiwyg', 1, '8.0.2.0', '0ad7e8dd-2f6b-4525-b4bf-db326b0f5ae8', '7.x', 'erpe, Aldus', 'GNU General Public License, TINYMCE is GPLv2+ license'),
(21, 'module', 'wrapper', 'Wrapper', 'This module allows you to wrap your site around another using an inline frame.', 'page', 1, '2.10.5', 'a5830654-06f3-402a-9d25-a03c53fc5574', '7.x', 'Ryan Djurovich, Dietrich Roland Pehlke (last)', 'GNU General Public License'),
(22, 'module', 'wysiwyg', 'WYSIWYG', 'This module allows you to edit the contents of a page using a graphical editor, including draft and history', 'page', 0, '4.0.4', 'DA07DFA3-7592-4781-89C2-D549DD77B017', '7.x', 'LEPTON project, thanks to Thorn for the idea', 'GNU General Public License'),
(23, 'module', 'wysiwyg_settings', 'Wysiwyg Settings', 'Admintool to handle and manage settings for wysiwyg editors.', 'tool', 1, '1.1.5', '5fcb6f56-29d0-40e9-ba6e-41e2bcc11dd6', '7.x', 'LEPTON team', '<a href="https://www.gnu.org/licenses/gpl-3.0.en.html" target="_blank">GNU General Public License 3</a>'),
(24, 'template', 'blank', 'Blank', 'This template is for use on page where you do not want anything wrapping the content.', 'template', 0, '1.1.4', '8f6b513e-ee82-47d8-a0d2-415a06ec8f0a', '5.x', 'erpe', '<a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>'),
(25, 'template', 'lepsem', 'Semantic Theme', 'Semantic Backend Theme for LEPTON CMS', 'theme', 0, '2.5.2', 'd910f924-3aa5-491e-92eb-73f7469629e9', '7.x', 'cms-lab', '<a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>'),
(26, 'template', 'lepton3', 'lepton3-start', 'This template is simply a start', 'template', 1, '2.5.6', '1bd949a2-46e6-40e3-a3fd-a372a9ede147', '7.0', 'CMS-LAB', 'https://creativecommons.org/licenses/by/3.0/'),
(27, 'template', 'semantic', 'Semantic-Frontend', 'This template bases on <a href="https://fomantic-ui.com" target="_blank">Fomantic</a>', 'template', 1, '3.1.1', 'd4365367-db03-4f3c-8304-42e88abc008f', '7.0', 'CMS-LAB', 'https://creativecommons.org/licenses/by/3.0/'),
(28, 'language', 'CZ', 'Czech', '', '', 1, '7.0', 'b6bb0738-b323-46b9-924e-3d068413653a', '7.x', 'Ryan Djurovich, Aleš Kuklínek', 'GNU General Public License'),
(29, 'language', 'DE', 'Deutsch', '', '', 1, '7.0', 'f49419c8-eb27-4a69-bffb-af61fce6b0c9', '7.x', 'Stefan Braunewell, Matthias Gallas, LEPTON project', 'GNU General Public License'),
(30, 'language', 'DK', 'Dansk', '', '', 1, '7.0', '2BF67D57-4B19-40CC-A63E-50CBDD81048D', '7.x', 'Hoerts', 'GNU General Public License'),
(31, 'language', 'EN', 'English', '', '', 0, '7.0', '1412c11c-378f-44ea-9a0e-a9223a2027ef', '7.x', 'Ryan Djurovich, Christian Sommer', 'GNU General Public License'),
(32, 'language', 'FI', 'Finnish', '', '', 1, '7.0', '2a4f8878-0b11-4715-8910-bfc719024727', '7.x', 'Jouni Reivolahti', 'GNU General Public License'),
(33, 'language', 'FR', 'Française', '', '', 1, '7.0', '32E0F6E0-2FA3-4033-9F9D-77E0EA3B4745', '7.x', 'Frédéric Bonain', 'GNU General Public License'),
(34, 'language', 'IT', 'Italiano', '', '', 1, '7.0', '5b92610a-2f4f-456c-b3db-28edf506a52d', '7.x', 'Mte90', 'GNU General Public License'),
(35, 'language', 'NL', 'Nederlands', '', '', 1, '7.0', '18bb3637-6f95-4a81-b1c0-796df2d326f0', '7.x', 'bpe', 'GNU General Public License'),
(36, 'language', 'PL', 'Polski', '', '', 1, '7.0', '1e84df1e-850d-4782-86a8-e560e7ebb90f', '7.x', 'Marek Stepien, Krzysztof Winnicki', 'GNU General Public License'),
(37, 'language', 'RU', 'Russian', '', '', 1, '7.0', '38748A1C-C86D-4B8A-8793-2796ED4CB282', '7.x', 'konstantinmsk', 'GNU General Public License');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `system_permissions` text,
  `module_permissions` text,
  `backend_access` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, 'Administrators', '', '', 1),
(2, 'Register', '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]keepout`
--

CREATE TABLE `[[dbprefix]]keepout` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referrer` text,
  `ip` varchar(64) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `logged` datetime DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '-1',
  `username` varchar(255) NOT NULL DEFAULT '',
  `action` varchar(255) NOT NULL DEFAULT '',
  `log_text` text NOT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `check` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_captcha_control`
--

CREATE TABLE `[[dbprefix]]mod_captcha_control` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `enabled_captcha` int(1) NOT NULL DEFAULT '0',
  `enabled_asp` int(1) NOT NULL DEFAULT '0',
  `captcha_type` varchar(255) NOT NULL DEFAULT 'calc_image',
  `asp_session_min_age` int(11) NOT NULL DEFAULT '20',
  `asp_view_min_age` int(11) NOT NULL DEFAULT '10',
  `asp_input_min_age` int(11) NOT NULL DEFAULT '5',
  `ct_text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mod_captcha_control`
--

INSERT INTO `[[dbprefix]]mod_captcha_control` VALUES
(1, 1, 0, 'calc_text', 20, 10, 5, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_code2`
--

CREATE TABLE `[[dbprefix]]mod_code2` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `whatis` int(11) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_cookie`
--

CREATE TABLE `[[dbprefix]]mod_cookie` (
  `cookie_id` int(11) NOT NULL AUTO_INCREMENT,
  `pop_bg` varchar(16) NOT NULL DEFAULT '#aaa',
  `pop_text` varchar(16) NOT NULL DEFAULT '#fff',
  `but_bg` varchar(16) NOT NULL DEFAULT 'transparent',
  `but_text` varchar(16) NOT NULL DEFAULT '#fff',
  `but_border` varchar(16) NOT NULL DEFAULT '#fff',
  `position` varchar(32) NOT NULL DEFAULT 'bottom-left',
  `layout` varchar(32) NOT NULL DEFAULT 'classic',
  `type` varchar(32) NOT NULL DEFAULT 'show',
  `overwrite` int(1) NOT NULL DEFAULT '0',
  `message` varchar(512) NOT NULL DEFAULT 'here the message text',
  `dismiss` varchar(128) NOT NULL DEFAULT 'Agree',
  `allow` varchar(128) NOT NULL DEFAULT 'Accept',
  `deny` varchar(128) NOT NULL DEFAULT 'Deny',
  `link` varchar(64) NOT NULL DEFAULT 'policy link',
  `href` varchar(256) NOT NULL DEFAULT 'https://cms-lab.com/_documentation/cookie.php',
  PRIMARY KEY (`cookie_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mod_cookie`
--

INSERT INTO `[[dbprefix]]mod_cookie` VALUES
(1, '#aaa', '#fff', 'transparent', '#fff', '#fff', 'bottom-left', 'classic', 'show', 0, 'here the message text', 'Agree', 'Accept', 'Deny', 'policy link', 'https://cms-lab.com/_documentation/cookie.php');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_droplets`
--

CREATE TABLE `[[dbprefix]]mod_droplets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `code` longtext NOT NULL,
  `description` text NOT NULL,
  `modified_when` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `admin_edit` int(11) NOT NULL DEFAULT '0',
  `admin_view` int(11) NOT NULL DEFAULT '0',
  `show_wysiwyg` int(11) NOT NULL DEFAULT '0',
  `comments` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]mod_droplets`
--

INSERT INTO `[[dbprefix]]mod_droplets` VALUES
(1, 'check-css', '// ---- begin droplet\r\n$ch = curl_init();\r\ncurl_setopt($ch, CURLOPT_URL, "https://doc.lepton-cms.org/_packinstall/check-css.txt" );\r\ncurl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);\r\n$source = curl_exec($ch);\r\ncurl_close($ch);\r\n       \r\nreturn $source;\r\n// end droplet', 'this droplets displays standard css of your template file', [[timestamp]], 1, 1, 0, 0, 0, 'Usage:[[check-css]]'),
(2, 'EditThisPage', '/**\r\n * Version for L* >= 7.2.x\r\n * This Droplet will show a link to the backend page editor. This is only shown when the user is logged in and has the correct permissions to edit the page in question.\r\n */\r\nglobal $HEADING;\r\n$leptoken=get_leptoken();\r\n$admin = new LEPTON_admin(auto_header: false, auto_auth: false);\r\n$database = LEPTON_database::getInstance();\r\n$oLEPTON= LEPTON_frontend::getInstance();\r\n$iCurrentPageId = $oLEPTON->page_id ?? 0;\r\n$str = " ";\r\n\r\nif (FRONTEND_LOGIN == ''enabled'' AND is_numeric($admin->getValue(''user_id'',''integer'',''session'')))\r\n{\r\n	$results_array = [];\r\n	$database->execute_query(\r\n	    "SELECT * FROM `".TABLE_PREFIX."pages` WHERE `page_id` = ".$iCurrentPageId,\r\n	    true,\r\n	    $results_array,\r\n	    false\r\n	);\r\n\r\n	if(empty($results_array))\r\n	{\r\n		return "";\r\n	}\r\n\r\n	$admin_groups   = explode('','', $results_array[''admin_groups'']);\r\n	$this_user      = $admin->getValue(''group_id'',''integer'',''session'');\r\n\r\n	$in_group = FALSE;\r\n\r\n	foreach($admin->getValue(''groups_id'',''string'', ''session'','','') as $sCurrentGroupId)\r\n	{\r\n		if (in_array($sCurrentGroupId, $admin_groups)) $in_group = TRUE;\r\n		if ($in_group == true ) \r\n		{\r\n			$str  = ''<a href="'' . ADMIN_URL . ''/pages/modify.php?page_id=''.$iCurrentPageId;\r\n			$str .= ''" target="_blank"><img align="left" border="0" src="'';\r\n			$str .= LEPTON_URL . ''/modules/lib_lepton/backend_images/modify_16.png" alt="'' . $HEADING[''MODIFY_PAGE''] . ''" />Edit Page</a>'';\r\n		}	\r\n	}      \r\n}\r\nreturn $str;\r\n// end droplet', 'Shows an Edit page link in the frontend', [[timestamp]], 1, 1, 0, 0, 0, 'Usage: [[editthispage]]'),
(3, 'EmailFilter', ' \r\n// You can configure the output filtering with the options below.\r\n// Tip: Mailto links can be encrypted by a Javascript function. \r\n// To make use of this option, one needs to add the PHP code \r\n//       register_frontend_modfiles(''js'');\r\n// into the <head> section of the index.php of your template. \r\n// Without this modification, only the @ character in the mailto part will be replaced.\r\n\r\n// Basic Email Configuration: \r\n// Filter Email addresses in text 0 = no, 1 = yes - default 1\r\n$filter_settings[''email_filter''] = ''1'';\r\n\r\n// Filter Email addresses in mailto links 0 = no, 1 = yes - default 1\r\n$filter_settings[''mailto_filter''] = ''1'';\r\n\r\n// Email Replacements, replace the ''@'' and the ''.'' by default (at) and (dot)\r\n$filter_settings[''at_replacement'']  = ''(at)'';\r\n$filter_settings[''dot_replacement''] = ''(dot)'';\r\n\r\n// No need to change stuff underneatch unless you know what you are doing.\r\n\r\n// work out the defined output filter mode: possible output filter modes: [0], 1, 2, 3, 6, 7\r\n// 2^0 * (0.. disable, 1.. enable) filtering of mail addresses in text\r\n// 2^1 * (0.. disable, 1.. enable) filtering of mail addresses in mailto links\r\n// 2^2 * (0.. disable, 1.. enable) Javascript mailto encryption (only if mailto filtering enabled)\r\n\r\n// only filter output if we are supposed to\r\nif($filter_settings[''email_filter''] != ''1'' && $filter_settings[''mailto_filter''] != ''1''){\r\n	// nothing to do ...\r\n	return true;\r\n}\r\n\r\n// check if non mailto mail addresses needs to be filtered\r\n$output_filter_mode = ($filter_settings[''email_filter''] == ''1'') ? 1 : 0;		// 0|1\r\n	\r\n// check if mailto mail addresses needs to be filtered\r\n$page_data = '''';\r\nif($filter_settings[''mailto_filter''] == ''1'')\r\n{\r\n	$output_filter_mode = $output_filter_mode + 2;								// 0|2\r\n					\r\n        // check if Javascript mailto encryption is enabled (call register_frontend_functions in the template)\r\n        $search_pattern = ''/<.*src=\\".*\\/mdcr.js.*>/iU'';\r\n        if(preg_match($search_pattern, $page_data))\r\n        {\r\n          $output_filter_mode = $output_filter_mode + 4;       // 0|4\r\n        } else {\r\n        	$mdcr_script_url = LEPTON_URL."/modules/droplets/js/mdcr.js";\r\n        	$mdcr_script_tag = "\\n<script type=''text/javascript'' src=''".$mdcr_script_url."''></script>\\n";\r\n        	$page_data = str_replace("</head>", $mdcr_script_tag."</head>", $page_data);\r\n        	$output_filter_mode = $output_filter_mode + 4;       // 0|4\r\n        }\r\n}\r\n		\r\n// define some constants so we do not call the database in the callback function again\r\ndefine(''OUTPUT_FILTER_MODE'', (int) $output_filter_mode);\r\ndefine(''OUTPUT_FILTER_AT_REPLACEMENT'', $filter_settings[''at_replacement'']);\r\ndefine(''OUTPUT_FILTER_DOT_REPLACEMENT'', $filter_settings[''dot_replacement'']);\r\n	\r\n// function to filter mail addresses embedded in text or mailto links before outputing them on the frontend\r\nif (!function_exists(''filter_mail_addresses'')) {\r\n	function filter_mail_addresses($match) { \r\n		\r\n	// check if required output filter mode is defined\r\n		if(!(defined(''OUTPUT_FILTER_MODE'') && defined(''OUTPUT_FILTER_MODE'') && defined(''OUTPUT_FILTER_MODE''))) {\r\n			return $match[0];\r\n		}\r\n		\r\n		$search = array(''@'', ''.'');\r\n		$replace = array(OUTPUT_FILTER_AT_REPLACEMENT ,OUTPUT_FILTER_DOT_REPLACEMENT);\r\n		\r\n		// check if the match contains the expected number of subpatterns (6|8)\r\n		if(count($match) == 8) {\r\n			/**\r\n				OUTPUT FILTER FOR EMAIL ADDRESSES EMBEDDED IN TEXT\r\n			**/\r\n			\r\n			// 1.. text mails only, 3.. text mails + mailto (no JS), 7 text mails + mailto (JS)\r\n			if(!in_array(OUTPUT_FILTER_MODE, array(1,3,7))) return $match[0];\r\n\r\n			// do not filter mail addresses included in input tags (<input ... value = "test@mail)\r\n			if (strpos($match[6], ''value'') !== false) return $match[0];\r\n			\r\n			// filtering of non mailto email addresses enabled\r\n			return str_replace($search, $replace, $match[0]);\r\n				\r\n		} elseif(count($match) == 6) {\r\n			/**\r\n				OUTPUT FILTER FOR EMAIL ADDRESSES EMBEDDED IN MAILTO LINKS\r\n			**/\r\n\r\n			// 2.. mailto only (no JS), 3.. text mails + mailto (no JS), 6.. mailto only (JS), 7.. all filters active\r\n			if(!in_array(OUTPUT_FILTER_MODE, array(2,3,6,7))) return $match[0];\r\n			\r\n			// check if last part of the a href link: >xxxx</a> contains a email address we need to filter\r\n			$pattern = ''#[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\\.)+[A-Z]{2,4}#i'';\r\n			if(preg_match_all($pattern, $match[5], $matches)) {\r\n				foreach($matches as $submatch) {\r\n					foreach($submatch as $value) {\r\n						// replace all . and all @ in email address parts by (dot) and (at) strings\r\n						$match[5] = str_replace($value, str_replace($search, $replace, $value), $match[5]);\r\n					}\r\n				}\r\n			}\r\n\r\n			// check if Javascript encryption routine is enabled\r\n			if(in_array(OUTPUT_FILTER_MODE, array(6,7))) {\r\n				/** USE JAVASCRIPT ENCRYPTION FOR MAILTO LINKS **/\r\n				\r\n				// extract possible class and id attribute from ahref link\r\n				preg_match(''/class\\s*?=\\s*?("|\\'')(.*?)\\1/ix'', $match[0], $class_attr);\r\n				$class_attr = empty($class_attr) ? '''' : ''class="'' . $class_attr[2] . ''" '';\r\n				preg_match(''/id\\s*?=\\s*?("|\\'')(.*?)\\1/ix'', $match[0], $id_attr);\r\n				$id_attr = empty($id_attr) ? '''' : ''id="'' . $id_attr[2] . ''" '';\r\n				\r\n				// preprocess mailto link parts for further usage\r\n				$search = array(''@'', ''.'', ''_'', ''-''); $replace = array(''F'', ''Z'', ''X'', ''K'');\r\n				$email_address = str_replace($search, $replace, strtolower($match[2]));\r\n				$email_subject = rawurlencode(html_entity_decode($match[3]));\r\n				\r\n				// create a random encryption key for the Caesar cipher\r\n				mt_srand((double)microtime()*1000000);	// (PHP < 4.2.0)\r\n				$shift = mt_rand(1, 25);\r\n				\r\n				// encrypt the email using an adapted Caesar cipher\r\n		  		$encrypted_email = "";\r\n				for($i = strlen($email_address) -1; $i > -1; $i--) {\r\n					if(preg_match(''#[FZXK0-9]#'', $email_address[$i], $characters)) {\r\n						$encrypted_email .= $email_address[$i];\r\n					} else {	\r\n						$encrypted_email .= chr((ord($email_address[$i]) -97 + $shift) % 26 + 97);\r\n					}\r\n				}\r\n				$encrypted_email .= chr($shift + 97);\r\n\r\n				// build the encrypted Javascript mailto link\r\n				$mailto_link  = "<a {$class_attr}{$id_attr}href=\\"javascript:mdcr(''$encrypted_email'',''$email_subject'')\\">" .$match[5] ."</a>";\r\n				\r\n				return $mailto_link;	\r\n\r\n			} else {\r\n				/** DO NOT USE JAVASCRIPT ENCRYPTION FOR MAILTO LINKS **/\r\n\r\n				// as minimum protection, replace replace @ in the mailto part by (at)\r\n				// dots are not transformed as this would transform my.name@domain.com into: my(dot)name(at)domain(dot)com\r\n				\r\n				// rebuild the mailto link from the subpatterns (at the missing characters " and </a>")\r\n				return $match[1] .str_replace(''@'', OUTPUT_FILTER_AT_REPLACEMENT, $match[2]) .$match[3] .''"'' .$match[4] .$match[5] .''</a>'';\r\n				// if you want to protect both, @ and dots, comment out the line above and remove the comment from the line below\r\n				// return $match[1] .str_replace($search, $replace, $match[2]) .$match[3] .''"'' .$match[4] .$match[5] .''</a>'';\r\n			}\r\n		\r\n		}\r\n		\r\n		// number of subpatterns do not match the requirements ... do nothing\r\n		return $match[0];\r\n	}		\r\n}\r\n	\r\n// first search part to find all mailto email addresses\r\n$pattern = ''#(<a[^<]*href\\s*?=\\s*?"\\s*?mailto\\s*?:\\s*?)([A-Z0-9._%+-]+@(?:[A-Z0-9-]+\\.)+[A-Z]{2,4})([^"]*?)"([^>]*>)(.*?)</a>'';\r\n// second part to find all non mailto email addresses\r\n$pattern .= ''|(value\\s*=\\s*"|\\'')??\\b([A-Z0-9._%+-]+@(?:[A-Z0-9-]+\\.)+[A-Z]{2,4})\\b#i'';\r\n\r\n// Sub 1:\\b(<a.[^<]*href\\s*?=\\s*?"\\s*?mailto\\s*?:\\s*?)		-->	"<a id="yyy" class="xxx" href = " mailto :" ignoring white spaces\r\n// Sub 2:([A-Z0-9._%+-]+@(?:[A-Z0-9-]+\\.)+[A-Z]{2,4})		-->	the email address in the mailto: part of the mail link\r\n// Sub 3:([^"]*?)"							--> possible ?Subject&cc... stuff attached to the mail address\r\n// Sub 4:([^>]*>)							--> all class or id statements after the mailto but before closing ..>\r\n// Sub 5:(.*?)</a>\\b						--> the mailto text; all characters between >xxxxx</a>\r\n// Sub 6:|\\b([A-Z0-9._%+-]+@(?:[A-Z0-9-]+\\.)+[A-Z]{2,4})\\b		--> email addresses which may appear in the text (require word boundaries)\r\n$content = $page_data;			\r\n// find all email addresses embedded in the content and filter them using a callback function\r\n$content = preg_replace_callback($pattern, ''filter_mail_addresses'', $content);\r\n$page_data = $content;\r\nreturn true;\r\n		\r\n', 'Emailfiltering on your output - output filtering with the options below - Mailto links can be encrypted by a Javascript', [[timestamp]], 1, 1, 0, 0, 0, 'usage:  [[EmailFilter]]'),
(4, 'LoginBox', 'global $oLEPTON, $TEXT, $MENU;\r\nif (!isset ($redirect_login)) { $redirect_login = LEPTON_URL."/index.php"; } \r\nif (!isset ($redirect_logout)) { $redirect_logout = $redirect_login ; }\r\n$return_value = " ";\r\n// not yet logged in\r\n\r\nif(FRONTEND_LOGIN == ''enabled'' && VISIBILITY != ''private'' && !isset($_SESSION[''USER_ID'']) ) \r\n{\r\n	$return_value  = ''<form name="login" action="''.LOGIN_URL.''?redirect=''.$redirect_login.''" method="post" class="login_table">'';\r\n	$return_value .= ''<h2>''.$TEXT[''LOGIN''].''</h2>'';\r\n	$return_value .= $TEXT[''USERNAME''].'':<input type="text" name="username" /><br />'';\r\n	$return_value .= $TEXT[''PASSWORD''].'':<input type="password" name="password" /><br />'';\r\n	$return_value .= ''<input type="submit" name="submit" value="''.$TEXT[''LOGIN''].''" class="dbutton" /><br />'';\r\n	$return_value .= ''<a href="''.FORGOT_URL.''">''.$TEXT[''FORGOT_DETAILS''].''</a><br />'';\r\n	if(is_numeric(FRONTEND_SIGNUP))  \r\n		$return_value .= ''<a href="''.SIGNUP_URL.''">''.$TEXT[''SIGNUP''].''</a>'';\r\n	$return_value .= ''</form>'';\r\n// logged in\r\n} \r\nelseif(FRONTEND_LOGIN == ''enabled'' && ($oLEPTON->getValue(''user_id'', ''integer'', ''session'') > 0) ) \r\n{\r\n	$return_value = ''<form name="logout" action="''.LOGOUT_URL.''?redirect=''.$redirect_logout.''" method="post" class="login_table">'';\r\n	$return_value .= ''<h2>''.$TEXT[''LOGGED_IN''].''</h2>'';\r\n	$return_value .= $TEXT[''WELCOME_BACK''].'', ''.$oLEPTON->getValue(''display_name'', ''string_clean'', ''session'').''<br />'';\r\n	$return_value .= ''<input type="submit" name="submit" value="''.$MENU[''LOGOUT''].''" class="dbutton" /><br />'';\r\n	$return_value .= ''</form>'';\r\n}\r\nreturn $return_value;', 'Puts a Login / Logout box on your page.', [[timestamp]], 1, 1, 0, 0, 0, 'Use: [[LoginBox]]. Remember to enable frontend login in your website settings. For details please see:  https://doc.lepton-cms.org/docu/english/home/tutorials/frontend-login.php'),
(5, 'Lorem', '$lorem = array();\n$lorem[] = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Ut odio. Nam sed est. Nam a risus et est iaculis adipiscing. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Integer ut justo. In tincidunt viverra nisl. Donec dictum malesuada magna. Curabitur id nibh auctor tellus adipiscing pharetra. Fusce vel justo non orci semper feugiat. Cras eu leo at purus ultrices tristique.<br /><br />";\n$lorem[] = "Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.<br /><br />";\n$lorem[] = "Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.<br /><br />";\n$lorem[] = "Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.<br /><br />";\n$lorem[] = "Cras consequat magna ac tellus. Duis sed metus sit amet nunc faucibus blandit. Fusce tempus cursus urna. Sed bibendum, dolor et volutpat nonummy, wisi justo convallis neque, eu feugiat leo ligula nec quam. Nulla in mi. Integer ac mauris vel ligula laoreet tristique. Nunc eget tortor in diam rhoncus vehicula. Nulla quis mi. Fusce porta fringilla mauris. Vestibulum sed dolor. Aliquam tincidunt interdum arcu. Vestibulum eget lacus. Curabitur pellentesque egestas lectus. Duis dolor. Aliquam erat volutpat. Aliquam erat volutpat. Duis egestas rhoncus dui. Sed iaculis, metus et mollis tincidunt, mauris dolor ornare odio, in cursus justo felis sit amet arcu. Aenean sollicitudin. Duis lectus leo, eleifend mollis, consequat ut, venenatis at, ante.<br /><br />";\n$lorem[] = "Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.<br /><br />"; \nif (!isset($blocks)) $blocks = 1;\n$blocks = (int)$blocks - 1;\nif ($blocks <= 0) $blocks = 0;\nif ($blocks > 5) $blocks = 5;\n$returnvalue = "";\nfor ( $i=0 ; $i<=$blocks ; $i++) {\n    $returnvalue .= $lorem[$i];\n}\nreturn $returnvalue;', 'Create Lorum Ipsum text', [[timestamp]], 1, 1, 0, 0, 0, 'Use: [[Lorem?blocks=6]] (max 6 paragraphs)'),
(6, 'year', '$datum = date("Y");\r\nreturn $datum;', 'displays the current year', [[timestamp]], 1, 1, 0, 0, 0, 'Usage:[[year]]'),
(7, 'site-cookie', 'return cookie::getInstance()->build_js();', 'sets a site cookie', [[timestamp]], 1, 1, 0, 0, 0, '[[site-cookie]]'),
(8, 'LEPTON_SearchBox', 'if (SHOW_SEARCH) \r\n{\r\n    $oLEPTON = LEPTON_frontend::getInstance();\r\n    $oTWIG = lib_twig_box::getInstance();\r\n    \r\n     $template = ($oLEPTON->page[''template''] != "")\r\n        ? $oLEPTON->page[''template''] // current frontend-template for this page\r\n        : DEFAULT_TEMPLATE  // default-frontend-template\r\n        ;\r\n\r\n    $oTWIG->registerModule(''lib_search'',''lib_search'');\r\n    // parse the search.box template\r\n    return $oTWIG->render(\r\n        ''@lib_search/search.box.lte'',\r\n        [\r\n            ''action'' 	=> LEPTON_URL.''/modules/lib_search/frontend_result.php'',\r\n            ''MOD_SEARCH''=> lib_search::getInstance()->language\r\n        ]\r\n    );\r\n}\r\nelse\r\n{\r\n    // the LEPTON search function is not enabled!\r\n    return false;\r\n}', 'Shows Search Box in the frontend', [[timestamp]], 1, 1, 0, 0, 0, 'Usage: [[LEPTON_SearchBox]]  This Droplet will show a search box. You can use it within your template or at any WYSIWYG page section');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_droplets_permissions`
--

CREATE TABLE `[[dbprefix]]mod_droplets_permissions` (
  `id` int(10) unsigned NOT NULL,
  `edit_perm` varchar(50) NOT NULL,
  `view_perm` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_droplets_settings`
--

CREATE TABLE `[[dbprefix]]mod_droplets_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute` varchar(50) NOT NULL DEFAULT '0',
  `value` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]mod_droplets_settings`
--

INSERT INTO `[[dbprefix]]mod_droplets_settings` VALUES
(1, 'Manage_backups', '1'),
(2, 'Import_droplets', '1'),
(3, 'Delete_droplets', '1'),
(4, 'Add_droplets', '1'),
(5, 'Export_droplets', '1'),
(6, 'Modify_droplets', '1'),
(7, 'Manage_perms', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_initial_page`
--

CREATE TABLE `[[dbprefix]]mod_initial_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '1',
  `init_page` text NOT NULL,
  `page_param` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mod_initial_page`
--

INSERT INTO `[[dbprefix]]mod_initial_page` VALUES
(1, 1, 'start/index.php', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_menu_link`
--

CREATE TABLE `[[dbprefix]]mod_menu_link` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `target_page_id` int(11) NOT NULL DEFAULT '0',
  `redirect_type` int(11) NOT NULL DEFAULT '302',
  `anchor` varchar(255) NOT NULL DEFAULT '0',
  `extern` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_comments`
--

CREATE TABLE `[[dbprefix]]mod_news_comments` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `post_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `comment` text NOT NULL,
  `commented_when` int(11) NOT NULL DEFAULT '0',
  `commented_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_groups`
--

CREATE TABLE `[[dbprefix]]mod_news_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_posts`
--

CREATE TABLE `[[dbprefix]]mod_news_posts` (
  `post_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `link` text NOT NULL,
  `content_short` text NOT NULL,
  `content_long` text NOT NULL,
  `commenting` varchar(7) NOT NULL DEFAULT '',
  `published_when` int(11) NOT NULL DEFAULT '0',
  `published_until` int(11) NOT NULL DEFAULT '0',
  `posted_when` int(11) NOT NULL DEFAULT '0',
  `posted_by` int(11) NOT NULL DEFAULT '0',
  `history_post_id` int(11) DEFAULT '-1',
  `history_max` int(1) NOT NULL DEFAULT '-1',
  `history_user` int(1) NOT NULL DEFAULT '-1',
  `history_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `history_type` int(1) NOT NULL DEFAULT '-1',
  `history_comment` text NOT NULL,
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_news_settings`
--

CREATE TABLE `[[dbprefix]]mod_news_settings` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `posts_per_page` int(11) NOT NULL DEFAULT '5',
  `commenting` varchar(7) NOT NULL DEFAULT 'none',
  `resize` int(11) NOT NULL DEFAULT '0',
  `use_captcha` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_quickform`
--

CREATE TABLE `[[dbprefix]]mod_quickform` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(128) NOT NULL DEFAULT '',
  `subject` varchar(128) NOT NULL DEFAULT '',
  `template` varchar(64) NOT NULL DEFAULT '',
  `successpage` int(11) NOT NULL DEFAULT '0',
  `usenbritems` int(11) NOT NULL DEFAULT '50',
  `useview` varchar(12) NOT NULL DEFAULT 'CLASSIC',
  `use_honeypot` int(1) DEFAULT '0',
  `spam_logging` int(1) DEFAULT '0',
  `spam_checktime` int(11) DEFAULT '0',
  `spam_honeypot` varchar(256) DEFAULT '',
  `spam_failpage` int(11) DEFAULT '0',
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_quickform_data`
--

CREATE TABLE `[[dbprefix]]mod_quickform_data` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `msg_group` varchar(32) NOT NULL DEFAULT 'INBOX',
  `data` text NOT NULL,
  `submitted_when` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wrapper`
--

CREATE TABLE `[[dbprefix]]mod_wrapper` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `url` text NOT NULL,
  `height` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]mod_wrapper`
--

INSERT INTO `[[dbprefix]]mod_wrapper` VALUES
(1, 1, 'https://doc.lepton-cms.org/_packinstall/start-package3.html', 900);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wysiwyg`
--

CREATE TABLE `[[dbprefix]]mod_wysiwyg` (
  `section_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `last_version` int(11) NOT NULL DEFAULT '0',
  `hist_autosave` int(11) NOT NULL DEFAULT '0',
  `max_history` int(11) NOT NULL DEFAULT '0',
  `use_workingcopy` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '-1' COMMENT 'User who last saved the content',
  `user_id_working` int(11) NOT NULL DEFAULT '-1' COMMENT 'User who last saved the working copy',
  `content` longtext NOT NULL,
  `content_comment` text NOT NULL,
  `text` longtext NOT NULL,
  `working_content` longtext NOT NULL,
  `working_content_comment` text NOT NULL,
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wysiwyg_history`
--

CREATE TABLE `[[dbprefix]]mod_wysiwyg_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL DEFAULT '0',
  `version` int(11) NOT NULL DEFAULT '0',
  `autosaved` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '-1' COMMENT 'User who last saved this content',
  `user_id_hist` int(11) NOT NULL DEFAULT '-1' COMMENT 'User who pushed this content to history',
  `comment` text NOT NULL,
  `content` longtext NOT NULL,
  `text` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `section_id` (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mod_wysiwyg_settings`
--

CREATE TABLE `[[dbprefix]]mod_wysiwyg_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `skin` varchar(128) NOT NULL DEFAULT 'none',
  `toolbar` varchar(128) NOT NULL DEFAULT 'none',
  `content_css` varchar(128) NOT NULL DEFAULT 'none',
  `width` int(4) NOT NULL DEFAULT '960',
  `height` int(4) NOT NULL DEFAULT '500',
  `editor` varchar(128) NOT NULL DEFAULT 'none',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) NOT NULL DEFAULT '0',
  `root_parent` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0',
  `link` text,
  `target` varchar(7) NOT NULL DEFAULT '',
  `page_title` varchar(255) NOT NULL DEFAULT '',
  `menu_title` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `keywords` text,
  `page_trail` text,
  `template` varchar(255) NOT NULL DEFAULT '',
  `visibility` varchar(255) NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT '0',
  `menu` int(11) NOT NULL DEFAULT '0',
  `language` varchar(5) NOT NULL DEFAULT '',
  `page_code` varchar(100) NOT NULL DEFAULT '',
  `open_tree` int(1) NOT NULL DEFAULT '0',
  `searching` int(11) NOT NULL DEFAULT '0',
  `admin_groups` text,
  `viewing_groups` text,
  `modified_when` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]pages`
--

INSERT INTO `[[dbprefix]]pages` VALUES
(1, 0, 1, 0, '/hello-world', '_self', 'hello world', 'hello world', '', '', '1', '', 'public', 0, 1, 'EN', '', 0, 1, '1', '1', [[timestamp]], 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search`
--

CREATE TABLE `[[dbprefix]]search` (
  `search_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`search_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]search`
--

INSERT INTO `[[dbprefix]]search` VALUES
(1, 'module_order', 'wysiwyg', ''),
(2, 'max_excerpt', '15', ''),
(3, 'time_limit', '0', ''),
(4, 'cfg_search_keywords', 'true', ''),
(5, 'cfg_search_description', 'true', ''),
(6, 'cfg_search_non_public_content', 'false', ''),
(7, 'cfg_link_non_public_content', '', ''),
(8, 'cfg_show_description', 'true', ''),
(9, 'template', '', ''),
(10, 'cfg_search_images', 'true', ''),
(11, 'cfg_thumbs_width', '100', ''),
(12, 'cfg_content_image', 'first', ''),
(13, 'cfg_search_library', 'lib_search', ''),
(14, 'cfg_search_droplet', 'LEPTON_SearchResults', ''),
(15, 'cfg_search_use_page_id', '-1', ''),
(16, 'module', 'news', 'a:6:{s:7:"page_id";s:7:"page_id";s:5:"title";s:10:"page_title";s:4:"link";s:4:"link";s:11:"description";s:11:"description";s:13:"modified_when";s:13:"modified_when";s:11:"modified_by";s:11:"modified_by";}'),
(17, 'query_start', 'SELECT [TP]pages.page_id, [TP]pages.page_title,	[TP]pages.link, [TP]pages.description, [TP]pages.modified_when, [TP]pages.modified_by	FROM [TP]mod_news_posts, [TP]mod_news_groups, [TP]mod_news_comments, [TP]mod_news_settings, [TP]pages WHERE ', 'news'),
(18, 'query_body', '\r\n    	[TP]pages.page_id = [TP]mod_news_posts.page_id AND [TP]mod_news_posts.title LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_posts.page_id AND [TP]mod_news_posts.content_short LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_posts.page_id AND [TP]mod_news_posts.content_long LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_comments.page_id AND [TP]mod_news_comments.title LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_comments.page_id AND [TP]mod_news_comments.comment LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_settings.page_id AND [TP]mod_news_settings.header LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_settings.page_id AND [TP]mod_news_settings.footer LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_settings.page_id AND [TP]mod_news_settings.post_header LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_settings.page_id AND [TP]mod_news_settings.post_footer LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_settings.page_id AND [TP]mod_news_settings.comments_header LIKE ''%[STRING]%''\r\n    	OR [TP]pages.page_id = [TP]mod_news_settings.page_id AND [TP]mod_news_settings.comments_footer LIKE ''%[STRING]%''\r\n	', 'news'),
(19, 'query_end', '', 'news'),
(20, 'module', 'wysiwyg', 'a:6:{s:7:"page_id";s:7:"page_id";s:5:"title";s:10:"page_title";s:4:"link";s:4:"link";s:11:"description";s:11:"description";s:13:"modified_when";s:13:"modified_when";s:11:"modified_by";s:11:"modified_by";}'),
(21, 'query_start', 'SELECT [TP]pages.page_id, [TP]pages.page_title,	[TP]pages.link, [TP]pages.description, [TP]pages.modified_when, [TP]pages.modified_by	FROM [TP]mod_wysiwyg, [TP]pages WHERE ', 'wysiwyg'),
(22, 'query_body', ' [TP]pages.page_id = [TP]mod_wysiwyg.page_id AND [TP]mod_wysiwyg.text [O] ''[W][STRING][W]'' AND [TP]pages.searching = ''1''', 'wysiwyg'),
(23, 'query_end', '', 'wysiwyg');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sections`
--

CREATE TABLE `[[dbprefix]]sections` (
  `section_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `module` varchar(255) NOT NULL DEFAULT '',
  `block` int(11) NOT NULL DEFAULT '0',
  `publ_start` int(11) NOT NULL DEFAULT '0',
  `publ_end` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT 'no name',
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]sections`
--

INSERT INTO `[[dbprefix]]sections` VALUES
(1, 1, 1, 'wrapper', 1, 0, 0, 'no name');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 'lepton_version', '7.4.0'),
(2, 'website_title', '[[site_name]]'),
(3, 'website_description', ''),
(4, 'website_keywords', ''),
(5, 'website_header', '[[site_name]]'),
(6, 'website_footer', 'settings/website footer'),
(7, 'backend_title', '[[site_name]]'),
(8, 'upload_whitelist', 'jpg,jpeg,png,gif,webp,bmp,svg,ico,jxl,avif,gz,pdf'),
(9, 'er_level', '-1'),
(11, 'default_language', 'EN'),
(12, 'app_name', '[[app_name]]'),
(13, 'sec_anchor', 'lep_'),
(14, 'default_timezone_string', 'America/Los_Angeles'),
(15, 'default_date_format', 'M d Y'),
(16, 'default_time_format', 'g:i A'),
(17, 'redirect_timer', '1500'),
(18, 'leptoken_lifetime', '1800'),
(19, 'max_attempts', '6'),
(20, 'home_folders', 'true'),
(21, 'default_template', 'semantic'),
(22, 'default_theme', 'lepsem'),
(23, 'default_charset', 'utf-8'),
(24, 'link_charset', 'utf-8'),
(25, 'multiple_menus', 'true'),
(26, 'page_level_limit', '4'),
(27, 'page_trash', 'inline'),
(28, 'homepage_redirection', 'false'),
(29, 'page_languages', 'false'),
(30, 'wysiwyg_editor', 'tinymce'),
(31, 'manage_sections', 'true'),
(32, 'section_blocks', 'true'),
(33, 'frontend_login', 'false'),
(34, 'frontend_signup', '0'),
(35, 'search', 'public'),
(36, 'page_extension', '.php'),
(37, 'page_spacer', '-'),
(38, 'pages_directory', '/page'),
(39, 'media_directory', '/media'),
(40, 'operating_system', '[[operating_system]]'),
(41, 'string_file_mode', '0644'),
(42, 'string_dir_mode', '0755'),
(43, 'mailer_routine', 'phpmail'),
(44, 'server_email', '[[admin_email]]'),
(45, 'mailer_default_sendername', 'LEPTON Mailer'),
(46, 'mailer_smtp_host', ''),
(47, 'mailer_smtp_auth', ''),
(48, 'mailer_smtp_secure', 'tls'),
(49, 'mailer_smtp_port', '587'),
(50, 'mailer_smtp_username', ''),
(51, 'mailer_smtp_password', ''),
(52, 'mediasettings', ''),
(53, 'tfa', 'none'),
(54, 'wysiwyg_history', 'false');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]temp`
--

CREATE TABLE `[[dbprefix]]temp` (
  `temp_id` int(2) NOT NULL AUTO_INCREMENT,
  `temp_browser` varchar(64) NOT NULL DEFAULT '',
  `temp_ip` varchar(64) NOT NULL DEFAULT '',
  `temp_time` int(24) NOT NULL DEFAULT '0',
  `temp_count` int(2) NOT NULL DEFAULT '0',
  `temp_active` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`temp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `groups_id` varchar(255) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `statusflags` int(11) NOT NULL DEFAULT '6',
  `username` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `last_reset` int(11) NOT NULL DEFAULT '0',
  `pin` varchar(255) NOT NULL DEFAULT '-1',
  `pin_set` int(1) NOT NULL DEFAULT '0',
  `display_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL DEFAULT '',
  `timezone_string` varchar(50) NOT NULL DEFAULT 'America/Los_Angeles',
  `date_format` varchar(255) NOT NULL DEFAULT '',
  `time_format` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(5) NOT NULL DEFAULT 'EN',
  `home_folder` text,
  `login_when` int(11) NOT NULL DEFAULT '0',
  `login_ip` varchar(64) NOT NULL DEFAULT '',
  `unix_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '1', 1, 6, '[[admin_username]]', '[[admin_pass]]', 0, '-1', 0, 'Administrator', '[[admin_email]]', 'America/Los_Angeles', '', '', 'EN', '', 0, '', 0);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
