<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          Twig Template Engine
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON  
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl-3.0.html
 * @license_terms   please see info.php of this module
 *
 */

use Twig\ExpressionParser\Infix\BinaryOperatorExpressionParser;
use Twig\ExpressionParser\Prefix\UnaryOperatorExpressionParser;
use Twig\Extension\AbstractExtension;
use Twig\Extension\ExtensionInterface;
use Twig\Node\Expression\Binary\AndBinary;
use Twig\Node\Expression\Binary\OrBinary;
use Twig\Node\Expression\Unary\NotUnary;

class lib_twig_operators extends AbstractExtension implements ExtensionInterface
{
    // initialize
    public function __construct()
    {
        // nothing here to do.
    }
    
    /**
     *  TWIG 3.21
     *  Method "getOperators" is deprecated!
     *
     *  See: https://twig.symfony.com/doc/3.x/deprecated.html
     *
     */
    #[\Override]
    public function getExpressionParsers(): array
    {
        return [
             new UnaryOperatorExpressionParser(NotUnary::class, '!', 50),
             new BinaryOperatorExpressionParser(OrBinary::class, '||', 10),
             new BinaryOperatorExpressionParser(AndBinary::class, '&&', 15)
        ];
    }
}