<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 *
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl-3.0.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */


// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file

// get classes
$admin = LEPTON_admin::getInstance();
$oTWIG = lib_twig_box::getInstance();

if (!isset($_SESSION['SYSTEM_PERMISSIONS']))
{
    die();
}
// prevent users to access url directly
if ($admin->userHasAdminRights() == false)
{
    if (!in_array('media', $_SESSION['SYSTEM_PERMISSIONS']))
    {
	header("Location: ".ADMIN_URL);
	exit(0);
    }
}
// enable custom files
if (LEPTON_handle::require_alternative('media/index.php'))
{
    return 0;
}

LEPTON_handle::include_files("/modules/lib_r_filemanager/library.php");	

$page_values = [
    'source'    => LEPTON_URL.'/modules/lib_r_filemanager/filemanager/dialog.php?akey='.$_SESSION['rfkey'],
    'image'     => LEPTON_URL.'/modules/lib_r_filemanager/filemanager/img/blank.png',
    'id'        => "id='r_filemanager'",
    'seamless'  => "seamless='seamless'"
];

echo $oTWIG->render(
    "@theme/media.lte",
    $page_values
);
 
$admin->print_footer();
