<?php

/**
 * @package    Joomla.Language
 *
 * @copyright  (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 *
 * @phpcs:disable Squiz.Classes.ValidClassName.NotCamelCaps
 *
 * @phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * tr-TR localise class.
 *
 * @since  1.6
 */
abstract class Tr_TRLocalise
{
    /**
     * Returns the potential suffixes for a specific number of items
     *
     * @param   integer  $count  The number of items.
     *
     * @return  array  An array of potential suffixes.
     *
     * @since   1.6
     */
    public static function getPluralSuffixes($count)
    {
        switch ($count) {
            case 0:
                return ['0'];

            case 1:
                return ['ONE', '1'];
        }

        return ['OTHER', 'MORE'];
    }
	
     /**
  	 * This method processes a string and replaces all accented UTF-8 characters by unaccented
  	 * ASCII-7 "equivalents"
  	 *
  	 * @param	string	$string	The string to transliterate
  	 * @return	string	The transliteration of the string
  	 * @since	1.6
     */
  	public static function transliterate($string)
  	{
  		$str = \Joomla\String\StringHelper::strtolower($string);
  
  		//Specific language transliteration.
  		//This one is for latin 1, latin supplement , extended A, Turkish, Türkçe
  
  		$glyph_array = [
  		'a'		=>	'à,á,â,ã,ä,å,ā,ă,ą,ḁ,α,ά',
  		'ae'	=>	'æ',
  		'b'		=>	'β,б',
  		'c'		=>	'ç,Ç,ć,ĉ,ċ,č,ч,ћ,ц',
  		'ch'	=>	'ч',
  		'd'		=>	'ď,đ,Ð,д,ђ,δ,ð',
  		'dz'	=>	'џ',
  		'e'		=>	'è,é,ê,ë,ē,ĕ,ė,ę,ě,э,ε,έ',
  		'f'		=>	'ƒ,ф',
  		'g'		=>	'ğ,ĝ,ğ,ġ,ģ,Ğ,г,γ',
  		'h'		=>	'ĥ,ħ,Ħ,х',
  		'i'		=>	'ì,í,İ,ï,ı,I,ī,ĭ,į,и,й,ъ,ы,ь,η,ή',
  		'ij'	=>	'ĳ',
  		'j'		=>	'ĵ',
  		'ja'	=>	'я',
  		'ju'	=>	'яю',
  		'k'		=>	'ķ,ĸ,κ',
  		'l'		=>	'ĺ,ļ,ľ,ŀ,ł,л,λ',
  		'lj'	=>	'љ',
  		'm'		=>	'μ',
  		'n'		=>	'ñ,ņ,ň,ŉ,ŋ,н,ν',
  		'nj'	=>	'њ',
  		'o'		=>	'ò,ó,Ö,õ,ø,ō,Ö,ö,ο,ό,ω,ώ',
  		'oe'	=>	'œ,ö',
  		'p'		=>	'п,π',
  		'ph'	=>	'φ',
  		'ps'	=>	'ψ',
  		'r'		=>	'ŕ,ŗ,ř,р,ρ,σ,ς',
  		's'		=>	'ş,ś,ŝ,Ş,š,с',
  		'ss'	=>	'ß,ſ',
  		'sh'	=>	'ш',
  		'shch'	=>	'щ',
  		't'		=>	'ţ,ť,ŧ,τ',
  		'th'	=>	'θ',
  		'u'		=>	'ù,ú,û,ü,Ü,ū,ŭ,ů,ű,ų,у',
  		'v'		=>	'в',
  		'w'		=>	'ŵ',
  		'x'		=>	'χ,ξ',
  		'y'		=>	'ý,þ,ÿ,ŷ',
  		'z'		=>	'ź,ż,ž,з,ж,ζ'
  		];
  
  		foreach( $glyph_array as $letter => $glyphs ) {
  			$glyphs = explode( ',', $glyphs );
  			$str = str_replace( $glyphs, $letter, $str );
  		}
  
  		return $str;
  	}
}
