{assign var="page_template" value="signup"}

{jrCore_include template="header.tpl"}

{literal}
    <style>
        .hide-checkbox {
            display:none;
        }
        input[type=checkbox] + label
        {
            background-color: transparent;
            background-image: url("/skins/jrElastic2/img/password-show.png");
            height: 16px;
            width: 16px;
            display:inline-block;
            padding: 0;
            margin-left:-30px;
        }
        input[type=checkbox]:checked + label
        {
            background-color: transparent;
            background-image: url("/skins/jrElastic2/img/password-hide.png");
            height: 16px;
            width: 16px;
            display:inline-block;
            padding: 0;
            margin-left:-30px;
        }
        #jrUser_signup_msg div {
            margin: 0 !important;
        }
        .form_captcha {
            margin: 10px 0;
        }
    </style>
{/literal}

<div class="row">
    <div class="col12">
        <div class="new_login signup">
            <h2>{$_conf.jrCore_system_name}</h2>
            {jrCore_module_url module="jrUser" assign="uurl"}
            {jrCore_form_create_session module="jrUser" option="signup" assign="token"}

            <div class="page_notice_drop">
                {if !empty($form_message_type)}
                    <div id="jrUser_signup_msg" class="page_notice form_notice {$form_message_type}" style="display:block">{$form_message_text}</div>
                {else}
                    <div id="jrUser_signup_msg" class="page_notice form_notice" style="margin:0"></div>
                {/if}
            </div>

            {if isset($_conf.jrUser_signup_note) && strlen($_conf.jrUser_signup_note) > 0}
            <div class="page_notice_drop">
                <div class="page_notice notice" style="text-transform:capitalize;">{$_conf.jrUser_signup_note}</div>
            </div>
            {/if}

            <form class="jrform" id="jrUser_signup" name="jrUser_signup" action="{$jamroom_url}/{$uurl}/signup_save" method="post" accept-charset="utf-8" enctype="multipart/form-data">

                <input name="jr_html_form_token" value="{$token}" type="hidden">

                {jrProfile_get_signup_quota assign="quotas"}
                {if is_numeric($quotas)}
                    {* We only have 1 signup quota - no need to show select option *}
                    <input id="quota_id" name="quota_id" value="{$quotas}" type="hidden">
                {/if}

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="4" default="user name" assign="txt"}
                    <input id="user_name" class="form_text" name="user_name" placeholder="{$txt|jrCore_entity_string}" value="" tabindex="1" autocorrect="off" autocapitalize="off" type="text">
                </div>

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="18" default="email address" assign="txt"}
                    <input id="user_email" class="form_text" name="user_email" placeholder="{$txt|jrCore_entity_string}" value="" tabindex="2" autocorrect="off" autocapitalize="off" type="text">
                </div>

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="7" default="password" assign="txt"}
                    <input id="user_passwd1" class="form_text" style="margin-left:-8px;" placeholder="" name="user_passwd1" value="{$txt|jrCore_entity_string}" tabindex="3" type="password">
                    <input type='checkbox' name='psswrd' value='valuable' id="psswrd" onclick="pwOne()" class="hide-checkbox"><label for="psswrd"></label>
                </div>

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="32" default="repeat password" assign="txt"}
                    <input id="user_passwd2" class="form_text" style="margin-left:-8px;" name="user_passwd2" placeholder="" value="{$txt|jrCore_entity_string}" tabindex="4" onkeypress="if (event && event.keyCode === 13 && this.value.length > 0) { jrFormSubmit('#jrUser_signup','{$token}','ajax'); }" type="password">
                    <input type='checkbox' name='rpsswrd' value='valuable' id="rpsswrd" onclick="pwTwo()" class="hide-checkbox"><label for="rpsswrd"></label>
                </div>

                {if is_array($quotas)}
                {* we have multiple signup quotas - show select *}
                <div class="form_text_wrap">
                    {jrCore_lang module="jrProfile" id=130 default="Select Account Type" assign="txt"}
                    <select id="quota_id" class="form_select" style="padding:0 0 0 8px;text-transform:capitalize;" name="quota_id">
                        <optgroup label="{$txt|jrCore_entity_string}">
                        {foreach $quotas as $id => $quota_name}
                            <option value="{$id}">{$quota_name}</option>
                        {/foreach}
                        </optgroup>
                    </select>
                </div>
                {/if}

                <div class="form_text_wrap center">
                    {if jrCore_module_is_active('jrCaptcha')}
                        {jrCore_include module="jrCaptcha" template="hcaptcha.tpl"}
                    {else}
                        {jrUser_signup_human_check tabindex=5} <span class="sb_label" style="text-transform:capitalize">{jrCore_lang module="jrUser" id=90 default="human check"}</span>
                    {/if}
                </div>

                <div class="form_submit_section">
                    <input id="jrUser_signup_submit" class="signup_button" value="{jrCore_lang module="jrUser" id="31" default="Create Account"}" tabindex="6" onclick="resetPassWordInputs();jrFormSubmit('#jrUser_signup','{$token}','ajax');" type="button"><br>
                    {jrCore_get_activity_indicator('form_submit_indicator', 30)}
                </div>

            </form>
            <br>
            <div class="login_forgot">
                <a href="{$jamroom_url}/{$uurl}/login">{jrCore_lang module="jrUser" id="131" default="Already Have an Account?"}</a>
            </div>

        </div>
    </div>
</div>

{literal}
    <script type="text/javascript">
        // Show/Hide password one
        function pwOne() {
            var x = document.getElementById("user_passwd1");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        }
        // Show/Hide password two
        function pwTwo() {
            var x = document.getElementById("user_passwd2");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        }
        function resetPassWordInputs() {
            // Set password one field back to password type
            var x = document.getElementById("user_passwd1");
            if (x.type === "text") {
                x.type = "password";
            }
            // Set password two field back to password type
            var y = document.getElementById("user_passwd2");
            if (y.type === "text") {
                y.type = "password";
            }
            // Set show password one checkbox to unchecked
            let inputs = document.getElementById('psswrd');
            inputs.checked = false;
            // Set show password two checkbox to unchecked
            let rinputs = document.getElementById('rpsswrd');
            rinputs.checked = false;
        }
    </script>
{/literal}

{jrCore_include template="footer.tpl"}
