<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_create($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    // Make sure user is allowed to create profiles....
    if (!jrUser_is_power_user()) {
        jrUser_not_authorized();
    }

    // If this a master admin creating...
    if (jrUser_is_master()) {
        jrCore_page_include_admin_menu();
        jrCore_page_admin_tabs('jrProfile');
    }

    // Show Quota picker - not that Power Users may/may not have access to
    // select a different Quota for the profiles created by them
    $_qut = jrProfile_get_quotas();
    if (!jrUser_is_admin()) {
        // We're a power user and may only have access to selected Quotas
        $key = jrUser_get_profile_home_key('quota_jrUser_power_user_quotas');
        if (strpos($key, ',')) {
            $_all = array();
            foreach (explode(',', $key) as $qid) {
                if (isset($_qut[$qid])) {
                    $_all[$qid] = $_qut[$qid];
                }
            }
            $_qut = $_all;
            unset($_all);
        }
        elseif (jrCore_checktype($key, 'number_nz') && isset($_qut[$key])) {
            $_qut = array($key => $_qut[$key]);
        }
        else {
            jrCore_notice_page('error', 'Unable to determine Power User Quota - please contact the system adminstrator');
        }
        // Show them how many profiles they can create
        if (isset($_user['quota_jrUser_power_user_max']) && $_user['quota_jrUser_power_user_max'] > 0) {

            // Let's see how many profiles they have created
            $num = jrProfile_get_user_linked_profiles($_user['_user_id']);
            $max = jrUser_get_profile_home_key('quota_jrUser_power_user_max');
            if ($num && is_array($num) && count($num) >= $max) {
                jrCore_notice_page('error', 37, 'referrer');
            }
            $_ln = jrUser_load_lang_strings();
            jrCore_set_form_notice('notice', "{$_ln['jrProfile'][28]} {$max}");
        }
    }

    // Show create new Profile Form
    jrCore_page_banner(7, false, false);

    // Form init
    $_tmp = array(
        'submit_value' => 8,
        'cancel'       => 'referrer'
    );
    jrCore_form_create($_tmp);

    // Profile Name
    $_tmp = array(
        'name'     => 'profile_name',
        'label'    => 9,
        'help'     => 10,
        'type'     => 'text',
        'required' => true,
        'validate' => 'printable'
    );
    jrCore_form_field_create($_tmp);

    if (isset($_qut) && is_array($_qut) && count($_qut) > 1) {
        $_tmp = array(
            'name'          => 'profile_quota_id',
            'label'         => 29,
            'help'          => 30,
            'type'          => 'select',
            'options'       => $_qut,
            'required'      => true,
            'validate'      => 'number_nz',
            'form_designer' => false // We do not allow the form designer to override this field
        );
        jrCore_form_field_create($_tmp);
    }
    else {
        $qval = array_keys($_qut);
        $qval = reset($qval);
        $_tmp = array(
            'name'          => 'profile_quota_id',
            'type'          => 'hidden',
            'value'         => $qval,
            'validate'      => 'number_nz',
            'form_designer' => false // We do not allow the form designer to override this field
        );
        jrCore_form_field_create($_tmp);
    }

    // Show User Picker...  (ADMINS ONLY)
    $_tmp = array(
        'name'          => 'profile_user_id',
        'group'         => 'admin',
        'label'         => 'profile owner',
        'help'          => 'What User Account should this profile be created for?  The User Account selected here will have admin capabilities for the Profile.',
        'type'          => 'live_search',
        'target'        => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/get_profile_users",
        'required'      => false,
        'validate'      => 'number_nz',
        'form_designer' => false // We do not allow the form designer to override this field
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
