<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_all_items
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_update_all_items($_post, $_user, $_conf)
{
    global $_post;
    jrUser_master_only();
    $_post['jr_html_modal_token'] = jrCore_get_temp_value('jrMarket', 'modal_update_key');
    $_up                          = jrCore_get_temp_value('jrMarket', 'jrupdate_results');
    if (!$_up || !is_array($_up)) {
        jrCore_form_modal_notice('error', 'Unable to retrieve update data - please try again');
        jrCore_form_modal_notice('complete', 'Errors were encountered updating the items');
        jrCore_exit();
    }
    jrCore_logger('INF', 'installing all marketplace updates');

    // Make sure we have time to run
    ignore_user_abort(true);
    ini_set('max_execution_time', 7200);

    foreach ($_up as $type => $_todo) {
        if (is_array($_todo) && count($_todo) > 0) {
            jrMarket_update_items($type, $_todo, false, true);
        }
    }

    jrCore_logger('INF', 'all marketplace updates successfully installed');
    $_post['jr_html_modal_token'] = jrCore_get_temp_value('jrMarket', 'modal_update_key');
    jrCore_form_modal_notice('complete', 'All items have been successfully updated - click close to validate the update');
    jrCore_delete_temp_value('jrMarket', 'modal_update_key');
    jrCore_exit();
}
