<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: history
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_history($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket');
    jrCore_page_banner('Install History');
    jrCore_get_form_notice();

    if (!isset($_post['p']) || !jrCore_checktype($_post['p'], 'number_nz')) {
        $_post['p'] = 1;
    }

    $tbl = jrCore_db_table_name('jrMarket', 'install');
    $req = "SELECT * FROM {$tbl} ORDER BY install_time DESC";
    $_rt = jrCore_db_paged_query($req, $_post['p'], 12);

    $dat             = array();
    $dat[1]['title'] = 'date';
    $dat[1]['width'] = '20%';
    $dat[2]['title'] = 'installed items';
    $dat[2]['width'] = '75%';
    $dat[3]['title'] = 'details';
    $dat[3]['width'] = '5%';
    jrCore_page_table_header($dat);

    if (isset($_rt['_items']) && is_array($_rt['_items'])) {
        foreach ($_rt['_items'] as $k => $_itm) {
            $dat             = array();
            $dat[1]['title'] = jrCore_format_time($_itm['install_time']);
            $dat[1]['class'] = 'center';
            $_it             = json_decode($_itm['install_data'], true);
            $itm             = array();
            if (isset($_it['modules']) && count($_it['modules']) > 0) {
                $itm[] = "<span style=\"display:inline-block;width:60px;text-align:right\"><b>Modules:</b></span> " . implode(', ', array_keys($_it['modules']));
            }
            if (isset($_it['skins']) && count($_it['skins']) > 0) {
                $itm[] = "<span style=\"display:inline-block;width:60px;text-align:right\"><b>Skins:</b></span> " . implode(', ', array_keys($_it['skins']));
            }
            $dat[2]['title'] = implode('<br>', $itm);
            $dat[3]['title'] = jrCore_page_button("v{$k}", "details", "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/install_result/{$_itm['install_id']}')");
            $dat[3]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>There is no installation history to show</p>';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_pager($_rt);
    jrCore_page_table_footer();
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
