<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: changelog
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_changelog($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    // Check for item
    if (!isset($_post['_1']) || strlen($_post['_1']) === 0) {
        jrCore_set_form_notice('error', 'Invalid marketplace item - please try again');
        jrCore_get_form_notice();
    }
    if (!isset($_post['_2']) || strlen($_post['_2']) === 0) {
        jrCore_set_form_notice('error', 'Invalid marketplace version - please try again');
        jrCore_get_form_notice();
    }
    $_dt = array(
        'item'    => $_post['_1'],
        'version' => $_post['_2']
    );
    if (!$_mkt = jrMarket_get_active_release_system()) {
        jrCore_set_form_notice('error', 'There are no active Marketplace Systems configured where you can download items or get system updates!<br>Enter a new Marketplace System below to enable the Marketplace.', false);
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/systems");
    }
    $_rs = jrCore_load_url("{$_mkt['system_url']}/networkmarket/changelog", $_dt, 'POST', jrMarket_get_port(), null, null, true, 60);
    if (!isset($_rs) || strpos($_rs, '{') !== 0) {
        jrCore_set_form_notice('error', 'Error communicating with update server - please try again');
        jrCore_get_form_notice();
    }
    $_rs = json_decode($_rs, true);
    if (!isset($_rs['changes'])) {
        jrCore_set_form_notice('error', 'Unable to retrieve changelog for item');
        jrCore_get_form_notice();
    }
    jrCore_page_banner("Change Log: {$_mods["{$_post['_1']}"]['module_name']}", jrCore_page_button('close', 'close', 'self.close()'));
    if (isset($_rs['changes'])) {
        jrCore_page_custom('<div class="p10 normal changelog_div">' . $_rs['changes'] . '</div>');
    }
    else {
        jrCore_page_notice('error', 'no change log found');
    }
    jrCore_page_close_button();
    jrCore_page_set_meta_header_only();
    jrCore_page_display();
}
