<?php
 /**
 * Jamroom Followers module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: following
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrFollower_following($_post, $_user, $_conf)
{
    // Must be logged
    jrUser_session_require_login();
    jrUser_check_quota_access('jrFollower');

    // Banner
    jrCore_page_banner(37);

    // Get all who I'm following
    $_rt = jrFollower_get_profiles_followed($_user['_user_id']);
    if ($_rt && is_array($_rt)) {
        $_tm = array();
        foreach ($_rt as $pid => $active) {
            $_tm[] = (int) $pid;
        }
        // Get and show all profiles followed
        if (count($_tm) > 0) {
            $_rt  = array(
                'search'    => array(
                    '_profile_id in ' . implode(',', $_tm)
                ),
                'page'      => $_post['p'],
                'pagebreak' => 24
            );
            $_rt  = jrCore_db_search_items('jrProfile', $_rt);
            $html = jrCore_parse_template('following.tpl', $_rt, 'jrFollower');
            $html .= jrCore_parse_template('list_pager.tpl', $_rt, 'jrCore');
            jrCore_page_custom($html);
        }
    }
    else {
        $_ln = jrUser_load_lang_strings();
        jrCore_page_note($_ln['jrFollower'][36]);
    }
    jrCore_page_display();
}
